/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.coverage;

import com.intellij.coverage.BaseCoverageSuite;
import com.intellij.coverage.CoverageEngine;
import com.intellij.coverage.CoverageFileProvider;
import com.intellij.coverage.CoverageRunner;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.coverage.RubyCoverageEngine;

public class RubyCoverageSuite
extends BaseCoverageSuite {
    private final CoverageEngine myCoverageEngine;
    private String myWorkingDirectory;
    private static final String WORKING_DIRECTORY = "WORKING_DIRECTORY";
    private static final String MODULE_NAME = "MODULE_NAME";
    private Module myModule;
    private String myModuleName;

    public RubyCoverageSuite(@NotNull RubyCoverageEngine coverageSupportProvider) {
        if (coverageSupportProvider == null) {
            RubyCoverageSuite.$$$reportNull$$$0(0);
        }
        this.myCoverageEngine = coverageSupportProvider;
    }

    public RubyCoverageSuite(String name, Project project, CoverageRunner coverageRunner, CoverageFileProvider fileProvider, long timestamp, boolean trackTestFolders, RubyCoverageEngine coverageEngine, String workingDirectory, @Nullable Module module) {
        super(name, project, coverageRunner, fileProvider, timestamp);
        this.myTrackTestFolders = trackTestFolders;
        this.myWorkingDirectory = workingDirectory;
        this.myCoverageEngine = coverageEngine;
        this.myModule = module;
        if (this.myModule != null) {
            this.myModuleName = this.myModule.getName();
        }
    }

    @Nullable
    public String getWorkingDirectory() {
        return this.myWorkingDirectory;
    }

    @NotNull
    public CoverageEngine getCoverageEngine() {
        CoverageEngine coverageEngine = this.myCoverageEngine;
        if (coverageEngine == null) {
            RubyCoverageSuite.$$$reportNull$$$0(1);
        }
        return coverageEngine;
    }

    public void writeExternal(Element element) throws WriteExternalException {
        super.writeExternal(element);
        element.setAttribute(WORKING_DIRECTORY, this.myWorkingDirectory);
        if (this.myModuleName != null) {
            element.setAttribute(MODULE_NAME, this.myModuleName);
        }
    }

    public void readExternal(Element element) throws InvalidDataException {
        super.readExternal(element);
        this.myWorkingDirectory = element.getAttributeValue(WORKING_DIRECTORY);
        this.myModuleName = element.getAttributeValue(MODULE_NAME);
    }

    @Nullable
    private Module findModule(String moduleName) {
        Project project = this.getProject();
        if (project == null || project.isDisposed()) {
            return null;
        }
        return (Module)ReadAction.compute(() -> ModuleManager.getInstance((Project)project).findModuleByName(moduleName));
    }

    @Nullable
    public Module getModule() {
        if (this.myModule == null && this.myModuleName != null) {
            this.myModule = this.findModule(this.myModuleName);
        }
        return this.myModule;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "coverageSupportProvider";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/coverage/RubyCoverageSuite";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/coverage/RubyCoverageSuite";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getCoverageEngine";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

