/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.coverage;

import com.intellij.codeEditor.printing.ExportToHTMLSettings;
import com.intellij.codeInspection.export.ExportToHTMLDialog;
import com.intellij.coverage.CoverageAnnotator;
import com.intellij.coverage.CoverageBundle;
import com.intellij.coverage.CoverageEngine;
import com.intellij.coverage.CoverageFileProvider;
import com.intellij.coverage.CoverageRunner;
import com.intellij.coverage.CoverageSuite;
import com.intellij.coverage.CoverageSuitesBundle;
import com.intellij.coverage.view.CoverageListRootNode;
import com.intellij.coverage.view.CoverageViewExtension;
import com.intellij.coverage.view.DirectoryCoverageViewExtension;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.coverage.CoverageEnabledConfiguration;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.ModuleAttachProcessor;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.rt.coverage.data.JumpData;
import com.intellij.rt.coverage.data.LineData;
import com.intellij.rt.coverage.data.SwitchData;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.coverage.RCovBundle;
import org.jetbrains.plugins.ruby.coverage.RCovReportGenerator;
import org.jetbrains.plugins.ruby.coverage.RubyCoverageAnnotator;
import org.jetbrains.plugins.ruby.coverage.RubyCoverageEnabledConfiguration;
import org.jetbrains.plugins.ruby.coverage.RubyCoverageSuite;
import org.jetbrains.plugins.ruby.coverage.RubyCoverageUtil;
import org.jetbrains.plugins.ruby.rails.nameConventions.ViewsConventions;
import org.jetbrains.plugins.ruby.ruby.RModuleUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RFile;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.RCaseStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.RWhenCase;
import org.jetbrains.plugins.ruby.ruby.run.configuration.AbstractRubyRunConfiguration;
import org.jetbrains.plugins.ruby.utils.RubyVirtualFileScanner;

public final class RubyCoverageEngine
extends CoverageEngine {
    public boolean isApplicableTo(@NotNull RunConfigurationBase conf) {
        if (conf == null) {
            RubyCoverageEngine.$$$reportNull$$$0(0);
        }
        return conf instanceof AbstractRubyRunConfiguration;
    }

    @NotNull
    public CoverageEnabledConfiguration createCoverageEnabledConfiguration(@NotNull RunConfigurationBase conf) {
        if (conf == null) {
            RubyCoverageEngine.$$$reportNull$$$0(1);
        }
        return new RubyCoverageEnabledConfiguration((AbstractRubyRunConfiguration)conf);
    }

    @NotNull
    public CoverageSuite createCoverageSuite(@NotNull String name, @NotNull Project project, @NotNull CoverageRunner runner, @NotNull CoverageFileProvider fileProvider, long timestamp) {
        if (name == null) {
            RubyCoverageEngine.$$$reportNull$$$0(2);
        }
        if (project == null) {
            RubyCoverageEngine.$$$reportNull$$$0(3);
        }
        if (runner == null) {
            RubyCoverageEngine.$$$reportNull$$$0(4);
        }
        if (fileProvider == null) {
            RubyCoverageEngine.$$$reportNull$$$0(5);
        }
        String workingDirectory = new File(fileProvider.getCoverageDataFilePath()).getParent();
        CoverageSuite coverageSuite = this.createSuite(name, project, runner, fileProvider, timestamp, false, workingDirectory, null);
        if (coverageSuite == null) {
            RubyCoverageEngine.$$$reportNull$$$0(6);
        }
        return coverageSuite;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public CoverageSuite createCoverageSuite(@NotNull String name, @NotNull Project project, @NotNull CoverageRunner runner, @NotNull CoverageFileProvider fileProvider, long timestamp, @NotNull CoverageEnabledConfiguration coverageEnabledConfiguration) {
        void config;
        if (name == null) {
            RubyCoverageEngine.$$$reportNull$$$0(7);
        }
        if (project == null) {
            RubyCoverageEngine.$$$reportNull$$$0(8);
        }
        if (runner == null) {
            RubyCoverageEngine.$$$reportNull$$$0(9);
        }
        if (fileProvider == null) {
            RubyCoverageEngine.$$$reportNull$$$0(10);
        }
        if (coverageEnabledConfiguration == null) {
            RubyCoverageEngine.$$$reportNull$$$0(11);
        }
        if (config instanceof RubyCoverageEnabledConfiguration) {
            RubyCoverageEnabledConfiguration rConfig = (RubyCoverageEnabledConfiguration)config;
            return this.createSuite(name, project, runner, fileProvider, timestamp, config.isTrackTestFolders(), rConfig.getConfiguration().getWorkingDirectory(), rConfig.getConfiguration().getModule());
        }
        return null;
    }

    @Nullable
    public CoverageSuite createEmptyCoverageSuite(@NotNull CoverageRunner covRunner) {
        if (covRunner == null) {
            RubyCoverageEngine.$$$reportNull$$$0(12);
        }
        return new RubyCoverageSuite(this);
    }

    @NotNull
    public CoverageAnnotator getCoverageAnnotator(@NotNull Project project) {
        if (project == null) {
            RubyCoverageEngine.$$$reportNull$$$0(13);
        }
        RubyCoverageAnnotator rubyCoverageAnnotator = RubyCoverageAnnotator.getInstance(project);
        if (rubyCoverageAnnotator == null) {
            RubyCoverageEngine.$$$reportNull$$$0(14);
        }
        return rubyCoverageAnnotator;
    }

    public boolean coverageEditorHighlightingApplicableTo(@NotNull PsiFile psiFile) {
        if (psiFile == null) {
            RubyCoverageEngine.$$$reportNull$$$0(15);
        }
        return psiFile instanceof RFile;
    }

    public boolean coverageProjectViewStatisticsApplicableTo(@NotNull VirtualFile file) {
        if (file == null) {
            RubyCoverageEngine.$$$reportNull$$$0(16);
        }
        return RubyVirtualFileScanner.isRubyFile((VirtualFile)file) || ViewsConventions.isValidRubyBasedViewTemplate((VirtualFile)file);
    }

    public boolean acceptedByFilters(@NotNull PsiFile psiFile, @NotNull CoverageSuitesBundle suite) {
        if (psiFile == null) {
            RubyCoverageEngine.$$$reportNull$$$0(17);
        }
        if (suite == null) {
            RubyCoverageEngine.$$$reportNull$$$0(18);
        }
        return true;
    }

    @Nullable
    protected String getQualifiedName(@NotNull File outputFile, @NotNull PsiFile sourceFile) {
        if (outputFile == null) {
            RubyCoverageEngine.$$$reportNull$$$0(19);
        }
        if (sourceFile == null) {
            RubyCoverageEngine.$$$reportNull$$$0(20);
        }
        return RubyCoverageEngine.getQName(sourceFile);
    }

    @Nullable
    private static String getQName(PsiFile sourceFile) {
        VirtualFile file = sourceFile.getVirtualFile();
        if (file == null) {
            return null;
        }
        return file.getPath();
    }

    @NotNull
    public Set<String> getQualifiedNames(@NotNull PsiFile sourceFile) {
        String qName;
        if (sourceFile == null) {
            RubyCoverageEngine.$$$reportNull$$$0(21);
        }
        Set<String> set = (qName = RubyCoverageEngine.getQName(sourceFile)) != null ? Collections.singleton(qName) : Collections.emptySet();
        if (set == null) {
            RubyCoverageEngine.$$$reportNull$$$0(22);
        }
        return set;
    }

    public boolean recompileProjectAndRerunAction(@NotNull Module module, @NotNull CoverageSuitesBundle suite, @NotNull Runnable chooseSuiteAction) {
        if (module == null) {
            RubyCoverageEngine.$$$reportNull$$$0(23);
        }
        if (suite == null) {
            RubyCoverageEngine.$$$reportNull$$$0(24);
        }
        if (chooseSuiteAction == null) {
            RubyCoverageEngine.$$$reportNull$$$0(25);
        }
        return false;
    }

    public boolean includeUntouchedFileInCoverage(@NotNull String qualifiedName, @NotNull File outputFile, @NotNull PsiFile sourceFile, @NotNull CoverageSuitesBundle suite) {
        if (qualifiedName == null) {
            RubyCoverageEngine.$$$reportNull$$$0(26);
        }
        if (outputFile == null) {
            RubyCoverageEngine.$$$reportNull$$$0(27);
        }
        if (sourceFile == null) {
            RubyCoverageEngine.$$$reportNull$$$0(28);
        }
        if (suite == null) {
            RubyCoverageEngine.$$$reportNull$$$0(29);
        }
        return true;
    }

    @NotNull
    public Set<File> getCorrespondingOutputFiles(@NotNull PsiFile srcFile, Module module, @NotNull CoverageSuitesBundle suite) {
        if (srcFile == null) {
            RubyCoverageEngine.$$$reportNull$$$0(30);
        }
        if (suite == null) {
            RubyCoverageEngine.$$$reportNull$$$0(31);
        }
        Set<File> set = Collections.singleton(VfsUtilCore.virtualToIoFile((VirtualFile)srcFile.getVirtualFile()));
        if (set == null) {
            RubyCoverageEngine.$$$reportNull$$$0(32);
        }
        return set;
    }

    @Nullable
    public List<Integer> collectSrcLinesForUntouchedFile(@NotNull File virtualFile, @NotNull CoverageSuitesBundle suite) {
        boolean[] srcCodeLineMapping;
        if (virtualFile == null) {
            RubyCoverageEngine.$$$reportNull$$$0(33);
        }
        if (suite == null) {
            RubyCoverageEngine.$$$reportNull$$$0(34);
        }
        if ((srcCodeLineMapping = RubyCoverageUtil.determineSrcCodeLines(virtualFile)) != null) {
            ArrayList<Integer> uncoveredLines = new ArrayList<Integer>();
            int srcCodeLineMappingLength = srcCodeLineMapping.length;
            for (int i = 0; i < srcCodeLineMappingLength; ++i) {
                if (!srcCodeLineMapping[i]) continue;
                uncoveredLines.add(i);
            }
            return uncoveredLines;
        }
        return null;
    }

    public String generateBriefReport(@NotNull Editor editor, @NotNull PsiFile psiFile, int lineNumber, int startOffset, int endOffset, @Nullable LineData lineData) {
        if (editor == null) {
            RubyCoverageEngine.$$$reportNull$$$0(35);
        }
        if (psiFile == null) {
            RubyCoverageEngine.$$$reportNull$$$0(36);
        }
        StringBuilder builder = new StringBuilder();
        builder.append(super.generateBriefReport(editor, psiFile, lineNumber, startOffset, endOffset, lineData)).append("\n");
        if (lineData != null) {
            JumpData[] jumps = lineData.getJumps();
            SwitchData[] switches = lineData.getSwitches();
            if (jumps != null) {
                for (JumpData jump : jumps) {
                    builder.append(RCovBundle.message("rcov.branch.coverage.true.hits", jump.getTrueHits())).append("\n");
                    int hits = jump.getFalseHits();
                    if (hits < 0) continue;
                    builder.append(RCovBundle.message("rcov.branch.coverage.false.hits", hits)).append("\n");
                }
            }
            if (switches != null) {
                RCaseStatement caseStatement = (RCaseStatement)PsiTreeUtil.getParentOfType((PsiElement)psiFile.findElementAt(endOffset), RCaseStatement.class);
                for (SwitchData switchData : switches) {
                    int[] hits = switchData.getHits();
                    if (hits == null) continue;
                    for (int i = 0; i < hits.length; ++i) {
                        RWhenCase whenCase = caseStatement != null ? (RWhenCase)caseStatement.getCases().get(i) : null;
                        RPsiElement expression = whenCase != null ? whenCase.getCaseExpression() : null;
                        String text = expression != null ? RCovBundle.message("rcov.branch.coverage.when.case", "when " + expression.getText(), hits[i]) : RCovBundle.message("rcov.branch.coverage.when.case.no.source", i, hits[i]);
                        builder.append(text).append("\n");
                    }
                    builder.append(RCovBundle.message("rcov.branch.coverage.false.hits", switchData.getDefaultHits())).append("\n");
                }
            }
        } else {
            builder.append(CoverageBundle.message((String)"hits.title", (Object[])new Object[]{0}));
        }
        return builder.toString();
    }

    private CoverageSuite createSuite(String name, Project project, CoverageRunner covRunner, CoverageFileProvider fileProvider, long timeStamp, boolean trackTestFolders, @Nullable String workingDirectory, @Nullable Module module) {
        return new RubyCoverageSuite(name, project, covRunner, fileProvider, timeStamp, trackTestFolders, this, workingDirectory, module);
    }

    public boolean isReportGenerationAvailable(@NotNull Project project, @NotNull DataContext dataContext, @NotNull CoverageSuitesBundle currentSuite) {
        if (project == null) {
            RubyCoverageEngine.$$$reportNull$$$0(37);
        }
        if (dataContext == null) {
            RubyCoverageEngine.$$$reportNull$$$0(38);
        }
        if (currentSuite == null) {
            RubyCoverageEngine.$$$reportNull$$$0(39);
        }
        Module module = RModuleUtil.getInstance().getModuleWithRubySupport(project);
        return RModuleUtil.getInstance().findRubySdkForModule(module) != null;
    }

    public void generateReport(@NotNull Project project, @NotNull DataContext dataContext, @NotNull CoverageSuitesBundle currentSuite) {
        if (project == null) {
            RubyCoverageEngine.$$$reportNull$$$0(40);
        }
        if (dataContext == null) {
            RubyCoverageEngine.$$$reportNull$$$0(41);
        }
        if (currentSuite == null) {
            RubyCoverageEngine.$$$reportNull$$$0(42);
        }
        RCovReportGenerator.generate(project, currentSuite);
    }

    @NotNull
    public ExportToHTMLDialog createGenerateReportDialog(@NotNull Project project, @NotNull DataContext dataContext, @NotNull CoverageSuitesBundle currentSuite) {
        VirtualFile firstRoot;
        if (project == null) {
            RubyCoverageEngine.$$$reportNull$$$0(43);
        }
        if (dataContext == null) {
            RubyCoverageEngine.$$$reportNull$$$0(44);
        }
        if (currentSuite == null) {
            RubyCoverageEngine.$$$reportNull$$$0(45);
        }
        ExportToHTMLSettings settings = ExportToHTMLSettings.getInstance((Project)project);
        Module module = RModuleUtil.getInstance().getModule(dataContext);
        if (StringUtil.isEmpty((String)settings.OUTPUT_DIRECTORY) && module != null && (firstRoot = RModuleUtil.getInstance().getFirstContentRoot(module)) != null && firstRoot.isValid()) {
            settings.OUTPUT_DIRECTORY = FileUtil.toSystemDependentName((String)firstRoot.getPath()) + File.separator + "coverage";
        }
        ExportToHTMLDialog exportToHTMLDialog = super.createGenerateReportDialog(project, dataContext, currentSuite);
        if (exportToHTMLDialog == null) {
            RubyCoverageEngine.$$$reportNull$$$0(46);
        }
        return exportToHTMLDialog;
    }

    public CoverageViewExtension createCoverageViewExtension(final @NotNull Project project, CoverageSuitesBundle suiteBundle) {
        if (project == null) {
            RubyCoverageEngine.$$$reportNull$$$0(47);
        }
        if (!RModuleUtil.getInstance().isMultiProject(project)) {
            return new DirectoryCoverageViewExtension(project, this.getCoverageAnnotator(project), suiteBundle);
        }
        return new DirectoryCoverageViewExtension(project, this.getCoverageAnnotator(project), suiteBundle){

            @NotNull
            public AbstractTreeNode createRootNode() {
                Module primaryModule = ModuleAttachProcessor.getPrimaryModule((Project)project);
                Module moduleForLastSuite = RubyCoverageEngine.getModuleForLastSuite(this.mySuitesBundle);
                VirtualFile baseDir = this.myProject.getBaseDir();
                if (moduleForLastSuite != null && !moduleForLastSuite.equals(primaryModule)) {
                    VirtualFile moduleFile = moduleForLastSuite.getModuleFile();
                    assert (moduleFile != null);
                    baseDir = moduleFile.getParent().getParent();
                }
                PsiDirectory directory = PsiManager.getInstance((Project)this.myProject).findDirectory(baseDir);
                return new CoverageListRootNode(this.myProject, (PsiNamedElement)Objects.requireNonNull(directory), this.mySuitesBundle);
            }
        };
    }

    @Nullable
    private static Module getModuleForLastSuite(@Nullable CoverageSuitesBundle suitesBundle) {
        RubyCoverageSuite lastSuite = RubyCoverageEngine.getLastSuite(suitesBundle);
        return lastSuite == null ? null : lastSuite.getModule();
    }

    @Nullable
    public static RubyCoverageSuite getLastSuite(@Nullable CoverageSuitesBundle suitesBundle) {
        if (suitesBundle == null) {
            return null;
        }
        RubyCoverageSuite lastSuite = null;
        long lastTimeStamp = -1L;
        for (CoverageSuite suite : suitesBundle.getSuites()) {
            if (suite.getLastCoverageTimeStamp() <= lastTimeStamp || !(suite instanceof RubyCoverageSuite)) continue;
            lastTimeStamp = suite.getLastCoverageTimeStamp();
            lastSuite = (RubyCoverageSuite)suite;
        }
        return lastSuite;
    }

    public String getPresentableText() {
        return RCovBundle.message("action.rcoverage.text", new Object[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 14, 22, 32, 46 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "conf";
                break;
            }
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 3: 
            case 8: 
            case 13: 
            case 37: 
            case 40: 
            case 43: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runner";
                break;
            }
            case 5: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileProvider";
                break;
            }
            case 6: 
            case 14: 
            case 22: 
            case 32: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/coverage/RubyCoverageEngine";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "covRunner";
                break;
            }
            case 15: 
            case 17: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 18: 
            case 24: 
            case 29: 
            case 31: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suite";
                break;
            }
            case 19: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputFile";
                break;
            }
            case 20: 
            case 21: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceFile";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "chooseSuiteAction";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifiedName";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "srcFile";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 38: 
            case 41: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 39: 
            case 42: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentSuite";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/coverage/RubyCoverageEngine";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createCoverageSuite";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getCoverageAnnotator";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getQualifiedNames";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getCorrespondingOutputFiles";
                break;
            }
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "createGenerateReportDialog";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isApplicableTo";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createCoverageEnabledConfiguration";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createCoverageSuite";
                break;
            }
            case 6: 
            case 14: 
            case 22: 
            case 32: 
            case 46: {
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createEmptyCoverageSuite";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getCoverageAnnotator";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "coverageEditorHighlightingApplicableTo";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "coverageProjectViewStatisticsApplicableTo";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "acceptedByFilters";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getQualifiedName";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getQualifiedNames";
                break;
            }
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "recompileProjectAndRerunAction";
                break;
            }
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "includeUntouchedFileInCoverage";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getCorrespondingOutputFiles";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "collectSrcLinesForUntouchedFile";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "generateBriefReport";
                break;
            }
            case 37: 
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "isReportGenerationAvailable";
                break;
            }
            case 40: 
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "generateReport";
                break;
            }
            case 43: 
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "createGenerateReportDialog";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "createCoverageViewExtension";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 14, 22, 32, 46 -> new IllegalStateException(string);
        };
    }
}

