/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.coverage;

import com.intellij.coverage.CoverageRunner;
import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.coverage.CoverageEnabledConfiguration;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.WriteExternalException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.coverage.RCovRunner;
import org.jetbrains.plugins.ruby.coverage.run.RCovPattern;
import org.jetbrains.plugins.ruby.ruby.run.configuration.AbstractRubyRunConfiguration;

public final class RubyCoverageEnabledConfiguration
extends CoverageEnabledConfiguration {
    private static final String COVERAGE_PATTERN_ELEMENT_NAME = "COVERAGE_PATTERN";
    private static final String ENABLED_ATTRIBUTE_NAME = "ENABLED";
    private static final String ENABLE_BRANCH_COVERAGE_ELEMENT_NAME = "ENABLE_BRANCH_COVERAGE";
    private static final String ENABLE_FORKED_COVERAGE_ELEMENT_NAME = "ENABLE_FORKED_COVERAGE";
    private List<Pair<RCovPattern, Boolean>> myPatterns = Collections.emptyList();
    private boolean myEnableBranchCoverage;
    private boolean myEnableForkedCoverage;

    public RubyCoverageEnabledConfiguration(AbstractRubyRunConfiguration configuration) {
        super((RunConfigurationBase)configuration, (CoverageRunner)Objects.requireNonNull((RCovRunner)CoverageRunner.getInstance(RCovRunner.class)));
    }

    @NotNull
    public AbstractRubyRunConfiguration getConfiguration() {
        AbstractRubyRunConfiguration abstractRubyRunConfiguration = (AbstractRubyRunConfiguration)super.getConfiguration();
        if (abstractRubyRunConfiguration == null) {
            RubyCoverageEnabledConfiguration.$$$reportNull$$$0(0);
        }
        return abstractRubyRunConfiguration;
    }

    @Nullable
    public static RubyCoverageEnabledConfiguration getFrom(ModuleBasedConfiguration configuration) {
        CoverageEnabledConfiguration coverageEnabledConfiguration = RubyCoverageEnabledConfiguration.getOrCreate((RunConfigurationBase)configuration);
        if (coverageEnabledConfiguration instanceof RubyCoverageEnabledConfiguration) {
            return (RubyCoverageEnabledConfiguration)coverageEnabledConfiguration;
        }
        return null;
    }

    @NotNull
    public List<Pair<RCovPattern, Boolean>> getAllPatterns() {
        List<Pair<RCovPattern, Boolean>> list = this.myPatterns;
        if (list == null) {
            RubyCoverageEnabledConfiguration.$$$reportNull$$$0(1);
        }
        return list;
    }

    public void setAllPatterns(@NotNull List<Pair<RCovPattern, Boolean>> patterns) {
        if (patterns == null) {
            RubyCoverageEnabledConfiguration.$$$reportNull$$$0(2);
        }
        this.myPatterns = patterns;
    }

    public boolean isEnableBranchCoverage() {
        return this.myEnableBranchCoverage;
    }

    public void setEnableBranchCoverage(boolean enableBranchCoverage) {
        this.myEnableBranchCoverage = enableBranchCoverage;
    }

    public boolean isEnableForkedCoverage() {
        return this.myEnableForkedCoverage;
    }

    public void setEnableForkedCoverage(boolean enableForkedCoverage) {
        this.myEnableForkedCoverage = enableForkedCoverage;
    }

    public void writeExternal(Element element) throws WriteExternalException {
        super.writeExternal(element);
        for (Pair<RCovPattern, Boolean> patternAndEnabledFlag : this.myPatterns) {
            Element patternElement = new Element(COVERAGE_PATTERN_ELEMENT_NAME);
            patternElement.setAttribute(ENABLED_ATTRIBUTE_NAME, String.valueOf(patternAndEnabledFlag.second));
            ((RCovPattern)patternAndEnabledFlag.first).writeExternal(patternElement);
            element.addContent(patternElement);
        }
        if (this.myEnableBranchCoverage) {
            element.setAttribute(ENABLE_BRANCH_COVERAGE_ELEMENT_NAME, String.valueOf(true));
        }
        if (this.myEnableForkedCoverage) {
            element.setAttribute(ENABLE_FORKED_COVERAGE_ELEMENT_NAME, String.valueOf(true));
        }
    }

    public void readExternal(Element element) throws InvalidDataException {
        super.readExternal(element);
        List children = element.getChildren(COVERAGE_PATTERN_ELEMENT_NAME);
        if (!children.isEmpty()) {
            this.myPatterns = new ArrayList<Pair<RCovPattern, Boolean>>(children.size());
            for (Object child : children) {
                Element e = (Element)child;
                String enabledAttribute = e.getAttributeValue(ENABLED_ATTRIBUTE_NAME);
                boolean isEnabled = enabledAttribute != null && Boolean.valueOf(enabledAttribute) != false;
                RCovPattern pattern = new RCovPattern();
                pattern.readExternal(e);
                this.myPatterns.add((Pair<RCovPattern, Boolean>)new Pair((Object)pattern, (Object)isEnabled));
            }
        }
        String enableBranchCov = element.getAttributeValue(ENABLE_BRANCH_COVERAGE_ELEMENT_NAME);
        this.myEnableBranchCoverage = Boolean.parseBoolean(enableBranchCov);
        String enableForkedCov = element.getAttributeValue(ENABLE_FORKED_COVERAGE_ELEMENT_NAME);
        this.myEnableForkedCoverage = Boolean.parseBoolean(enableForkedCov);
    }

    protected String coverageFileNameSeparator() {
        return "@";
    }

    public String toString() {
        return "RubyCoverageEnabledConfiguration{myCoverageFilePath='" + this.myCoverageFilePath + "', myPatterns=" + String.valueOf(this.myPatterns) + ", myEnableBranchCoverage=" + this.myEnableBranchCoverage + ", myEnableForkedCoverage=" + this.myEnableForkedCoverage + "} " + super.toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/coverage/RubyCoverageEnabledConfiguration";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "patterns";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfiguration";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllPatterns";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/coverage/RubyCoverageEnabledConfiguration";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setAllPatterns";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2 -> new IllegalArgumentException(string);
        };
    }
}

