/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.coverage;

import com.intellij.coverage.CoverageEngine;
import com.intellij.coverage.CoverageLoadErrorReporter;
import com.intellij.coverage.CoverageLoadingResult;
import com.intellij.coverage.CoverageRunner;
import com.intellij.coverage.CoverageSuite;
import com.intellij.coverage.FailedCoverageLoadingResult;
import com.intellij.coverage.SuccessCoverageLoadingResult;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.OSAgnosticPathUtil;
import com.intellij.rt.coverage.data.ClassData;
import com.intellij.rt.coverage.data.JumpData;
import com.intellij.rt.coverage.data.LineData;
import com.intellij.rt.coverage.data.ProjectData;
import com.intellij.rt.coverage.data.SwitchData;
import java.io.File;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.coverage.RCovBundle;
import org.jetbrains.plugins.ruby.coverage.RCovCoverageType;
import org.jetbrains.plugins.ruby.coverage.RCovRawFileData;
import org.jetbrains.plugins.ruby.coverage.RubyCoverageDeserializationService;
import org.jetbrains.plugins.ruby.coverage.RubyCoverageEngine;
import org.jetbrains.plugins.ruby.coverage.RubyCoverageSuite;
import org.jetbrains.plugins.ruby.coverage.RubyCoverageUtil;

public final class RCovRunner
extends CoverageRunner {
    private static final Logger LOG = Logger.getInstance(RCovRunner.class);
    private static final String DATA_FILE_EXT = "rcov";
    private static final String SIMPLECOV_FILE_EXT = "json";
    private static final String ID = "rcov";
    private static final Set<String> CYCLES_WITH_BODY = Set.of(":while", ":until");
    private static final String SWITCH_CASE_NAME = ":case";
    private static final String THEN_BRANCH_NAME = ":then";
    private static final String ELSE_BRANCH_NAME = ":else";
    private static final String BODY_BRANCH_NAME = ":body";

    @NotNull
    public CoverageLoadingResult loadCoverageData(@NotNull File sessionDataFile, @Nullable CoverageSuite coverageSuite, @NotNull CoverageLoadErrorReporter reporter) {
        if (sessionDataFile == null) {
            RCovRunner.$$$reportNull$$$0(0);
        }
        if (reporter == null) {
            RCovRunner.$$$reportNull$$$0(1);
        }
        ProjectData projectInfo = new ProjectData();
        if (!(coverageSuite instanceof RubyCoverageSuite)) {
            String message = "Ruby coverage suite is expected here, got: " + (coverageSuite == null ? "null" : coverageSuite.getClass().getName());
            LOG.warn(message);
            return new FailedCoverageLoadingResult(message);
        }
        List<RCovRawFileData> fileDataList = RubyCoverageDeserializationService.getInstance().deserialize(sessionDataFile.getPath(), reporter);
        if (fileDataList == null) {
            return new FailedCoverageLoadingResult("Was not able to deserialize Ruby coverage data", null, projectInfo);
        }
        String wd = ((RubyCoverageSuite)coverageSuite).getWorkingDirectory();
        for (RCovRawFileData rawFileData : fileDataList) {
            String rcoveraziedPath = rawFileData.getFilePath();
            ClassData classInfo = projectInfo.getOrCreateClassData(RCovRunner.normalizePath(rcoveraziedPath, wd));
            int linesQuantity = rawFileData.getLinesNumber();
            LineData[] linesInfo = new LineData[linesQuantity + 1];
            for (int i = 0; i < linesQuantity; ++i) {
                int lineNumber = i + 1;
                boolean isMostLikelyNonSrcCode = RubyCoverageUtil.isMostLikelyNonSrcCode(i, rawFileData);
                if (isMostLikelyNonSrcCode) {
                    linesInfo[lineNumber] = null;
                    continue;
                }
                if (linesInfo[lineNumber] == null) {
                    linesInfo[lineNumber] = new LineData(lineNumber, "");
                }
                LineData info = linesInfo[lineNumber];
                RCovCoverageType lineCoverage = rawFileData.getCoverage(i);
                info.setStatus(lineCoverage.status);
                info.setHits(lineCoverage.status == 1 ? 1 : rawFileData.getHits(i));
                RCovRawFileData.BranchElement branch = rawFileData.getBranch(lineNumber);
                if (branch == null) continue;
                if (branch.getText().equals(SWITCH_CASE_NAME)) {
                    RCovRunner.addSwitchCase(info, branch);
                } else if (CYCLES_WITH_BODY.contains(branch.getText())) {
                    RCovRunner.addCycleBody(info, branch);
                } else {
                    RCovRunner.addJump(info, branch);
                }
                info.fillArrays();
            }
            classInfo.setLines(linesInfo);
        }
        return new SuccessCoverageLoadingResult(projectInfo);
    }

    private static void addJump(LineData info, RCovRawFileData.BranchElement branch) {
        JumpData jump = info.addJump(0);
        RCovRawFileData.BranchElement thenBranch = branch.getBranchByName(THEN_BRANCH_NAME);
        RCovRawFileData.BranchElement elseBranch = branch.getBranchByName(ELSE_BRANCH_NAME);
        if (thenBranch != null) {
            jump.setTrueHits(thenBranch.getHitCount());
        }
        if (elseBranch != null) {
            jump.setFalseHits(elseBranch.getHitCount());
        }
    }

    private static void addSwitchCase(LineData info, RCovRawFileData.BranchElement branch) {
        SwitchData switchData = info.addSwitch(0, new int[0]);
        List<RCovRawFileData.BranchElement> children = branch.getChildren();
        Object[] objects = children.stream().filter(it -> !it.getText().equals(ELSE_BRANCH_NAME)).map(it -> it.getHitCount()).toArray();
        int[] keys = new int[objects.length];
        int[] hits = new int[objects.length];
        for (int j = 0; j < objects.length; ++j) {
            keys[j] = j;
            hits[j] = (Integer)objects[j];
        }
        switchData.setKeysAndHits(keys, hits);
        RCovRawFileData.BranchElement elseBranch = branch.getBranchByName(ELSE_BRANCH_NAME);
        if (elseBranch != null) {
            switchData.setDefaultHits(elseBranch.getHitCount());
        }
    }

    private static void addCycleBody(LineData info, RCovRawFileData.BranchElement branch) {
        JumpData jump = info.addJump(0);
        RCovRawFileData.BranchElement body = branch.getBranchByName(BODY_BRANCH_NAME);
        if (body != null) {
            jump.setTrueHits(body.getHitCount());
        }
        jump.setFalseHits(-1);
    }

    @NotNull
    private static String normalizePath(@NotNull String rcoveraziedPath, @Nullable String wd) {
        if (rcoveraziedPath == null) {
            RCovRunner.$$$reportNull$$$0(2);
        }
        if (wd != null) {
            if (SystemInfo.isUnix) {
                if (!rcoveraziedPath.startsWith(File.separator)) {
                    String string = wd + "/" + rcoveraziedPath;
                    if (string == null) {
                        RCovRunner.$$$reportNull$$$0(3);
                    }
                    return string;
                }
            } else if (SystemInfo.isWindows) {
                if (rcoveraziedPath.length() > 3 && OSAgnosticPathUtil.isAbsoluteDosPath((String)rcoveraziedPath)) {
                    String string = rcoveraziedPath;
                    if (string == null) {
                        RCovRunner.$$$reportNull$$$0(4);
                    }
                    return string;
                }
                String string = wd + "/" + rcoveraziedPath;
                if (string == null) {
                    RCovRunner.$$$reportNull$$$0(5);
                }
                return string;
            }
        }
        String string = rcoveraziedPath;
        if (string == null) {
            RCovRunner.$$$reportNull$$$0(6);
        }
        return string;
    }

    @NotNull
    public String getPresentableName() {
        String string = RCovRunner.getRunnerName();
        if (string == null) {
            RCovRunner.$$$reportNull$$$0(7);
        }
        return string;
    }

    @NonNls
    @NotNull
    public String getId() {
        return "rcov";
    }

    @NonNls
    @NotNull
    public String getDataFileExtension() {
        return "rcov";
    }

    public String @NotNull [] getDataFileExtensions() {
        String[] stringArray = new String[]{"rcov", SIMPLECOV_FILE_EXT};
        if (stringArray == null) {
            RCovRunner.$$$reportNull$$$0(8);
        }
        return stringArray;
    }

    public boolean acceptsCoverageEngine(@NotNull CoverageEngine engine) {
        if (engine == null) {
            RCovRunner.$$$reportNull$$$0(9);
        }
        return engine instanceof RubyCoverageEngine;
    }

    private static String getRunnerName() {
        return RCovBundle.message("rcov.runner.name", new Object[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 5, 6, 7, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sessionDataFile";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reporter";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rcoveraziedPath";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/coverage/RCovRunner";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "engine";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/coverage/RCovRunner";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "normalizePath";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableName";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getDataFileExtensions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "loadCoverageData";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "normalizePath";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "acceptsCoverageEngine";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 5, 6, 7, 8 -> new IllegalStateException(string);
        };
    }
}

