/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.coverage;

import com.intellij.codeEditor.printing.ExportToHTMLSettings;
import com.intellij.coverage.CoverageSuitesBundle;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionMode;
import com.intellij.execution.ExecutionModes;
import com.intellij.execution.process.CapturingProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.ide.BrowserUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.components.panels.VerticalLayout;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.PlatformUtils;
import java.awt.Component;
import java.awt.LayoutManager;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.coverage.RCovBundle;
import org.jetbrains.plugins.ruby.coverage.RCovRunner;
import org.jetbrains.plugins.ruby.coverage.RubyCoverageDeserializationProvider;
import org.jetbrains.plugins.ruby.coverage.RubyCoverageDeserializationService;
import org.jetbrains.plugins.ruby.coverage.RubyCoverageEngine;
import org.jetbrains.plugins.ruby.coverage.RubyCoverageSuite;
import org.jetbrains.plugins.ruby.gem.GemInfo;
import org.jetbrains.plugins.ruby.gem.util.BundlerUtil;
import org.jetbrains.plugins.ruby.gem.util.RubyGemSearchUtil;
import org.jetbrains.plugins.ruby.gem.util.RubyProjectGemSearchService;
import org.jetbrains.plugins.ruby.ruby.RModuleUtil;
import org.jetbrains.plugins.ruby.ruby.RubyUtil;
import org.jetbrains.plugins.ruby.ruby.run.RunnerUtil;
import org.jetbrains.plugins.ruby.ruby.run.context.RubyScriptExecutionContext;

public final class RCovReportGenerator {
    private static final Logger LOG = Logger.getInstance(RCovRunner.class);
    private static final String GENERATOR_FOLDER = "rb/report/";
    private static final String GENERATOR_SCRIPT_SUFFIX = "_generator.rb";
    private static final String GENERATOR_OPT_RCOV_VERS = "--rcov-version";

    private RCovReportGenerator() {
    }

    public static void generate(final @NotNull Project project, @NotNull CoverageSuitesBundle currentSuite) {
        String outputDirectory;
        RubyCoverageSuite selectedSuite;
        if (project == null) {
            RCovReportGenerator.$$$reportNull$$$0(0);
        }
        if (currentSuite == null) {
            RCovReportGenerator.$$$reportNull$$$0(1);
        }
        ExportToHTMLSettings settings = ExportToHTMLSettings.getInstance((Project)project);
        String outputDir = settings.OUTPUT_DIRECTORY;
        final boolean openInBrowser = settings.OPEN_IN_BROWSER;
        if (currentSuite.getSuites().length > 1) {
            Ref ref = new Ref();
            boolean got = RCovReportGenerator.createChooseSuiteDialog(project, currentSuite, (Ref<Integer>)ref).showAndGet();
            Integer selected = (Integer)ref.get();
            if (!got || selected == null || selected < 0) {
                return;
            }
            Object[] rubySuites = Arrays.stream(currentSuite.getSuites()).filter(it -> it instanceof RubyCoverageSuite).toArray();
            selectedSuite = (RubyCoverageSuite)((Object)rubySuites[selected]);
        } else {
            selectedSuite = RubyCoverageEngine.getLastSuite(currentSuite);
        }
        Module module = selectedSuite == null ? null : selectedSuite.getModule();
        Module module2 = module = module == null ? RModuleUtil.getInstance().getModuleWithRubySupport(project) : module;
        if (module == null) {
            Messages.showErrorDialog((Project)project, (String)RCovBundle.message("rcov.report.generator.error.module.not.found", new Object[0]), (String)RCovBundle.message("rcov.report.generator.dialog.title", new Object[0]));
            return;
        }
        String coverageDataFileName = selectedSuite.getCoverageDataFileName();
        RubyCoverageDeserializationProvider provider = RubyCoverageDeserializationService.getInstance().determineCoverageDataProvider(coverageDataFileName);
        if (provider == null) {
            Messages.showErrorDialog((Project)project, (String)RCovBundle.message("rcov.report.generator.error.coverage.report.generator.not.found", coverageDataFileName), (String)RCovBundle.message("rcov.report.generator.dialog.title", new Object[0]));
            return;
        }
        VirtualFile firstRoot = RModuleUtil.getInstance().getFirstContentRoot(module);
        if (outputDir != null) {
            outputDirectory = outputDir;
        } else {
            if (firstRoot == null || !firstRoot.isValid()) {
                Messages.showErrorDialog((Project)project, (String)RCovBundle.message("rcov.report.generator.error.output.dir.not.found", new Object[0]), (String)RCovBundle.message("rcov.report.generator.dialog.title", new Object[0]));
                return;
            }
            outputDirectory = firstRoot.getPath();
        }
        Sdk sdk = RModuleUtil.getInstance().findRubySdkForModule(module);
        if (sdk == null) {
            String msg = RCovBundle.message("rcov.report.generator.error.ruby.sdk.not.found", PlatformUtils.isRubyMine() ? RCovBundle.message("rcov.report.generator.error.ruby.sdk.configure.project", new Object[0]) : RCovBundle.message("rcov.report.generator.error.ruby.sdk.configure.module", module.getName()));
            Messages.showErrorDialog((Project)project, (String)msg, (String)RCovBundle.message("rcov.report.generator.dialog.title", new Object[0]));
            return;
        }
        String generatorGemName = provider.getReportGeneratorGemName();
        final String reportGenerator = RubyUtil.getScriptFullPath((String)(GENERATOR_FOLDER + generatorGemName + GENERATOR_SCRIPT_SUFFIX));
        LOG.assertTrue(reportGenerator != null);
        @Nullable GemInfo coverageGem = RubyProjectGemSearchService.Companion.findGem(module, generatorGemName);
        coverageGem = coverageGem != null ? coverageGem : RubyGemSearchUtil.findGem((Module)module, (Sdk)sdk, (String)generatorGemName);
        final String errorTitle = RCovBundle.message("rcov.report.generator.error.console.title", generatorGemName);
        String title = RCovBundle.message("rcov.report.generator.progress.title", currentSuite.getPresentableName());
        ArrayList<Object> argsList = new ArrayList<Object>();
        argsList.add(coverageDataFileName);
        argsList.add(outputDirectory);
        if (coverageGem != null) {
            argsList.add(GENERATOR_OPT_RCOV_VERS);
            argsList.add("=" + coverageGem.getNullableVersion());
        }
        final String[] args = ArrayUtilRt.toStringArray(argsList);
        ExecutionModes.BackGroundMode mode = new ExecutionModes.BackGroundMode(true, title);
        CapturingProcessAdapter listener = new CapturingProcessAdapter(){

            public void processTerminated(@NotNull ProcessEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                super.processTerminated(event);
                RunnerUtil.reportErrorsIfNeeded((Project)project, (String)errorTitle, (String)reportGenerator, (String)this.getOutput().getStderr());
                if (event.getExitCode() == 0) {
                    ApplicationManager.getApplication().invokeLater(() -> {
                        if (openInBrowser) {
                            BrowserUtil.browse((File)new File(outputDirectory, "index.html"));
                        } else {
                            Messages.showInfoMessage((String)RCovBundle.message("rcov.report.generator.success.dialog.text", outputDirectory + File.separator + "index.html"), (String)RCovBundle.message("rcov.report.generator.dialog.title", new Object[0]));
                        }
                    });
                } else {
                    LOG.warn("RCov report generated with errors. Exit code = " + event.getExitCode() + ". Arguments: " + Arrays.asList(args).toString());
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "org/jetbrains/plugins/ruby/coverage/RCovReportGenerator$1", "processTerminated"));
            }
        };
        mode.addProcessListener((ProcessListener)listener);
        try {
            ((RubyScriptExecutionContext)((RubyScriptExecutionContext)((RubyScriptExecutionContext)((RubyScriptExecutionContext)((RubyScriptExecutionContext)RubyScriptExecutionContext.create((String)reportGenerator, (Sdk)sdk).withModule(module)).withWorkingDir(firstRoot)).withExecutionMode((ExecutionMode)mode)).withCommandLinePreprocessor(BundlerUtil.getBundlerPreprocessor((Sdk)sdk, (Module)module))).withArguments(args)).executeScript();
        }
        catch (ExecutionException e) {
            LOG.warn((Throwable)e);
        }
    }

    @NotNull
    private static DialogWrapper createChooseSuiteDialog(@NotNull Project project, final @NotNull CoverageSuitesBundle bundle, final @NotNull Ref<Integer> toSelect) {
        if (project == null) {
            RCovReportGenerator.$$$reportNull$$$0(2);
        }
        if (bundle == null) {
            RCovReportGenerator.$$$reportNull$$$0(3);
        }
        if (toSelect == null) {
            RCovReportGenerator.$$$reportNull$$$0(4);
        }
        return new DialogWrapper(project, false){
            private JComboBox<Object> myComboBox;
            {
                super(arg0, arg1);
                this.init();
                this.setTitle(RCovBundle.message("rcov.report.generator.select.suite.title", new Object[0]));
            }

            @NotNull
            protected JComponent createCenterPanel() {
                JPanel panel = new JPanel((LayoutManager)new VerticalLayout(4));
                panel.add((Component)new JLabel(RCovBundle.message("rcov.report.generator.select.suite.text", new Object[0]) + ":"), "TOP");
                this.myComboBox = new ComboBox(Arrays.stream(bundle.getSuites()).filter(it -> it instanceof RubyCoverageSuite).map(it -> it.getPresentableName()).toArray());
                panel.add(this.myComboBox, "CENTER");
                JPanel jPanel = panel;
                if (jPanel == null) {
                    2.$$$reportNull$$$0(0);
                }
                return jPanel;
            }

            public boolean showAndGet() {
                boolean got = super.showAndGet();
                toSelect.set((Object)this.myComboBox.getSelectedIndex());
                return got;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/ruby/coverage/RCovReportGenerator$2", "createCenterPanel"));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentSuite";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bundle";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toSelect";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/ruby/coverage/RCovReportGenerator";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "generate";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "createChooseSuiteDialog";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

