/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.coverage;

import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;
import org.jetbrains.plugins.ruby.coverage.RCovCoverageType;

public final class RCovRawFileData {
    private final int[] myHits;
    private final String myFilePath;
    private final List<RCovCoverageType> myCoverage;
    private final boolean[] mySrcLinesMap;
    private final int myLinesNumber;
    @NotNull
    private final Map<Integer, BranchElement> myBranches;

    public RCovRawFileData(@NotNull String filePath, @NotNull List<RCovCoverageType> coverage, int @NotNull [] hits, boolean[] srcLinesMap, @NotNull Map<Integer, BranchElement> branches) {
        if (filePath == null) {
            RCovRawFileData.$$$reportNull$$$0(0);
        }
        if (coverage == null) {
            RCovRawFileData.$$$reportNull$$$0(1);
        }
        if (branches == null) {
            RCovRawFileData.$$$reportNull$$$0(2);
        }
        if (hits == null) {
            RCovRawFileData.$$$reportNull$$$0(3);
        }
        this.myFilePath = filePath;
        this.myCoverage = coverage;
        this.myBranches = branches;
        this.myLinesNumber = Math.min(srcLinesMap.length, coverage.size());
        this.mySrcLinesMap = srcLinesMap;
        this.myHits = hits;
    }

    public int getLinesNumber() {
        return this.myLinesNumber;
    }

    public boolean isSourceCode(int line) {
        return this.mySrcLinesMap[line];
    }

    public String getFilePath() {
        return this.myFilePath;
    }

    public RCovCoverageType getCoverage(int line) {
        return this.myCoverage.get(line);
    }

    public int getHits(int line) {
        return this.myHits[line];
    }

    @NotNull
    public Map<Integer, BranchElement> getBranches() {
        Map<Integer, BranchElement> map = this.myBranches;
        if (map == null) {
            RCovRawFileData.$$$reportNull$$$0(4);
        }
        return map;
    }

    @Nullable
    public BranchElement getBranch(int lineNumber) {
        return this.myBranches.get(lineNumber);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "coverage";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "branches";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hits";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/coverage/RCovRawFileData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/coverage/RCovRawFileData";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getBranches";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4 -> new IllegalStateException(string);
        };
    }

    @VisibleForTesting
    public static class BranchElement {
        @NotNull
        private final String myText;
        private final int myIndex;
        private final int myStartLine;
        private final int myStartColumn;
        private final int myEndLine;
        private final int myEndColumn;
        private final int myHitCount;
        @NotNull
        private final List<BranchElement> myChildren;

        BranchElement(@NotNull String text, int index, int startLine, int startColumn, int endLine, int endColumn, int hitCount, @NotNull List<BranchElement> children) {
            if (text == null) {
                BranchElement.$$$reportNull$$$0(0);
            }
            if (children == null) {
                BranchElement.$$$reportNull$$$0(1);
            }
            this.myText = text;
            this.myIndex = index;
            this.myStartLine = startLine;
            this.myStartColumn = startColumn;
            this.myEndLine = endLine;
            this.myEndColumn = endColumn;
            this.myHitCount = hitCount;
            this.myChildren = children;
        }

        @NotNull
        public String getText() {
            String string = this.myText;
            if (string == null) {
                BranchElement.$$$reportNull$$$0(2);
            }
            return string;
        }

        public int getStartLine() {
            return this.myStartLine;
        }

        public int getStartColumn() {
            return this.myStartColumn;
        }

        public int getEndLine() {
            return this.myEndLine;
        }

        public int getEndColumn() {
            return this.myEndColumn;
        }

        public int getHitCount() {
            return this.myHitCount;
        }

        @NotNull
        public List<BranchElement> getChildren() {
            List<BranchElement> list = this.myChildren;
            if (list == null) {
                BranchElement.$$$reportNull$$$0(3);
            }
            return list;
        }

        public int getIndex() {
            return this.myIndex;
        }

        @Nullable
        public BranchElement getBranchByName(@NotNull String name) {
            if (name == null) {
                BranchElement.$$$reportNull$$$0(4);
            }
            return (BranchElement)ContainerUtil.find(this.myChildren, it -> it.getText().equals(name));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "children";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/ruby/coverage/RCovRawFileData$BranchElement";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/ruby/coverage/RCovRawFileData$BranchElement";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChildren";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "getBranchByName";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3 -> new IllegalStateException(string);
            };
        }
    }
}

