/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.haml.lexer;

import com.intellij.lexer.FlexLexer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.xml.XmlTokenType;
import java.io.IOException;
import java.io.Reader;
import org.jetbrains.plugins.haml.psi.HAMLTokenTypes;

public class _HAMLLexer
implements FlexLexer,
HAMLTokenTypes {
    public static final int YYEOF = -1;
    private static final int ZZ_BUFFERSIZE = 16384;
    public static final int YYINITIAL = 0;
    public static final int IN_TAG_STATE = 2;
    public static final int IN_CLASS_STATE = 4;
    public static final int IN_ID_STATE = 6;
    public static final int AFTER_TAG_STATE = 8;
    public static final int AFTER_TAG_ARGS_STATE = 10;
    public static final int TAGS_ARG_STATE = 12;
    public static final int STRING_STATE = 14;
    public static final int TEXT_STATE = 16;
    public static final int RUBY_CODE_STATE = 18;
    public static final int RUBY_LINE_CODE_STATE = 20;
    public static final int RUBY_STRING_STATE = 22;
    public static final int COMMENT_STATE = 24;
    public static final int CONDITIONAL_COMMENT_STATE = 26;
    public static final int BLOCK_WITHOUT_INTERPOLATION_STATE = 28;
    public static final int BLOCK_WITH_INTERPOLATION_STATE = 30;
    public static final int IN_IMPLICIT_TAG_STATE = 32;
    public static final int IN_EXPLICIT_TAG_STATE = 34;
    public static final int AFTER_TAG_STATE_WITHOUT_RUBY_INJECTION = 36;
    private static final int[] ZZ_LEXSTATE = new int[]{0, 0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8, 9, 9, 10, 10, 11, 11, 12, 12, 13, 13, 14, 14, 15, 15, 16, 16, 17, 17, 18, 18};
    private static final int[] ZZ_CMAP_TOP = _HAMLLexer.zzUnpackcmap_top();
    private static final String ZZ_CMAP_TOP_PACKED_0 = "\u0001\u0000\u001f\u0100\u0001\u0200\u00b7\u0100\b\u0300\u1020\u0100";
    private static final int[] ZZ_CMAP_BLOCKS = _HAMLLexer.zzUnpackcmap_blocks();
    private static final String ZZ_CMAP_BLOCKS_PACKED_0 = "\t\u0000\u0001\u0001\u0001\u0002\u0002\u0003\u0001\u0004\u0012\u0000\u0001\u0005\u0001\u0006\u0001\u0007\u0001\b\u0001\u0000\u0001\t\u0001\n\u0001\u000b\u0001\f\u0001\r\u0002\u0000\u0001\u000e\u0001\u000f\u0001\u0010\u0001\u0011\n\u0012\u0001\u0013\u0001\u0000\u0001\u0014\u0001\u0015\u0001\u0016\u0001\u0000\u0001\u0017\u001a\u0018\u0001\u0019\u0001\u001a\u0002\u0000\u0001\u0018\u0001\u0000\u0001\u0018\u0001\u001b\u000f\u0018\u0001\u001c\u0002\u0018\u0001\u001d\u0003\u0018\u0001\u001e\u0001\u0018\u0001\u001f\u0001 \u0001\u0000\u0001!\u0006\u0000\u0001\u0003\u01a2\u0000\u0002\u0003\u00d6\u0000\u0100\"";
    private static final int[] ZZ_ACTION = _HAMLLexer.zzUnpackAction();
    private static final String ZZ_ACTION_PACKED_0 = "\u000b\u0000\u0001\u0001\u0001\u0002\u0006\u0000\u0001\u0003\u0001\u0004\u0001\u0005\u0004\u0003\u0001\u0006\u0001\u0003\u0001\u0007\u0001\u0003\u0001\b\u0002\u0003\u0001\b\u0001\t\u0001\u0000\u0001\n\u0001\u000b\u0001\f\u0001\u0003\u0001\r\u0001\u0003\u0001\u000e\u0002\u000f\u0001\u0003\u0001\u0010\u0001\u0011\u0001\u0012\u0001\u0013\u0001\u0014\u0001\u0015\u0001\u0016\u0001\u0010\u0001\u0017\u0001\u0010\u0001\u0018\u0001\u0019\u0001\u001a\u0001\u0019\u0001\u001b\u0003\u001c\u0002\u001d\u0001\u001e\u0001\u001f\u0001\u001e\u0001\u0001\u0001\u0002\u0001 \u0001!\u0001\"\u0001#\u0001$\u0001%\u0001#\u0001$\u0001&\u0001\u0000\u0001\u0004\u0001\u0000\u0001'\u0001(\u0001\u0006\u0001)\u0001'\u0002*\u0001+\u0001,\u0001\u001c\u0002-\u0001.\u0001/\u0001\u0000\u00010\u0001\u000e\u0001\u0000\u00021\u0002\u0000\u00011\u0001\u0016\u00012\u00013\u0001\u0000\u00014\u00015\u0002\u001e\u0001\u0000\u0001 \u00016\u00017\u00018\u00019\u0001:\u0001;\u0001<\u0001=\u0001\u0000\u0002(\u0002\u0000\u0001*\u0001\u0000\u0001>\u0003\u0000\u0001\u001e\u0001?\u0001\u001e\u0001@\u0001A\u0002<\u0001*\u0001>\u0002\u0000\u0001B\u0001A\u0001C";
    private static final int[] ZZ_ROWMAP = _HAMLLexer.zzUnpackRowMap();
    private static final String ZZ_ROWMAP_PACKED_0 = "\u0000\u0000\u0000#\u0000F\u0000i\u0000\u008c\u0000\u00af\u0000\u00d2\u0000\u00f5\u0000\u0118\u0000\u013b\u0000\u015e\u0000\u0181\u0000\u01a4\u0000\u01c7\u0000\u01ea\u0000\u020d\u0000\u0230\u0000\u0253\u0000\u0276\u0000\u01c7\u0000\u0299\u0000\u01c7\u0000\u02bc\u0000\u02df\u0000\u0302\u0000\u0325\u0000\u0348\u0000\u036b\u0000\u038e\u0000\u03b1\u0000\u03d4\u0000\u03f7\u0000\u041a\u0000\u043d\u0000\u0460\u0000\u0483\u0000\u04a6\u0000\u04c9\u0000\u04ec\u0000\u050f\u0000\u01c7\u0000\u0532\u0000\u0555\u0000\u01c7\u0000\u0578\u0000\u059b\u0000\u01c7\u0000\u05be\u0000\u05e1\u0000\u0604\u0000\u01c7\u0000\u01c7\u0000\u0627\u0000\u064a\u0000\u066d\u0000\u0690\u0000\u06b3\u0000\u01c7\u0000\u01c7\u0000\u06d6\u0000\u01c7\u0000\u01c7\u0000\u06f9\u0000\u041a\u0000\u01c7\u0000\u041a\u0000\u071c\u0000\u01c7\u0000\u073f\u0000\u0762\u0000\u0785\u0000\u07a8\u0000\u07cb\u0000\u07ee\u0000\u0811\u0000\u01c7\u0000\u0834\u0000\u0857\u0000\u087a\u0000\u01c7\u0000\u089d\u0000\u08c0\u0000\u08e3\u0000\u0906\u0000\u0929\u0000\u094c\u0000\u01c7\u0000\u096f\u0000\u0992\u0000\u09b5\u0000\u09d8\u0000\u01c7\u0000\u09fb\u0000\u01c7\u0000\u0a1e\u0000\u01c7\u0000\u0a41\u0000\u0a64\u0000\u0a87\u0000\u01c7\u0000\u059b\u0000\u01c7\u0000\u0aaa\u0000\u0acd\u0000\u0af0\u0000\u0b13\u0000\u0b36\u0000\u0b59\u0000\u0b7c\u0000\u0b9f\u0000\u01c7\u0000\u01c7\u0000\u0bc2\u0000\u0be5\u0000\u0c08\u0000\u0c2b\u0000\u01c7\u0000\u0c4e\u0000\u01c7\u0000\u0c71\u0000\u01c7\u0000\u01c7\u0000\u0c94\u0000\u0cb7\u0000\u0302\u0000\u01c7\u0000\u0cda\u0000\u036b\u0000\u0cfd\u0000\u0d20\u0000\u09fb\u0000\u0d43\u0000\u0d66\u0000\u0d89\u0000\u0dac\u0000\u0dcf\u0000\u01c7\u0000\u0df2\u0000\u01c7\u0000\u0e15\u0000\u01c7\u0000\u0e38\u0000\u0e5b\u0000\u01c7\u0000\u0e7e\u0000\u0ea1\u0000\u01c7\u0000\u01c7\u0000\u0992";
    private static final int[] ZZ_TRANS = _HAMLLexer.zzUnpacktrans();
    private static final String ZZ_TRANS_PACKED_0 = "\u0001\u0014\u0001\u0015\u0001\u0016\u0002\u0014\u0001\u0015\u0001\u0017\u0001\u0014\u0001\u0018\u0001\u0019\u0001\u001a\u0004\u0014\u0001\u001b\u0001\u001c\u0001\u001d\u0001\u0014\u0001\u001e\u0001\u0014\u0001\u001f\u0004\u0014\u0001 \u0005\u0014\u0001!\u0001\"\u0001\u0014\u0018\u0000\u0001#\u0002\u0000\u0004#\u0013\u0000\u0001$\b\u0000\u0001%\u0002\u0000\u0004%\u001c\u0000\u0001&\u0002\u0000\u0004&\u0004\u0000\u0001\u0014\u0001'\u0001\u0016\u0002\u0014\u0001'\u0001\u001a\u0001\u0014\u0001(\u0001\u0019\u0001\u001a\u0001\u0014\u0001)\u0003\u0014\u0001*\u0001+\u0001\u0014\u0001\u001e\u0001,\u0001\u001f\u0001-\u0002\u0014\u0001.\u0001,\u0004\u0014\u0001.\u0001!\u0001\"\u0002\u0014\u0001\u0015\u0001\u0016\u0002\u0014\u0001\u0015\u0001\u001a\u0003\u0014\u0001\u001a\u0006\u0014\u0001+\u0003\u0014\u0001\u001f\n\u0014\u0001!\u0001\"\u0001\u0014\u0001/\u00020\u0002\u0000\u00010\u0001/\u00011\u0003/\u00012\u00013\u00014\u0004/\u00015\u00016\u0001/\u00017\u0001/\u00018\u00019\u0002/\u00049\u0003/\u0001\u0000\u0002:\u0001/\u0002\u0000\u0002:\u0001;\u0001<\u0002:\u0001=\u0016:\u0001\u0000\u0002>\u0001\u0016\u0005>\u0001?\u0017>\u0001@\u0002>\u0002A\u0001\u0016\u001dA\u0001B\u0002A\u0002C\u0001D\u001dC\u0001E\u0002C\u0002F\u0001\u0016 F\u0002G\u0001H G#\u0000\u0001I\u0001J\u0001K\u0002I\u0001J\u001dI\u0001L\u0001M\u0001N\u0002L\u0001M\u0002L\u0001O\u001aL\u0002P\u0003\u0000\u001dP\n\u0000\u0001Q\u0019\u0000\u0001\u0014\u0001R\u0001\u0016\u0002\u0014\u0001R\u0001\u001a\u0001\u0014\u0001(\u0001\u0019\u0001\u001a\u0001\u0014\u0001)\u0003\u0014\u0001*\u0001+\u0001\u0014\u0001\u001e\u0001,\u0001\u001f\u0001-\u0003\u0014\u0001,\u0005\u0014\u0001!\u0001\"\u0001\u0014\u0001\u0000\u0001\u0015\u0003\u0000\u0001\u0015#\u0000\u0001S\u000e\u0000\u0001\"%\u0000\u0001T\u0002\u0000\u0004T\u001c\u0000\u0001U\u0002\u0000\u0004U\u0019\u0000\u0001\"\u000e\u0000\u0001V\u0003\u0000\u0001V\u0002\u0000\u0001W2\u0000\u0001X\u0002\u0000\u0004X\u0004\u0000\u0002\u001d\u0003\u0000\u001d\u001d\u0019\u0000\u0001Y\u0002\u0000\u0001Y\u0001Z\u0002Y\u0005\u0000\u0001\"\u0003\u0000\u0001\"\u000f\u0000\u0001[\r\u0000\u0002\\\u0003\u0000\u001d\\\u0003\u0000\u0001]\u0001^\u0001_\u001f\u0000\u0001\"\u0003\u0000\u0001\",\u0000\u0001#\u0002\u0000\u0001#\u0001\u0002\u0004\u0000\u0001#\u0002\u0000\u0004#\u001c\u0000\u0001%\u0002\u0000\u0004%\u0013\u0000\u0001%\u0002\u0000\u0001%\u0005\u0000\u0001%\u0002\u0000\u0004%\u0013\u0000\u0001&\u0002\u0000\u0001&\u0005\u0000\u0001&\u0002\u0000\u0004&\u0005\u0000\u0001'\u0003\u0000\u0001'\u0006\u0000\u0001`.\u0000\u0001a\u0002\u0000\u0004a\u0013\u0000\u0001b\b\u0000\u0001c\u0002\u0000\u0004c\u0005\u0000\u0001+\u0001d\u0002\u0000\u0001+1\u0000\u0001,\u000f\u0000\u0001e\u0003\u0000\u0001e\u0001\u0000\u0001f\u0003\u0000\u0002f\u0005\u0000\u0001g\u0001h\u0003\u0000\u0001i\u0001j\u0001f\u0001\u0000\u0004j\u0001f\u0004\u0000\u00020\u0002\u0000\u00010\u001d\u0000\u00021\u0001\u0000 1\u00022\u0001\u0000 2\u0012\u0000\u00015(\u0000\u0001k\u0002\u0000\u0004k\u001c\u0000\u0001l\u0002\u0000\u0004l\u001c\u0000\u0001m\u0002\u0000\u0004m\u0013\u0000\u00019\u0002\u0000\u00019\u0001n\u0004\u0000\u00019\u0002\u0000\u00049#\u0000\u0001o\"\u0000\u0001p\u0003\u0000\u0002C\u0001\u0000\u0002C\u0001q\bC\u0001r\u0016C\u0001s\u0002C\u0001q\bC\u0001r\u0014C\u0002F\u0001\u0000 F\u0002G\u0001\u0000 G\u0001\u0000\u0001t\u0001u\u0002\u0000\u0001t\u001d\u0000\u0002I\u0003\u0000\u001dI\u0002\u0000\u0001J\u0003\u0000\u0001J\u001e\u0000\u0001v\u0001w\u0002\u0000\u0001v\u001e\u0000\u0001M\u0003\u0000\u0001M\u001e\u0000\u0001x\u0001y\u0002\u0000\u0001x<\u0000\u0001z\u001b\u0000\u0001{\u0002\u0000\u0004{\u0005\u0000\u0001R\u0003\u0000\u0001R\u0006\u0000\u0001`\u001c\u0000\u0001|+\u0000\u0001T\u0002\u0000\u0001T\u0005\u0000\u0001T\u0002\u0000\u0004T\u0013\u0000\u0001U\u0002\u0000\u0001U\u0001}\u0001~\u0001\u0000\u0001\u007f\u0001\u0000\u0001U\u0001\u0000\u0001~\u0004U\u0005\u0000\u0001V\u0003\u0000\u0001V,\u0000\u0001X\u0001\u0080\u0001\u0000\u0001X\u0005\u0000\u0001X\u0002\u0000\u0004X\u0013\u0000\u0001Y\u0002\u0000\u0001Y\u0001\u0081\u0004\u0000\u0001Y\u0002\u0000\u0004Y\u0013\u0000\u0001Y\u0002\u0000\u0001Y\u0001\u0081\u0004\u0000\u0001Y\u0002\u0000\u0002Y\u0001\u0082\u0001Y\u0005\u0000\u0001[\u0003\u0000\u0001[\u001d\u0000\u0002\u0083\u0001\u0000\u001d\u0083\u0001\u0084\u0002\u0083\u0002\u0000\u0001^/\u0000\u0001a\u0002\u0000\u0001a\u0005\u0000\u0001a\u0002\u0000\u0004a\u001c\u0000\u0001c\u0002\u0000\u0004c\u0013\u0000\u0001c\u0002\u0000\u0001c\u0005\u0000\u0001c\u0002\u0000\u0004c\u0016\u0000\u0001g\u0017\u0000\u0001\u0085\u0003\u0000\u0001\u0086\f\u0000\u0001j\u0002\u0000\u0004j\u001b\u0000\u0001\u0087\u0001j\u0002\u0000\u0004j\u0016\u0000\u0001j\u0005\u0000\u0001j\u0002\u0000\u0004j\u0013\u0000\u0001k\u0002\u0000\u0001k\u0005\u0000\u0001k\u0002\u0000\u0004k\u0013\u0000\u0001l\u0002\u0000\u0001l\u0005\u0000\u0001l\u0002\u0000\u0004l\u0013\u0000\u0001m\u0002\u0000\u0001m\u0005\u0000\u0001m\u0002\u0000\u0004m\u001c\u0000\u00019\u0002\u0000\u00049\u0004\u0000\u0002C\u0001\u0000\u0002C\u0001q\bC\u0001r\u0011C\u0001\u0088\u0003C\u0001r\u0001\u0089\u0002C\u0001\u008a\bC\u0001r\u0014C\u0002s\u0001\u008b\u001ds\u0001\u008c\u0002s\u0001\u0000\u0001t\u0003\u0000\u0001t\u001e\u0000\u0001v\u0003\u0000\u0001v\u001e\u0000\u0001x\u0003\u0000\u0001x,\u0000\u0001{\u0002\u0000\u0001{\u0001Q\u0001\u008d\u0001\u0000\u0001\u008e\u0001\u0000\u0001{\u0001\u0000\u0001\u008d\u0004{\u0004\u0000\u0002|\u0001\u0000 |\u0014\u0000\u0001~&\u0000\u0001Y\u0002\u0000\u0004Y\u0013\u0000\u0001Y\u0002\u0000\u0001Y\u0001\u0081\u0004\u0000\u0001Y\u0002\u0000\u0001\u008f\u0003Y\u0004\u0000\u0002\u0083\u0001\u0090\u001d\u0083\u0001\u0084\u0002\u0083\u0007\u0085\u0001f\u0012\u0085\u0001\u0091\b\u0085\u000b\u0086\u0001f\u000e\u0086\u0001\u0092\b\u0086\u0018\u0000\u0001j\u0002\u0000\u0004j\u0004\u0000\u0002C\u0001\u0093\u0002C\u0001q\bC\u0001r\u0015C\u0001r\u0001\u0089\u0002C\u0001\u008a\bC\u0001r\u0011C\u0001\u0088\u0002C\u0002s\u0001\u0094\u001ds\u0001\u008c\u0002s\u0014\u0000\u0001\u008d\u001d\u0000\u0001Y\u0002\u0000\u0001Y\u0001\u0081\u0004\u0000\u0001Y\u0002\u0000\u0003Y\u0001\u0095\u0004\u0000\u0002\u0085\u0003\u0000\u001d\u0085\u0001\u0000\u0002\u0086\u0003\u0000\u001d\u0086\u0001\u0000";
    private static final int ZZ_UNKNOWN_ERROR = 0;
    private static final int ZZ_NO_MATCH = 1;
    private static final int ZZ_PUSHBACK_2BIG = 2;
    private static final String[] ZZ_ERROR_MSG = new String[]{"Unknown internal scanner error", "Error: could not match input", "Error: pushback value was too large"};
    private static final int[] ZZ_ATTRIBUTE = _HAMLLexer.zzUnpackAttribute();
    private static final String ZZ_ATTRIBUTE_PACKED_0 = "\u000b\u0000\u0002\u0001\u0001\b\u0005\u0000\u0001\t\u0001\u0001\u0001\t\r\u0001\u0001\u0000\u0004\u0001\u0001\t\u0002\u0001\u0001\t\u0002\u0001\u0001\t\u0003\u0001\u0002\t\u0005\u0001\u0002\t\u0001\u0001\u0002\t\u0002\u0001\u0001\t\u0002\u0001\u0001\t\u0007\u0001\u0001\t\u0003\u0001\u0001\t\u0001\u0000\u0001\u0001\u0001\u0000\u0003\u0001\u0001\t\u0004\u0001\u0001\t\u0001\u0001\u0001\t\u0001\u0001\u0001\t\u0001\u0001\u0001\u0000\u0001\u0001\u0001\t\u0001\u0000\u0001\t\u0001\u0001\u0002\u0000\u0004\u0001\u0001\u0000\u0002\t\u0002\u0001\u0001\u0000\u0001\u0001\u0001\t\u0001\u0001\u0001\t\u0001\u0001\u0002\t\u0002\u0001\u0001\u0000\u0001\t\u0001\u0001\u0002\u0000\u0001\u0001\u0001\u0000\u0001\u0001\u0003\u0000\u0001\u0001\u0001\t\u0001\u0001\u0001\t\u0001\u0001\u0001\t\u0002\u0001\u0001\t\u0002\u0000\u0002\t\u0001\u0001";
    private Reader zzReader;
    private int zzState;
    private int zzLexicalState = 0;
    private CharSequence zzBuffer = "";
    private int zzMarkedPos;
    private int zzCurrentPos;
    private int zzStartRead;
    private int zzEndRead;
    private boolean zzAtEOF;
    private int yyline;
    protected int yycolumn;
    private long yychar;
    private boolean zzAtBOL = true;
    private boolean zzEOFDone;
    private int filterContentIndent = 0;
    private int commentIndent = 0;
    private BlockState myState;
    private char openBrace;
    private char closeBrace;
    private boolean includeDelimiter;
    private int nextState;
    private boolean lineContinuationSeen = false;
    private boolean injectionParam = false;
    private boolean interpolatedString = false;
    private IElementType myCommentType = null;
    private int myCommentIndent = 0;
    private boolean myConditionalComment = false;

    private static int[] zzUnpackcmap_top() {
        int[] result = new int[4352];
        int offset = 0;
        offset = _HAMLLexer.zzUnpackcmap_top(ZZ_CMAP_TOP_PACKED_0, offset, result);
        return result;
    }

    private static int zzUnpackcmap_top(String packed, int offset, int[] result) {
        int i = 0;
        int j = offset;
        int l = packed.length();
        while (i < l) {
            int count = packed.charAt(i++);
            char value = packed.charAt(i++);
            do {
                result[j++] = value;
            } while (--count > 0);
        }
        return j;
    }

    private static int[] zzUnpackcmap_blocks() {
        int[] result = new int[1024];
        int offset = 0;
        offset = _HAMLLexer.zzUnpackcmap_blocks(ZZ_CMAP_BLOCKS_PACKED_0, offset, result);
        return result;
    }

    private static int zzUnpackcmap_blocks(String packed, int offset, int[] result) {
        int i = 0;
        int j = offset;
        int l = packed.length();
        while (i < l) {
            int count = packed.charAt(i++);
            char value = packed.charAt(i++);
            do {
                result[j++] = value;
            } while (--count > 0);
        }
        return j;
    }

    private static int[] zzUnpackAction() {
        int[] result = new int[149];
        int offset = 0;
        offset = _HAMLLexer.zzUnpackAction(ZZ_ACTION_PACKED_0, offset, result);
        return result;
    }

    private static int zzUnpackAction(String packed, int offset, int[] result) {
        int i = 0;
        int j = offset;
        int l = packed.length();
        while (i < l) {
            int count = packed.charAt(i++);
            char value = packed.charAt(i++);
            do {
                result[j++] = value;
            } while (--count > 0);
        }
        return j;
    }

    private static int[] zzUnpackRowMap() {
        int[] result = new int[149];
        int offset = 0;
        offset = _HAMLLexer.zzUnpackRowMap(ZZ_ROWMAP_PACKED_0, offset, result);
        return result;
    }

    private static int zzUnpackRowMap(String packed, int offset, int[] result) {
        int i = 0;
        int j = offset;
        int l = packed.length() - 1;
        while (i < l) {
            int high = packed.charAt(i++) << 16;
            result[j++] = high | packed.charAt(i++);
        }
        return j;
    }

    private static int[] zzUnpacktrans() {
        int[] result = new int[3780];
        int offset = 0;
        offset = _HAMLLexer.zzUnpacktrans(ZZ_TRANS_PACKED_0, offset, result);
        return result;
    }

    private static int zzUnpacktrans(String packed, int offset, int[] result) {
        int i = 0;
        int j = offset;
        int l = packed.length();
        while (i < l) {
            int count = packed.charAt(i++);
            int value = packed.charAt(i++);
            do {
                result[j++] = --value;
            } while (--count > 0);
        }
        return j;
    }

    private static int[] zzUnpackAttribute() {
        int[] result = new int[149];
        int offset = 0;
        offset = _HAMLLexer.zzUnpackAttribute(ZZ_ATTRIBUTE_PACKED_0, offset, result);
        return result;
    }

    private static int zzUnpackAttribute(String packed, int offset, int[] result) {
        int i = 0;
        int j = offset;
        int l = packed.length();
        while (i < l) {
            int count = packed.charAt(i++);
            char value = packed.charAt(i++);
            do {
                result[j++] = value;
            } while (--count > 0);
        }
        return j;
    }

    private int getIndent() {
        int commentIndent = 0;
        int loc = this.getTokenStart() - 1;
        while (0 <= loc && this.zzBuffer.charAt(loc) != '\n') {
            --loc;
            ++commentIndent;
        }
        return commentIndent;
    }

    private void yyBegin(int newState) {
        this.yybegin(newState);
    }

    private char previousChar() {
        return this.charAt(-1);
    }

    private char charAt(int offset) {
        int loc = this.getTokenStart() + offset;
        return 0 <= loc && loc < this.zzBuffer.length() ? this.zzBuffer.charAt(loc) : (char)'\uffff';
    }

    private void readParens() {
        char c;
        int length;
        int braceBalance = 1;
        int n = length = this.includeDelimiter ? 1 : 0;
        while (braceBalance != 0 && (c = this.charAt(length)) != '\uffff') {
            if (c == this.openBrace) {
                ++braceBalance;
            }
            if (c == this.closeBrace) {
                --braceBalance;
            }
            ++length;
        }
        this.zzMarkedPos += length - 1;
        if (!this.includeDelimiter) {
            --this.zzMarkedPos;
        }
    }

    private boolean doesPipeBelongToRuby(String text) {
        int i;
        text = text.trim();
        for (i = text.length() - 2; i >= 0 && text.charAt(i) != '|'; --i) {
        }
        if (i > 0) {
            --i;
            while (i >= 0 && StringUtil.isWhiteSpace((char)text.charAt(i))) {
                --i;
            }
            return i >= 2 && text.substring(i - 1, i + 1).equals("do");
        }
        return false;
    }

    public _HAMLLexer(Reader in) {
        this.zzReader = in;
    }

    private int zzMaxBufferLen() {
        return Integer.MAX_VALUE;
    }

    private boolean zzCanGrow() {
        return true;
    }

    private static int zzCMap(int input) {
        int offset = input & 0xFF;
        return offset == input ? ZZ_CMAP_BLOCKS[offset] : ZZ_CMAP_BLOCKS[ZZ_CMAP_TOP[input >> 8] | offset];
    }

    public final int getTokenStart() {
        return this.zzStartRead;
    }

    public final int getTokenEnd() {
        return this.getTokenStart() + this.yylength();
    }

    public void reset(CharSequence buffer, int start, int end, int initialState) {
        this.zzBuffer = buffer;
        this.zzMarkedPos = this.zzStartRead = start;
        this.zzCurrentPos = this.zzStartRead;
        this.zzAtEOF = false;
        this.zzAtBOL = true;
        this.zzEndRead = end;
        this.yybegin(initialState);
    }

    private boolean zzRefill() throws IOException {
        return true;
    }

    public final int yystate() {
        return this.zzLexicalState;
    }

    public final void yybegin(int newState) {
        this.zzLexicalState = newState;
    }

    public final CharSequence yytext() {
        return this.zzBuffer.subSequence(this.zzStartRead, this.zzMarkedPos);
    }

    public final char yycharat(int pos) {
        return this.zzBuffer.charAt(this.zzStartRead + pos);
    }

    public final int yylength() {
        return this.zzMarkedPos - this.zzStartRead;
    }

    private void zzScanError(int errorCode) {
        String message;
        try {
            message = ZZ_ERROR_MSG[errorCode];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            message = ZZ_ERROR_MSG[0];
        }
        throw new Error(message);
    }

    public void yypushback(int number) {
        if (number > this.yylength()) {
            this.zzScanError(2);
        }
        this.zzMarkedPos -= number;
    }

    public IElementType advance() throws IOException {
        int zzEndReadL = this.zzEndRead;
        CharSequence zzBufferL = this.zzBuffer;
        int[] zzTransL = ZZ_TRANS;
        int[] zzRowMapL = ZZ_ROWMAP;
        int[] zzAttrL = ZZ_ATTRIBUTE;
        block136: while (true) {
            int zzInput;
            int zzMarkedPosL = this.zzMarkedPos;
            int zzAction = -1;
            this.zzCurrentPos = this.zzStartRead = zzMarkedPosL;
            int zzCurrentPosL = this.zzStartRead;
            this.zzState = ZZ_LEXSTATE[this.zzLexicalState];
            int zzAttributes = zzAttrL[this.zzState];
            if ((zzAttributes & 1) == 1) {
                zzAction = this.zzState;
            }
            while (true) {
                if (zzCurrentPosL < zzEndReadL) {
                    zzInput = Character.codePointAt(zzBufferL, zzCurrentPosL);
                    zzCurrentPosL += Character.charCount(zzInput);
                } else {
                    if (this.zzAtEOF) {
                        zzInput = -1;
                        break;
                    }
                    this.zzCurrentPos = zzCurrentPosL;
                    this.zzMarkedPos = zzMarkedPosL;
                    boolean eof = this.zzRefill();
                    zzCurrentPosL = this.zzCurrentPos;
                    zzMarkedPosL = this.zzMarkedPos;
                    zzBufferL = this.zzBuffer;
                    zzEndReadL = this.zzEndRead;
                    if (eof) {
                        zzInput = -1;
                        break;
                    }
                    zzInput = Character.codePointAt(zzBufferL, zzCurrentPosL);
                    zzCurrentPosL += Character.charCount(zzInput);
                }
                int zzNext = zzTransL[zzRowMapL[this.zzState] + _HAMLLexer.zzCMap(zzInput)];
                if (zzNext == -1) break;
                this.zzState = zzNext;
                zzAttributes = zzAttrL[this.zzState];
                if ((zzAttributes & 1) != 1) continue;
                zzAction = this.zzState;
                zzMarkedPosL = zzCurrentPosL;
                if ((zzAttributes & 8) == 8) break;
            }
            this.zzMarkedPos = zzMarkedPosL;
            if (zzInput == -1 && this.zzStartRead == this.zzCurrentPos) {
                this.zzAtEOF = true;
                return null;
            }
            switch (zzAction < 0 ? zzAction : ZZ_ACTION[zzAction]) {
                case 1: {
                    return RUBY_STRING;
                }
                case 68: {
                    continue block136;
                }
                case 2: {
                    return this.myCommentType;
                }
                case 69: {
                    continue block136;
                }
                case 3: {
                    this.yypushback(1);
                    this.yyBegin(16);
                }
                case 70: {
                    continue block136;
                }
                case 4: {
                    char prev = this.previousChar();
                    return prev == '\n' || prev == '\uffff' ? INDENT : WHITESPACE;
                }
                case 71: {
                    continue block136;
                }
                case 5: {
                    this.yyBegin(0);
                    return EOL;
                }
                case 72: {
                    continue block136;
                }
                case 6: {
                    this.yyBegin(20);
                    this.lineContinuationSeen = false;
                    return RUBY_CODE_MARKER;
                }
                case 73: {
                    continue block136;
                }
                case 7: {
                    this.myConditionalComment = this.yytext().toString().startsWith("/[");
                    this.myCommentType = HTML_COMMENT;
                    this.myCommentIndent = this.getIndent();
                    this.yybegin(24);
                    return this.myCommentType;
                }
                case 74: {
                    continue block136;
                }
                case 8: {
                    this.yyBegin(20);
                    this.lineContinuationSeen = false;
                    return RUBY_CODE_MARKER;
                }
                case 75: {
                    continue block136;
                }
                case 9: {
                    this.yyBegin(8);
                    return TAG_NAME;
                }
                case 76: {
                    continue block136;
                }
                case 10: {
                    this.yyBegin(8);
                    return CLASS;
                }
                case 77: {
                    continue block136;
                }
                case 11: {
                    this.yyBegin(8);
                    return ID;
                }
                case 78: {
                    continue block136;
                }
                case 12: {
                    this.yyBegin(36);
                    char prev = this.previousChar();
                    return prev == '\n' || prev == '\uffff' ? INDENT : WHITESPACE;
                }
                case 79: {
                    continue block136;
                }
                case 13: {
                    this.yypushback(1);
                    this.openBrace = (char)40;
                    this.closeBrace = (char)41;
                    this.includeDelimiter = true;
                    this.yyBegin(12);
                }
                case 80: {
                    continue block136;
                }
                case 14: {
                    this.zzMarkedPos = Character.offsetByCodePoints(zzBufferL, this.zzStartRead, 1);
                    this.yyBegin(0);
                    return CLOSE_TAG;
                }
                case 81: {
                    continue block136;
                }
                case 15: {
                    return SPACE_EATER;
                }
                case 82: {
                    continue block136;
                }
                case 16: {
                    this.injectionParam = false;
                    this.yypushback(1);
                    this.yyBegin(0);
                }
                case 83: {
                    continue block136;
                }
                case 17: {
                    this.injectionParam = false;
                    return WHITESPACE;
                }
                case 84: {
                    continue block136;
                }
                case 18: {
                    this.interpolatedString = true;
                    this.yypushback(this.yylength() - 1);
                    this.yyBegin(14);
                    return XmlTokenType.XML_ATTRIBUTE_VALUE_START_DELIMITER;
                }
                case 85: {
                    continue block136;
                }
                case 19: {
                    this.interpolatedString = false;
                    this.yypushback(this.yylength() - 1);
                    this.yyBegin(14);
                    return XmlTokenType.XML_ATTRIBUTE_VALUE_START_DELIMITER;
                }
                case 86: {
                    continue block136;
                }
                case 20: {
                    return OP_BRACE;
                }
                case 87: {
                    continue block136;
                }
                case 21: {
                    this.injectionParam = false;
                    this.yyBegin(8);
                    return CL_BRACE;
                }
                case 88: {
                    continue block136;
                }
                case 22: {
                    return PARAM;
                }
                case 89: {
                    continue block136;
                }
                case 23: {
                    return EQUALS;
                }
                case 90: {
                    continue block136;
                }
                case 24: {
                    return this.injectionParam ? INJECTION_CODE : PARAM;
                }
                case 91: {
                    continue block136;
                }
                case 25: {
                    return XmlTokenType.XML_ATTRIBUTE_VALUE_TOKEN;
                }
                case 92: {
                    continue block136;
                }
                case 26: {
                    if (this.interpolatedString && (this.charAt(-1) != '\\' || this.charAt(-2) == '\\')) {
                        this.yyBegin(12);
                    }
                    return this.interpolatedString ? XmlTokenType.XML_ATTRIBUTE_VALUE_END_DELIMITER : XmlTokenType.XML_ATTRIBUTE_VALUE_TOKEN;
                }
                case 93: {
                    continue block136;
                }
                case 27: {
                    if (!(this.interpolatedString || this.charAt(-1) == '\\' && this.charAt(-2) != '\\')) {
                        this.yyBegin(12);
                    }
                    return this.interpolatedString ? XmlTokenType.XML_ATTRIBUTE_VALUE_TOKEN : XmlTokenType.XML_ATTRIBUTE_VALUE_END_DELIMITER;
                }
                case 94: {
                    continue block136;
                }
                case 28: {
                    return TEXT;
                }
                case 95: {
                    continue block136;
                }
                case 29: {
                    this.readParens();
                    this.yyBegin(this.nextState);
                    return INJECTION_CODE;
                }
                case 96: {
                    continue block136;
                }
                case 30: {
                    if (this.lineContinuationSeen) {
                        if (this.charAt(this.yylength() - 1) == '|') {
                            if (this.yylength() > 1) {
                                this.yypushback(1);
                                return INJECTION_CODE;
                            }
                            return LINE_CONTINUATION;
                        }
                        this.yypushback(this.yylength());
                        this.yyBegin(0);
                    } else {
                        return INJECTION_CODE;
                    }
                }
                case 97: {
                    continue block136;
                }
                case 31: {
                    this.yyBegin(0);
                    return EOL;
                }
                case 98: {
                    continue block136;
                }
                case 32: {
                    if (this.myConditionalComment) {
                        this.yybegin(0);
                        return EOL;
                    }
                    if (this.yylength() - 1 > this.myCommentIndent) {
                        return this.myCommentType;
                    }
                    this.yybegin(0);
                    this.yypushback(this.yylength());
                }
                case 99: {
                    continue block136;
                }
                case 33: {
                    return this.myState == BlockState.RUBY_STATE ? INJECTION_CODE : HAML_COMMENT;
                }
                case 100: {
                    continue block136;
                }
                case 34: {
                    if (this.previousChar() == '\n' && this.filterContentIndent >= this.yylength()) {
                        this.yyBegin(0);
                        return INDENT;
                    }
                    return this.myState == BlockState.RUBY_STATE ? INJECTION_CODE : HAML_COMMENT;
                }
                case 101: {
                    continue block136;
                }
                case 35: {
                    this.yyBegin(0);
                    return EOL;
                }
                case 102: {
                    continue block136;
                }
                case 36: {
                    return FILTER_CONTENT;
                }
                case 103: {
                    continue block136;
                }
                case 37: {
                    if (this.previousChar() == '\n' && this.filterContentIndent >= this.yylength()) {
                        this.yyBegin(0);
                        return INDENT;
                    }
                    return FILTER_CONTENT;
                }
                case 104: {
                    continue block136;
                }
                case 38: {
                    this.yypushback(this.yylength());
                    this.yyBegin(8);
                    return PSEUDO_TAG_NAME;
                }
                case 105: {
                    continue block136;
                }
                case 39: {
                    this.yypushback(this.yylength());
                    this.yyBegin(32);
                    return PSEUDO_TAG_START;
                }
                case 106: {
                    continue block136;
                }
                case 40: {
                    this.yypushback(this.yylength());
                    this.yyBegin(34);
                    return PSEUDO_TAG_START;
                }
                case 107: {
                    continue block136;
                }
                case 41: {
                    this.myCommentType = HAML_COMMENT;
                    this.myCommentIndent = this.getIndent();
                    this.yybegin(24);
                    return this.myCommentType;
                }
                case 108: {
                    continue block136;
                }
                case 42: {
                    this.yyBegin(30);
                    this.myState = BlockState.FILTER_STATE;
                    this.filterContentIndent = this.getIndent();
                    return FILTER;
                }
                case 109: {
                    continue block136;
                }
                case 43: {
                    this.yyBegin(22);
                    return RUBY_STRING_MARKER;
                }
                case 110: {
                    continue block136;
                }
                case 44: {
                    this.yyBegin(16);
                    return ESCAPE;
                }
                case 111: {
                    continue block136;
                }
                case 45: {
                    this.zzMarkedPos = Character.offsetByCodePoints(zzBufferL, this.zzStartRead, 1);
                    return TEXT;
                }
                case 112: {
                    continue block136;
                }
                case 46: {
                    this.yypushback(1);
                    this.yyBegin(16);
                    return WHITESPACE;
                }
                case 113: {
                    continue block136;
                }
                case 47: {
                    this.yypushback(this.yylength() - 1);
                    this.yyBegin(6);
                    return ID_START;
                }
                case 114: {
                    continue block136;
                }
                case 48: {
                    this.yypushback(this.yylength() - 1);
                    this.yyBegin(4);
                    return CLASS_START;
                }
                case 115: {
                    continue block136;
                }
                case 49: {
                    this.zzMarkedPos = Character.offsetByCodePoints(zzBufferL, this.zzStartRead, 1);
                    this.yypushback(1);
                    this.nextState = this.openBrace == '[' ? 36 : 8;
                    this.openBrace = this.charAt(0);
                    this.closeBrace = (char)(this.openBrace == '{' ? 125 : 93);
                    this.includeDelimiter = true;
                    this.yyBegin(18);
                    if (this.nextState == 36) {
                        return RUBY_CODE_MARKER;
                    }
                }
                case 116: {
                    continue block136;
                }
                case 50: {
                    this.yypushback(this.yylength() - 1);
                    this.injectionParam = true;
                    return EQUALS;
                }
                case 117: {
                    continue block136;
                }
                case 51: {
                    return INJECTION_CODE;
                }
                case 118: {
                    continue block136;
                }
                case 52: {
                    if (this.interpolatedString && (this.charAt(-1) != '\\' || this.charAt(-2) == '\\')) {
                        this.openBrace = (char)123;
                        this.closeBrace = (char)125;
                        this.includeDelimiter = false;
                        this.nextState = 14;
                        this.yyBegin(18);
                    }
                    return XmlTokenType.XML_ATTRIBUTE_VALUE_TOKEN;
                }
                case 119: {
                    continue block136;
                }
                case 53: {
                    if (this.charAt(-1) != '\\' || this.charAt(-2) == '\\') {
                        this.openBrace = (char)123;
                        this.closeBrace = (char)125;
                        this.includeDelimiter = false;
                        this.nextState = 16;
                        this.yyBegin(18);
                    }
                    return TEXT;
                }
                case 120: {
                    continue block136;
                }
                case 54: {
                    this.zzMarkedPos = Character.offsetByCodePoints(zzBufferL, this.zzStartRead, 1);
                    return this.myCommentType;
                }
                case 121: {
                    continue block136;
                }
                case 55: {
                    if (this.filterContentIndent < this.yylength() - 1) {
                        this.yypushback(this.yylength() - 1);
                        return this.myState == BlockState.RUBY_STATE ? INJECTION_CODE : HAML_COMMENT;
                    }
                    this.yypushback(this.yylength() - 1);
                    this.yyBegin(0);
                    return EOL;
                }
                case 122: {
                    continue block136;
                }
                case 56: {
                    this.zzMarkedPos = Character.offsetByCodePoints(zzBufferL, this.zzStartRead, 1);
                    return this.myState == BlockState.RUBY_STATE ? INJECTION_CODE : HAML_COMMENT;
                }
                case 123: {
                    continue block136;
                }
                case 57: {
                    if (this.filterContentIndent < this.yylength() - 1) {
                        this.yypushback(this.yylength() - 1);
                        return FILTER_CONTENT;
                    }
                    this.yypushback(this.yylength() - 1);
                    this.yyBegin(0);
                    return EOL;
                }
                case 124: {
                    continue block136;
                }
                case 58: {
                    this.zzMarkedPos = Character.offsetByCodePoints(zzBufferL, this.zzStartRead, 1);
                    return FILTER_CONTENT;
                }
                case 125: {
                    continue block136;
                }
                case 59: {
                    if (this.charAt(-1) != '\\' || this.charAt(-2) == '\\') {
                        this.openBrace = (char)123;
                        this.closeBrace = (char)125;
                        this.includeDelimiter = false;
                        this.nextState = 30;
                        this.yyBegin(18);
                    }
                    return FILTER_CONTENT;
                }
                case 126: {
                    continue block136;
                }
                case 60: {
                    this.yypushback(this.yylength() - 1);
                    this.yyBegin(2);
                    return TAG_START;
                }
                case 127: {
                    continue block136;
                }
                case 61: {
                    return XHTML;
                }
                case 128: {
                    continue block136;
                }
                case 62: {
                    this.zzMarkedPos = Character.offsetByCodePoints(zzBufferL, this.zzStartRead, 2);
                    this.yyBegin(0);
                    return LINE_CONTINUATION;
                }
                case 129: {
                    continue block136;
                }
                case 63: {
                    if (this.lineContinuationSeen) {
                        this.yypushback(this.yylength());
                        this.yyBegin(0);
                    } else {
                        return INJECTION_CODE;
                    }
                }
                case 130: {
                    continue block136;
                }
                case 64: {
                    this.zzMarkedPos = Character.offsetByCodePoints(zzBufferL, this.zzStartRead, 2);
                    this.yyBegin(0);
                    return EOL;
                }
                case 131: {
                    continue block136;
                }
                case 65: {
                    this.zzMarkedPos = Character.offsetByCodePoints(zzBufferL, this.zzStartRead, 2);
                    this.lineContinuationSeen = true;
                    return LINE_CONTINUATION;
                }
                case 132: {
                    continue block136;
                }
                case 66: {
                    if (this.doesPipeBelongToRuby(this.yytext().toString())) {
                        this.yypushback(1);
                    } else {
                        this.yypushback(2);
                    }
                    return INJECTION_CODE;
                }
                case 133: {
                    continue block136;
                }
                case 67: {
                    this.yyBegin(28);
                    this.myState = BlockState.RUBY_STATE;
                    this.filterContentIndent = this.getIndent();
                    return FILTER;
                }
                case 134: {
                    continue block136;
                }
            }
            this.zzScanError(1);
        }
    }

    static enum BlockState {
        FILTER_STATE,
        RUBY_STATE,
        COMMENT_STATE;

    }
}

