/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.haml.filters;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.injection.MultiHostInjector;
import com.intellij.lang.injection.MultiHostRegistrar;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.haml.psi.HAMLTokenTypes;
import org.jetbrains.plugins.haml.psi.impl.HAMLTagImpl;

public final class HamlFilterInjector
implements MultiHostInjector {
    private static final Map<String, String> HAML_FILTER_TO_LANGUAGE_ID_MAP = new HashMap<String, String>();

    public void getLanguagesToInject(@NotNull MultiHostRegistrar registrar, @NotNull PsiElement element) {
        if (registrar == null) {
            HamlFilterInjector.$$$reportNull$$$0(0);
        }
        if (element == null) {
            HamlFilterInjector.$$$reportNull$$$0(1);
        }
        if (element instanceof HAMLTagImpl) {
            ASTNode possibleFilterContent;
            ASTNode firstChild = element.getNode().getFirstChildNode();
            if (firstChild.getElementType() == HAMLTokenTypes.INDENT) {
                firstChild = firstChild.getTreeNext();
            }
            if (firstChild != null && firstChild.getElementType() == HAMLTokenTypes.FILTER && (possibleFilterContent = firstChild.getTreeNext()).getElementType() == HAMLTokenTypes.FILTER_CONTENT) {
                String languageName = firstChild.getText();
                String languageId = HAML_FILTER_TO_LANGUAGE_ID_MAP.get(languageName = StringUtil.trimStart((String)languageName, (String)":"));
                if (languageId == null) {
                    return;
                }
                Language filterLanguage = Language.findLanguageByID((String)languageId);
                if (filterLanguage == null) {
                    return;
                }
                if (LanguageParserDefinitions.INSTANCE.forLanguage(filterLanguage) == null) {
                    return;
                }
                registrar.startInjecting(filterLanguage);
                for (PsiElement child : element.getChildren()) {
                    if (child.getNode().getElementType() != HAMLTokenTypes.FILTER_CONTENT) continue;
                    int injectionOffset = child.getNode().getStartOffset() - ((HAMLTagImpl)element).getStartOffset();
                    TextRange range = new TextRange(injectionOffset, injectionOffset + child.getTextLength());
                    registrar.addPlace(null, null, (PsiLanguageInjectionHost)element, range);
                }
                registrar.doneInjecting();
            }
        }
    }

    @NotNull
    public List<? extends Class<? extends PsiElement>> elementsToInjectIn() {
        List<Class<HAMLTagImpl>> list = Collections.singletonList(HAMLTagImpl.class);
        if (list == null) {
            HamlFilterInjector.$$$reportNull$$$0(2);
        }
        return list;
    }

    static {
        HAML_FILTER_TO_LANGUAGE_ID_MAP.put("ruby", "ruby");
        HAML_FILTER_TO_LANGUAGE_ID_MAP.put("javascript", "JavaScript");
        HAML_FILTER_TO_LANGUAGE_ID_MAP.put("css", "CSS");
        HAML_FILTER_TO_LANGUAGE_ID_MAP.put("sass", "SASS");
        HAML_FILTER_TO_LANGUAGE_ID_MAP.put("scss", "SCSS");
        HAML_FILTER_TO_LANGUAGE_ID_MAP.put("less", "LESS");
        HAML_FILTER_TO_LANGUAGE_ID_MAP.put("styl", "Stylus");
        HAML_FILTER_TO_LANGUAGE_ID_MAP.put("coffee", "CoffeeScript");
        HAML_FILTER_TO_LANGUAGE_ID_MAP.put("coffeescript", "CoffeeScript");
        HAML_FILTER_TO_LANGUAGE_ID_MAP.put("erb", "ERB");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "registrar";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/haml/filters/HamlFilterInjector";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/haml/filters/HamlFilterInjector";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "elementsToInjectIn";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getLanguagesToInject";
                break;
            }
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

