/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.haml;

import com.intellij.lang.Commenter;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageCommenters;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.templateLanguages.MultipleLangCommentProvider;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.haml.HAMLCommenter;
import org.jetbrains.plugins.haml.HAMLLanguage;
import org.jetbrains.plugins.haml.psi.HAMLTokenTypes;

public final class HAMLCommentProvider
implements MultipleLangCommentProvider {
    @Nullable
    public Commenter getLineCommenter(@NotNull PsiFile file, @NotNull Editor editor, @NotNull Language lineStartLanguage, @NotNull Language lineEndLanguage) {
        if (file == null) {
            HAMLCommentProvider.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            HAMLCommentProvider.$$$reportNull$$$0(1);
        }
        if (lineStartLanguage == null) {
            HAMLCommentProvider.$$$reportNull$$$0(2);
        }
        if (lineEndLanguage == null) {
            HAMLCommentProvider.$$$reportNull$$$0(3);
        }
        Commenter hamlCommenter = (Commenter)LanguageCommenters.INSTANCE.forLanguage((Language)HAMLLanguage.INSTANCE);
        if (lineStartLanguage != lineEndLanguage) {
            return hamlCommenter;
        }
        if (file.getTextLength() == 0) {
            return hamlCommenter;
        }
        int offset = editor.getCaretModel().getOffset();
        PsiElement element = file.findElementAt(offset);
        if (element == null) {
            element = file.findElementAt(offset - 1);
        }
        if (element == null) {
            return hamlCommenter;
        }
        IElementType elementType = element.getNode().getElementType();
        String id = null;
        if (elementType == HAMLTokenTypes.INJECTION_CODE) {
            id = "ruby";
        } else if (elementType == HAMLTokenTypes.JAVASCRIPT_CODE) {
            id = "JavaScript";
        }
        if (id == null) {
            return hamlCommenter;
        }
        Language language = Language.findLanguageByID((String)id);
        if (language == null) {
            return hamlCommenter;
        }
        final Commenter commenter = (Commenter)LanguageCommenters.INSTANCE.forLanguage(language);
        if (commenter == null) {
            return hamlCommenter;
        }
        return new HAMLCommenter(){

            @Override
            public String getLineCommentPrefix() {
                return commenter.getLineCommentPrefix();
            }

            @Override
            public String getBlockCommentPrefix() {
                return commenter.getBlockCommentPrefix();
            }

            @Override
            public String getBlockCommentSuffix() {
                return commenter.getBlockCommentSuffix();
            }
        };
    }

    public boolean canProcess(@NotNull PsiFile file, @NotNull FileViewProvider viewProvider) {
        if (file == null) {
            HAMLCommentProvider.$$$reportNull$$$0(4);
        }
        if (viewProvider == null) {
            HAMLCommentProvider.$$$reportNull$$$0(5);
        }
        return viewProvider.getLanguages().contains((Object)HAMLLanguage.INSTANCE);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lineStartLanguage";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lineEndLanguage";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "viewProvider";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/haml/HAMLCommentProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getLineCommenter";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "canProcess";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

