/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ruby.rbs.frontback.psi.tree;

import com.intellij.lang.ASTFactory;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.ruby.rbs.frontback.psi.RbsLexerAdapter;
import com.intellij.ruby.rbs.frontback.psi.tree.RbsElementTypesGenerated;
import com.intellij.ruby.rbs.frontback.psi.tree.RbsReparseableTokenType;
import com.intellij.util.text.MergingCharSequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RbsReparseableLexerConfirmedTokenType
extends RbsReparseableTokenType {
    private static final Logger LOG = Logger.getInstance(RbsReparseableLexerConfirmedTokenType.class);
    private static final TokenSet SAFE_LEXING_CONTAINERS = TokenSet.create((IElementType[])new IElementType[]{RbsElementTypesGenerated.RBS_CLASS_DECL, RbsElementTypesGenerated.RBS_MODULE_DECL, RbsElementTypesGenerated.RBS_INTERFACE_DECL, RbsElementTypesGenerated.RBS_METHOD_MEMBER, RbsElementTypesGenerated.RBS_INCLUDE_MEMBER, RbsElementTypesGenerated.RBS_ALIAS_MEMBER, RbsElementTypesGenerated.RBS_TYPE_DECL, RbsElementTypesGenerated.RBS_GLOBAL_DECL, RbsElementTypesGenerated.RBS_CONST_DECL, RbsElementTypesGenerated.RBS_EXTEND_MEMBER, RbsElementTypesGenerated.RBS_PREPEND_MEMBER, RbsElementTypesGenerated.RBS_VAR_TYPE_MEMBER, RbsElementTypesGenerated.RBS_ATTRIBUTE_MEMBER, RbsElementTypesGenerated.RBS_ANNOTATION});

    public RbsReparseableLexerConfirmedTokenType(@NotNull String debugName) {
        if (debugName == null) {
            RbsReparseableLexerConfirmedTokenType.$$$reportNull$$$0(0);
        }
        super(debugName);
    }

    @Nullable
    public ASTNode reparseLeaf(@NotNull ASTNode leaf, @NotNull CharSequence newText) {
        if (leaf == null) {
            RbsReparseableLexerConfirmedTokenType.$$$reportNull$$$0(1);
        }
        if (newText == null) {
            RbsReparseableLexerConfirmedTokenType.$$$reportNull$$$0(2);
        }
        if (newText.isEmpty()) {
            return null;
        }
        ASTNode lexingContainer = TreeUtil.findParent((ASTNode)leaf, (TokenSet)SAFE_LEXING_CONTAINERS);
        if (lexingContainer == null) {
            LOG.debug("No re-lexing container for a leaf");
            return null;
        }
        CharSequence originalCharSequence = lexingContainer.getChars();
        TextRange originalLeafRangeInLexingContainer = leaf.getTextRange().shiftLeft(lexingContainer.getStartOffset());
        MergingCharSequence updatedCharSequence = StringUtil.replaceSubSequence((CharSequence)originalCharSequence, (int)originalLeafRangeInLexingContainer.getStartOffset(), (int)originalLeafRangeInLexingContainer.getEndOffset(), (CharSequence)newText);
        LeafElement currentLeaf = TreeUtil.findFirstLeaf((ASTNode)lexingContainer);
        RbsLexerAdapter rbsLexer = new RbsLexerAdapter();
        rbsLexer.start((CharSequence)updatedCharSequence);
        while (true) {
            if (currentLeaf == null) {
                LOG.debug("We are out of original leaves");
                return null;
            }
            IElementType tokenType = rbsLexer.getTokenType();
            if (tokenType != currentLeaf.getElementType()) {
                LOG.debug("Wrong token type lexed: ", new Object[]{tokenType, " instead of ", currentLeaf.getElementType()});
                return null;
            }
            TextRange currentLeafRangeInLexingContainer = currentLeaf.getTextRange().shiftLeft(lexingContainer.getStartOffset());
            if (currentLeaf == leaf) {
                int expectedEndOffset = currentLeafRangeInLexingContainer.getStartOffset() + newText.length();
                if (rbsLexer.getTokenEnd() == expectedEndOffset) break;
                LOG.debug("Wrong end offset, got ", new Object[]{rbsLexer.getTokenEnd(), " instead of ", expectedEndOffset});
                return null;
            }
            if (currentLeafRangeInLexingContainer.getEndOffset() != rbsLexer.getTokenEnd()) {
                LOG.debug("Wrong token end offset for: ", new Object[]{tokenType, "; got ", rbsLexer.getTokenEnd(), " instead of ", currentLeafRangeInLexingContainer.getEndOffset()});
                return null;
            }
            currentLeaf = TreeUtil.nextLeaf((LeafElement)currentLeaf);
            rbsLexer.advance();
        }
        return ASTFactory.leaf((IElementType)this, (CharSequence)newText);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "leaf";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newText";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ruby/rbs/frontback/psi/tree/RbsReparseableLexerConfirmedTokenType";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "reparseLeaf";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

