/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ruby.rbs.frontback.formatter.processors;

import com.intellij.formatting.ASTBlock;
import com.intellij.formatting.Block;
import com.intellij.formatting.Spacing;
import com.intellij.formatting.SpacingBuilder;
import com.intellij.lang.ASTNode;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.tree.IElementType;
import com.intellij.ruby.rbs.frontback.psi.tree.RbsElementTypesGenerated;
import com.intellij.ruby.rbs.frontback.psi.tree.RbsTokenSets;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.lang.formatter.processors.RubyFormattingProcessor;

public final class RbsSpacingProcessor
extends RubyFormattingProcessor {
    @NotNull
    private final SpacingBuilder mySpacingBuilder;

    RbsSpacingProcessor(@NotNull CommonCodeStyleSettings settings) {
        if (settings == null) {
            RbsSpacingProcessor.$$$reportNull$$$0(0);
        }
        super(settings);
        this.mySpacingBuilder = this.createSpacingBuilder();
    }

    @NotNull
    private SpacingBuilder createSpacingBuilder() {
        SpacingBuilder spacingBuilder = new SpacingBuilder(this.mySettings).between(RbsElementTypesGenerated.RBS_USE_DIRECTIVE, RbsElementTypesGenerated.RBS_USE_DIRECTIVE).spacing(0, 0, 1, false, 0).before(RbsTokenSets.RBS_VISIBILITY_MEMBER).blankLines(1).after(RbsTokenSets.RBS_VISIBILITY_MEMBER).blankLines(1).after(RbsElementTypesGenerated.RBS_LINE_COMMENT).lineBreakInCode().between(RbsElementTypesGenerated.RBS_KLBRACKET, RbsElementTypesGenerated.RBS_KRBRACKET).spaces(1).between(RbsElementTypesGenerated.RBS_KRPAREN, RbsElementTypesGenerated.RBS_KQUESTION).none().before(RbsTokenSets.RBS_ONE_SPACE_BEFORE_ELEMENTS).spaces(1).after(RbsTokenSets.RBS_ONE_SPACE_AFTER_ELEMENTS).spaces(1).between(RbsElementTypesGenerated.RBS_CLASS_NAME, RbsElementTypesGenerated.RBS_KCOLON).spaces(1).between(RbsTokenSets.RBS_ONE_SPACE_BETWEEN_ALIAS_NAMES, RbsTokenSets.RBS_ONE_SPACE_BETWEEN_ALIAS_NAMES).spaces(1).after(RbsTokenSets.RBS_NO_SPACE_AFTER_ELEMENTS).none().before(RbsTokenSets.RBS_NO_SPACE_BEFORE_ELEMENTS).none().afterInside(RbsTokenSets.RBS_ONE_SPACE_AFTER_ELEMENT_INSIDE_TYPE_PARAMS, RbsTokenSets.RBS_TYPE_PARAMS).spaces(1);
        if (spacingBuilder == null) {
            RbsSpacingProcessor.$$$reportNull$$$0(1);
        }
        return spacingBuilder;
    }

    @Nullable
    public Spacing getSpacing(@NotNull Block parentBlock, @Nullable Block leftBlock, @NotNull Block rightBlock) {
        IElementType rightType;
        IElementType leftType;
        if (parentBlock == null) {
            RbsSpacingProcessor.$$$reportNull$$$0(2);
        }
        if (rightBlock == null) {
            RbsSpacingProcessor.$$$reportNull$$$0(3);
        }
        ASTNode parentNode = RbsSpacingProcessor.extractNode(parentBlock);
        ASTNode leftNode = RbsSpacingProcessor.extractNode(leftBlock);
        ASTNode rightNode = RbsSpacingProcessor.extractNode(rightBlock);
        if (parentNode == null || leftNode == null || rightNode == null) {
            return null;
        }
        IElementType parentType = parentNode.getElementType();
        Spacing spacingFromBuilder = this.mySpacingBuilder.getSpacing(parentBlock, parentType, leftType = leftNode.getElementType(), rightType = rightNode.getElementType());
        if (spacingFromBuilder != null) {
            return spacingFromBuilder;
        }
        boolean keepLineBreaks = this.mySettings.KEEP_LINE_BREAKS;
        if (RbsTokenSets.RBS_NEED_2_NEW_LINE.contains(leftType) && rightType != RbsElementTypesGenerated.RBS_KEND) {
            return Spacing.createSpacing((int)0, (int)0, (int)2, (boolean)keepLineBreaks, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE);
        }
        if (RbsTokenSets.RBS_NEED_2_NEW_LINE_BETWEEN_GROUP_ELEMENTS.contains(leftType) && leftType != rightType && rightType != RbsElementTypesGenerated.RBS_KEND) {
            return Spacing.createSpacing((int)0, (int)0, (int)2, (boolean)keepLineBreaks, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE);
        }
        if (RbsTokenSets.RBS_NEED_NEW_LINE.contains(leftType) || RbsTokenSets.RBS_NEED_NEW_LINE.contains(rightType)) {
            return Spacing.createSpacing((int)0, (int)0, (int)1, (boolean)keepLineBreaks, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE);
        }
        if (rightType == RbsElementTypesGenerated.RBS_KCOLON && leftType != RbsElementTypesGenerated.RBS_CLASS_NAME) {
            return Spacing.createSpacing((int)0, (int)0, (int)0, (boolean)keepLineBreaks, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE);
        }
        return null;
    }

    @Contract(value="null -> null")
    @Nullable
    public static ASTNode extractNode(@Nullable Block block) {
        if (block instanceof ASTBlock) {
            return ((ASTBlock)block).getNode();
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ruby/rbs/frontback/formatter/processors/RbsSpacingProcessor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentBlock";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rightBlock";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ruby/rbs/frontback/formatter/processors/RbsSpacingProcessor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createSpacingBuilder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getSpacing";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

