/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ruby.rbs.frontback.editor;

import com.intellij.lexer.Lexer;
import com.intellij.openapi.editor.DefaultLanguageHighlighterColors;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.fileTypes.SyntaxHighlighterBase;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.ruby.rbs.frontback.psi.RbsLexerAdapter;
import com.intellij.ruby.rbs.frontback.psi.tree.RbsElementTypesGenerated;
import com.intellij.ruby.rbs.frontback.psi.tree.RbsTokenSets;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.ruby.lang.highlighter.RubyHighlighter;

final class RbsSyntaxHighlighter
extends SyntaxHighlighterBase {
    private final Map<IElementType, TextAttributesKey[]> myAttributes = new HashMap<IElementType, TextAttributesKey[]>();

    RbsSyntaxHighlighter() {
        this.registerTokenSet(RubyHighlighter.KEYWORD, RbsTokenSets.RBS_KEYWORDS);
        this.registerTokenSet(RubyHighlighter.RUBY_SPECIFIC_CALL, RbsTokenSets.RBS_RUBY_SPECIFIC_CALLS);
        this.registerTokenSet(RubyHighlighter.OPERATION_SIGN, RbsTokenSets.RBS_OPERATORS);
        this.registerTokenSet(RubyHighlighter.COMMENT, RbsTokenSets.RBS_COMMENTS);
        this.registerTokenTypes(RubyHighlighter.NUMBER, RbsElementTypesGenerated.RBS_TINTEGER);
        this.registerTokenTypes(RubyHighlighter.PARENTHESES, RbsElementTypesGenerated.RBS_KLPAREN, RbsElementTypesGenerated.RBS_KRPAREN);
        this.registerTokenTypes(RubyHighlighter.BRACKETS, RbsElementTypesGenerated.RBS_KLBRACKET, RbsElementTypesGenerated.RBS_KRBRACKET);
        this.registerTokenTypes(RubyHighlighter.BRACES, RbsElementTypesGenerated.RBS_KLBRACE, RbsElementTypesGenerated.RBS_KRBRACE);
        this.registerTokenTypes(DefaultLanguageHighlighterColors.METADATA, RbsElementTypesGenerated.RBS_ANNOTATION_PREFIX, RbsElementTypesGenerated.RBS_TANNOTATION, RbsElementTypesGenerated.RBS_RAQUOTE, RbsElementTypesGenerated.RBS_LAQUOTE);
        this.registerTokenTypes(RubyHighlighter.IDENTIFIER, RbsElementTypesGenerated.RBS_RXQUOTE, RbsElementTypesGenerated.RBS_LXQUOTE, RbsElementTypesGenerated.RBS_TQUOTEDIDENT);
        this.registerTokenTypes(RubyHighlighter.METHOD_NAME, RbsElementTypesGenerated.RBS_TMETHOD_NAME);
        this.registerTokenTypes(RubyHighlighter.SIMPLE_STRING, RbsElementTypesGenerated.RBS_RSQUOTE, RbsElementTypesGenerated.RBS_LSQUOTE, RbsElementTypesGenerated.RBS_RDQUOTE, RbsElementTypesGenerated.RBS_LDQUOTE, RbsElementTypesGenerated.RBS_TSTRING);
        this.registerTokenTypes(RubyHighlighter.SYMBOL, RbsElementTypesGenerated.RBS_TSYMBOL);
        this.registerTokenTypes(RubyHighlighter.CONSTANT, RbsElementTypesGenerated.RBS_TNAMESPACE, RbsElementTypesGenerated.RBS_TUIDENT, RbsElementTypesGenerated.RBS_TINTERFACEIDENT);
        this.registerTokenTypes(RubyHighlighter.IDENTIFIER, RbsElementTypesGenerated.RBS_TLIDENT, RbsElementTypesGenerated.RBS_TUNDERSCOREIDENT, RbsElementTypesGenerated.RBS_TLKEYWORD, RbsElementTypesGenerated.RBS_TLKEYWORD_Q_E, RbsElementTypesGenerated.RBS_TUKEYWORD, RbsElementTypesGenerated.RBS_TUKEYWORD_Q_E);
        this.registerTokenTypes(RubyHighlighter.GVAR, RbsElementTypesGenerated.RBS_TGLOBALIDENT);
        this.registerTokenTypes(RubyHighlighter.IVAR, RbsElementTypesGenerated.RBS_TIVAR);
        this.registerTokenTypes(RubyHighlighter.CVAR, RbsElementTypesGenerated.RBS_TCLASSVAR);
    }

    private void registerTokenTypes(@NotNull TextAttributesKey textAttributesKey, IElementType ... elementTypes) {
        if (textAttributesKey == null) {
            RbsSyntaxHighlighter.$$$reportNull$$$0(0);
        }
        if (elementTypes == null) {
            RbsSyntaxHighlighter.$$$reportNull$$$0(1);
        }
        for (IElementType elementType : elementTypes) {
            this.myAttributes.put(elementType, new TextAttributesKey[]{textAttributesKey});
        }
    }

    private void registerTokenSet(@NotNull TextAttributesKey textAttributesKey, @NotNull TokenSet tokenSet) {
        if (textAttributesKey == null) {
            RbsSyntaxHighlighter.$$$reportNull$$$0(2);
        }
        if (tokenSet == null) {
            RbsSyntaxHighlighter.$$$reportNull$$$0(3);
        }
        this.registerTokenTypes(textAttributesKey, tokenSet.getTypes());
    }

    @NotNull
    public Lexer getHighlightingLexer() {
        return new RbsLexerAdapter();
    }

    public TextAttributesKey @NotNull [] getTokenHighlights(IElementType tokenType) {
        TextAttributesKey[] textAttributesKeyArray = this.myAttributes.getOrDefault(tokenType, TextAttributesKey.EMPTY_ARRAY);
        if (textAttributesKeyArray == null) {
            RbsSyntaxHighlighter.$$$reportNull$$$0(4);
        }
        return textAttributesKeyArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textAttributesKey";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementTypes";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tokenSet";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ruby/rbs/frontback/editor/RbsSyntaxHighlighter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ruby/rbs/frontback/editor/RbsSyntaxHighlighter";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getTokenHighlights";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "registerTokenTypes";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "registerTokenSet";
                break;
            }
            case 4: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4 -> new IllegalStateException(string);
        };
    }
}

