/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ruby.rbs.frontback.editor;

import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.editorActions.TypedHandler;
import com.intellij.codeInsight.editorActions.TypedHandlerDelegate;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.ruby.rbs.frontback.editor.RbsQuoteHandler;
import com.intellij.ruby.rbs.frontback.psi.tree.RbsElementTypesGenerated;
import com.intellij.ruby.rbs.frontback.psi.util.RbsCommonPsiUtil;
import org.jetbrains.annotations.NotNull;

final class RbsQuoteTypedHandler
extends TypedHandlerDelegate {
    RbsQuoteTypedHandler() {
    }

    @NotNull
    public TypedHandlerDelegate.Result beforeCharTyped(char c, @NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file, @NotNull FileType fileType) {
        if (project == null) {
            RbsQuoteTypedHandler.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            RbsQuoteTypedHandler.$$$reportNull$$$0(1);
        }
        if (file == null) {
            RbsQuoteTypedHandler.$$$reportNull$$$0(2);
        }
        if (fileType == null) {
            RbsQuoteTypedHandler.$$$reportNull$$$0(3);
        }
        if (!RbsCommonPsiUtil.isRbsFile(file)) {
            TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.CONTINUE;
            if (result == null) {
                RbsQuoteTypedHandler.$$$reportNull$$$0(4);
            }
            return result;
        }
        if (RbsQuoteHandler.getAnnotationCloseQuoteChar(c) != '\u0000' && RbsQuoteTypedHandler.isAfterAnnotationPrefix(editor) && TypedHandler.handleQuote((Project)project, (Editor)editor, (char)c, (PsiFile)file)) {
            TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.STOP;
            if (result == null) {
                RbsQuoteTypedHandler.$$$reportNull$$$0(5);
            }
            return result;
        }
        if (RbsQuoteTypedHandler.isCloseAnnotationQuote(c, editor) && TypedHandler.handleQuote((Project)project, (Editor)editor, (char)c, (PsiFile)file)) {
            TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.STOP;
            if (result == null) {
                RbsQuoteTypedHandler.$$$reportNull$$$0(6);
            }
            return result;
        }
        TypedHandlerDelegate.Result result = super.beforeCharTyped(c, project, editor, file, fileType);
        if (result == null) {
            RbsQuoteTypedHandler.$$$reportNull$$$0(7);
        }
        return result;
    }

    @NotNull
    public TypedHandlerDelegate.Result beforeSelectionRemoved(char c, @NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
        int selectionStartOffset;
        if (project == null) {
            RbsQuoteTypedHandler.$$$reportNull$$$0(8);
        }
        if (editor == null) {
            RbsQuoteTypedHandler.$$$reportNull$$$0(9);
        }
        if (file == null) {
            RbsQuoteTypedHandler.$$$reportNull$$$0(10);
        }
        char closeQuoteChar = RbsQuoteHandler.getAnnotationCloseQuoteChar(c);
        if (!RbsCommonPsiUtil.isRbsFile(file) || closeQuoteChar == '\u0000' || !CodeInsightSettings.getInstance().SURROUND_SELECTION_ON_QUOTE_TYPED) {
            TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.CONTINUE;
            if (result == null) {
                RbsQuoteTypedHandler.$$$reportNull$$$0(11);
            }
            return result;
        }
        SelectionModel selectionModel = editor.getSelectionModel();
        if (!selectionModel.hasSelection()) {
            TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.CONTINUE;
            if (result == null) {
                RbsQuoteTypedHandler.$$$reportNull$$$0(12);
            }
            return result;
        }
        String selectedText = selectionModel.getSelectedText();
        if (selectedText == null || selectedText.length() < 2 || selectedText.indexOf(10) > -1) {
            TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.CONTINUE;
            if (result == null) {
                RbsQuoteTypedHandler.$$$reportNull$$$0(13);
            }
            return result;
        }
        char firstSelectedChar = selectedText.charAt(0);
        char expectedCloseChar = RbsQuoteHandler.getAnnotationCloseQuoteChar(firstSelectedChar);
        if (firstSelectedChar == c || expectedCloseChar == '\u0000' || selectedText.charAt(selectedText.length() - 1) != expectedCloseChar) {
            TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.CONTINUE;
            if (result == null) {
                RbsQuoteTypedHandler.$$$reportNull$$$0(14);
            }
            return result;
        }
        EditorHighlighter editorHighlighter = editor.getHighlighter();
        HighlighterIterator highlighterIterator = editorHighlighter.createIterator(selectionStartOffset = selectionModel.getSelectionStart());
        if (highlighterIterator.atEnd() || highlighterIterator.getTokenType() != RbsElementTypesGenerated.RBS_LAQUOTE) {
            TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.CONTINUE;
            if (result == null) {
                RbsQuoteTypedHandler.$$$reportNull$$$0(15);
            }
            return result;
        }
        int selectionEndOffset = selectionModel.getSelectionEnd();
        do {
            boolean isAtCloseQuote;
            highlighterIterator.advance();
            boolean bl = isAtCloseQuote = !highlighterIterator.atEnd() && highlighterIterator.getTokenType() == RbsElementTypesGenerated.RBS_RAQUOTE;
            if (selectionEndOffset == highlighterIterator.getEnd()) {
                if (isAtCloseQuote) {
                    Document editorDocument = editor.getDocument();
                    editorDocument.replaceString(selectionStartOffset, selectionStartOffset + 1, (CharSequence)String.valueOf(c));
                    editorDocument.replaceString(selectionEndOffset - 1, selectionEndOffset, (CharSequence)String.valueOf(closeQuoteChar));
                    EditorModificationUtil.moveCaretRelatively((Editor)editor, (int)1);
                    selectionModel.setSelection(selectionStartOffset + 1, selectionEndOffset - 1);
                    TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.STOP;
                    if (result == null) {
                        RbsQuoteTypedHandler.$$$reportNull$$$0(16);
                    }
                    return result;
                }
                TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.CONTINUE;
                if (result == null) {
                    RbsQuoteTypedHandler.$$$reportNull$$$0(17);
                }
                return result;
            }
            if (!isAtCloseQuote) continue;
            TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.CONTINUE;
            if (result == null) {
                RbsQuoteTypedHandler.$$$reportNull$$$0(18);
            }
            return result;
        } while (!highlighterIterator.atEnd());
        TypedHandlerDelegate.Result result = super.beforeSelectionRemoved(c, project, editor, file);
        if (result == null) {
            RbsQuoteTypedHandler.$$$reportNull$$$0(19);
        }
        return result;
    }

    private static boolean isCloseAnnotationQuote(char c, @NotNull Editor editor) {
        char openQuoteChar;
        if (editor == null) {
            RbsQuoteTypedHandler.$$$reportNull$$$0(20);
        }
        if ((openQuoteChar = RbsQuoteHandler.getAnnotationOpenQuoteChar(c)) == '\u0000') {
            return false;
        }
        int caretOffset = editor.getCaretModel().getOffset();
        if (caretOffset < 3) {
            return false;
        }
        HighlighterIterator iterator = editor.getHighlighter().createIterator(caretOffset - 1);
        if (iterator.getTokenType() == RbsElementTypesGenerated.RBS_TANNOTATION) {
            return true;
        }
        iterator.retreat();
        return iterator.getTokenType() == RbsElementTypesGenerated.RBS_ANNOTATION_PREFIX;
    }

    private static boolean isAfterAnnotationPrefix(@NotNull Editor editor) {
        int caretOffset;
        if (editor == null) {
            RbsQuoteTypedHandler.$$$reportNull$$$0(21);
        }
        if ((caretOffset = editor.getCaretModel().getOffset()) < 2) {
            return false;
        }
        return editor.getHighlighter().createIterator(caretOffset - 1).getTokenType() == RbsElementTypesGenerated.RBS_ANNOTATION_PREFIX;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 6, 7, 11, 12, 13, 14, 15, 16, 17, 18, 19 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 9: 
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileType";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ruby/rbs/frontback/editor/RbsQuoteTypedHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ruby/rbs/frontback/editor/RbsQuoteTypedHandler";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "beforeCharTyped";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "beforeSelectionRemoved";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "beforeCharTyped";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "beforeSelectionRemoved";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "isCloseAnnotationQuote";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "isAfterAnnotationPrefix";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5, 6, 7, 11, 12, 13, 14, 15, 16, 17, 18, 19 -> new IllegalStateException(string);
        };
    }
}

