/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ruby.rbs.frontback.editor;

import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.editorActions.BackspaceHandlerDelegate;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.psi.PsiFile;
import com.intellij.ruby.rbs.frontback.editor.RbsQuoteHandler;
import com.intellij.ruby.rbs.frontback.psi.tree.RbsElementTypesGenerated;
import com.intellij.ruby.rbs.frontback.psi.util.RbsCommonPsiUtil;
import org.jetbrains.annotations.NotNull;

final class RbsQuoteBackspaceHandler
extends BackspaceHandlerDelegate {
    RbsQuoteBackspaceHandler() {
    }

    public void beforeCharDeleted(char c, @NotNull PsiFile file, @NotNull Editor editor) {
        if (file == null) {
            RbsQuoteBackspaceHandler.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            RbsQuoteBackspaceHandler.$$$reportNull$$$0(1);
        }
        if (!RbsCommonPsiUtil.isRbsFile(file)) {
            return;
        }
        if (!CodeInsightSettings.getInstance().AUTOINSERT_PAIR_QUOTE) {
            return;
        }
        char closeQuoteChar = RbsQuoteHandler.getCloseQuoteChar(c);
        if (closeQuoteChar != '\u0000') {
            int currentOffset = editor.getCaretModel().getOffset();
            HighlighterIterator iterator = editor.getHighlighter().createIterator(currentOffset);
            if (!iterator.atEnd() && iterator.getTokenType() == RbsElementTypesGenerated.RBS_RAQUOTE) {
                iterator.retreat();
                if (!iterator.atEnd() && iterator.getTokenType() == RbsElementTypesGenerated.RBS_LAQUOTE) {
                    editor.getDocument().deleteString(currentOffset, currentOffset + 1);
                }
            }
        }
    }

    public boolean charDeleted(char c, @NotNull PsiFile file, @NotNull Editor editor) {
        if (file == null) {
            RbsQuoteBackspaceHandler.$$$reportNull$$$0(2);
        }
        if (editor == null) {
            RbsQuoteBackspaceHandler.$$$reportNull$$$0(3);
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ruby/rbs/frontback/editor/RbsQuoteBackspaceHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "beforeCharDeleted";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "charDeleted";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

