/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ruby.rbs.frontback.editor;

import com.intellij.codeInsight.editorActions.enter.EnterHandlerDelegate;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtilEx;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.ruby.rbs.frontback.psi.tree.RbsElementTypesGenerated;
import com.intellij.ruby.rbs.frontback.psi.util.RbsCommonPsiUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.actions.editor.RubyEditorOptions;

final class RbsEnterCommentHandler
implements EnterHandlerDelegate {
    private static final Key<Boolean> IS_SHIFT_PRESSED_KEY = new Key("rbs.editor.enter.shift.pressed");
    private static final Logger LOG = Logger.getInstance(RbsEnterCommentHandler.class);

    RbsEnterCommentHandler() {
    }

    public EnterHandlerDelegate.Result preprocessEnter(@NotNull PsiFile file, @NotNull Editor editor, @NotNull Ref<Integer> caretOffset, @NotNull Ref<Integer> caretAdvance, @NotNull DataContext dataContext, EditorActionHandler originalHandler) {
        if (file == null) {
            RbsEnterCommentHandler.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            RbsEnterCommentHandler.$$$reportNull$$$0(1);
        }
        if (caretOffset == null) {
            RbsEnterCommentHandler.$$$reportNull$$$0(2);
        }
        if (caretAdvance == null) {
            RbsEnterCommentHandler.$$$reportNull$$$0(3);
        }
        if (dataContext == null) {
            RbsEnterCommentHandler.$$$reportNull$$$0(4);
        }
        Boolean isShiftPressed = (Boolean)editor.getUserData(IS_SHIFT_PRESSED_KEY);
        editor.putUserData(IS_SHIFT_PRESSED_KEY, (Object)Boolean.FALSE);
        if (RbsCommonPsiUtil.isRbsFile(file)) {
            Project project = editor.getProject();
            if (project == null) {
                LOG.debug("Editor doesn't have a project");
                return EnterHandlerDelegate.Result.Continue;
            }
            int caret = editor.getCaretModel().getOffset();
            if (caret < 1) {
                return EnterHandlerDelegate.Result.Continue;
            }
            Document document = editor.getDocument();
            CharSequence documentSequence = document.getCharsSequence();
            int lineNumber = document.getLineNumber(caret);
            CharSequence commentTail = documentSequence.subSequence(caret, document.getLineEndOffset(lineNumber));
            CharSequence lineHead = documentSequence.subSequence(document.getLineStartOffset(lineNumber), caret);
            EditorHighlighter highlighter = editor.getHighlighter();
            HighlighterIterator highlighterIterator = highlighter.createIterator(caret - 1);
            if (highlighterIterator.getTokenType() == RbsElementTypesGenerated.RBS_LINE_COMMENT) {
                if (RubyEditorOptions.getInstance().isDeleteEmptyCommentsOnEnter() && (isShiftPressed == null || !isShiftPressed.booleanValue())) {
                    CharSequence commentChars = highlighterIterator.getDocument().getCharsSequence().subSequence(highlighterIterator.getStart() + 1, highlighterIterator.getEnd());
                    if (StringUtil.isEmptyOrSpaces((CharSequence)commentChars)) {
                        caretOffset.set((Object)highlighterIterator.getStart());
                        document.deleteString(highlighterIterator.getStart(), highlighterIterator.getEnd());
                        return EnterHandlerDelegate.Result.Stop;
                    }
                    LOG.debug("We shouldn't remove non-empty comment");
                } else {
                    LOG.debug("We shouldn't delete the comment since the shift key is pressed");
                }
                if (RbsEnterCommentHandler.shouldContinueCommentLine(lineHead, commentTail)) {
                    EditorModificationUtilEx.insertStringAtCaret((Editor)editor, (String)("\n#" + (StringUtil.startsWith((CharSequence)commentTail, (CharSequence)" ") ? "" : " ")));
                    int newOffset = CodeStyleManager.getInstance((Project)project).adjustLineIndent(document, document.getLineStartOffset(lineNumber + 1));
                    editor.getCaretModel().moveToOffset(newOffset + 2);
                    return EnterHandlerDelegate.Result.Stop;
                }
                LOG.debug("We shouldn't continue a comment line");
            }
        } else {
            LOG.debug("Not our file: ", new Object[]{file});
        }
        return super.preprocessEnter(file, editor, caretOffset, caretAdvance, dataContext, originalHandler);
    }

    private static boolean shouldContinueCommentLine(@NotNull CharSequence lineHead, @NotNull CharSequence commentTail) {
        int commentStartIndex;
        boolean shouldContinueCommentLine;
        if (lineHead == null) {
            RbsEnterCommentHandler.$$$reportNull$$$0(5);
        }
        if (commentTail == null) {
            RbsEnterCommentHandler.$$$reportNull$$$0(6);
        }
        boolean bl = shouldContinueCommentLine = !StringUtil.isEmptyOrSpaces((CharSequence)commentTail);
        if (RubyEditorOptions.getInstance().isProlongComments() && (commentStartIndex = StringUtil.indexOf((CharSequence)lineHead, (char)'#')) > -1) {
            shouldContinueCommentLine = shouldContinueCommentLine || StringUtil.isEmptyOrSpaces((CharSequence)lineHead.subSequence(0, commentStartIndex));
        }
        return shouldContinueCommentLine;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "caretOffset";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "caretAdvance";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lineHead";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commentTail";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ruby/rbs/frontback/editor/RbsEnterCommentHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "preprocessEnter";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "shouldContinueCommentLine";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static final class RbsShiftEnterCommentHandler
    extends EditorActionHandler {
        private final EditorActionHandler myOriginalHandler;

        public RbsShiftEnterCommentHandler(@NotNull EditorActionHandler originalHandler) {
            if (originalHandler == null) {
                RbsShiftEnterCommentHandler.$$$reportNull$$$0(0);
            }
            this.myOriginalHandler = originalHandler;
        }

        protected void doExecute(@NotNull Editor editor, @Nullable Caret caret, DataContext dataContext) {
            PsiFile psiFile;
            if (editor == null) {
                RbsShiftEnterCommentHandler.$$$reportNull$$$0(1);
            }
            if ((psiFile = (PsiFile)CommonDataKeys.PSI_FILE.getData(dataContext)) != null && RbsCommonPsiUtil.isRbsFile(psiFile)) {
                editor.putUserData(IS_SHIFT_PRESSED_KEY, (Object)Boolean.TRUE);
            }
            this.myOriginalHandler.execute(editor, caret, dataContext);
        }

        protected boolean isEnabledForCaret(@NotNull Editor editor, @NotNull Caret caret, DataContext dataContext) {
            if (editor == null) {
                RbsShiftEnterCommentHandler.$$$reportNull$$$0(2);
            }
            if (caret == null) {
                RbsShiftEnterCommentHandler.$$$reportNull$$$0(3);
            }
            return this.myOriginalHandler.isEnabled(editor, caret, dataContext);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "originalHandler";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "caret";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/ruby/rbs/frontback/editor/RbsEnterCommentHandler$RbsShiftEnterCommentHandler";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "doExecute";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isEnabledForCaret";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

