/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ruby.rbs.frontback.editor;

import com.intellij.codeInsight.editorActions.BackspaceHandlerDelegate;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import com.intellij.ruby.rbs.frontback.psi.tree.RbsElementTypesGenerated;
import com.intellij.ruby.rbs.frontback.psi.util.RbsCommonPsiUtil;
import org.jetbrains.annotations.NotNull;

final class RbsBackspaceCommentHandler
extends BackspaceHandlerDelegate {
    RbsBackspaceCommentHandler() {
    }

    public void beforeCharDeleted(char c, @NotNull PsiFile file, @NotNull Editor editor) {
        if (file == null) {
            RbsBackspaceCommentHandler.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            RbsBackspaceCommentHandler.$$$reportNull$$$0(1);
        }
        if (!RbsCommonPsiUtil.isRbsFile(file)) {
            return;
        }
        if (RbsBackspaceCommentHandler.shouldRemoveComment(file, editor, c)) {
            int caretPosition = editor.getCaretModel().getOffset();
            editor.getDocument().deleteString(caretPosition - 1, caretPosition);
        }
    }

    public boolean charDeleted(char c, @NotNull PsiFile file, @NotNull Editor editor) {
        if (file == null) {
            RbsBackspaceCommentHandler.$$$reportNull$$$0(2);
        }
        if (editor == null) {
            RbsBackspaceCommentHandler.$$$reportNull$$$0(3);
        }
        return false;
    }

    private static boolean shouldRemoveComment(@NotNull PsiFile file, @NotNull Editor editor, char c) {
        if (file == null) {
            RbsBackspaceCommentHandler.$$$reportNull$$$0(4);
        }
        if (editor == null) {
            RbsBackspaceCommentHandler.$$$reportNull$$$0(5);
        }
        int caretPosition = editor.getCaretModel().getOffset();
        Document document = editor.getDocument();
        CharSequence text = document.getCharsSequence();
        return Registry.is((String)"ruby.auto.remove.comment") && Character.isWhitespace(c) && caretPosition > 1 && text.charAt(caretPosition - 2) == '#' && RbsBackspaceCommentHandler.isInEmptyCommentStart(editor, caretPosition);
    }

    private static boolean isInEmptyCommentStart(@NotNull Editor editor, int caretPosition) {
        EditorHighlighter highlighter;
        HighlighterIterator iterator;
        if (editor == null) {
            RbsBackspaceCommentHandler.$$$reportNull$$$0(6);
        }
        if ((iterator = (highlighter = editor.getHighlighter()).createIterator(caretPosition - 1)).getTokenType() != RbsElementTypesGenerated.RBS_LINE_COMMENT) {
            return false;
        }
        CharSequence commentChars = iterator.getDocument().getCharsSequence().subSequence(iterator.getStart(), iterator.getEnd());
        if (commentChars.length() < 2) {
            return false;
        }
        return StringUtil.isEmptyOrSpaces((CharSequence)commentChars.subSequence(1, commentChars.length()));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ruby/rbs/frontback/editor/RbsBackspaceCommentHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "beforeCharDeleted";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "charDeleted";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "shouldRemoveComment";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "isInEmptyCommentStart";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

