/*
 * Decompiled with CFR 0.152.
 */
package org.coffeescript.lang.parser;

import com.intellij.indentation.OperationParserHelper;
import com.intellij.lang.ASTNode;
import com.intellij.lang.LighterASTNode;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.ecmascript6.JSXXmlTokensParser;
import com.intellij.lang.javascript.parsing.JSXmlTokensParser;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.BooleanStack;
import com.intellij.util.containers.Stack;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.coffeescript.CoffeeScriptLiterateLanguage;
import org.coffeescript.CsBundle;
import org.coffeescript.lang.lexer.CoffeeScriptTokenSets;
import org.coffeescript.lang.lexer.CoffeeScriptTokenTypes;
import org.coffeescript.lang.parser.BaseCoffeeScriptParser;
import org.coffeescript.lang.parser.CoffeeScriptElementTypes;
import org.coffeescript.lang.parser.CoffeeScriptParserMetaData;
import org.coffeescript.lang.parser.CoffeeScriptPsiBuilder;
import org.coffeescript.lang.parser.CoffeeScriptStubElementTypes;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CoffeeScriptParser
extends BaseCoffeeScriptParser {
    private final StatementInvoker myStatementInvoker = new StatementInvoker();
    private final ExpressionInvoker myExpressionInvoker = new ExpressionInvoker();
    private final BooleanStack oneLineState = new BooleanStack();
    private int parenthesisLevel = 0;
    private int argumentListLevel = 0;
    private int invocationIndent = -1;
    protected JSXmlTokensParser myXmlParser;
    private boolean myMultilineArgumentListAllowed = true;
    private final List<String> CS_RESERVED = Arrays.asList("case", "function", "var", "void", "with", "const", "let", "enum", "native", "__hasProp", "__extends", "__slice", "__bind", "__indexOf", "implements", "interface", "let", "package", "private", "protected", "public", "static", "yield");
    private final Map<Integer, CoffeeScriptParserMetaData> metaData = new HashMap<Integer, CoffeeScriptParserMetaData>();
    private final Stack<Integer> wantedElseAtIndent = new Stack();
    private static final Map<IElementType, IElementType> BRACKETS = new HashMap<IElementType, IElementType>();

    @NotNull
    public ASTNode parse(@NotNull IElementType root, @NotNull PsiBuilder builder) {
        if (root == null) {
            CoffeeScriptParser.$$$reportNull$$$0(0);
        }
        if (builder == null) {
            CoffeeScriptParser.$$$reportNull$$$0(1);
        }
        this.myCoffeeScriptPsiBuilder = new CoffeeScriptPsiBuilder(builder);
        this.myBuilder = this.myCoffeeScriptPsiBuilder;
        this.myXmlParser = new JSXXmlTokensParser((PsiBuilder)this.myBuilder, CoffeeScriptTokenSets.JSX_EMBEDDED_ELEMENTS).withEmptyTagNameAllowed(true);
        this.parseRoot(root);
        ASTNode aSTNode = this.myBuilder.getTreeBuilt();
        if (aSTNode == null) {
            CoffeeScriptParser.$$$reportNull$$$0(2);
        }
        return aSTNode;
    }

    @NotNull
    public ASTNode parseJsxAttributesExpression(@NotNull IElementType root, @NotNull PsiBuilder builder) {
        if (root == null) {
            CoffeeScriptParser.$$$reportNull$$$0(3);
        }
        if (builder == null) {
            CoffeeScriptParser.$$$reportNull$$$0(4);
        }
        this.myCoffeeScriptPsiBuilder = new CoffeeScriptPsiBuilder(builder);
        this.myBuilder = this.myCoffeeScriptPsiBuilder;
        this.oneLineState.push(false);
        this.myXmlParser = new JSXXmlTokensParser((PsiBuilder)this.myBuilder, CoffeeScriptTokenSets.JSX_EMBEDDED_ELEMENTS).withEmptyTagNameAllowed(true);
        PsiBuilder.Marker rootMarker = this.myBuilder.mark();
        this.startScope();
        this.parseArgumentList(0);
        if (!builder.eof()) {
            this.error(CsBundle.message("parsing.error.unexpected", "token"));
            while (!builder.eof()) {
                builder.advanceLexer();
            }
        }
        this.endScope();
        this.oneLineState.pop();
        rootMarker.done(root);
        ASTNode aSTNode = this.myBuilder.getTreeBuilt();
        if (aSTNode == null) {
            CoffeeScriptParser.$$$reportNull$$$0(5);
        }
        return aSTNode;
    }

    public void parseRoot(IElementType root) {
        PsiBuilder.Marker rootMarker = this.myBuilder.mark();
        this.myCoffeeScriptPsiBuilder.init();
        while (!this.eof()) {
            int offset = this.getCurrentOffset();
            if (root.getLanguage() == CoffeeScriptLiterateLanguage.INSTANCE) {
                PsiBuilder.Marker marker = this.myBuilder.mark();
                this.parseBlock(0, false);
                this.done(marker, CoffeeScriptElementTypes.INDENT_BLOCK);
            } else {
                this.parseBlock(-1, false);
            }
            if (offset != this.getCurrentOffset()) continue;
            this.error(CsBundle.message("parsing.error.unexpected", "token"));
            this.advance();
        }
        rootMarker.done(root);
    }

    private void parseBlock(int blockIndent, boolean withMark) {
        this.parseBlock(blockIndent, withMark, true);
    }

    private void parseBlock(int blockIndent, boolean withMark, boolean withScope) {
        if (this.isTerminator()) {
            return;
        }
        this.oneLineState.push(false);
        this.invocationIndent = -1;
        if (withScope) {
            this.startScope();
        }
        int firstIndent = -1;
        PsiBuilder.Marker marker = this.mark();
        while (!this.eof()) {
            if (firstIndent < 0) {
                firstIndent = this.getCurrentIndent();
                if (this.invocationIndent >= 0) {
                    firstIndent = this.invocationIndent;
                }
                if (firstIndent <= blockIndent) break;
            }
            if (this.getCurrentIndent() < firstIndent) break;
            int offset = this.getCurrentOffset();
            if (!this.isCurrentTokenIn(CoffeeScriptTokenTypes.PARENTHESIS_END)) {
                if (this.getCurrentIndent() > firstIndent) {
                    this.error(CsBundle.message("parsing.error.unexpected", "indent"));
                    this.parseBlock(blockIndent + 1, false);
                } else {
                    this.parseLine(true);
                    if (!(this.isNewLine() || this.eof() || this.isCurrentTokenIn(CoffeeScriptTokenTypes.PARENTHESIS_END))) {
                        this.error(CsBundle.message("parsing.error.expected.end.of.line", new Object[0]));
                    }
                }
            }
            if (offset == this.getCurrentOffset()) {
                if (this.parenthesisLevel != 0 && this.isCurrentTokenIn(CoffeeScriptTokenTypes.PARENTHESIS_END)) break;
                this.error(CsBundle.message("parsing.error.unexpected", "token"));
                this.advance();
            }
            if (!this.eof()) continue;
            break;
        }
        if (withMark) {
            this.done(marker, CoffeeScriptElementTypes.INDENT_BLOCK);
        } else {
            marker.drop();
        }
        if (withScope) {
            this.endScope();
        }
        this.oneLineState.pop();
    }

    private void parseLineWithNewScope(boolean withScope) {
        if (this.isTerminator()) {
            return;
        }
        this.oneLineState.push(true);
        if (withScope) {
            this.startScope();
        }
        this.parseLine(withScope);
        if (withScope) {
            this.endScope();
        }
        this.oneLineState.pop();
    }

    private void parseLine(boolean finalizationAllowed) {
        while (!this.eof()) {
            int offset = this.getCurrentOffset();
            if (this.isStatement()) {
                this.parseWithPossibleWhileOrForOrIf(this.myStatementInvoker);
            } else {
                IElementType lastTokenType;
                PsiBuilder.Marker marker = this.mark();
                boolean success = this.parseWithPossibleWhileOrForOrIf(this.myExpressionInvoker);
                LighterASTNode lastMarker = this.myBuilder.getLatestDoneMarker();
                IElementType iElementType = lastTokenType = lastMarker != null ? lastMarker.getTokenType() : null;
                if (success && finalizationAllowed && !CoffeeScriptElementTypes.STATEMENTS.contains(lastTokenType)) {
                    this.done(marker, CoffeeScriptElementTypes.EXPRESSION_STATEMENT);
                } else {
                    marker.drop();
                }
            }
            if (offset == this.getCurrentOffset()) {
                String message = CsBundle.message("parsing.error.unexpected", "token");
                if (this.isCurrentTokenIn(CoffeeScriptTokenTypes.IF)) {
                    message = CsBundle.message("parsing.error.unexpected", "POST_IF");
                }
                this.error(message);
                break;
            }
            if (!this.isCurrentTokenIn(CoffeeScriptTokenTypes.SEMICOLON)) break;
            this.advance();
            if (!this.isNewLine()) continue;
            break;
        }
        if (this.currentTokenIn(new IElementType[]{CoffeeScriptTokenTypes.SEMICOLON})) {
            this.advance();
        }
    }

    private void parseFor() {
        this.startScope();
        int forIndent = this.getCurrentIndent();
        PsiBuilder.Marker marker = this.mark();
        this.parseForBody();
        this.parseBlockOrThen(forIndent);
        this.done(marker, CoffeeScriptElementTypes.FOR_STATEMENT);
        this.endScope();
    }

    private void parseForBody() {
        this.expect(CoffeeScriptTokenTypes.FOR);
        boolean oldMultilineArgumentListAllowed = this.myMultilineArgumentListAllowed;
        this.myMultilineArgumentListAllowed = false;
        if (this.isRange()) {
            this.parseRange();
        } else {
            if (this.isCurrentTokenIn(CoffeeScriptTokenTypes.OWN)) {
                this.advance();
            }
            if (this.isForVariables()) {
                this.parseForVariables();
            } else {
                this.error(CsBundle.message("parsing.error.expected.for.variables", new Object[0]));
            }
            this.parseForSource();
        }
        if (this.parseTokenCondition(CoffeeScriptTokenTypes.WHEN)) {
            this.parseTokenCondition(CoffeeScriptTokenTypes.BY);
        } else if (this.parseTokenCondition(CoffeeScriptTokenTypes.BY)) {
            this.parseTokenCondition(CoffeeScriptTokenTypes.WHEN);
        }
        this.myMultilineArgumentListAllowed = oldMultilineArgumentListAllowed;
    }

    private void parseForSource() {
        if (this.isCurrentTokenIn(CoffeeScriptTokenTypes.IN_KEYWORD, CoffeeScriptTokenTypes.OF)) {
            this.advance();
        } else if (this.isKeywordStatement("from")) {
            this.myBuilder.remapCurrentToken(CoffeeScriptTokenTypes.FROM_KEYWORD);
            this.advance();
        } else {
            this.error(CsBundle.message("parsing.error.unexpected", this.getTokenText()));
            return;
        }
        this.parseOperation();
    }

    private void parseForVariables() {
        this.parseForVariable();
        if (this.isCurrentTokenIn(CoffeeScriptTokenTypes.COMMA)) {
            this.advance();
            this.parseForVariable();
        }
    }

    private void parseForVariable() {
        if (this.isThis()) {
            PsiBuilder.Marker thisMarker = this.mark();
            PsiBuilder.Marker refMarker = this.mark();
            this.parseThis();
            this.done(refMarker, CoffeeScriptElementTypes.REFERENCED_EXPRESSION);
            this.done(thisMarker, CoffeeScriptElementTypes.DEFINITION_EXPRESSION);
        } else if (this.isIdentifier() && this.isInScope(this.getTokenText())) {
            PsiBuilder.Marker markerReference = this.mark();
            this.parseIdentifier(false);
            this.done(markerReference, CoffeeScriptElementTypes.REFERENCED_EXPRESSION);
        } else {
            PsiBuilder.Marker varStatementMarker = this.mark();
            PsiBuilder.Marker marker = this.mark();
            if (this.isArray()) {
                this.parseDestructuringArray();
            } else if (this.isIdentifier()) {
                this.addVariableInCurrentScope(this.getTokenText());
                this.parseIdentifier(false);
            } else if (this.isObject()) {
                this.parseObject();
            } else {
                this.error(CsBundle.message("parsing.error.unexpected", "token"));
            }
            this.done(marker, (IElementType)CoffeeScriptElementTypes.VARIABLE);
            this.done(varStatementMarker, CoffeeScriptElementTypes.VAR_STATEMENT);
        }
    }

    private boolean isForVariables() {
        return this.isArray() || this.isIdentifier() || this.isObject() || this.isThis();
    }

    private void parseWhileExpression() {
        boolean oldMultilineArgumentListAllowed = this.myMultilineArgumentListAllowed;
        this.myMultilineArgumentListAllowed = false;
        this.advance();
        this.parseOperation();
        this.parseTokenCondition(CoffeeScriptTokenTypes.WHEN);
        this.myMultilineArgumentListAllowed = oldMultilineArgumentListAllowed;
    }

    private boolean parseTokenCondition(IElementType ... types) {
        if (types == null) {
            CoffeeScriptParser.$$$reportNull$$$0(6);
        }
        if (this.isCurrentTokenIn(types)) {
            this.advance();
            boolean marker = this.parseOperation();
            if (!marker) {
                this.error(CsBundle.message("parsing.error.expected.when.condition", new Object[0]));
            }
            return true;
        }
        return false;
    }

    private void parseWhile() {
        PsiBuilder.Marker marker = this.mark();
        int whileIndent = this.getCurrentIndent();
        this.parseWhileExpression();
        this.parseBlockOrThen(whileIndent);
        this.done(marker, CoffeeScriptElementTypes.WHILE_STATEMENT);
    }

    private void parseTry() {
        int indent = this.getCurrentIndent();
        PsiBuilder.Marker marker = this.mark();
        this.advance();
        this.parseBlockOrLine(indent);
        while (this.isCurrentTokenIn(CoffeeScriptTokenTypes.CATCH) && this.getCurrentIndent() >= indent) {
            this.parseCatch();
        }
        if (this.isCurrentTokenIn(CoffeeScriptTokenTypes.FINALLY)) {
            this.advance();
            this.parseBlockOrLine(indent);
        }
        this.done(marker, CoffeeScriptElementTypes.TRY_STATEMENT);
    }

    private void parseLoop() {
        int indent = this.getCurrentIndent();
        PsiBuilder.Marker loopMarker = this.mark();
        this.advance();
        this.parseBlockOrLine(indent);
        this.done(loopMarker, JSElementTypes.WHILE_STATEMENT);
    }

    private void parseCatch() {
        int indent = this.getCurrentIndent();
        if (this.currentTokenIn(new IElementType[]{CoffeeScriptTokenTypes.CATCH})) {
            PsiBuilder.Marker marker = this.mark();
            this.advance();
            if (!this.isNewLine()) {
                if (this.isIdentifier()) {
                    this.parseParam();
                } else if (this.isObject()) {
                    this.parseDestructuringObject((IElementType)CoffeeScriptElementTypes.VARIABLE, true, true);
                }
            }
            this.parseBlockOrThen(indent);
            this.done(marker, CoffeeScriptElementTypes.CATCH_BLOCK);
        }
    }

    private void parseBlockOrThen(int indent) {
        if (this.isNewLine()) {
            this.parseBlock(indent, true);
        } else if (this.isCurrentTokenIn(CoffeeScriptTokenTypes.THEN)) {
            this.advance();
            this.parseLineWithNewScope(true);
        }
    }

    private void parseBlockOrLine(int indent) {
        if (this.isNewLine()) {
            this.parseBlock(indent, true);
        } else {
            this.parseLineWithNewScope(true);
        }
    }

    private boolean parseIfCondition() {
        this.advance();
        boolean oldMultilineArgumentListAllowed = this.myMultilineArgumentListAllowed;
        this.myMultilineArgumentListAllowed = false;
        boolean parsed = this.parseOperation();
        this.myMultilineArgumentListAllowed = oldMultilineArgumentListAllowed;
        if (!parsed) {
            this.error(CsBundle.message("parsing.error.expected.if.condition", new Object[0]));
        }
        return parsed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isPostSuffix(ParseInvoker parseInvoker) {
        if (this.rawLookup(-1) == CoffeeScriptTokenTypes.WHITE_SPACE && this.rawLookup(-2) == null || this.rawLookup(-1) == null || this.isNewLine()) {
            return false;
        }
        int indent = this.getCurrentIndent();
        PsiBuilder.Marker marker = this.mark(true);
        try {
            parseInvoker.parse();
            if (this.eof()) {
                boolean bl = true;
                return bl;
            }
            if (this.isNewLine()) {
                if (this.getCurrentIndent() > indent || this.getCurrentIndent() == indent && this.isCurrentTokenIn(CoffeeScriptTokenTypes.THEN, CoffeeScriptTokenTypes.ELSE)) {
                    boolean bl = false;
                    return bl;
                }
                boolean bl = true;
                return bl;
            }
            if (this.isCurrentTokenIn(CoffeeScriptTokenTypes.PARENTHESIS_END, CoffeeScriptTokenTypes.INTERPOLATION_END, CoffeeScriptTokenTypes.BRACE_END, CoffeeScriptTokenTypes.BRACKET_END, CoffeeScriptTokenTypes.PARENTHESIS_END, CoffeeScriptTokenTypes.IF, CoffeeScriptTokenTypes.FOR, CoffeeScriptTokenTypes.WHILE, CoffeeScriptTokenTypes.UNLESS)) {
                boolean bl = true;
                return bl;
            }
        }
        finally {
            this.rollbackTo(marker);
        }
        return false;
    }

    private void parseIf() {
        int indent = this.getCurrentIndent();
        PsiBuilder.Marker marker = this.mark();
        if (this.parseIfCondition()) {
            int wantedElseAtNewLine;
            boolean positiveStatement = false;
            boolean positiveBlock = false;
            boolean thenKeyword = false;
            if (this.isCurrentTokenIn(CoffeeScriptTokenTypes.THEN)) {
                positiveStatement = true;
                thenKeyword = true;
                this.advance();
                if (!this.isNewLine()) {
                    this.parseLineWithNewScope(false);
                }
            } else if (!this.isCurrentTokenIn(CoffeeScriptTokenTypes.ELSE)) {
                positiveStatement = true;
                positiveBlock = true;
                int offset = this.getCurrentOffset();
                this.parseBlock(indent, true, false);
                if (offset == this.getCurrentOffset()) {
                    this.error(CsBundle.message("parsing.error.unexpected", "POST_IF"));
                }
            }
            int n = wantedElseAtNewLine = !this.wantedElseAtIndent.isEmpty() ? (Integer)this.wantedElseAtIndent.peek() : -1;
            if ((!thenKeyword || !this.isNewLine() || this.isNewLine() && indent == this.getCurrentIndent() && wantedElseAtNewLine != this.getCurrentIndent()) && this.isCurrentTokenIn(CoffeeScriptTokenTypes.ELSE)) {
                if (this.getCurrentIndent() == indent || positiveBlock && this.getCurrentIndent() > indent) {
                    this.advance();
                    if (!this.isTerminator() || this.isNewLine()) {
                        this.parseBlockOrLine(indent);
                    }
                }
            } else if (!positiveStatement && !this.eof()) {
                this.error(CsBundle.message("parsing.error.unexpected", "POST_IF"));
            }
        }
        this.done(marker, CoffeeScriptElementTypes.IF_STATEMENT);
    }

    private boolean isTerminator() {
        return this.currentTokenIn(new IElementType[]{CoffeeScriptTokenTypes.BRACE_END, CoffeeScriptTokenTypes.PARENTHESIS_END, CoffeeScriptTokenTypes.INTERPOLATION_END, CoffeeScriptTokenTypes.CATCH, CoffeeScriptTokenTypes.FINALLY});
    }

    private boolean isClass() {
        return this.isCurrentTokenIn(CoffeeScriptTokenTypes.CLASS) || this.isCurrentTokenIn(CoffeeScriptTokenTypes.EXPORT_KEYWORD) && this.lookAhead(1) == CoffeeScriptTokenTypes.CLASS;
    }

    private void parseClass() {
        this.parseClass(false);
    }

    private void parseClass(boolean classExpression) {
        PsiBuilder.Marker marker = this.mark();
        int indent = this.getCurrentIndent();
        this.parseAttributeList();
        this.advance();
        if (!this.isNewLine() && this.isSimpleAssignable()) {
            this.parseValuesAndInvocations(false, false, false, false);
        }
        if (!this.isNewLine() && this.isCurrentTokenIn(CoffeeScriptTokenTypes.EXTENDS)) {
            PsiBuilder.Marker extendsListMarker = this.mark();
            this.advance();
            if (this.isSimpleAssignable() || this.isExpression() && !this.isNewLine()) {
                PsiBuilder.Marker extendsMemberMarker = this.mark();
                this.parseValuesAndInvocations(false, true, false, false);
                this.done(extendsMemberMarker, (IElementType)JSStubElementTypes.EXTENDS_LIST_MEMBER);
            } else {
                this.error(CsBundle.message("parsing.error.expected.class.name", new Object[0]));
            }
            this.done(extendsListMarker, (IElementType)JSStubElementTypes.EXTENDS_LIST);
        }
        if (!this.isNewLine() && !this.eof()) {
            if (this.currentTokenIn(new IElementType[]{CoffeeScriptTokenTypes.THEN})) {
                this.advance();
                if (!this.isNewLine()) {
                    this.parseLine(false);
                }
            } else if (this.parenthesisLevel == 0 || !this.currentTokenIn(new IElementType[]{CoffeeScriptTokenTypes.PARENTHESIS_END})) {
                this.error(CsBundle.message("parsing.error.expected.end.of.line", new Object[0]));
            }
        } else if (this.isNewLine()) {
            this.parseBlock(indent, true);
        }
        this.done(marker, (IElementType)(classExpression ? JSStubElementTypes.CLASS_EXPRESSION : CoffeeScriptElementTypes.CLASS));
    }

    private void parseAttributeList() {
        if (this.currentTokenIn(new IElementType[]{CoffeeScriptTokenTypes.EXPORT_KEYWORD})) {
            PsiBuilder.Marker attributeListMarker = this.mark();
            this.advance();
            this.done(attributeListMarker, (IElementType)JSStubElementTypes.ATTRIBUTE_LIST);
        }
    }

    private void parseSimpleAssignable() {
        if (this.isIdentifier()) {
            this.parseIdentifier(false);
        } else if (this.isThisProperty()) {
            this.parseThisProperty();
        } else {
            this.error(CsBundle.message("parsing.error.expected", "Assignable"));
        }
    }

    private void parseIdentifier(boolean reservedWordsAllowed) {
        if (!reservedWordsAllowed && !CoffeeScriptParser.tokenIn((IElementType)this.rawLookup(-1), (IElementType[])new IElementType[]{CoffeeScriptTokenTypes.DOT}) && this.CS_RESERVED.contains(this.getTokenText())) {
            this.error(CsBundle.message("parsing.error.reserved.word", new Object[0]));
        }
        this.advance();
    }

    private boolean parseContinue() {
        if (this.currentTokenIn(new IElementType[]{CoffeeScriptTokenTypes.CONTINUE})) {
            PsiBuilder.Marker marker = this.mark();
            this.advance();
            this.done(marker, JSElementTypes.CONTINUE_STATEMENT);
            return true;
        }
        return false;
    }

    private boolean parseStatement() {
        if (this.isReturn()) {
            this.parseReturn();
        } else if (this.isString()) {
            this.skipString();
        } else if (!this.parseContinue()) {
            this.advance();
        }
        return true;
    }

    private void parseThisProperty() {
        PsiBuilder.Marker marker = this.mark();
        this.advance();
        this.advance();
        this.done(marker, CoffeeScriptElementTypes.THIS_PROPERTY);
    }

    private ValueTypes parseAccessor(@Nullable PsiBuilder.Marker referenceMarker, @Nullable PsiBuilder.Marker invocationMarker, boolean invocationWithoutParenthesisAllowed, boolean argumentsOnNewLineAllowed) {
        ValueTypes result = ValueTypes.VALUE;
        if (this.isCurrentTokenIn(CoffeeScriptTokenTypes.DOT)) {
            this.advance();
            result = this.parseValueOrInvocation(referenceMarker, invocationMarker, invocationWithoutParenthesisAllowed, true, argumentsOnNewLineAllowed);
        } else if (this.isPrototype()) {
            this.advance();
            if (this.getTokenType() == CoffeeScriptTokenTypes.IDENTIFIER) {
                this.advance();
            }
            if (referenceMarker != null) {
                this.done(referenceMarker, CoffeeScriptElementTypes.REFERENCED_EXPRESSION);
            }
        } else if (this.isIndex()) {
            this.parseIndex();
            if (referenceMarker != null) {
                this.done(referenceMarker, CoffeeScriptElementTypes.INDEXED_PROPERTY_ACCESS_EXPRESSION);
            }
        } else if (this.isExist()) {
            this.advance();
            if (referenceMarker != null) {
                this.done(referenceMarker, CoffeeScriptElementTypes.REFERENCED_EXPRESSION);
            }
        } else {
            referenceMarker.drop();
            this.error(CsBundle.message("parsing.error.unexpected", "token"));
        }
        return result;
    }

    private void parseIndex() {
        this.advance();
        if (this.isRangeSymbol()) {
            this.advance();
            if (!this.isCurrentTokenIn(CoffeeScriptTokenTypes.BRACKET_END)) {
                this.parseOperation();
            }
        } else {
            this.parseOperation();
            if (this.isRangeSymbol()) {
                this.advance();
            }
            if (!(this.isCurrentTokenIn(CoffeeScriptTokenTypes.BRACKET_END) || this.isNewLine() || this.eof())) {
                this.parseOperation();
            }
        }
        this.expect(CoffeeScriptTokenTypes.BRACKET_END);
    }

    private boolean isValue() {
        return this.isAssignable() || this.isLiteral() || this.isParenthetical() || this.isRange() || this.isThis() || this.isSuper() || this.currentTokenIn(new IElementType[]{CoffeeScriptTokenTypes.NEW_KEYWORD}) || this.isImportCall();
    }

    private boolean isAssignable() {
        return this.isSimpleAssignable() || this.isArray() || this.isObject();
    }

    private boolean isStringObjectKey() {
        boolean result = false;
        if (this.isString()) {
            PsiBuilder.Marker marker = this.mark(true);
            this.skipString();
            result = this.isCurrentTokenIn(CoffeeScriptTokenTypes.COLON);
            this.rollbackTo(marker);
        }
        return result;
    }

    private boolean isObject() {
        return this.isCurrentTokenIn(CoffeeScriptTokenTypes.BRACE_START) || this.isStringObjectKey() || this.isIdentifier() && CoffeeScriptParser.isTokenIn(this.lookAhead(1), CoffeeScriptTokenTypes.COLON) || this.isThisProperty() && CoffeeScriptParser.isTokenIn(this.lookAhead(2), CoffeeScriptTokenTypes.COLON);
    }

    private void parseDestructuringObject(@NotNull IElementType propertyType, boolean wrapWithVarStatement, boolean checkForBraces) {
        if (propertyType == null) {
            CoffeeScriptParser.$$$reportNull$$$0(7);
        }
        PsiBuilder.Marker varStatementMarker = this.mark();
        PsiBuilder.Marker destructuringElementMarker = this.mark();
        PsiBuilder.Marker destructuringObjectMarker = this.mark();
        boolean withBraces = false;
        if (this.currentTokenIn(new IElementType[]{CoffeeScriptTokenTypes.BRACE_START})) {
            this.advance();
            withBraces = true;
        } else if (checkForBraces) {
            this.error(CsBundle.message("parser.destructuring.object.without.braces", new Object[0]));
        }
        while (this.isIdentifier() || this.isShortThis() || this.isString()) {
            boolean doAsReference = true;
            PsiBuilder.Marker propertyMarker = this.mark();
            PsiBuilder.Marker definitionMarker = this.mark();
            PsiBuilder.Marker propertyNameMarker = this.mark();
            String variableName = null;
            if (this.isString()) {
                this.skipString();
            } else {
                if (this.isThis()) {
                    PsiBuilder.Marker marker = this.mark();
                    this.advance();
                    this.done(marker, JSElementTypes.REFERENCE_EXPRESSION);
                } else {
                    doAsReference = false;
                }
                variableName = this.getTokenText();
                this.advance();
            }
            if (this.isCurrentTokenIn(CoffeeScriptTokenTypes.EQ)) {
                this.done(propertyNameMarker, propertyType);
                CoffeeScriptParser.drop((PsiBuilder.Marker)definitionMarker);
                this.advance();
                this.myExpressionInvoker.parse();
            } else if (this.isCurrentTokenIn(CoffeeScriptTokenTypes.COLON)) {
                this.done(propertyNameMarker, CoffeeScriptElementTypes.REFERENCED_EXPRESSION);
                CoffeeScriptParser.drop((PsiBuilder.Marker)definitionMarker);
                this.advance();
                if (this.isObject()) {
                    this.parseDestructuringObject((IElementType)CoffeeScriptElementTypes.VARIABLE, false, false);
                } else if (this.currentTokenIn(new IElementType[]{CoffeeScriptTokenTypes.BRACKET_START})) {
                    this.parseDestructuringArray();
                } else if (this.shouldDeclareVariable(this.getTokenText())) {
                    this.parseDestructuringVariable(propertyType);
                } else {
                    definitionMarker = this.mark();
                    PsiBuilder.Marker referenceMarker = this.mark();
                    if (this.isShortThis()) {
                        PsiBuilder.Marker referenceMarkerForThis = this.mark();
                        this.advance();
                        this.done(referenceMarkerForThis, JSElementTypes.REFERENCE_EXPRESSION);
                    }
                    this.advance();
                    this.done(referenceMarker, JSElementTypes.REFERENCE_EXPRESSION);
                    this.done(definitionMarker, (IElementType)JSStubElementTypes.DEFINITION_EXPRESSION);
                }
            } else if (!doAsReference && this.shouldDeclareVariable(variableName)) {
                this.addVariableInCurrentScope(variableName);
                CoffeeScriptParser.drop((PsiBuilder.Marker)propertyNameMarker);
                this.done(definitionMarker, propertyType);
            } else {
                this.done(propertyNameMarker, JSElementTypes.REFERENCE_EXPRESSION);
                this.done(definitionMarker, (IElementType)JSStubElementTypes.DEFINITION_EXPRESSION);
            }
            this.done(propertyMarker, (IElementType)JSStubElementTypes.DESTRUCTURING_PROPERTY);
            if (!this.isCurrentTokenIn(CoffeeScriptTokenTypes.COMMA, CoffeeScriptTokenTypes.SPLAT)) continue;
            this.advance();
        }
        if (withBraces) {
            this.expectAndAdvance(CoffeeScriptTokenTypes.BRACE_END);
        }
        if (this.currentTokenIn(new IElementType[]{CoffeeScriptTokenTypes.EQ})) {
            this.advance();
            this.parseWithPossibleWhileOrForOrIf(this.myExpressionInvoker);
        }
        this.done(destructuringObjectMarker, (IElementType)JSStubElementTypes.DESTRUCTURING_OBJECT);
        this.done(destructuringElementMarker, (IElementType)CoffeeScriptElementTypes.DESTRUCTURING_ASSIGNMENT_EXPRESSION);
        if (wrapWithVarStatement) {
            this.done(varStatementMarker, CoffeeScriptElementTypes.VAR_STATEMENT);
        } else {
            CoffeeScriptParser.drop((PsiBuilder.Marker)varStatementMarker);
        }
    }

    private void parseDestructuringVariable(@NotNull IElementType propertyType) {
        if (propertyType == null) {
            CoffeeScriptParser.$$$reportNull$$$0(8);
        }
        this.addVariableInCurrentScope(this.getTokenText());
        PsiBuilder.Marker variableMarker = this.mark();
        this.advance();
        this.done(variableMarker, propertyType);
    }

    private boolean shouldDeclareVariable(String text) {
        return text != null && !this.isShortThis() && !this.isInScope(text);
    }

    private void parseObject() {
        PsiBuilder.Marker marker = this.mark(true);
        boolean startedOnNewLine = this.isNewLine();
        boolean withBraces = false;
        this.invocationIndent = -1;
        if (this.isCurrentTokenIn(CoffeeScriptTokenTypes.BRACE_START)) {
            this.advance();
            withBraces = true;
        }
        boolean firstObjectValue = true;
        int indent = this.getCurrentIndent();
        PsiBuilder.Marker lastCommaMarker = null;
        while (!withBraces || !this.isCurrentTokenIn(CoffeeScriptTokenTypes.BRACE_END)) {
            int offset = this.getCurrentOffset();
            if (this.isNewLine()) {
                int newIndent = this.getCurrentIndent();
                if (indent >= 0 && newIndent > indent && !withBraces || newIndent < indent && !withBraces || !startedOnNewLine && newIndent == indent && !withBraces) break;
                indent = newIndent;
            } else if (!firstObjectValue && this.isNewLine() && 0 < indent && !withBraces) break;
            if (this.isComma() && lastCommaMarker == null) {
                lastCommaMarker = this.mark(true);
                this.advance();
                continue;
            }
            if (!withBraces && (!this.isThisProperty() || !CoffeeScriptParser.isTokenIn(this.lookAhead(2), CoffeeScriptTokenTypes.COLON)) && !this.isStringObjectKey() && (!this.isCurrentTokenIn(CoffeeScriptTokenTypes.IDENTIFIER) || !CoffeeScriptParser.isTokenIn(this.lookAhead(1), CoffeeScriptTokenTypes.COLON))) break;
            if (!withBraces || !this.isCurrentTokenIn(CoffeeScriptTokenTypes.BRACE_END)) {
                this.parseAssignObj();
            }
            if (lastCommaMarker != null) {
                CoffeeScriptParser.drop((PsiBuilder.Marker)lastCommaMarker);
                lastCommaMarker = null;
            }
            if (this.getCurrentOffset() == offset) {
                this.error(CsBundle.message("parsing.error.expected", "AssignObj"));
                break;
            }
            firstObjectValue = false;
        }
        if (withBraces) {
            this.expect(CoffeeScriptTokenTypes.BRACE_END);
        }
        if (withBraces && this.isCurrentTokenIn(CoffeeScriptTokenTypes.EQ)) {
            this.rollbackTo(marker);
            this.parseDestructuringObject((IElementType)CoffeeScriptElementTypes.VARIABLE, true, true);
        } else {
            if (lastCommaMarker != null) {
                if (withBraces || this.isNewLine()) {
                    CoffeeScriptParser.drop((PsiBuilder.Marker)lastCommaMarker);
                } else {
                    this.rollbackTo(lastCommaMarker);
                }
            }
            this.done(marker, CoffeeScriptElementTypes.OBJECT);
        }
    }

    private void parseAssignObj() {
        PsiBuilder.Marker marker = this.mark(true);
        if (this.isObjAssignable()) {
            int indent = this.getCurrentIndent();
            PsiBuilder.Marker referenceMarker = this.mark();
            boolean couldBeReference = this.parseObjAssignable();
            if (this.isCurrentTokenIn(CoffeeScriptTokenTypes.COLON)) {
                this.advance();
                if (!(this.isExpressionTerminator() || this.isNewLine() && this.getCurrentIndent() <= indent)) {
                    this.parseWithPossibleWhileOrForOrIf(this.myExpressionInvoker);
                } else {
                    this.error(CsBundle.message("parsing.error.unexpected", "new line"));
                }
                couldBeReference = false;
            }
            if (couldBeReference) {
                this.done(referenceMarker, CoffeeScriptElementTypes.REFERENCED_EXPRESSION);
            } else {
                referenceMarker.drop();
            }
        }
        this.done(marker, (IElementType)CoffeeScriptElementTypes.PROPERTY);
    }

    private boolean parseObjAssignable() {
        boolean couldBeReference = true;
        if (this.isIdentifier()) {
            couldBeReference = false;
            PsiBuilder.Marker referenceExpressionMarker = this.mark();
            this.parseIdentifier(true);
            if (this.isCurrentTokenIn(CoffeeScriptTokenTypes.COLON)) {
                CoffeeScriptParser.drop((PsiBuilder.Marker)referenceExpressionMarker);
            } else {
                this.done(referenceExpressionMarker, CoffeeScriptElementTypes.REFERENCED_EXPRESSION);
                if (this.isSplatSymbol()) {
                    this.advance();
                }
            }
        } else if (this.isAlphaNumeric()) {
            this.parseObjectAssignableLiteral();
            couldBeReference = false;
        } else if (this.isThisProperty()) {
            this.advance();
            this.parseIdentifier(true);
        } else {
            couldBeReference = false;
            this.error(CsBundle.message("parsing.error.unexpected", "token"));
        }
        return couldBeReference;
    }

    private void parseParenthetical() {
        ++this.parenthesisLevel;
        this.startScope();
        PsiBuilder.Marker marker = this.mark();
        this.advance();
        while (!this.isCurrentTokenIn(CoffeeScriptTokenTypes.PARENTHESIS_END)) {
            int offset = this.getCurrentOffset();
            this.parseLine(false);
            if (offset != this.getCurrentOffset()) continue;
            this.error(CsBundle.message("parsing.error.unexpected", this.getTokenType()));
            break;
        }
        this.expect(CoffeeScriptTokenTypes.PARENTHESIS_END);
        this.done(marker, CoffeeScriptElementTypes.PARENTHESIZED_EXPRESSION);
        --this.parenthesisLevel;
        this.endScope();
    }

    private boolean isRange() {
        if (this.isCurrentTokenIn(CoffeeScriptTokenTypes.BRACKET_START)) {
            int offset = this.getCurrentOffset();
            CoffeeScriptParserMetaData md = this.metaData.get(offset);
            if (md != null) {
                if (md.isRange != null) {
                    return md.isRange;
                }
            } else {
                md = new CoffeeScriptParserMetaData();
                this.metaData.put(offset, md);
            }
            PsiBuilder.Marker marker = this.mark(true);
            this.advance();
            this.parseOperation();
            if (this.isRangeSymbol() && this.lookAhead(1) != CoffeeScriptTokenTypes.COMMA) {
                this.advance();
                if (!this.isNewLine()) {
                    this.rollbackTo(marker);
                    md.isRange = true;
                    return true;
                }
            }
            md.isRange = false;
            this.rollbackTo(marker);
        }
        return false;
    }

    private boolean parseParameterList() {
        this.startScope();
        PsiBuilder.Marker marker = this.mark();
        this.advance();
        while (!this.eof() && !this.isCurrentTokenIn(CoffeeScriptTokenTypes.PARENTHESIS_END)) {
            int offset = this.getCurrentOffset();
            this.parseParam();
            if (offset == this.getCurrentOffset()) {
                return false;
            }
            if (!this.isCurrentTokenIn(CoffeeScriptTokenTypes.COMMA)) continue;
            this.advance();
        }
        if (!this.isCurrentTokenIn(CoffeeScriptTokenTypes.PARENTHESIS_END)) {
            this.endScope();
            this.error(CsBundle.message("parsing.error.expected", ")"));
            return false;
        }
        this.advance();
        this.done(marker, (IElementType)JSStubElementTypes.PARAMETER_LIST);
        return true;
    }

    private void parseSplat() {
        this.advance();
    }

    private void parseParam() {
        String result;
        if (this.isIdentifier() && this.isInScope(this.getTokenText())) {
            result = this.getTokenText();
            PsiBuilder.Marker marker = this.mark();
            this.parseValuesAndInvocations(true, false, false, false);
            this.done(marker, (IElementType)CoffeeScriptElementTypes.PARAMETER);
        } else if (this.isObject()) {
            this.parseDestructuringObject((IElementType)CoffeeScriptElementTypes.PARAMETER, false, true);
            if (this.isCurrentTokenIn(CoffeeScriptTokenTypes.EQ)) {
                this.advance();
                this.parseOperation();
            }
            result = null;
        } else if (this.isArray()) {
            this.parseDestructuringArrayInParameters();
            if (this.isSplatSymbol()) {
                this.parseSplat();
            }
            result = null;
        } else {
            PsiBuilder.Marker marker = this.mark();
            result = this.parseParamVar();
            if (this.isSplatSymbol()) {
                this.parseSplat();
            } else if (this.isCurrentTokenIn(CoffeeScriptTokenTypes.EQ)) {
                this.advance();
                this.parseOperation();
            }
            this.done(marker, (IElementType)CoffeeScriptElementTypes.PARAMETER);
        }
        if (result != null) {
            this.addVariableInCurrentScope(result);
        }
    }

    private void parseDestructuringArrayInParameters() {
        Stack bracesStack = new Stack();
        int offset = this.getCurrentOffset();
        int splatCount = 0;
        PsiBuilder.Marker destructuringArrayMarker = this.mark();
        do {
            if (BRACKETS.containsValue(this.getTokenType())) {
                bracesStack.push((Object)this.getTokenType());
                this.advance();
            }
            if (BRACKETS.containsKey(this.getTokenType())) {
                if (!bracesStack.isEmpty() && bracesStack.peek() == BRACKETS.get(this.getTokenType())) {
                    this.advance();
                    bracesStack.pop();
                } else {
                    this.error(CsBundle.message("parsing.error.unmatched", this.getTokenText()));
                    break;
                }
            }
            if (this.isSplatSymbol()) {
                this.parseSplat();
                if (++splatCount > 1) {
                    this.error(CsBundle.message("parsing.error.multiple.splats", new Object[0]));
                }
            } else if (this.isIdentifier()) {
                PsiBuilder.Marker parameterMarker = this.mark();
                this.addVariableInCurrentScope(this.getTokenText());
                this.advance();
                this.done(parameterMarker, (IElementType)CoffeeScriptElementTypes.PARAMETER);
            }
            if (this.isSplatSymbol()) {
                if (splatCount > 0) {
                    this.error(CsBundle.message("parsing.error.multiple.splats", new Object[0]));
                }
                this.parseSplat();
                ++splatCount;
            }
            if (this.isComma() || this.currentTokenIn(new IElementType[]{CoffeeScriptTokenTypes.COLON})) {
                this.advance();
            }
            if (offset == this.getCurrentOffset()) break;
            offset = this.getCurrentOffset();
        } while (!bracesStack.isEmpty() && !this.eof());
        this.done(destructuringArrayMarker, (IElementType)JSStubElementTypes.DESTRUCTURING_ARRAY);
    }

    private void parseDestructuringArray() {
        PsiBuilder.Marker destructuringElementMarker = this.mark();
        PsiBuilder.Marker destructuringArrayMarker = this.mark();
        this.expectAndAdvance(CoffeeScriptTokenTypes.BRACKET_START);
        while (!this.currentTokenIn(new IElementType[]{CoffeeScriptTokenTypes.BRACKET_END})) {
            PsiBuilder.Marker definitionMarker = this.mark();
            if (this.isSplatSymbol()) {
                this.parseSplat();
            } else {
                this.parseValuesAndInvocations(true, false, false, false);
            }
            if (this.isSplatSymbol()) {
                this.parseSplat();
            }
            this.done(definitionMarker, CoffeeScriptElementTypes.DEFINITION_EXPRESSION);
            if (!this.isComma()) break;
            this.advance();
        }
        this.expectAndAdvance(CoffeeScriptTokenTypes.BRACKET_END);
        if (this.currentTokenIn(new IElementType[]{CoffeeScriptTokenTypes.EQ})) {
            this.advance();
            this.parseExpression();
        }
        this.done(destructuringArrayMarker, (IElementType)JSStubElementTypes.DESTRUCTURING_ARRAY);
        this.done(destructuringElementMarker, (IElementType)CoffeeScriptElementTypes.DESTRUCTURING_ASSIGNMENT_EXPRESSION);
    }

    @Nullable
    private String parseParamVar() {
        String result = null;
        if (this.isCurrentTokenIn(CoffeeScriptTokenTypes.THIS)) {
            if (this.getTokenText().equals("this")) {
                this.error(CsBundle.message("parsing.error.unexpected", "\"this\""));
                this.advance();
                this.expectAndAdvance(CoffeeScriptTokenTypes.DOT);
            } else {
                this.advance();
            }
            this.expectAndAdvance(CoffeeScriptTokenTypes.IDENTIFIER);
        } else if (this.isIdentifier()) {
            result = this.getTokenText();
            this.advance();
        } else if (this.isArray()) {
            this.parseArray();
        }
        return result;
    }

    private void parseArray() {
        boolean eqFound;
        int indent = this.getCurrentIndent();
        PsiBuilder.Marker arrayAssignmentMarker = this.mark(true);
        PsiBuilder.Marker arrayMarker = this.mark();
        this.advance();
        while (!this.eof() && !this.isCurrentTokenIn(CoffeeScriptTokenTypes.BRACKET_END)) {
            int offset = this.getCurrentOffset();
            if (!this.isSplatSymbol()) {
                this.parseWithPossibleWhileOrForOrIf(this.myExpressionInvoker);
            }
            if (this.isSplatSymbol()) {
                this.parseSplat();
            }
            if (offset == this.getCurrentOffset()) {
                this.error(CsBundle.message("parsing.error.unexpected", "token"));
                break;
            }
            if (this.isComma() || this.isExpressionTerminator()) {
                this.advance();
                while (this.isComma()) {
                    this.error(CsBundle.message("parsing.error.unexpected", ","));
                    this.advance();
                }
                continue;
            }
            if (this.isNewLine() || this.isCurrentTokenIn(CoffeeScriptTokenTypes.BRACKET_END)) continue;
            this.error(CsBundle.message("parsing.error.expected", ","));
        }
        this.expect(CoffeeScriptTokenTypes.BRACKET_END);
        this.done(arrayMarker, CoffeeScriptElementTypes.ARRAY_LITERAL_EXPRESSION);
        boolean bl = eqFound = this.isCurrentTokenIn(CoffeeScriptTokenTypes.EQ) && this.getCurrentIndent() >= indent;
        if (eqFound) {
            this.rollbackTo(arrayAssignmentMarker);
            this.parseDestructuringArray();
            return;
        }
        arrayAssignmentMarker.drop();
    }

    private boolean parseWithPossibleWhileOrForOrIf(@NotNull ParseInvoker invoker) {
        if (invoker == null) {
            CoffeeScriptParser.$$$reportNull$$$0(9);
        }
        PsiBuilder.Marker labelMarker = this.mark();
        boolean result = invoker.parse();
        while (!this.isNewLine() && (this.isForBody() || this.isIf() || this.isWhile())) {
            PsiBuilder.Marker marker = labelMarker;
            labelMarker = labelMarker.precede();
            if (this.isWhile()) {
                this.parseWhileExpression();
                this.done(marker, CoffeeScriptElementTypes.WHILE_STATEMENT);
                continue;
            }
            if (this.isForBody()) {
                this.parseForBody();
                this.done(marker, CoffeeScriptElementTypes.FOR_STATEMENT);
                continue;
            }
            if (!this.isIf()) continue;
            this.parseIfCondition();
            this.done(marker, CoffeeScriptElementTypes.IF_STATEMENT);
        }
        labelMarker.drop();
        return result;
    }

    private void parseSimpleArgs() {
        while (true) {
            this.parseOperation();
            if (!this.isCurrentTokenIn(CoffeeScriptTokenTypes.COMMA)) break;
            this.advance();
        }
    }

    private void parseSwitch() {
        int indent;
        int switchIndent = this.getCurrentIndent();
        PsiBuilder.Marker marker = this.mark();
        this.advance();
        if (!this.isNewLine()) {
            this.parseOperation();
            if (!this.isNewLine()) {
                this.error(CsBundle.message("parsing.error.unexpected", this.getTokenText()));
            }
        }
        if ((indent = this.getCurrentIndent()) <= switchIndent) {
            this.error(CsBundle.message("parsing.error.when.block.must.be.inside.switch.block", new Object[0]));
        } else {
            this.parseWhens(indent);
        }
        this.done(marker, CoffeeScriptElementTypes.SWITCH_STATEMENT);
    }

    private void parseWhens(int indent) {
        block5: {
            this.wantedElseAtIndent.push((Object)indent);
            while (this.isNewLine()) {
                if (this.getCurrentIndent() == indent) {
                    if (this.isCurrentTokenIn(CoffeeScriptTokenTypes.WHEN)) {
                        this.parseWhen();
                        continue;
                    }
                    if (this.isCurrentTokenIn(CoffeeScriptTokenTypes.ELSE)) {
                        this.parseCaseElse();
                        continue;
                    }
                    this.error(CsBundle.message("parsing.error.expected", "When"));
                }
                break block5;
            }
            if (!this.eof()) {
                this.error(CsBundle.message("parsing.error.expected", "Indent"));
            }
        }
        this.wantedElseAtIndent.pop();
    }

    private void parseCaseElse() {
        int indent = this.getCurrentIndent();
        PsiBuilder.Marker marker = this.mark();
        this.advance();
        this.parseBlockOrLine(indent);
        this.done(marker, CoffeeScriptElementTypes.CASE_CLAUSE);
    }

    private void parseWhen() {
        int indent = this.getCurrentIndent();
        PsiBuilder.Marker marker = this.mark();
        this.advance();
        this.parseSimpleArgs();
        this.parseBlockOrThen(indent);
        this.done(marker, CoffeeScriptElementTypes.CASE_CLAUSE);
    }

    private boolean parseAssignment() {
        PsiBuilder.Marker assignmentMarker = this.mark();
        PsiBuilder.Marker definitionMarker = this.mark();
        boolean result = OperationParserHelper.callParsingBinaryOperation((OperationParserHelper.BinaryOperationParser)this, (int)(CoffeeScriptTokenTypes.BINARY_OPERATION_PRIORITY.length - 1));
        if (CoffeeScriptTokenTypes.ASSIGNMENT_OPERATIONS.contains(this.getTokenType())) {
            this.done(definitionMarker, CoffeeScriptElementTypes.DEFINITION_EXPRESSION);
            this.advance();
            result = this.parseAssignment();
            this.done(assignmentMarker, CoffeeScriptElementTypes.ASSIGN_EXPRESSION);
        } else {
            definitionMarker.drop();
            assignmentMarker.drop();
        }
        return result;
    }

    private boolean parseOperation() {
        return this.parseAssignment();
    }

    private void parseVariable() {
        int variableIndent = this.getCurrentIndent();
        PsiBuilder.Marker varMarker = this.mark();
        this.parseAttributeList();
        PsiBuilder.Marker marker = this.mark();
        String variableName = this.getTokenText();
        this.addVariableInCurrentScope(variableName);
        this.parseIdentifier(false);
        this.advance();
        if (this.isNewLine()) {
            int indent = this.getCurrentIndent();
            if (indent < variableIndent) {
                this.error(CsBundle.message("parsing.error.unexpected", "Outdent"));
            }
            this.parseWithPossibleWhileOrForOrIf(this.myExpressionInvoker);
        } else {
            this.parseOperation();
        }
        this.done(marker, (IElementType)CoffeeScriptElementTypes.VARIABLE);
        this.done(varMarker, CoffeeScriptElementTypes.VAR_STATEMENT);
    }

    private ValueTypes parseValueOrInvocation(@Nullable PsiBuilder.Marker referenceMarker, @Nullable PsiBuilder.Marker invocationMarker, boolean invocationWithoutParenthesisAllowed, boolean objectAllowed, boolean argumentsOnNewLineAllowed) {
        int indent = this.getCurrentIndent();
        boolean referenced = this.parseValue(objectAllowed);
        if (referenceMarker != null) {
            if (referenced) {
                this.done(referenceMarker, CoffeeScriptElementTypes.REFERENCED_EXPRESSION);
            } else {
                referenceMarker.drop();
            }
        }
        if (!this.currentTokenIn(new IElementType[]{CoffeeScriptTokenTypes.PARENTHESIS_START}) && (!invocationWithoutParenthesisAllowed || !argumentsOnNewLineAllowed && this.isNewLine())) {
            return ValueTypes.VALUE;
        }
        if (this.isInvocationWithBraces()) {
            this.parseArgumentList(0);
            if (invocationMarker != null) {
                this.done(invocationMarker, CoffeeScriptElementTypes.CALL_EXPRESSION);
            }
            return ValueTypes.INVOCATION_WITH_BRACES;
        }
        if (referenced && this.isExpression() && (!this.isNewLine() && this.hasSpaceBefore() || this.isNewLine() && this.isObject() && indent < this.getCurrentIndent() && !this.isCurrentTokenIn(CoffeeScriptTokenTypes.BRACE_START))) {
            this.parseArgumentList(indent);
            if (invocationMarker != null) {
                this.done(invocationMarker, CoffeeScriptElementTypes.CALL_EXPRESSION);
            }
            return ValueTypes.INVOCATION_WITHOUT_BRACES;
        }
        return ValueTypes.VALUE;
    }

    private boolean startsExpression() {
        int i = -1;
        if (CoffeeScriptTokenTypes.WHITESPACES.contains(this.rawLookup(i))) {
            --i;
        }
        return this.isNewLine() || CoffeeScriptParser.tokenIn((IElementType)this.rawLookup(i), (IElementType[])new IElementType[]{CoffeeScriptTokenTypes.SEMICOLON, CoffeeScriptTokenTypes.EQ, CoffeeScriptTokenTypes.PARENTHESIS_START, CoffeeScriptTokenTypes.RETURN, CoffeeScriptTokenTypes.EXIST, CoffeeScriptTokenTypes.DO_KEYWORD, CoffeeScriptTokenTypes.YIELD_KEYWORD});
    }

    private void parseValuesAndInvocations(boolean finishInvocation, boolean invocationWithoutParenthesisAllowed, boolean objectAllowed, boolean argumentsOnNewLineAllowed) {
        boolean isCallable = !this.isCurrentTokenIn(CoffeeScriptTokenTypes.NUMBER, CoffeeScriptTokenTypes.STRING_LITERAL, CoffeeScriptTokenTypes.BOOL) && !this.isObject();
        int indent = this.getCurrentIndent();
        boolean startsNewExpression = this.startsExpression();
        PsiBuilder.Marker implicitInvocationMarker = this.mark();
        PsiBuilder.Marker leftMarker = this.mark();
        PsiBuilder.Marker rightMarker = this.mark();
        ValueTypes valueType = this.parseValueOrInvocation(rightMarker, leftMarker, invocationWithoutParenthesisAllowed, objectAllowed, argumentsOnNewLineAllowed);
        if (valueType != ValueTypes.VALUE) {
            leftMarker = leftMarker.precede();
        }
        rightMarker = leftMarker;
        leftMarker = leftMarker.precede();
        while (this.isAccessor(indent) && (!this.isNewLine() || startsNewExpression) || this.isInvocationWithBraces() || this.isExist()) {
            int offset = this.getCurrentOffset();
            if (this.isAccessor(indent)) {
                valueType = this.parseAccessor(rightMarker, leftMarker, invocationWithoutParenthesisAllowed, argumentsOnNewLineAllowed);
                if (valueType != ValueTypes.VALUE) {
                    leftMarker = leftMarker.precede();
                }
                rightMarker = leftMarker;
                leftMarker = leftMarker.precede();
            }
            if (this.isInvocationWithBraces() || argumentsOnNewLineAllowed && this.isNewLine() && this.isArgumentObject(indent)) {
                this.parseArgumentList(indent);
                this.done(rightMarker, CoffeeScriptElementTypes.CALL_EXPRESSION);
                rightMarker = leftMarker;
                leftMarker = leftMarker.precede();
            }
            if (offset != this.getCurrentOffset()) continue;
            break;
        }
        rightMarker.drop();
        leftMarker.drop();
        if (valueType != ValueTypes.INVOCATION_WITHOUT_BRACES && (this.isNewLine() && this.isArgumentObject(indent) && this.myMultilineArgumentListAllowed || !this.isNewLine() && this.isExpression()) && finishInvocation && isCallable) {
            this.parseArgumentList(indent);
            this.done(implicitInvocationMarker, CoffeeScriptElementTypes.CALL_EXPRESSION);
        } else {
            implicitInvocationMarker.drop();
        }
    }

    private void parseImportExportSpecifier(boolean allowAsterisk, boolean allowDefault, IElementType specifierType, IElementType specifierAliasType) {
        if (allowAsterisk && this.isCurrentTokenIn(CoffeeScriptTokenTypes.MULT) || allowDefault && this.isCurrentTokenIn(CoffeeScriptTokenTypes.DEFAULT_KEYWORD) || this.isIdentifier()) {
            PsiBuilder.Marker specifierMarker = this.mark();
            this.advance();
            if (this.isKeywordStatement("as")) {
                PsiBuilder.Marker marker = this.mark();
                this.myBuilder.remapCurrentToken(CoffeeScriptTokenTypes.AS_KEYWORD);
                this.advance();
                if (!(this.isIdentifier() || allowDefault && this.isCurrentTokenIn(CoffeeScriptTokenTypes.DEFAULT_KEYWORD))) {
                    this.error(CsBundle.message("parsing.error.expected", "Alias"));
                }
                this.advance();
                if (allowAsterisk) {
                    CoffeeScriptParser.drop((PsiBuilder.Marker)marker);
                } else {
                    this.done(marker, specifierAliasType);
                }
            }
            this.done(specifierMarker, specifierType);
        }
    }

    private void parseImportSpecifiers() {
        if (this.isCurrentTokenIn(CoffeeScriptTokenTypes.MULT)) {
            this.parseImportExportSpecifier(true, false, CoffeeScriptElementTypes.IMPORTED_BINDING, CoffeeScriptElementTypes.IMPORT_SPECIFIER_ALIAS);
            return;
        }
        while (!(this.eof() || this.isNewLine() || this.isTerminator() || this.isString())) {
            int currentOffset = this.getCurrentOffset();
            if (this.isCurrentTokenIn(CoffeeScriptTokenTypes.BRACE_START)) {
                int offset;
                PsiBuilder.Marker namedImports = this.myBuilder.mark();
                this.advance();
                do {
                    offset = this.getCurrentOffset();
                    this.parseImportExportSpecifier(false, false, CoffeeScriptElementTypes.IMPORT_SPECIFIER, CoffeeScriptElementTypes.IMPORT_SPECIFIER_ALIAS);
                    if (!this.isCurrentTokenIn(CoffeeScriptTokenTypes.COMMA)) continue;
                    this.advance();
                } while (offset != this.getCurrentOffset() && !this.isCurrentTokenIn(CoffeeScriptTokenTypes.BRACE_END));
                this.expectAndAdvance(CoffeeScriptTokenTypes.BRACE_END);
                namedImports.done(CoffeeScriptElementTypes.NAMED_IMPORTS);
            } else {
                if (this.isKeywordStatement("from")) break;
                PsiBuilder.Marker importedBindingMarker = this.mark();
                this.expectAndAdvance(CoffeeScriptTokenTypes.IDENTIFIER);
                this.done(importedBindingMarker, CoffeeScriptElementTypes.IMPORTED_BINDING);
            }
            if (this.isCurrentTokenIn(CoffeeScriptTokenTypes.COMMA)) {
                this.advance();
            }
            if (currentOffset != this.getCurrentOffset()) continue;
            break;
        }
    }

    private boolean parseFromClause() {
        if (this.isKeywordStatement("from")) {
            PsiBuilder.Marker marker = this.mark();
            this.myBuilder.remapCurrentToken(CoffeeScriptTokenTypes.FROM_KEYWORD);
            this.advance();
            if (this.expect(CoffeeScriptTokenTypes.STRING_LITERAL)) {
                this.parseSimpleString();
            }
            this.done(marker, CoffeeScriptElementTypes.FROM_CLAUSE);
            return true;
        }
        return false;
    }

    private boolean isKeywordStatement(String keyword) {
        return this.isCurrentTokenIn(CoffeeScriptTokenTypes.IDENTIFIER) && StringUtil.equals((CharSequence)keyword, (CharSequence)this.getTokenText());
    }

    private boolean isImportCall() {
        return this.isCurrentTokenIn(CoffeeScriptTokenTypes.IMPORT_KEYWORD) && CoffeeScriptParser.tokenIn((IElementType)this.lookAhead(1), (IElementType[])new IElementType[]{CoffeeScriptTokenTypes.PARENTHESIS_START});
    }

    private boolean isImportDeclaration() {
        return this.isCurrentTokenIn(CoffeeScriptTokenTypes.IMPORT_KEYWORD) && !CoffeeScriptParser.tokenIn((IElementType)this.lookAhead(1), (IElementType[])new IElementType[]{CoffeeScriptTokenTypes.PARENTHESIS_START});
    }

    private void parseImportCall() {
        PsiBuilder.Marker marker = this.mark();
        this.expectAndAdvance(CoffeeScriptTokenTypes.IMPORT_KEYWORD);
        this.expectAndAdvance(CoffeeScriptTokenTypes.PARENTHESIS_START);
        this.parseSimpleExpression();
        this.expectAndAdvance(CoffeeScriptTokenTypes.PARENTHESIS_END);
        this.done(marker, CoffeeScriptElementTypes.IMPORT_CALL);
    }

    private void parseImportDeclaration() {
        PsiBuilder.Marker marker = this.mark();
        this.advance();
        this.parseImportSpecifiers();
        if (!this.parseFromClause() && this.expect(CoffeeScriptTokenTypes.STRING_LITERAL)) {
            this.parseSimpleString();
        }
        this.done(marker, CoffeeScriptElementTypes.IMPORT_DECLARATION);
    }

    private void parseExportSpecifiers() {
        if (this.isCurrentTokenIn(CoffeeScriptTokenTypes.MULT)) {
            this.advance();
            return;
        }
        if (this.isCurrentTokenIn(CoffeeScriptTokenTypes.BRACE_START)) {
            this.advance();
            while (!this.eof() && !this.isCurrentTokenIn(CoffeeScriptTokenTypes.BRACE_END)) {
                int offset = this.getCurrentOffset();
                this.parseImportExportSpecifier(false, true, CoffeeScriptElementTypes.EXPORT_SPECIFIER, CoffeeScriptElementTypes.EXPORT_SPECIFIER_ALIAS);
                if (offset == this.getCurrentOffset()) break;
                if (!this.isComma()) continue;
                this.advance();
            }
            this.expectAndAdvance(CoffeeScriptTokenTypes.BRACE_END);
        }
    }

    private boolean isExportedVariable() {
        return this.isCurrentTokenIn(CoffeeScriptTokenTypes.EXPORT_KEYWORD) && this.lookAhead(1) == CoffeeScriptTokenTypes.IDENTIFIER && this.lookAhead(2) == CoffeeScriptTokenTypes.EQ;
    }

    private boolean isExportDefaultAssignment() {
        return this.isCurrentTokenIn(CoffeeScriptTokenTypes.EXPORT_KEYWORD) && this.lookAhead(1) == CoffeeScriptTokenTypes.DEFAULT_KEYWORD;
    }

    private void parseExportDefaultAssignment() {
        PsiBuilder.Marker marker = this.mark();
        this.advance();
        this.advance();
        if (this.isClass()) {
            this.parseClass(true);
        } else {
            this.parseExpression();
        }
        this.done(marker, (IElementType)JSStubElementTypes.EXPORT_DEFAULT_ASSIGNMENT);
    }

    private void parseExportStatement() {
        if (this.isExportedVariable()) {
            this.parseVariable();
            return;
        }
        if (this.isExportDefaultAssignment()) {
            this.parseExportDefaultAssignment();
            return;
        }
        PsiBuilder.Marker marker = this.mark();
        this.advance();
        this.parseExportSpecifiers();
        this.parseFromClause();
        this.done(marker, CoffeeScriptElementTypes.EXPORT_DECLARATION);
    }

    private void parseAwaitCall() {
        PsiBuilder.Marker marker = this.mark();
        this.expectAndAdvance(CoffeeScriptTokenTypes.AWAIT_KEYWORD);
        this.parseExpression();
        this.done(marker, JSElementTypes.PREFIX_EXPRESSION);
    }

    @Override
    protected boolean parseExpression() {
        boolean skip = false;
        if (this.isCode()) {
            skip = this.parseFunction();
        }
        if (!skip) {
            if (this.myXmlParser.isXmlTagStart(this.getTokenType())) {
                this.myXmlParser.parseTag(new Stack());
            } else if (this.isCurrentTokenIn(CoffeeScriptTokenTypes.AWAIT_KEYWORD)) {
                this.parseAwaitCall();
            } else if (this.isCurrentTokenIn(CoffeeScriptTokenTypes.DO_KEYWORD)) {
                this.parseDoExpression();
            } else if (this.isClass()) {
                this.parseClass(false);
            } else if (this.isImportDeclaration()) {
                this.parseImportDeclaration();
            } else if (this.isCurrentTokenIn(CoffeeScriptTokenTypes.EXPORT_KEYWORD)) {
                this.parseExportStatement();
            } else if (this.isIf() && !this.isPostIf()) {
                this.parseIf();
            } else if (this.isWhile() && !this.isPostWhile()) {
                this.parseWhile();
            } else if (this.isLoop()) {
                this.parseLoop();
            } else if (this.isVariable()) {
                this.parseVariable();
            } else if (this.isValue()) {
                this.parseValuesAndInvocations(true, true, true, true);
            } else if (this.isForBody() && !this.isPostFor()) {
                this.parseFor();
            } else if (this.isSwitch()) {
                this.parseSwitch();
            } else if (this.isCurrentTokenIn(CoffeeScriptTokenTypes.TRY)) {
                this.parseTry();
            } else if (this.isThrow()) {
                this.parseThrow();
            } else if (!this.parseYield()) {
                if (!this.isIf() && !this.isWhile() && !this.isForBody() || this.isNewLine()) {
                    this.error(CsBundle.message("parsing.error.unexpected", "token"));
                }
                return false;
            }
        }
        return true;
    }

    private boolean parseYield() {
        if (this.currentTokenIn(new IElementType[]{CoffeeScriptTokenTypes.YIELD_KEYWORD})) {
            PsiBuilder.Marker marker = this.mark();
            this.advance();
            if (this.isReturn()) {
                this.parseReturn();
            } else {
                if (this.currentTokenIn(new IElementType[]{CoffeeScriptTokenTypes.FROM_KEYWORD})) {
                    this.advance();
                }
                this.myExpressionInvoker.parse();
            }
            this.done(marker, JSElementTypes.YIELD_EXPRESSION);
            return true;
        }
        return false;
    }

    private void parseDoExpression() {
        PsiBuilder.Marker marker = this.mark();
        this.advance();
        if (!this.myExpressionInvoker.parse()) {
            this.error(CsBundle.message("parsing.error.expected", "Expression"));
        }
        this.done(marker, CoffeeScriptElementTypes.DO_EXPRESSION);
    }

    private boolean isPostIf() {
        return this.isIf() && this.isPostSuffix(new ParseInvoker(){

            @Override
            public boolean parse() {
                CoffeeScriptParser.this.parseIfCondition();
                return false;
            }
        });
    }

    private boolean isPostWhile() {
        return this.isWhile() && this.isPostSuffix(new ParseInvoker(){

            @Override
            public boolean parse() {
                CoffeeScriptParser.this.parseWhileExpression();
                return false;
            }
        });
    }

    private boolean isPostFor() {
        return this.isForBody() && this.isPostSuffix(new ParseInvoker(){

            @Override
            public boolean parse() {
                CoffeeScriptParser.this.parseForBody();
                return false;
            }
        });
    }

    private boolean endOfOneLineFunctionScope() {
        return this.isNewLine() || this.eof() || this.isCurrentTokenIn(CoffeeScriptTokenTypes.PARENTHESIS_END, CoffeeScriptTokenTypes.BRACE_END, CoffeeScriptTokenTypes.BRACKET_END);
    }

    private boolean parseFunction() {
        int codeIndent = this.getCurrentIndent();
        PsiBuilder.Marker marker = this.mark(true);
        boolean parameterListParsed = true;
        boolean parametersScopeCreated = false;
        if (this.isCurrentTokenIn(CoffeeScriptTokenTypes.PARENTHESIS_START)) {
            parameterListParsed = this.parseParameterList();
            parametersScopeCreated = true;
        }
        if (!parameterListParsed || !this.isCurrentTokenIn(CoffeeScriptTokenTypes.FUNCTION, CoffeeScriptTokenTypes.FUNCTION_BIND)) {
            this.rollbackTo(marker);
            return false;
        }
        if (this.invocationIndent >= 0) {
            codeIndent = this.invocationIndent;
        }
        this.advance();
        boolean newLine = this.isNewLine();
        if (newLine) {
            this.parseBlock(codeIndent, true);
        } else {
            boolean functionBodyParsed = false;
            if (this.isExpression() || this.isStatement()) {
                int offset = this.getCurrentOffset();
                this.parseLineWithNewScope(true);
                boolean bl = functionBodyParsed = this.getCurrentOffset() > offset;
            }
            if (!(!functionBodyParsed || this.oneLineState.peek() || this.endOfOneLineFunctionScope() || this.currentTokenIn(new IElementType[]{CoffeeScriptTokenTypes.INTERPOLATION_END}) || this.currentTokenIn(new IElementType[]{CoffeeScriptTokenTypes.COMMA}) && this.nextTokenOnNewLine())) {
                this.error(CsBundle.message("parsing.error.unexpected", this.getTokenText()));
            }
        }
        this.done(marker, CoffeeScriptElementTypes.FUNCTION_EXPRESSION);
        if (parametersScopeCreated) {
            this.endScope();
        }
        return true;
    }

    private void parseReturn() {
        PsiBuilder.Marker marker = this.mark();
        this.advance();
        if (!this.isNewLine() && this.isExpression()) {
            this.parseOperation();
        }
        this.done(marker, CoffeeScriptElementTypes.RETURN_STATEMENT);
    }

    private void parseThrow() {
        PsiBuilder.Marker marker = this.mark();
        this.advance();
        this.parseOperation();
        this.done(marker, CoffeeScriptElementTypes.THROW_STATEMENT);
    }

    private void parseNewStatement() {
        if (this.currentTokenIn(new IElementType[]{CoffeeScriptTokenTypes.NEW_KEYWORD})) {
            PsiBuilder.Marker newMarker = this.mark(false);
            this.advance();
            PsiBuilder.Marker invocationMarker = this.mark();
            PsiBuilder.Marker referenceMarker = this.mark();
            ValueTypes valueType = this.parseValueOrInvocation(referenceMarker, invocationMarker, true, true, false);
            if (valueType == ValueTypes.VALUE) {
                CoffeeScriptParser.drop((PsiBuilder.Marker)invocationMarker);
            }
            this.done(newMarker, CoffeeScriptElementTypes.NEW_EXPRESSION);
        }
    }

    private boolean parseValue(boolean objectAllowed) {
        boolean referenced = false;
        if (this.isImportCall()) {
            this.parseImportCall();
            referenced = true;
        } else if (this.currentTokenIn(new IElementType[]{CoffeeScriptTokenTypes.NEW_KEYWORD})) {
            this.parseNewStatement();
        } else if (this.isParenthetical()) {
            this.parseParenthetical();
        } else if (objectAllowed && this.isObject()) {
            this.parseObject();
        } else if (this.isCurrentTokenIn(CoffeeScriptTokenTypes.THIS)) {
            referenced = this.parseThis();
        } else if (this.isRange()) {
            this.parseRange();
        } else if (this.isAssignable()) {
            referenced = this.parseAssignable();
        } else if (this.isLiteral()) {
            this.parseLiteral();
        } else if (this.isSuper()) {
            this.advance();
        } else if (this.isCurrentTokenIn(CoffeeScriptTokenTypes.CLASS)) {
            this.parseClass();
        } else {
            this.error(CsBundle.message("parsing.error.unexpected", String.valueOf(this.getTokenType()) + " (" + this.getTokenText() + ")"));
        }
        return referenced;
    }

    private void expectAndAdvance(IElementType tokenType) {
        if (this.getTokenType() != tokenType) {
            this.error(CsBundle.message("parsing.error.expected.token.but.got", tokenType, this.getTokenType()));
            return;
        }
        this.advance();
    }

    private boolean parseAssignable() {
        boolean referenced = false;
        if (this.isArray()) {
            this.parseArray();
        } else if (this.isSimpleAssignable()) {
            referenced = true;
            this.parseSimpleAssignable();
        } else if (this.isObject()) {
            this.parseDestructuringObject((IElementType)CoffeeScriptElementTypes.VARIABLE, true, true);
        } else {
            this.error(CsBundle.message("parsing.error.unexpected.token.in.assignable.element", new Object[0]));
        }
        return referenced;
    }

    private void parseObjectAssignableLiteral() {
        if (this.isString()) {
            this.skipString();
        } else if (this.isCurrentTokenIn(CoffeeScriptTokenTypes.NUMBER, CoffeeScriptTokenTypes.BOOL)) {
            this.advance();
        }
    }

    private void parseLiteral() {
        if (this.isString()) {
            this.parseString();
        } else if (this.isCurrentTokenIn(CoffeeScriptTokenTypes.NUMBER, CoffeeScriptTokenTypes.BOOL)) {
            PsiBuilder.Marker marker = this.mark();
            this.advance();
            this.done(marker, CoffeeScriptElementTypes.LITERAL_EXPRESSION);
        } else if (this.isRegexp()) {
            PsiBuilder.Marker marker = this.mark();
            IElementType elementType = this.parseRegexp();
            this.done(marker, elementType);
        } else if (this.isCurrentTokenIn(CoffeeScriptTokenTypes.JAVASCRIPT_LITERAL)) {
            PsiBuilder.Marker marker = this.mark();
            this.advance();
            while (!(this.isCurrentTokenIn(CoffeeScriptTokenTypes.JAVASCRIPT_LITERAL) || this.isNewLine() || this.eof())) {
                this.advance();
            }
            this.expectAndAdvance(CoffeeScriptTokenTypes.JAVASCRIPT_LITERAL);
            this.done(marker, CoffeeScriptElementTypes.LITERAL_EXPRESSION);
        } else {
            this.error(CsBundle.message("parsing.error.unexpected", "token"));
        }
    }

    private void parseRange() {
        if (this.currentTokenIn(new IElementType[]{CoffeeScriptTokenTypes.BRACKET_START})) {
            PsiBuilder.Marker marker = this.mark();
            this.advance();
            if (!this.isSplatOrRange()) {
                this.parseOperation();
            }
            if (this.isSplatOrRange()) {
                if (this.isSplatSymbol()) {
                    this.parseSplat();
                } else {
                    this.advance();
                }
                if (!this.isCurrentTokenIn(CoffeeScriptTokenTypes.BRACKET_END)) {
                    this.parseOperation();
                }
                if (this.isCurrentTokenIn(CoffeeScriptTokenTypes.BRACKET_END)) {
                    this.advance();
                } else {
                    this.error(CsBundle.message("parsing.error.expected", "]"));
                }
            } else {
                this.error(CsBundle.message("parsing.error.expected", "..."));
            }
            this.done(marker, CoffeeScriptElementTypes.RANGE);
        }
    }

    private boolean parseThis() {
        if (this.isShortThis()) {
            PsiBuilder.Marker marker = this.mark();
            int offset = this.getCurrentOffset();
            this.advance();
            this.done(marker, CoffeeScriptElementTypes.THIS_PROPERTY);
            if (offset + 1 == this.getCurrentOffset() && (this.isIdentifier() || this.isPrototype())) {
                this.advance();
                return true;
            }
            return false;
        }
        PsiBuilder.Marker marker = this.mark();
        this.advance();
        this.done(marker, CoffeeScriptElementTypes.THIS_PROPERTY);
        return false;
    }

    private void parseInterpolation() {
        if (this.currentTokenIn(new IElementType[]{CoffeeScriptTokenTypes.INTERPOLATION_START})) {
            this.advance();
            while (!this.isCurrentTokenIn(CoffeeScriptTokenTypes.INTERPOLATION_END)) {
                this.parseWithPossibleWhileOrForOrIf(this.myExpressionInvoker);
                if (!this.isCurrentTokenIn(CoffeeScriptTokenTypes.SEMICOLON)) break;
                this.advance();
            }
            this.expectAndAdvance(CoffeeScriptTokenTypes.INTERPOLATION_END);
        }
    }

    private void parseGeneralString(@NotNull IElementType end, IElementType ... body) {
        if (end == null) {
            CoffeeScriptParser.$$$reportNull$$$0(10);
        }
        if (body == null) {
            CoffeeScriptParser.$$$reportNull$$$0(11);
        }
        this.advance();
        while (!this.eof() && !this.isCurrentTokenIn(end)) {
            if (this.isCurrentTokenIn(CoffeeScriptTokenTypes.INTERPOLATION_START)) {
                this.parseInterpolation();
                continue;
            }
            if (!ArrayUtil.contains((Object)this.getTokenType(), (Object[])body)) {
                this.error(CsBundle.message("parsing.error.unexpected", this.getTokenType()));
            }
            this.advance();
        }
        if (this.isCurrentTokenIn(end)) {
            this.advance();
            if (this.isCurrentTokenIn(CoffeeScriptTokenTypes.REGEX_FLAG)) {
                this.advance();
            }
        } else {
            this.error(CsBundle.message("parsing.error.expected.end.of.string", end));
        }
    }

    private IElementType parseRegexp() {
        if (this.isCurrentTokenIn(CoffeeScriptTokenTypes.HEREGEX_START)) {
            this.parseGeneralString(CoffeeScriptTokenTypes.HEREGEX_END, null, CoffeeScriptTokenTypes.TERMINATOR, CoffeeScriptTokenTypes.HEREGEX_TOKEN, CoffeeScriptTokenTypes.REGEX_BRACE_START, CoffeeScriptTokenTypes.REGEX_BRACE_END, CoffeeScriptTokenTypes.REGEX_BRACKET_START, CoffeeScriptTokenTypes.REGEX_BRACKET_END, CoffeeScriptTokenTypes.REGEX_PARENTHESIS_START, CoffeeScriptTokenTypes.REGEX_PARENTHESIS_END, CoffeeScriptTokenTypes.REGEX_FLAG, CoffeeScriptTokenTypes.ESCAPE_SEQUENCE, CoffeeScriptTokenTypes.INTERPOLATION_START, CoffeeScriptTokenTypes.INTERPOLATION_END, CoffeeScriptTokenTypes.BRACKET_START, CoffeeScriptTokenTypes.BRACKET_END, CoffeeScriptTokenTypes.PARENTHESIS_START, CoffeeScriptTokenTypes.PARENTHESIS_END, CoffeeScriptTokenTypes.INDENT);
            return CoffeeScriptElementTypes.HEREGEX;
        }
        this.parseGeneralString(CoffeeScriptTokenTypes.REGEX_END, null, CoffeeScriptTokenTypes.REGEX);
        return CoffeeScriptElementTypes.LITERAL_EXPRESSION;
    }

    private void parseSimpleString() {
        TokenSet stringBody = TokenSet.create((IElementType[])new IElementType[]{CoffeeScriptTokenTypes.STRING_LITERAL, CoffeeScriptTokenTypes.INTERPOLATION_START, CoffeeScriptTokenTypes.ESCAPE_SEQUENCE});
        boolean firstToken = true;
        while (this.currentTokenIn(stringBody) && (firstToken || this.rawLookup(-1) != CoffeeScriptTokenTypes.WHITE_SPACE && !this.isNewLine())) {
            firstToken = false;
            if (this.getTokenType() == CoffeeScriptTokenTypes.INTERPOLATION_START) {
                this.parseInterpolation();
                continue;
            }
            this.advance();
        }
    }

    private void skipString() {
        if (this.isCurrentTokenIn(CoffeeScriptTokenTypes.STRING_LITERAL)) {
            this.parseSimpleString();
        } else {
            this.parseGeneralString(CoffeeScriptTokenTypes.HEREDOC_END, null, CoffeeScriptTokenTypes.HEREDOC, CoffeeScriptTokenTypes.TERMINATOR, CoffeeScriptTokenTypes.INTERPOLATION_START, CoffeeScriptTokenTypes.INTERPOLATION_END, CoffeeScriptTokenTypes.ESCAPE_SEQUENCE);
        }
    }

    private void parseString() {
        Object stringElementType;
        PsiBuilder.Marker marker = this.mark();
        Object object = stringElementType = this.isCurrentTokenIn(CoffeeScriptTokenTypes.STRING_LITERAL) ? JSStubElementTypes.LITERAL_EXPRESSION : CoffeeScriptStubElementTypes.HEREDOC;
        if (this.isCurrentTokenIn(CoffeeScriptTokenTypes.STRING_LITERAL)) {
            this.parseSimpleString();
        } else {
            this.parseGeneralString(CoffeeScriptTokenTypes.HEREDOC_END, null, CoffeeScriptTokenTypes.HEREDOC, CoffeeScriptTokenTypes.TERMINATOR, CoffeeScriptTokenTypes.INTERPOLATION_START, CoffeeScriptTokenTypes.INTERPOLATION_END, CoffeeScriptTokenTypes.ESCAPE_SEQUENCE);
        }
        this.done(marker, (IElementType)stringElementType);
    }

    private void parseArgument(boolean invocationWithBraces) {
        boolean leadingSplatPresent = this.isSplatSymbol();
        if (leadingSplatPresent) {
            this.parseSplat();
        }
        if (invocationWithBraces) {
            this.parseWithPossibleWhileOrForOrIf(this.myExpressionInvoker);
        } else {
            this.parseOperation();
        }
        if (this.isSplatSymbol()) {
            if (leadingSplatPresent) {
                this.error(CsBundle.message("parsing.error.unexpected", "..."));
            }
            this.parseSplat();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isArgumentObject(int indent) {
        PsiBuilder.Marker marker = this.mark(true);
        try {
            if (this.isNewLine() && this.myMultilineArgumentListAllowed && this.getCurrentIndent() > indent && this.isObject()) {
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.rollbackTo(marker);
        }
    }

    private boolean isExpression() {
        return !(this.eof() || this.isExpressionTerminator() || this.isStatement() && !this.isVariable() || this.isCurrentTokenIn(CoffeeScriptTokenTypes.BAD_CHARACTER, CoffeeScriptTokenTypes.PARENTHESIS_END, CoffeeScriptTokenTypes.BRACKET_END, CoffeeScriptTokenTypes.DOT, CoffeeScriptTokenTypes.ELSE, CoffeeScriptTokenTypes.THEN, CoffeeScriptTokenTypes.COMMA, CoffeeScriptTokenTypes.WHEN, CoffeeScriptTokenTypes.BRACE_END, CoffeeScriptTokenTypes.BY, CoffeeScriptTokenTypes.COLON, CoffeeScriptTokenTypes.EQ, CoffeeScriptTokenTypes.EXTENDS, CoffeeScriptTokenTypes.EXIST, CoffeeScriptTokenTypes.RANGE, CoffeeScriptTokenTypes.INTERPOLATION_END) || this.isOperationSymbol() || this.isPostIf() || this.isRelationSymbol() || this.isSwitchEnd() || this.isPostFor() || this.isPostWhile() || this.isSplatSymbol() || this.isPostfixOperator() && this.rawLookup(-1) != CoffeeScriptTokenTypes.WHITE_SPACE);
    }

    private void parseArgumentList(int callIndent) {
        ++this.argumentListLevel;
        int oldInvocationIndent = this.invocationIndent;
        this.invocationIndent = callIndent;
        PsiBuilder.Marker argumentListMarker = this.mark();
        boolean invocationWithBraces = this.isInvocationWithBraces();
        if (invocationWithBraces) {
            ++this.parenthesisLevel;
            this.advance();
            while (!this.eof() && !this.isCurrentTokenIn(CoffeeScriptTokenTypes.PARENTHESIS_END)) {
                int offset = this.getCurrentOffset();
                if (this.currentTokenIn(new IElementType[]{CoffeeScriptTokenTypes.COMMA})) {
                    this.advance();
                    while (this.currentTokenIn(new IElementType[]{CoffeeScriptTokenTypes.COMMA})) {
                        this.error(CsBundle.message("parsing.error.unexpected", ","));
                        this.advance();
                    }
                }
                if (this.isCurrentTokenIn(CoffeeScriptTokenTypes.PARENTHESIS_END)) break;
                this.parseArgument(true);
                if (offset != this.getCurrentOffset()) continue;
                this.error(CsBundle.message("parsing.error.unexpected", "token"));
                break;
            }
            this.expect(CoffeeScriptTokenTypes.PARENTHESIS_END);
            --this.parenthesisLevel;
        } else if (this.getTokenType() == CoffeeScriptTokenTypes.COMMA) {
            this.error(CsBundle.message("parsing.error.unexpected", ","));
        } else {
            int offset;
            boolean argumentObject = false;
            boolean firstArgument = true;
            boolean comma = false;
            while ((!this.eof() && this.isExpression() || this.isSplatSymbol()) && (this.myMultilineArgumentListAllowed || !this.isNewLine())) {
                offset = this.getCurrentOffset();
                if (!firstArgument && !comma && (!this.isNewLine() || this.getCurrentIndent() <= callIndent) || !this.isExpression() && !this.isSplatSymbol()) break;
                firstArgument = false;
                if (this.isObject()) {
                    argumentObject = true;
                }
                this.parseArgument(false);
                comma = false;
                while (this.isCurrentTokenIn(CoffeeScriptTokenTypes.COMMA) && (this.getCurrentIndent() >= callIndent || this.argumentListLevel == 1)) {
                    if (comma) {
                        this.error(CsBundle.message("parsing.error.unexpected", ","));
                    }
                    comma = true;
                    this.advance();
                }
                if (offset != this.getCurrentOffset()) continue;
                this.error(CsBundle.message("parsing.error.unexpected", "token"));
                break;
            }
            if (this.isArgumentObject(callIndent)) {
                argumentObject = true;
                this.parseArgument(false);
                comma = false;
            }
            if (this.isComma() && (!this.isNewLine() || this.getCurrentIndent() == callIndent)) {
                this.advance();
                comma = true;
            }
            if (argumentObject || comma) {
                while (!(this.getCurrentIndent() <= callIndent || this.eof() || this.isStatement() || this.isNewLine() && this.getCurrentIndent() <= callIndent)) {
                    offset = this.getCurrentOffset();
                    if (this.isExpression()) {
                        comma = false;
                        this.parseArgument(false);
                    }
                    if (offset != this.getCurrentOffset()) continue;
                    break;
                }
            }
            if (this.isComma() && (this.getCurrentIndent() >= callIndent || !this.isNewLine())) {
                this.advance();
            } else if (comma) {
                this.error(CsBundle.message("parsing.error.unexpected", this.getTokenText()));
            }
        }
        this.done(argumentListMarker, CoffeeScriptElementTypes.ARGUMENT_LIST);
        --this.argumentListLevel;
        this.invocationIndent = oldInvocationIndent;
    }

    static {
        BRACKETS.put(CoffeeScriptTokenTypes.BRACKET_END, CoffeeScriptTokenTypes.BRACKET_START);
        BRACKETS.put(CoffeeScriptTokenTypes.BRACE_END, CoffeeScriptTokenTypes.BRACE_START);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/coffeescript/lang/parser/CoffeeScriptParser";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyType";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "invoker";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "end";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "body";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/coffeescript/lang/parser/CoffeeScriptParser";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "parse";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "parseJsxAttributesExpression";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "parse";
                break;
            }
            case 2: 
            case 5: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "parseJsxAttributesExpression";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "parseTokenCondition";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "parseDestructuringObject";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "parseDestructuringVariable";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "parseWithPossibleWhileOrForOrIf";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "parseGeneralString";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 5 -> new IllegalStateException(string);
        };
    }

    private class StatementInvoker
    implements ParseInvoker {
        private StatementInvoker() {
        }

        @Override
        public final boolean parse() {
            return CoffeeScriptParser.this.parseStatement();
        }
    }

    private class ExpressionInvoker
    implements ParseInvoker {
        private ExpressionInvoker() {
        }

        @Override
        public final boolean parse() {
            return CoffeeScriptParser.this.parseOperation();
        }
    }

    private static interface ParseInvoker {
        public boolean parse();
    }

    static enum ValueTypes {
        VALUE,
        INVOCATION_WITH_BRACES,
        INVOCATION_WITHOUT_BRACES;

    }
}

