/*
 * Decompiled with CFR 0.152.
 */
package org.coffeescript.lang.injection;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.css.CSSLanguage;
import com.intellij.lang.html.HTMLLanguage;
import com.intellij.lang.injection.MultiHostInjector;
import com.intellij.lang.injection.MultiHostRegistrar;
import com.intellij.lang.javascript.JSLanguageInjector;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.injections.JSInjectionController;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.util.PsiUtilCore;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;
import org.coffeescript.CoffeeScriptUtil;
import org.coffeescript.lang.injection.CoffeeScriptInjectionUtil;
import org.coffeescript.lang.lexer.CoffeeScriptTokenTypes;
import org.coffeescript.lang.psi.impl.CoffeeScriptHeregexImpl;
import org.jetbrains.annotations.NotNull;

final class CoffeeScriptInjector
implements MultiHostInjector {
    private static final Language regexpLanguage = Language.findLanguageByID((String)"RegExp");

    CoffeeScriptInjector() {
    }

    public void getLanguagesToInject(@NotNull MultiHostRegistrar registrar, @NotNull PsiElement element) {
        if (registrar == null) {
            CoffeeScriptInjector.$$$reportNull$$$0(0);
        }
        if (element == null) {
            CoffeeScriptInjector.$$$reportNull$$$0(1);
        }
        if (element instanceof JSLiteralExpression) {
            if (element instanceof PsiLanguageInjectionHost && !((PsiLanguageInjectionHost)element).isValidHost()) {
                return;
            }
            ASTNode firstChild = element.getNode().getFirstChildNode();
            if (firstChild != null && firstChild.getElementType() == CoffeeScriptTokenTypes.HEREDOC_START) {
                JSInjectionController.HtmlInjectionKind injectHtml = JSInjectionController.willInjectHtml((PsiElement)element);
                if (injectHtml == JSInjectionController.HtmlInjectionKind.HTML) {
                    CoffeeScriptInjectionUtil.injectInDocString(registrar, element, (Language)HTMLLanguage.INSTANCE);
                } else if (injectHtml == JSInjectionController.HtmlInjectionKind.REACT_JSX) {
                    CoffeeScriptInjectionUtil.injectInDocString(registrar, element, (Language)JavaScriptSupportLoader.ECMA_SCRIPT_6);
                }
            } else if (CoffeeScriptUtil.isCoffeeScriptContent(element) && firstChild != null && firstChild.getElementType() == CoffeeScriptTokenTypes.STRING_LITERAL) {
                HTMLLanguage languageToInject = null;
                JSInjectionController.HtmlInjectionKind injectHtml = JSInjectionController.willInjectHtml((PsiElement)element);
                if (injectHtml == JSInjectionController.HtmlInjectionKind.HTML) {
                    languageToInject = HTMLLanguage.INSTANCE;
                } else if (injectHtml == JSInjectionController.HtmlInjectionKind.REACT_JSX) {
                    languageToInject = JavaScriptSupportLoader.ECMA_SCRIPT_6;
                } else if (JSInjectionController.willInjectCss((PsiElement)element)) {
                    languageToInject = CSSLanguage.INSTANCE;
                }
                if (languageToInject != null) {
                    CoffeeScriptInjectionUtil.injectInString(registrar, element, (Language)languageToInject);
                }
            } else if (CoffeeScriptUtil.isCoffeeScriptContent(element) && ((JSLiteralExpression)element).isRegExpLiteral()) {
                JSLanguageInjector.injectInRegexLiteral((MultiHostRegistrar)registrar, (PsiElement)element);
            }
        } else if (regexpLanguage != null && element instanceof CoffeeScriptHeregexImpl && ((CoffeeScriptHeregexImpl)element).isValidHost()) {
            ArrayList heredocRanges = new ArrayList();
            Stream.of(element.getChildren()).filter(p -> PsiUtilCore.getElementType((PsiElement)p) == JSTokenTypes.REGEXP_LITERAL).forEach(p -> heredocRanges.add(p.getTextRangeInParent()));
            if (!heredocRanges.isEmpty()) {
                registrar.startInjecting(regexpLanguage);
                for (TextRange range : heredocRanges) {
                    registrar.addPlace(null, null, (PsiLanguageInjectionHost)element, range);
                }
                registrar.doneInjecting();
            }
        }
    }

    @NotNull
    public List<? extends Class<? extends PsiElement>> elementsToInjectIn() {
        List<Class> list = Arrays.asList(JSLiteralExpression.class, CoffeeScriptHeregexImpl.class);
        if (list == null) {
            CoffeeScriptInjector.$$$reportNull$$$0(2);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "registrar";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/coffeescript/lang/injection/CoffeeScriptInjector";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/coffeescript/lang/injection/CoffeeScriptInjector";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "elementsToInjectIn";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getLanguagesToInject";
                break;
            }
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

