/*
 * Decompiled with CFR 0.152.
 */
package org.coffeescript.editor;

import com.intellij.lang.ASTNode;
import com.intellij.lang.folding.FoldingDescriptor;
import com.intellij.lang.javascript.folding.JavaScriptFoldingBuilder;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.tree.IElementType;
import java.util.List;
import java.util.StringTokenizer;
import org.coffeescript.lang.lexer.CoffeeScriptTokenTypes;
import org.jetbrains.annotations.NotNull;

public final class CoffeeScriptFoldingBuilder
extends JavaScriptFoldingBuilder {
    protected ASTNode appendDescriptors(ASTNode node, Document document, List<? super FoldingDescriptor> descriptors) {
        if (node.getElementType() == CoffeeScriptTokenTypes.BLOCK_COMMENT && node.getTextLength() > 1) {
            descriptors.add((FoldingDescriptor)new FoldingDescriptor(node, node.getTextRange()));
        }
        return super.appendDescriptors(node, document, descriptors);
    }

    protected String getLanguagePlaceholderText(@NotNull ASTNode node, @NotNull TextRange range) {
        IElementType type;
        if (node == null) {
            CoffeeScriptFoldingBuilder.$$$reportNull$$$0(0);
        }
        if (range == null) {
            CoffeeScriptFoldingBuilder.$$$reportNull$$$0(1);
        }
        if ((type = node.getElementType()) == CoffeeScriptTokenTypes.BLOCK_COMMENT) {
            String text = node.getText();
            StringTokenizer tokenizer = new StringTokenizer(text, "\n\r");
            String firstLine = "";
            if (tokenizer.countTokens() > 2) {
                tokenizer.nextToken();
                firstLine = tokenizer.nextToken();
                firstLine = StringUtil.replace((String)firstLine.trim(), (String)"*", (String)"");
            }
            return "### " + firstLine + "... ###";
        }
        return super.getLanguagePlaceholderText(node, range);
    }

    public String getBlockPlaceholderText() {
        return "...";
    }

    @NotNull
    protected String getFoldedTestByProperty(String nameText, String valueText) {
        String string = nameText + ": " + valueText + "...";
        if (string == null) {
            CoffeeScriptFoldingBuilder.$$$reportNull$$$0(2);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/coffeescript/editor/CoffeeScriptFoldingBuilder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/coffeescript/editor/CoffeeScriptFoldingBuilder";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFoldedTestByProperty";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getLanguagePlaceholderText";
                break;
            }
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

