/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.java.run;

import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.filters.OpenFileHyperlinkInfo;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.ui.NamedColorUtil;
import java.awt.Color;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.run.filters.FileLinksFilterUtil;

public class JRubyStacktraceFilter
implements Filter {
    private static final Pattern LINE_PATTERN = Pattern.compile("((?<=^|[\\s\\[])(?:\\.{1,2}|[A-Za-z]:|[/\\p{Alnum}_~])[^:\\s]+\\.java):(\\d+):in");
    private static final TextAttributes HYPERLINK_ATTRIBUTES = EditorColorsManager.getInstance().getGlobalScheme().getAttributes(CodeInsightColors.HYPERLINK_ATTRIBUTES);
    @NotNull
    private final Project myProject;
    @Nullable
    private final String myWorkingDirectory;

    public JRubyStacktraceFilter(@NotNull Project project) {
        if (project == null) {
            JRubyStacktraceFilter.$$$reportNull$$$0(0);
        }
        this(project, null);
    }

    public JRubyStacktraceFilter(@NotNull Project project, @Nullable String workingDirectory) {
        if (project == null) {
            JRubyStacktraceFilter.$$$reportNull$$$0(1);
        }
        this.myProject = project;
        this.myWorkingDirectory = workingDirectory;
    }

    public Filter.Result applyFilter(@NotNull String line, int textEndOffset) {
        VirtualFile virtualFile;
        int lineNum;
        String cuttedLine;
        Matcher matcher;
        if (line == null) {
            JRubyStacktraceFilter.$$$reportNull$$$0(2);
        }
        if ((matcher = JRubyStacktraceFilter.getMatcher(cuttedLine = FileLinksFilterUtil.cutLineIfLong((String)line))) == null) {
            return null;
        }
        try {
            lineNum = Integer.parseInt(matcher.group(2));
        }
        catch (NumberFormatException e) {
            return null;
        }
        String classFqnOrRelativePath = matcher.group(1);
        if (classFqnOrRelativePath.startsWith("./")) {
            if (this.myWorkingDirectory == null) {
                return null;
            }
            virtualFile = LocalFileSystem.getInstance().findFileByPath(this.myWorkingDirectory + classFqnOrRelativePath.substring(1));
        } else {
            String classFqn = classFqnOrRelativePath.replaceFirst(".java$", "").replace('/', '.');
            JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)this.myProject);
            PsiClass aClass = psiFacade.findClass(classFqn, GlobalSearchScope.allScope((Project)this.myProject));
            if (aClass == null) {
                return null;
            }
            PsiFile file = (PsiFile)aClass.getContainingFile().getNavigationElement();
            if (file == null) {
                return null;
            }
            virtualFile = file.getVirtualFile();
        }
        if (virtualFile == null) {
            return null;
        }
        int textStartOffset = textEndOffset - line.length();
        int highlightStartOffset = textStartOffset + matcher.start(1);
        int highlightEndOffset = textStartOffset + matcher.end(2);
        OpenFileHyperlinkInfo linkInfo = new OpenFileHyperlinkInfo(this.myProject, virtualFile, lineNum - 1);
        TextAttributes attributes = HYPERLINK_ATTRIBUTES.clone();
        if (!ProjectRootManager.getInstance((Project)this.myProject).getFileIndex().isInContent(virtualFile)) {
            Color color = NamedColorUtil.getInactiveTextColor();
            attributes.setForegroundColor(color);
            attributes.setEffectColor(color);
        }
        return new Filter.Result(highlightStartOffset, highlightEndOffset, (HyperlinkInfo)linkInfo, attributes);
    }

    @Nullable
    public static Matcher getMatcher(@NotNull String line) {
        Matcher matcher;
        if (line == null) {
            JRubyStacktraceFilter.$$$reportNull$$$0(3);
        }
        return (matcher = LINE_PATTERN.matcher(line)).find() ? matcher : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "line";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/ruby/java/run/JRubyStacktraceFilter";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "applyFilter";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getMatcher";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

