/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.java.run;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderEnumerator;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PathsList;
import java.util.Map;
import org.jetbrains.plugins.ruby.gem.GemInfo;
import org.jetbrains.plugins.ruby.ruby.run.RunEnvironmentProvider;
import org.jetbrains.plugins.ruby.ruby.sdk.jruby.JRubySdkUtil;
import org.jetbrains.plugins.ruby.utils.OSUtil;

public final class JRubyRunEnvironmentProvider
extends RunEnvironmentProvider {
    private static final Condition<OrderEntry> NOT_FAKE_LIBRARY = orderEntry -> !JRubyRunEnvironmentProvider.isFakeLibary(orderEntry);

    public void addEnvironment(Sdk sdk, Module module, Map<String, String> envs) {
        VirtualFile[] roots;
        if (module == null || !JRubySdkUtil.isJRubySDK((Sdk)sdk)) {
            return;
        }
        PathsList classpath = new PathsList();
        for (VirtualFile root : roots = OrderEnumerator.orderEntries((Module)module).withoutSdk().recursively().satisfying(NOT_FAKE_LIBRARY).getClassesRoots()) {
            VirtualFile[] children = root.getChildren();
            if (children == null || children.length <= 0) continue;
            classpath.add(root);
        }
        String classpathString = classpath.getPathsString();
        if (!StringUtil.isEmpty((String)classpathString)) {
            String cp = OSUtil.appendToPATHenvVariable((String)envs.get("CLASSPATH"), (String)classpathString);
            envs.put("CLASSPATH", cp);
        }
    }

    private static boolean isFakeLibary(OrderEntry entry) {
        String name;
        if (entry instanceof LibraryOrderEntry && (name = ((LibraryOrderEntry)entry).getLibraryName()) != null) {
            DependencyScope scope = ((LibraryOrderEntry)entry).getScope();
            if (scope == DependencyScope.PROVIDED) {
                return true;
            }
            if (name.endsWith(" facet library")) {
                return true;
            }
            if (GemInfo.isGemLibrary((String)name)) {
                return true;
            }
        }
        return false;
    }
}

