/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.java.module;

import com.intellij.ide.util.projectWizard.ModuleBuilder;
import com.intellij.ide.util.projectWizard.SourcePathsBuilder;
import com.intellij.openapi.module.ModifiableModuleModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.module.ModuleWithNameAlreadyExists;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ui.configuration.ProjectStructureConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ProjectSdksModel;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.Pair;
import com.intellij.util.containers.ContainerUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.java.module.RubyModuleType;
import org.jetbrains.plugins.ruby.ruby.RModuleUtil;

public class RubyModuleBuilder
extends ModuleBuilder
implements SourcePathsBuilder {
    @Nullable
    private Sdk mySdk;
    @Nullable
    private Sdk myProjectSdk;
    private List<Pair<String, String>> mySourcePaths;
    private final List<Runnable> mySdkChangedListeners = ContainerUtil.createLockFreeCopyOnWriteList();

    @NotNull
    public Module createModule(@NotNull ModifiableModuleModel moduleModel) throws InvalidDataException, IOException, ModuleWithNameAlreadyExists, JDOMException, ConfigurationException {
        if (moduleModel == null) {
            RubyModuleBuilder.$$$reportNull$$$0(0);
        }
        Module myModule = super.createModule(moduleModel);
        RModuleUtil.getInstance().refreshRubyModuleTypeContent(myModule);
        Module module = myModule;
        if (module == null) {
            RubyModuleBuilder.$$$reportNull$$$0(1);
        }
        return module;
    }

    public ModuleType<?> getModuleType() {
        return RubyModuleType.getInstance();
    }

    public boolean isAvailable() {
        return false;
    }

    public int getWeight() {
        return 1200;
    }

    @Nullable
    public Sdk getSdk() {
        return this.mySdk;
    }

    @Nullable
    public Sdk getEffectiveSdk() {
        return this.mySdk == null ? this.myProjectSdk : this.mySdk;
    }

    public void setupRootModel(@NotNull ModifiableRootModel rootModel) throws ConfigurationException {
        if (rootModel == null) {
            RubyModuleBuilder.$$$reportNull$$$0(2);
        }
        if (this.mySdk != null) {
            rootModel.setSdk(this.mySdk);
            Project project = rootModel.getModule().getProject();
            ProjectSdksModel projectJdksModel = ProjectStructureConfigurable.getInstance((Project)project).getProjectJdksModel();
            projectJdksModel.getProjectSdks().put(this.mySdk, this.mySdk);
        } else {
            rootModel.inheritSdk();
        }
        this.doAddContentEntry(rootModel);
    }

    public void setSdk(@Nullable Sdk sdk, @Nullable Sdk projectSdk) {
        boolean fireListeners = false;
        if (this.myProjectSdk != projectSdk) {
            this.myProjectSdk = projectSdk;
            fireListeners = true;
        }
        if (this.mySdk != sdk) {
            this.mySdk = sdk;
            fireListeners = true;
        }
        if (fireListeners) {
            for (Runnable runnable : this.mySdkChangedListeners) {
                runnable.run();
            }
        }
    }

    public void setSourcePaths(List<Pair<String, String>> paths) {
        this.mySourcePaths = paths;
    }

    public List<Pair<String, String>> getSourcePaths() {
        return this.mySourcePaths;
    }

    public void addSourcePath(Pair<String, String> sourcePathInfo) {
        if (this.mySourcePaths == null) {
            this.mySourcePaths = new ArrayList<Pair<String, String>>();
        }
        this.mySourcePaths.add(sourcePathInfo);
    }

    public void addSdkChangedListener(Runnable runnable) {
        this.mySdkChangedListeners.add(runnable);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleModel";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/java/module/RubyModuleBuilder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootModel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/java/module/RubyModuleBuilder";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createModule";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createModule";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setupRootModel";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

