/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.java.jruby.types;

import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.HierarchicalMethodSignature;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.Processor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.java.jruby.JRubyNameConventions;
import org.jetbrains.plugins.ruby.java.jruby.symbols.RJavaClassSymbol;
import org.jetbrains.plugins.ruby.java.jruby.symbols.RJavaClassTypeSymbol;
import org.jetbrains.plugins.ruby.java.jruby.symbols.RJavaFieldSymbol;
import org.jetbrains.plugins.ruby.java.jruby.symbols.RJavaMethodSymbol;
import org.jetbrains.plugins.ruby.java.jruby.types.RAbstractJavaType;
import org.jetbrains.plugins.ruby.ruby.codeInsight.resolve.scope.RElementWithFQN;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.Type;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.MultiSymbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.Symbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.SymbolProcessor;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.SymbolUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.TypedPsiElementSymbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.util.SymbolHierarchy;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.Access;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.Context;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.ContextImpl;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.RSingletonInstanceConvertableType;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.RType;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.impl.RClassType;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RFile;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.Visibility;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.modules.RModule;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RContainer;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.holders.utils.RContainerUtil;

public final class RJavaClassType
extends RAbstractJavaType
implements RSingletonInstanceConvertableType {
    @NotNull
    private final RJavaClassSymbol myClassSymbol;
    @NotNull
    private final PsiClass myClass;
    @NotNull
    private final PsiSubstitutor mySubstitutor;
    @NonNls
    private static final String JAVA = "java";
    @NonNls
    private static final String INTERFACE_JAVA_PROXY = "InterfaceJavaProxy";

    private RJavaClassType(@NotNull RJavaClassSymbol classSymbol, @NotNull PsiClass aClass, @NotNull Context context, @NotNull PsiSubstitutor substitutor) {
        if (classSymbol == null) {
            RJavaClassType.$$$reportNull$$$0(0);
        }
        if (aClass == null) {
            RJavaClassType.$$$reportNull$$$0(1);
        }
        if (context == null) {
            RJavaClassType.$$$reportNull$$$0(2);
        }
        if (substitutor == null) {
            RJavaClassType.$$$reportNull$$$0(3);
        }
        super(context);
        this.myClassSymbol = classSymbol;
        this.myClass = aClass;
        this.mySubstitutor = substitutor;
    }

    @NotNull
    public PsiClass getPsiClass() {
        PsiClass psiClass = this.myClass;
        if (psiClass == null) {
            RJavaClassType.$$$reportNull$$$0(4);
        }
        return psiClass;
    }

    @NotNull
    public PsiSubstitutor getSubstitutor() {
        PsiSubstitutor psiSubstitutor = this.mySubstitutor;
        if (psiSubstitutor == null) {
            RJavaClassType.$$$reportNull$$$0(5);
        }
        return psiSubstitutor;
    }

    @Override
    protected Project getProject() {
        return this.myClass.getProject();
    }

    public void processMembers(@NotNull Predicate<? super Symbol> filter, @Nullable PsiElement invocationPoint, @NotNull Consumer<? super Symbol> consumer) {
        if (filter == null) {
            RJavaClassType.$$$reportNull$$$0(6);
        }
        if (consumer == null) {
            RJavaClassType.$$$reportNull$$$0(7);
        }
        if (!this.myClass.isValid()) {
            return;
        }
        Processor processor = SymbolUtil.createSymbolProcessor(filter, consumer);
        this.processInnerClassMessages((Processor<? super Symbol>)processor);
        this.processMethodMessages((Processor<? super Symbol>)processor);
        this.processFieldMessages((Processor<? super Symbol>)processor, null);
        this.processMixins((Processor<? super Symbol>)processor, null, invocationPoint);
        this.processRubyMethods((Processor<? super Symbol>)processor, null, invocationPoint);
        this.processProxyMethods((Processor<? super Symbol>)processor, null, invocationPoint);
        processor.process((Object)new RJavaClassTypeSymbol(this.myClass));
    }

    private boolean processInnerClassMessages(Processor<? super Symbol> processor) {
        if (this.myContext.getAccess().acceptClass()) {
            for (PsiClass innerClass : this.myClass.getAllInnerClasses()) {
                if (processor.process((Object)new RJavaClassSymbol(innerClass))) continue;
                return false;
            }
        }
        return true;
    }

    private boolean processMethodMessages(Processor<? super Symbol> processor) {
        Collection signatures = this.myClass.getVisibleSignatures();
        for (HierarchicalMethodSignature signature : signatures) {
            PsiMethod method = signature.getMethod();
            if (method.isConstructor() || !this.checkContext(method.hasModifierProperty("static"))) continue;
            String name = method.getName();
            if (!processor.process((Object)new RJavaMethodSymbol(method, name, (Symbol)this.myClassSymbol))) {
                return false;
            }
            for (String rubyName : JRubyNameConventions.getRubyNames(name)) {
                if (processor.process((Object)new RJavaMethodSymbol(method, rubyName, (Symbol)this.myClassSymbol))) continue;
                return false;
            }
        }
        return true;
    }

    private boolean processFieldMessages(Processor<? super Symbol> processor, @Nullable String name) {
        PsiField[] fields = this.myClass.getAllFields();
        boolean isUppercase = name != null && StringUtil.isUpperCase((CharSequence)name);
        for (PsiField field : fields) {
            if (!this.checkContext(field.hasModifierProperty("static") ^ isUppercase) || processor.process((Object)new RJavaFieldSymbol(field))) continue;
            return false;
        }
        return true;
    }

    private boolean processRubyMethods(final Processor<? super Symbol> processor, final @Nullable String name, final PsiElement invocationPoint) {
        Symbol symbol;
        if (this.myClass.isInterface() && (symbol = SymbolUtil.getSymbolRepresentingContext((Symbol)SymbolUtil.findConstantByFQN((Project)this.myClass.getProject(), (Type)Type.CLASS, (String)INTERFACE_JAVA_PROXY, null), (Context)this.myContext)) != null) {
            return SymbolHierarchy.processSymbolChildren((Symbol)symbol, (SymbolProcessor)new SymbolProcessor(){

                public boolean process(@NotNull Symbol symbol) {
                    if (symbol == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return processor.process((Object)symbol);
                }

                public String getName() {
                    return name;
                }

                public PsiElement getInvocationPoint() {
                    return invocationPoint;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "symbol", "org/jetbrains/plugins/ruby/java/jruby/types/RJavaClassType$1", "process"));
                }
            });
        }
        return true;
    }

    @Nullable
    public Symbol getMemberForName(@NotNull String name, @NotNull Predicate<? super Symbol> filter, PsiElement invocationPoint) {
        if (name == null) {
            RJavaClassType.$$$reportNull$$$0(8);
        }
        if (filter == null) {
            RJavaClassType.$$$reportNull$$$0(9);
        }
        ProgressManager.checkCanceled();
        if (!this.myClass.isValid()) {
            return null;
        }
        if (name.equals("new")) {
            ArrayList<TypedPsiElementSymbol> result = new ArrayList<TypedPsiElementSymbol>();
            PsiMethod[] constructors = this.myClass.getConstructors();
            if (constructors.length != 0) {
                for (PsiMethod method : constructors) {
                    result.add(new RJavaMethodSymbol(method, (Symbol)this.myClassSymbol));
                }
            } else {
                result.add(new RJavaClassSymbol(this.myClass));
            }
            return MultiSymbol.of((Symbol[])result.toArray(new Symbol[0]));
        }
        Ref result = new Ref();
        Processor processor = symbol -> {
            if (name.equals(symbol.getName())) {
                result.set(symbol);
            }
            return result.isNull();
        };
        if (!this.processInnerClassMessages((Processor<? super Symbol>)processor)) {
            return (Symbol)result.get();
        }
        if (!this.processMethodMessages((Processor<? super Symbol>)processor)) {
            return (Symbol)result.get();
        }
        if (!this.processFieldMessages((Processor<? super Symbol>)processor, name)) {
            return (Symbol)result.get();
        }
        if (!this.processMixins((Processor<? super Symbol>)processor, name, invocationPoint)) {
            return (Symbol)result.get();
        }
        if (!this.processRubyMethods((Processor<? super Symbol>)processor, name, invocationPoint)) {
            return (Symbol)result.get();
        }
        if (!processor.process((Object)new RJavaClassTypeSymbol(this.myClass))) {
            return (Symbol)result.get();
        }
        if (!this.processProxyMethods((Processor<? super Symbol>)processor, name, invocationPoint)) {
            return (Symbol)result.get();
        }
        return null;
    }

    private boolean processMixins(Processor<? super Symbol> processor, @Nullable String name, PsiElement invocationPoint) {
        return this.processMixinsRecursive(this.myClass, new HashSet(), processor, name, invocationPoint);
    }

    private boolean processMixinsRecursive(PsiClass aClass, Set<? super PsiClass> processed, Processor<? super Symbol> processor, String name, PsiElement invocationPoint) {
        processed.add((PsiClass)aClass);
        boolean result = this.processMixinsForClass(aClass, processor, name, invocationPoint);
        if (!result) {
            return false;
        }
        for (PsiClass superClass : aClass.getSupers()) {
            if (processed.contains(superClass) || (result = this.processMixinsRecursive(superClass, processed, processor, name, invocationPoint))) continue;
            return false;
        }
        return true;
    }

    private boolean processMixinsForClass(PsiClass aClass, final Processor<? super Symbol> processor, final String name, final PsiElement invocationPoint) {
        String qName = aClass.getQualifiedName();
        if (qName == null) {
            return true;
        }
        @NonNls String[] nameComponents = qName.split("\\.");
        if (nameComponents[0].equals(JAVA)) {
            PsiFile[] files;
            String packageFile = qName.substring(0, qName.lastIndexOf(46)) + ".rb";
            for (PsiFile psiFile : files = FilenameIndex.getFilesByName((Project)this.getProject(), (String)packageFile, (GlobalSearchScope)GlobalSearchScope.allScope((Project)this.getProject()))) {
                Symbol symbol;
                if (!(psiFile instanceof RFile)) continue;
                RFile file = (RFile)psiFile;
                RModule module = RContainerUtil.getModuleByName((RContainer)file, (String)nameComponents[nameComponents.length - 1]);
                Symbol symbol2 = symbol = module != null ? SymbolUtil.getSymbolByContainer((RElementWithFQN)module) : null;
                if (symbol == null) continue;
                if (!processor.process((Object)symbol)) {
                    return false;
                }
                Symbol targetSymbol = SymbolUtil.getSymbolRepresentingContext((Symbol)symbol, (Context)this.myContext);
                if (targetSymbol == null) continue;
                return SymbolHierarchy.processSymbolChildren((Symbol)targetSymbol, (SymbolProcessor)new SymbolProcessor(){

                    public boolean process(@NotNull Symbol symbol) {
                        if (symbol == null) {
                            2.$$$reportNull$$$0(0);
                        }
                        return processor.process((Object)symbol);
                    }

                    public String getName() {
                        return name;
                    }

                    public PsiElement getInvocationPoint() {
                        return invocationPoint;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "symbol", "org/jetbrains/plugins/ruby/java/jruby/types/RJavaClassType$2", "process"));
                    }
                });
            }
        }
        return true;
    }

    private boolean checkContext(boolean hasStaticModifier) {
        Access access = this.myContext.getAccess();
        return access.acceptInstance() && !hasStaticModifier || access.acceptClass() && hasStaticModifier;
    }

    public String getName() {
        return this.myClass.getQualifiedName();
    }

    public String getPresentableName() {
        return this.myClass.getName();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RJavaClassType type = (RJavaClassType)((Object)o);
        return Objects.equals(this.myClass, type.myClass);
    }

    @Override
    public int hashCode() {
        return 31 * super.hashCode() + this.myClass.hashCode();
    }

    @NotNull
    public RType convertToNotSingletonType() {
        if (this.myContext.getAccess().acceptInstance()) {
            RJavaClassType rJavaClassType = this;
            if (rJavaClassType == null) {
                RJavaClassType.$$$reportNull$$$0(10);
            }
            return rJavaClassType;
        }
        ContextImpl context = ContextImpl.create((Visibility)this.myContext.getVisibility(), (Access)Access.INSTANCE);
        return new RJavaClassType(this.myClassSymbol, this.myClass, (Context)context, this.mySubstitutor);
    }

    @NotNull
    public RType convertToSingletonTypeIfPossible() {
        if (this.myContext.getAccess().acceptClass()) {
            RJavaClassType rJavaClassType = this;
            if (rJavaClassType == null) {
                RJavaClassType.$$$reportNull$$$0(11);
            }
            return rJavaClassType;
        }
        ContextImpl context = ContextImpl.create((Visibility)this.myContext.getVisibility(), (Access)Access.CLASS);
        return new RJavaClassType(this.myClassSymbol, this.myClass, (Context)context, this.mySubstitutor);
    }

    @NotNull
    public static RType createClassOrInstanceTypeDependingOnContext(@NotNull RJavaClassSymbol classSymbol, @NotNull PsiClass psiClass, @NotNull Context context, @NotNull PsiSubstitutor substitutor) {
        if (classSymbol == null) {
            RJavaClassType.$$$reportNull$$$0(12);
        }
        if (psiClass == null) {
            RJavaClassType.$$$reportNull$$$0(13);
        }
        if (context == null) {
            RJavaClassType.$$$reportNull$$$0(14);
        }
        if (substitutor == null) {
            RJavaClassType.$$$reportNull$$$0(15);
        }
        RJavaClassType classOriginalType = new RJavaClassType(classSymbol, psiClass, context, substitutor);
        RJavaClassType rJavaClassType = context.getAccess().acceptClass() ? new RClassType((RType)classOriginalType) : classOriginalType;
        if (rJavaClassType == null) {
            RJavaClassType.$$$reportNull$$$0(16);
        }
        return rJavaClassType;
    }

    @NotNull
    public static RType createClassOrInstanceTypeDependingOnContext(@NotNull RJavaClassSymbol classSymbol, @NotNull PsiClass psiClass, @NotNull Context context) {
        if (classSymbol == null) {
            RJavaClassType.$$$reportNull$$$0(17);
        }
        if (psiClass == null) {
            RJavaClassType.$$$reportNull$$$0(18);
        }
        if (context == null) {
            RJavaClassType.$$$reportNull$$$0(19);
        }
        return RJavaClassType.createClassOrInstanceTypeDependingOnContext(classSymbol, psiClass, context, PsiSubstitutor.EMPTY);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 10, 11, 16 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classSymbol";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 2: 
            case 14: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "substitutor";
                break;
            }
            case 4: 
            case 5: 
            case 10: 
            case 11: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/java/jruby/types/RJavaClassType";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 13: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/java/jruby/types/RJavaClassType";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getPsiClass";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getSubstitutor";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "convertToNotSingletonType";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "convertToSingletonTypeIfPossible";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "createClassOrInstanceTypeDependingOnContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 10: 
            case 11: 
            case 16: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "processMembers";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getMemberForName";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "createClassOrInstanceTypeDependingOnContext";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5, 10, 11, 16 -> new IllegalStateException(string);
        };
    }
}

