/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.java.jruby.types;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.util.PsiTypesUtil;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.java.jruby.search.JRubySuperMethodSearchExecutor;
import org.jetbrains.plugins.ruby.java.jruby.symbols.RJavaClassSymbol;
import org.jetbrains.plugins.ruby.java.jruby.types.RJavaClassType;
import org.jetbrains.plugins.ruby.java.jruby.types.RJavaTypeFactory;
import org.jetbrains.plugins.ruby.ruby.codeInsight.resolve.ResolveUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.Symbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.Context;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.ContextImpl;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.RType;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.RubyTypeProvider;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPossibleCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.ArgumentInfo;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RArgument;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RArgumentList;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RBlockArgumentList;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RMethod;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RExpression;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RContainer;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.controlStructures.methods.RArgumentListNavigator;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.controlStructures.methods.arguments.RArgumentNavigator;
import org.jetbrains.plugins.ruby.ruby.lang.psi.iterators.RBlockCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.references.RReference;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RIdentifier;

public final class JRubyTypeProvider
implements RubyTypeProvider {
    @NonNls
    private static final String IMPL = "impl";

    public RType createTypeByRExpression(@NotNull RExpression expression) {
        RContainer container;
        RIdentifier identifier;
        if (expression == null) {
            JRubyTypeProvider.$$$reportNull$$$0(0);
        }
        if (expression instanceof RIdentifier && (identifier = (RIdentifier)expression).isMethodParameterDeclaration() && (container = expression.getParentContainer()) instanceof RMethod) {
            int number;
            RArgumentList list;
            RMethod method = (RMethod)container;
            if (RubyPsiUtil.getVirtualFileFromElement((PsiElement)container) == null) {
                return null;
            }
            RArgument argument = RArgumentNavigator.getByParameter((RPsiElement)identifier);
            assert (argument != null);
            if (argument.getType() == ArgumentInfo.Type.SIMPLE && (list = RArgumentListNavigator.getByArgument((RArgument)argument)) != null && (number = list.getArgNumber(argument)) != -1) {
                PsiParameter[] params;
                PsiElement superMethod;
                boolean nonSimpleArgSeen = false;
                for (int i = 0; i < number; ++i) {
                    List argsInfoList = list.getArgumentInfos();
                    ArgumentInfo argumentInfo = (ArgumentInfo)argsInfoList.get(i);
                    if (argumentInfo.getType() == ArgumentInfo.Type.SIMPLE) continue;
                    nonSimpleArgSeen = true;
                }
                if (!nonSimpleArgSeen && (superMethod = JRubySuperMethodSearchExecutor.findJavaSuperMethod(method)) instanceof PsiMethod && number < (params = ((PsiMethod)superMethod).getParameterList().getParameters()).length) {
                    PsiTypeElement element = params[number].getTypeElement();
                    PsiType type = element != null ? element.getType() : null;
                    return type != null ? RJavaTypeFactory.createType(method.getProject(), type, (Context)ContextImpl.INSTANCE) : null;
                }
            }
        }
        return null;
    }

    @Nullable
    public RType getBlockParameterType(RPsiElement parameter, RPsiElement scope) {
        PsiElement element;
        if (!(scope instanceof RBlockCall)) {
            return null;
        }
        String command = ((RBlockCall)scope).getCommand();
        if (!IMPL.equals(command)) {
            return null;
        }
        RPossibleCall call = ((RBlockCall)scope).getCall();
        if (!(call instanceof RReference)) {
            return null;
        }
        RPsiElement receiver = ((RReference)call).getReceiver();
        Symbol symbol = receiver != null ? ResolveUtil.resolveToSymbolWithCaching((PsiReference)receiver.getReference()) : null;
        PsiElement psiElement = element = symbol != null ? symbol.getPsiElement() : null;
        if (!(element instanceof PsiClass) || !((PsiClass)element).isInterface()) {
            return null;
        }
        PsiMethod[] methods = ((PsiClass)element).getMethods();
        if (methods.length != 1) {
            return null;
        }
        RArgument parameterArgument = RArgumentNavigator.getByParameter((RPsiElement)parameter);
        if (parameterArgument == null) {
            return null;
        }
        RArgumentList blockVariables = RArgumentListNavigator.getByArgument((RArgument)parameterArgument);
        if (!(blockVariables instanceof RBlockArgumentList)) {
            return null;
        }
        PsiParameter[] parameters = methods[0].getParameterList().getParameters();
        int index = blockVariables.getArgNumber(parameterArgument);
        if (index == -1 || index >= parameters.length) {
            return null;
        }
        PsiClass psiClass = PsiTypesUtil.getPsiClass((PsiType)parameters[index].getType());
        return psiClass != null ? RJavaClassType.createClassOrInstanceTypeDependingOnContext(new RJavaClassSymbol(psiClass), psiClass, (Context)ContextImpl.getContext((PsiElement)parameter)) : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/plugins/ruby/java/jruby/types/JRubyTypeProvider", "createTypeByRExpression"));
    }
}

