/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.java.jruby.types;

import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JRubyTypeConventions {
    @NonNls
    private static final String CHAR = "char";
    @NonNls
    private static final String JAVA_LANG_STRING = "java.lang.String";
    @NonNls
    private static final String LONG = "long";
    @NonNls
    private static final String INT = "int";
    @NonNls
    private static final String JAVA_LANG_LONG = "java.lang.Long";
    @NonNls
    private static final String JAVA_LANG_INTEGER = "java.lang.Integer";
    @NonNls
    private static final String FLOAT = "float";
    @NonNls
    private static final String DOUBLE = "double";
    @NonNls
    private static final String JAVA_LANG_FLOAT = "java.lang.Float";
    @NonNls
    private static final String JAVA_LANG_DOUBLE = "java.lang.Double";
    @NonNls
    private static final String BOOLEAN = "boolean";
    @NonNls
    private static final String JAVA_LANG_BOOLEAN = "java.lang.Boolean";

    @Nullable
    public static String getRubyType(@NotNull String javaType) {
        if (javaType == null) {
            JRubyTypeConventions.$$$reportNull$$$0(0);
        }
        if (CHAR.equals(javaType) || JAVA_LANG_STRING.equals(javaType)) {
            return "String";
        }
        if (LONG.equals(javaType) || INT.equals(javaType) || JAVA_LANG_LONG.equals(javaType) || JAVA_LANG_INTEGER.equals(javaType)) {
            return "Fixnum";
        }
        if (FLOAT.equals(javaType) || DOUBLE.equals(javaType) || JAVA_LANG_FLOAT.equals(javaType) || JAVA_LANG_DOUBLE.equals(javaType)) {
            return "Float";
        }
        if (BOOLEAN.equals(javaType) || JAVA_LANG_BOOLEAN.equals(javaType)) {
            return "TrueClass";
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "javaType", "org/jetbrains/plugins/ruby/java/jruby/types/JRubyTypeConventions", "getRubyType"));
    }
}

