/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.java.jruby.symbols;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.source.resolve.DefaultParameterTypeInferencePolicy;
import com.intellij.psi.impl.source.resolve.ParameterTypeInferencePolicy;
import com.intellij.psi.impl.source.tree.java.PsiEmptyExpressionImpl;
import com.intellij.psi.util.PsiTypesUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.java.jruby.types.JavaSymbolTypes;
import org.jetbrains.plugins.ruby.java.jruby.types.RJavaClassType;
import org.jetbrains.plugins.ruby.java.jruby.types.RJavaTypeFactory;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.CallableSymbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.Symbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.TypedPsiElementSymbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.TypedSymbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.Context;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.ContextImpl;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.RType;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.RTypeUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.impl.REmptyType;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.ArgumentInfo;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.controlStructures.methods.RCommandArgumentListImpl;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RCall;

public final class RJavaMethodSymbol
extends TypedPsiElementSymbol<PsiMethod>
implements CallableSymbol,
TypedSymbol {
    private RType myType;
    private final NotNullLazyValue<List<ArgumentInfo>> myArgumentInfos;

    public RJavaMethodSymbol(@NotNull PsiMethod element, @Nullable Symbol parentSymbol) {
        if (element == null) {
            RJavaMethodSymbol.$$$reportNull$$$0(0);
        }
        super((PsiElement)element, element.getName(), JavaSymbolTypes.JAVA_METHOD, parentSymbol);
        this.myArgumentInfos = NotNullLazyValue.lazy(this::createArgumentInfos);
    }

    public RJavaMethodSymbol(@NotNull PsiMethod element, @NotNull String name, @Nullable Symbol parentSymbol) {
        if (element == null) {
            RJavaMethodSymbol.$$$reportNull$$$0(1);
        }
        if (name == null) {
            RJavaMethodSymbol.$$$reportNull$$$0(2);
        }
        super((PsiElement)element, name, JavaSymbolTypes.JAVA_METHOD, parentSymbol);
        this.myArgumentInfos = NotNullLazyValue.lazy(this::createArgumentInfos);
    }

    @NotNull
    public List<ArgumentInfo> getArgumentInfos() {
        List list = (List)this.myArgumentInfos.getValue();
        if (list == null) {
            RJavaMethodSymbol.$$$reportNull$$$0(3);
        }
        return list;
    }

    @Nullable
    public List<ArgumentInfo> getArgumentInfos(boolean includeDefaultArgs) {
        return this.getArgumentInfos();
    }

    @NotNull
    private List<ArgumentInfo> createArgumentInfos() {
        PsiParameter[] parameters = ((PsiMethod)this.myPsiElement).getParameterList().getParameters();
        ArrayList<ArgumentInfo> list = new ArrayList<ArgumentInfo>(parameters.length);
        for (int i = 0; i < parameters.length; ++i) {
            PsiParameter parameter = parameters[i];
            ArgumentInfo.Type type = parameter.isVarArgs() ? ArgumentInfo.Type.ARRAY : (i + 1 == parameters.length && RJavaMethodSymbol.isParameterSimpleInterface(parameter) ? ArgumentInfo.Type.BLOCK : ArgumentInfo.Type.SIMPLE);
            ArgumentInfo info = new ArgumentInfo(parameter.getName(), type);
            list.add(info);
        }
        ArrayList<ArgumentInfo> arrayList = list;
        if (arrayList == null) {
            RJavaMethodSymbol.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    private static boolean isParameterSimpleInterface(PsiParameter parameter) {
        PsiClass psiClass = PsiTypesUtil.getPsiClass((PsiType)parameter.getType());
        return psiClass != null && psiClass.isInterface() && psiClass.getMethods().length == 1;
    }

    public RType getCallType(RCall call) {
        List args = call.getArguments();
        Project project = call.getProject();
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)project).getElementFactory();
        PsiExpression[] arguments = new PsiExpression[args.size()];
        PsiMethod method = (PsiMethod)this.getPsiElement();
        PsiParameterList parameterList = method.getParameterList();
        int parametersCount = parameterList.getParametersCount();
        PsiParameter[] psiParameters = parameterList.getParameters();
        for (int i = 0; i < Math.min(args.size(), parametersCount); ++i) {
            PsiParameter parameter = psiParameters[i];
            PsiType psiType = RJavaMethodSymbol.getJavaType((RPsiElement)args.get(i), call, factory);
            if (psiType == null) {
                psiType = parameter.getType();
            }
            arguments[i] = new PsiRubyExpression(psiType, call);
        }
        PsiResolveHelper resolveHelper = JavaPsiFacade.getInstance((Project)project).getResolveHelper();
        PsiSubstitutor substitutor = resolveHelper.inferTypeArguments(method.getTypeParameters(), psiParameters, arguments, PsiSubstitutor.EMPTY, (PsiElement)call, (ParameterTypeInferencePolicy)DefaultParameterTypeInferencePolicy.INSTANCE);
        PsiType returnType = substitutor.substitute(method.getReturnType());
        RType type = RJavaTypeFactory.createType(project, returnType, (Context)ContextImpl.INSTANCE);
        if (!(type instanceof REmptyType)) {
            return type;
        }
        return null;
    }

    private static PsiType getJavaType(RPsiElement rPsiElement, RCall call, PsiElementFactory factory) {
        RType type = RTypeUtil.getType((PsiElement)rPsiElement);
        if (type instanceof RJavaClassType) {
            RJavaClassType javaClassType = (RJavaClassType)type;
            PsiClass psiClass = javaClassType.getPsiClass();
            return factory.createType(psiClass, javaClassType.getSubstitutor());
        }
        return null;
    }

    @NotNull
    public RType getType(@NotNull Context context) {
        if (context == null) {
            RJavaMethodSymbol.$$$reportNull$$$0(5);
        }
        if (this.myType == null) {
            this.myType = RJavaTypeFactory.createType(((PsiMethod)this.myPsiElement).getProject(), ((PsiMethod)this.getPsiElement()).getReturnType(), context);
        }
        RType rType = this.myType;
        if (rType == null) {
            RJavaMethodSymbol.$$$reportNull$$$0(6);
        }
        return rType;
    }

    public String getArgsPresentation() {
        List<ArgumentInfo> argumentInfos = this.getArgumentInfos();
        return RCommandArgumentListImpl.getPresentableName(argumentInfos);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 3: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/java/jruby/symbols/RJavaMethodSymbol";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/java/jruby/symbols/RJavaMethodSymbol";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getArgumentInfos";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createArgumentInfos";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 6: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getType";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 6 -> new IllegalStateException(string);
        };
    }

    private static class PsiRubyExpression
    extends PsiEmptyExpressionImpl {
        private final PsiType myPsiType;
        private final RCall myCall;

        PsiRubyExpression(PsiType psiType, RCall call) {
            this.myPsiType = psiType;
            this.myCall = call;
        }

        public PsiType getType() {
            return this.myPsiType;
        }

        public PsiFile getContainingFile() {
            return this.myCall.getContainingFile();
        }
    }
}

