/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.java.jruby.symbols;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.java.jruby.JRubySupport;
import org.jetbrains.plugins.ruby.java.jruby.symbols.JRubyJavaImportSymbol;
import org.jetbrains.plugins.ruby.java.jruby.symbols.JavaPrimitiveTypeSymbol;
import org.jetbrains.plugins.ruby.java.jruby.symbols.JavaResolveUtil;
import org.jetbrains.plugins.ruby.java.jruby.symbols.RJavaClassSymbol;
import org.jetbrains.plugins.ruby.java.jruby.symbols.RJavaFieldSymbol;
import org.jetbrains.plugins.ruby.java.jruby.symbols.RJavaMethodSymbol;
import org.jetbrains.plugins.ruby.java.jruby.symbols.RJavaPackageSymbol;
import org.jetbrains.plugins.ruby.java.jruby.types.JavaSymbolTypes;
import org.jetbrains.plugins.ruby.ruby.codeInsight.references.SymbolResolveResult;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.RubySymbolProvider;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.TypeSet;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.fqn.FQN;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.Symbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.TypedPsiElementSymbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.ContextImpl;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RFile;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.Visibility;
import org.jetbrains.plugins.ruby.ruby.lang.psi.references.RReference;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RConstant;

public final class JRubySymbolProvider
implements RubySymbolProvider {
    @NonNls
    public static final String JAVA = "java";

    @Nullable
    public Symbol findSymbol(@NotNull Symbol contextSymbol, @NotNull FQN fqn, @NotNull TypeSet types, @Nullable PsiElement invocationPoint) {
        if (contextSymbol == null) {
            JRubySymbolProvider.$$$reportNull$$$0(0);
        }
        if (fqn == null) {
            JRubySymbolProvider.$$$reportNull$$$0(1);
        }
        if (types == null) {
            JRubySymbolProvider.$$$reportNull$$$0(2);
        }
        if (!(invocationPoint != null && JRubySupport.hasJRubySupport(invocationPoint) || JRubySymbolProvider.hasJRubySupport(contextSymbol))) {
            return null;
        }
        Project project = contextSymbol.getProject();
        if (invocationPoint instanceof RConstant && "Java".equals(invocationPoint.getText())) {
            return new JRubyJavaImportSymbol(project, (RFile)invocationPoint.getContainingFile());
        }
        PsiElement element = JavaResolveUtil.getPsiElement(project, fqn.asList(), invocationPoint);
        Symbol result = JRubySymbolProvider.symbolFromPsiElement(element, invocationPoint);
        if (result != null) {
            return result;
        }
        return null;
    }

    private static boolean hasJRubySupport(@NotNull Symbol symbol) {
        if (symbol == null) {
            JRubySymbolProvider.$$$reportNull$$$0(3);
        }
        Module module = symbol.getModule();
        PsiElement element = symbol.getPsiElement();
        return module != null && JRubySupport.hasJRubySupport(module) || element != null && JRubySupport.hasJRubySupport(element);
    }

    @Nullable
    private static Symbol symbolFromPsiElement(PsiElement element, PsiElement invocationPoint) {
        String name;
        TypedPsiElementSymbol result = null;
        if (element instanceof PsiPackage) {
            String name2 = ((PsiPackage)element).getName();
            RReference ref = (RReference)PsiTreeUtil.getTopmostParentOfType((PsiElement)invocationPoint, RReference.class);
            if (name2 != null && ref != null && PsiTreeUtil.isAncestor((PsiElement)ref.getReceiver(), (PsiElement)invocationPoint, (boolean)false)) {
                result = new RJavaPackageSymbol((PsiPackage)element, name2);
            }
        } else if (element instanceof PsiClass && (name = ((PsiClass)element).getName()) != null) {
            result = new RJavaClassSymbol((PsiClass)element, name);
        }
        return result;
    }

    public boolean acceptsSymbol(@NotNull Symbol symbol, @NotNull ContextImpl context) {
        PsiModifierList modifiers;
        if (symbol == null) {
            JRubySymbolProvider.$$$reportNull$$$0(4);
        }
        if (context == null) {
            JRubySymbolProvider.$$$reportNull$$$0(5);
        }
        if (symbol instanceof RJavaPackageSymbol || symbol instanceof JavaPrimitiveTypeSymbol) {
            return true;
        }
        if (symbol instanceof RJavaMethodSymbol) {
            modifiers = ((PsiMethod)((RJavaMethodSymbol)symbol).getPsiElement()).getModifierList();
        } else if (symbol instanceof RJavaClassSymbol) {
            modifiers = ((PsiClass)((RJavaClassSymbol)symbol).getPsiElement()).getModifierList();
        } else if (symbol instanceof RJavaFieldSymbol) {
            modifiers = ((PsiField)((RJavaFieldSymbol)symbol).getPsiElement()).getModifierList();
        } else {
            return false;
        }
        Visibility modifier = context.getVisibility();
        if (modifiers == null) {
            return modifier.accepts(Visibility.PROTECTED);
        }
        if (modifiers.hasModifierProperty("private")) {
            return modifier.accepts(Visibility.PRIVATE);
        }
        if (modifiers.hasModifierProperty("protected")) {
            return modifier.accepts(Visibility.PROTECTED);
        }
        if (modifiers.hasModifierProperty("public")) {
            return modifier.accepts(Visibility.PUBLIC);
        }
        return false;
    }

    public ContextImpl getAccessContext(@NotNull PsiElement element) {
        if (element == null) {
            JRubySymbolProvider.$$$reportNull$$$0(6);
        }
        return null;
    }

    @NotNull
    public TypeSet getNonQualifiedTypes() {
        TypeSet typeSet = JavaSymbolTypes.ALL_JAVA_TYPES;
        if (typeSet == null) {
            JRubySymbolProvider.$$$reportNull$$$0(7);
        }
        return typeSet;
    }

    public TypeSet getClassTypes() {
        return JavaSymbolTypes.JAVA_CLASS.asSet();
    }

    public TypeSet getMethodTypes() {
        return JavaSymbolTypes.JAVA_METHOD.asSet();
    }

    @Nullable
    public SymbolResolveResult processSuperMethod(@NotNull PsiElement element) {
        if (element == null) {
            JRubySymbolProvider.$$$reportNull$$$0(8);
        }
        if (element instanceof PsiMethod) {
            return SymbolResolveResult.create((Symbol)new RJavaMethodSymbol((PsiMethod)element, null));
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextSymbol";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fqn";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbol";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/java/jruby/symbols/JRubySymbolProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/java/jruby/symbols/JRubySymbolProvider";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getNonQualifiedTypes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findSymbol";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "hasJRubySupport";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "acceptsSymbol";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getAccessContext";
                break;
            }
            case 7: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "processSuperMethod";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7 -> new IllegalStateException(string);
        };
    }
}

