/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.java.jruby.search;

import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.psi.PsiElement;
import com.intellij.util.CommonProcessors;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.QueryExecutor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.java.jruby.JRubyNameConventions;
import org.jetbrains.plugins.ruby.java.jruby.types.JavaSymbolTypes;
import org.jetbrains.plugins.ruby.ruby.codeInsight.RubyOverrideImplementUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.resolve.scope.RElementWithFQN;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.Symbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.SymbolUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RMethod;
import org.jetbrains.plugins.ruby.ruby.lang.search.overriden.RubySuperMethodsSearch;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkUtil;
import org.jetbrains.plugins.ruby.ruby.sdk.jruby.JRubySdkUtil;

public final class JRubySuperMethodSearchExecutor
implements QueryExecutor<Symbol, RubySuperMethodsSearch.SearchParameters> {
    public boolean execute(@NotNull RubySuperMethodsSearch.SearchParameters queryParameters, @NotNull Processor<? super Symbol> consumer) {
        RMethod method;
        Sdk sdk;
        if (queryParameters == null) {
            JRubySuperMethodSearchExecutor.$$$reportNull$$$0(0);
        }
        if (consumer == null) {
            JRubySuperMethodSearchExecutor.$$$reportNull$$$0(1);
        }
        if ((sdk = RubySdkUtil.findRubySdk((PsiElement)(method = queryParameters.getDerivedMethod()))) == null || !JRubySdkUtil.isJRubySDK((Sdk)sdk)) {
            return true;
        }
        return JRubySuperMethodSearchExecutor.processJavaSuperMethods(method, consumer);
    }

    public static boolean processJavaSuperMethods(RMethod method, Processor<? super Symbol> consumer) {
        String name = method.getName();
        Symbol container = SymbolUtil.getSymbolByContainer((RElementWithFQN)method);
        if (container == null) {
            return true;
        }
        for (String javaName : JRubyNameConventions.getJavaNames(name)) {
            RubyOverrideImplementUtil.processOverriddenSymbols((Symbol)container, (String)javaName, (PsiElement)container.getPsiElement(), symbol -> {
                if (symbol.getType() != JavaSymbolTypes.JAVA_METHOD) {
                    return true;
                }
                return consumer.process(symbol);
            });
        }
        return true;
    }

    public static PsiElement findJavaSuperMethod(RMethod method) {
        CommonProcessors.FindFirstProcessor processor = new CommonProcessors.FindFirstProcessor();
        JRubySuperMethodSearchExecutor.processJavaSuperMethods(method, (Processor<? super Symbol>)processor);
        return (PsiElement)ObjectUtils.doIfNotNull((Object)((Symbol)processor.getFoundValue()), Symbol::getPsiElement);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "queryParameters";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "consumer";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/plugins/ruby/java/jruby/search/JRubySuperMethodSearchExecutor";
        objectArray[2] = "execute";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

