/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.java.jruby.intentions;

import com.intellij.codeInsight.intention.AbstractIntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.java.jruby.types.JavaSymbolTypes;
import org.jetbrains.plugins.ruby.java.jruby.types.RJavaClassType;
import org.jetbrains.plugins.ruby.ruby.codeInsight.resolve.ResolveUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.Symbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.RTypeUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.impl.RClassType;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyElementFactoryCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RExpression;
import org.jetbrains.plugins.ruby.ruby.lang.psi.references.RDotReference;
import org.jetbrains.plugins.ruby.ruby.lang.psi.references.RReference;

public final class JRubyJavaToRubyCallStyleIntention
extends AbstractIntentionAction {
    @NotNull
    public String getText() {
        String string = RBundle.message((String)"ruby.intentions.java.to.ruby.call.style");
        if (string == null) {
            JRubyJavaToRubyCallStyleIntention.$$$reportNull$$$0(0);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile psiFile) {
        RDotReference reference;
        if (project == null) {
            JRubyJavaToRubyCallStyleIntention.$$$reportNull$$$0(1);
        }
        if ((reference = JRubyJavaToRubyCallStyleIntention.getReference(editor, psiFile)) == null) {
            return false;
        }
        Pair<PsiElement, List<PsiElement>> parts = JRubyJavaToRubyCallStyleIntention.getCallParts(reference);
        return parts != null && !((List)parts.getSecond()).isEmpty();
    }

    private static RDotReference getReference(Editor editor, PsiFile file) {
        return (RDotReference)PsiTreeUtil.getTopmostParentOfType((PsiElement)file.findElementAt(editor.getCaretModel().getOffset()), RDotReference.class);
    }

    @Nullable
    private static Pair<PsiElement, List<PsiElement>> getCallParts(RDotReference element) {
        ArrayList<Object> list = new ArrayList<Object>();
        RDotReference cur = element;
        Symbol symbol = ResolveUtil.resolveToSymbolWithCaching((PsiReference)cur.getReference());
        while (cur instanceof RReference && (symbol == null || symbol.getType() != JavaSymbolTypes.JAVA_CLASS && !JRubyJavaToRubyCallStyleIntention.acceptField(symbol)) && !JRubyJavaToRubyCallStyleIntention.ignoreReferenceValue(((RReference)cur).getValue()) || cur instanceof RExpression && !(cur instanceof RReference) && !(RTypeUtil.getType((PsiElement)cur) instanceof RClassType) && !(RTypeUtil.getType((PsiElement)cur) instanceof RJavaClassType)) {
            if (cur instanceof RReference) {
                list.add(((RReference)cur).getValue());
            } else {
                list.add(cur);
            }
            cur = cur.getFirstChild();
            symbol = ResolveUtil.resolveToSymbolWithCaching((PsiReference)cur.getReference());
        }
        return cur instanceof RExpression ? Pair.create((Object)cur, list) : null;
    }

    private static boolean acceptField(Symbol symbol) {
        PsiElement element = symbol.getPsiElement();
        return element instanceof PsiField && !((PsiField)element).hasModifierProperty("static");
    }

    private static boolean ignoreReferenceValue(@Nullable RPsiElement value) {
        return value == null || Holder.ignoreMethodNames.contains(value.getText());
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile psiFile) throws IncorrectOperationException {
        RDotReference reference;
        if (project == null) {
            JRubyJavaToRubyCallStyleIntention.$$$reportNull$$$0(2);
        }
        if ((reference = JRubyJavaToRubyCallStyleIntention.getReference(editor, psiFile)) == null) {
            return;
        }
        Pair<PsiElement, List<PsiElement>> parts = JRubyJavaToRubyCallStyleIntention.getCallParts(reference);
        if (parts == null) {
            return;
        }
        RPsiElement generated = JRubyJavaToRubyCallStyleIntention.constructNewReference(parts);
        reference.replace((PsiElement)generated);
    }

    private static RPsiElement constructNewReference(@NotNull Pair<PsiElement, List<PsiElement>> parts) {
        if (parts == null) {
            JRubyJavaToRubyCallStyleIntention.$$$reportNull$$$0(3);
        }
        StringBuilder sb = new StringBuilder(((PsiElement)parts.getFirst()).getText());
        List second = (List)parts.getSecond();
        for (int i = second.size() - 1; i >= 0; --i) {
            PsiElement element = (PsiElement)second.get(i);
            sb.append("::");
            sb.append(element.getText());
        }
        return RubyElementFactoryCore.createElementFromText((PsiElement)((PsiElement)parts.getFirst()), (String)sb.toString());
    }

    public boolean startInWriteAction() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/java/jruby/intentions/JRubyJavaToRubyCallStyleIntention";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parts";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/java/jruby/intentions/JRubyJavaToRubyCallStyleIntention";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "constructNewReference";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3 -> new IllegalArgumentException(string);
        };
    }

    private static class Holder {
        private static final List<String> ignoreMethodNames = List.of("new");

        private Holder() {
        }
    }
}

