/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.java.jruby.inspections;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiReference;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.java.jruby.symbols.JavaResolveUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.resolve.ResolveUtil;
import org.jetbrains.plugins.ruby.ruby.inspections.RubyInspectionVisitor;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyElementFactoryCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtilCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.RubyLanguageLevelService;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RIdentifier;
import org.jetbrains.plugins.ruby.ruby.sdk.LanguageLevel;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkUtil;
import org.jetbrains.plugins.ruby.ruby.sdk.jruby.JRubySdkUtil;

public final class WrongTopLevelPackageInspection
extends LocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Sdk sdk;
        if (holder == null) {
            WrongTopLevelPackageInspection.$$$reportNull$$$0(0);
        }
        if ((sdk = RubySdkUtil.findRubySdk((PsiElement)holder.getFile())) == null || !JRubySdkUtil.isJRubySDK((Sdk)sdk)) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            if (psiElementVisitor == null) {
                WrongTopLevelPackageInspection.$$$reportNull$$$0(1);
            }
            return psiElementVisitor;
        }
        return new MyVisitor(holder);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/java/jruby/inspections/WrongTopLevelPackageInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/java/jruby/inspections/WrongTopLevelPackageInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }

    private static class MyVisitor
    extends RubyInspectionVisitor {
        private MyVisitor(@NotNull ProblemsHolder holder) {
            if (holder == null) {
                MyVisitor.$$$reportNull$$$0(0);
            }
            super(holder);
        }

        public void visitRIdentifier(@NotNull RIdentifier rIdentifier) {
            PsiElement element;
            List list;
            if (rIdentifier == null) {
                MyVisitor.$$$reportNull$$$0(1);
            }
            if ((list = ResolveUtil.multiResolve((PsiReference)rIdentifier.getReference(), (boolean)false)).size() == 1 && (element = (PsiElement)list.get(0)) instanceof PsiPackage && !JavaResolveUtil.isTopLevelPackageOk((PsiPackage)element)) {
                this.registerProblem((PsiElement)rIdentifier, RBundle.message((String)"inspection.wrong.top.level.package.should.be.one.of", (Object[])new Object[]{"'java', 'javax', 'org', 'com'"}), new LocalQuickFix[]{MyQuickFix.getInstance()});
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "holder";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rIdentifier";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/plugins/ruby/java/jruby/inspections/WrongTopLevelPackageInspection$MyVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitRIdentifier";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class MyQuickFix
    implements LocalQuickFix {
        private static volatile MyQuickFix ourInstance;
        @NonNls
        private static final String JAVA = "Java::";

        private MyQuickFix() {
        }

        @NotNull
        private static MyQuickFix getInstance() {
            if (ourInstance == null) {
                ourInstance = new MyQuickFix();
            }
            MyQuickFix myQuickFix = ourInstance;
            if (myQuickFix == null) {
                MyQuickFix.$$$reportNull$$$0(0);
            }
            return myQuickFix;
        }

        @NonNls
        @NotNull
        public String getName() {
            String string = RBundle.message((String)"inspection.wrong.top.level.package.fix");
            if (string == null) {
                MyQuickFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        @NonNls
        @NotNull
        public String getFamilyName() {
            String string = RBundle.message((String)"inspection.group.jruby.name");
            if (string == null) {
                MyQuickFix.$$$reportNull$$$0(2);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiElement inspectedElement;
            if (project == null) {
                MyQuickFix.$$$reportNull$$$0(3);
            }
            if (descriptor == null) {
                MyQuickFix.$$$reportNull$$$0(4);
            }
            if ((inspectedElement = descriptor.getPsiElement()) == null) {
                return;
            }
            String text = inspectedElement.getText();
            LanguageLevel languageLevel = RubyLanguageLevelService.getLanguageLevelByElement((PsiElement)inspectedElement);
            if (languageLevel != null) {
                RPsiElement element = RubyElementFactoryCore.createElementFromText((Project)project, (String)(JAVA + text), (LanguageLevel)languageLevel);
                RubyPsiUtilCore.replaceInParent((PsiElement)inspectedElement, (PsiElement)element);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 3, 4 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/ruby/java/jruby/inspections/WrongTopLevelPackageInspection$MyQuickFix";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getInstance";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/ruby/java/jruby/inspections/WrongTopLevelPackageInspection$MyQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 3, 4 -> new IllegalArgumentException(string);
            };
        }
    }
}

