/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.java.jruby.inspections;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixOnPsiElement;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.java.jruby.symbols.RJavaClassSymbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.Symbol;
import org.jetbrains.plugins.ruby.ruby.inspections.RubyInspectionVisitor;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyElementFactoryCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.blocks.RCompoundStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.names.RSuperClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.RubyClassResolveUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.controlStructures.classes.RClassImpl;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkUtil;
import org.jetbrains.plugins.ruby.ruby.sdk.jruby.JRubySdkUtil;

public final class JRubySuperClassInspection
extends LocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Sdk sdk;
        if (holder == null) {
            JRubySuperClassInspection.$$$reportNull$$$0(0);
        }
        if ((sdk = RubySdkUtil.findRubySdk((PsiElement)holder.getFile())) == null || !JRubySdkUtil.isJRubySDK((Sdk)sdk)) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            if (psiElementVisitor == null) {
                JRubySuperClassInspection.$$$reportNull$$$0(1);
            }
            return psiElementVisitor;
        }
        return new MyVisitor(holder);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/java/jruby/inspections/JRubySuperClassInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/java/jruby/inspections/JRubySuperClassInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }

    private static class MyVisitor
    extends RubyInspectionVisitor {
        private MyVisitor(@NotNull ProblemsHolder holder) {
            if (holder == null) {
                MyVisitor.$$$reportNull$$$0(0);
            }
            super(holder);
        }

        public void visitRClass(@NotNull RClass rClass) {
            RJavaClassSymbol javaClassSymbol;
            Symbol superClassSymbol;
            if (rClass == null) {
                MyVisitor.$$$reportNull$$$0(1);
            }
            if ((superClassSymbol = RubyClassResolveUtil.resolveSuperClassSymbol((RClass)rClass, (PsiElement)this.myHolder.getFile())) instanceof RJavaClassSymbol && ((PsiClass)(javaClassSymbol = (RJavaClassSymbol)superClassSymbol).getPsiElement()).isInterface()) {
                this.registerProblem((PsiElement)rClass.getPsiSuperClass(), RBundle.message((String)"inspection.super.class.must.be.a.class.message"), new LocalQuickFix[]{new MyQuickFix((PsiElement)rClass)});
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "holder";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rClass";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/plugins/ruby/java/jruby/inspections/JRubySuperClassInspection$MyVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitRClass";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class MyQuickFix
    extends LocalQuickFixOnPsiElement {
        public static final String INCLUDE_TEMPLATE = "include %s";

        private MyQuickFix(@NotNull PsiElement element) {
            if (element == null) {
                MyQuickFix.$$$reportNull$$$0(0);
            }
            super(element);
        }

        @NotNull
        public String getText() {
            String string = RBundle.message((String)"inspection.super.class.must.be.a.class.fix.name");
            if (string == null) {
                MyQuickFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = RBundle.message((String)"inspection.group.jruby.name");
            if (string == null) {
                MyQuickFix.$$$reportNull$$$0(2);
            }
            return string;
        }

        public void invoke(@NotNull Project project, @NotNull PsiFile psiFile, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
            PsiElement whitespace;
            RClass clazz;
            if (project == null) {
                MyQuickFix.$$$reportNull$$$0(3);
            }
            if (psiFile == null) {
                MyQuickFix.$$$reportNull$$$0(4);
            }
            if (startElement == null) {
                MyQuickFix.$$$reportNull$$$0(5);
            }
            if (endElement == null) {
                MyQuickFix.$$$reportNull$$$0(6);
            }
            if ((clazz = (RClass)ObjectUtils.tryCast((Object)startElement, RClass.class)) == null) {
                return;
            }
            RSuperClass superClassPsiElement = clazz.getPsiSuperClass();
            if (superClassPsiElement == null) {
                return;
            }
            for (whitespace = superClassPsiElement.getPrevSibling(); whitespace != null && !whitespace.getText().equals("<"); whitespace = whitespace.getPrevSibling()) {
            }
            if (whitespace == null) {
                return;
            }
            RubyPsiUtil.removeElements((PsiElement[])new PsiElement[]{whitespace, superClassPsiElement});
            String fqn = superClassPsiElement.getText();
            RPsiElement imp = RubyElementFactoryCore.createElementFromText((PsiElement)clazz, (String)String.format(INCLUDE_TEMPLATE, fqn));
            RCompoundStatement compoundStatement = ((RClassImpl)clazz).getBody().getCompoundStatement();
            if (compoundStatement.getChildren().length > 0) {
                compoundStatement.addBefore((PsiElement)imp, compoundStatement.getChildren()[0]);
            } else {
                compoundStatement.add((PsiElement)imp);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/ruby/java/jruby/inspections/JRubySuperClassInspection$MyQuickFix";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "psiFile";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "startElement";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "endElement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/ruby/java/jruby/inspections/JRubySuperClassInspection$MyQuickFix";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 2 -> new IllegalStateException(string);
            };
        }
    }
}

