/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.java.jruby.inspections;

import com.intellij.codeInsight.daemon.impl.analysis.HighlightMessageUtil;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocCommentOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.impl.PsiImplUtil;
import java.util.Collection;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.ruby.codeInsight.resolve.ResolveUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.Symbol;
import org.jetbrains.plugins.ruby.ruby.inspections.RubyInspectionVisitor;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RArgumentList;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RMethod;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.references.RReferenceNavigator;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.references.RColonReference;
import org.jetbrains.plugins.ruby.ruby.lang.psi.references.RDotReference;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RIdentifier;
import org.jetbrains.plugins.ruby.ruby.lang.search.overriden.RubySuperMethodsSearch;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkUtil;
import org.jetbrains.plugins.ruby.ruby.sdk.jruby.JRubySdkUtil;

public final class JRubyDeprecatedJavaMethodUsageInspection
extends LocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Sdk sdk;
        if (holder == null) {
            JRubyDeprecatedJavaMethodUsageInspection.$$$reportNull$$$0(0);
        }
        if ((sdk = RubySdkUtil.findRubySdk((PsiElement)holder.getFile())) == null || !JRubySdkUtil.isJRubySDK((Sdk)sdk)) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            if (psiElementVisitor == null) {
                JRubyDeprecatedJavaMethodUsageInspection.$$$reportNull$$$0(1);
            }
            return psiElementVisitor;
        }
        return new MyVisitor(holder);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/java/jruby/inspections/JRubyDeprecatedJavaMethodUsageInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/java/jruby/inspections/JRubyDeprecatedJavaMethodUsageInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }

    private static class MyVisitor
    extends RubyInspectionVisitor {
        private MyVisitor(@NotNull ProblemsHolder holder) {
            if (holder == null) {
                MyVisitor.$$$reportNull$$$0(0);
            }
            super(holder);
        }

        public void visitRMethod(@NotNull RMethod rMethod) {
            if (rMethod == null) {
                MyVisitor.$$$reportNull$$$0(1);
            }
            Collection searchResults = RubySuperMethodsSearch.search((RMethod)rMethod).mapping(Symbol::getPsiElement).filtering(Objects::nonNull).findAll();
            RArgumentList argumentList = rMethod.getArgumentList();
            if (argumentList == null) {
                return;
            }
            int size = argumentList.getArguments().size();
            for (PsiElement superMethod : searchResults) {
                if (!(superMethod instanceof PsiMethod) || !MyVisitor.isDeprecated(superMethod)) continue;
                int count = ((PsiMethod)superMethod).getParameterList().getParametersCount();
                PsiClass aClass = ((PsiMethod)superMethod).getContainingClass();
                if (size != count || aClass == null) continue;
                this.registerProblem((PsiElement)rMethod.getMethodName(), RBundle.message((String)"inspection.jruby.deprecated.java.method.override", (Object[])new Object[]{HighlightMessageUtil.getSymbolName((PsiElement)aClass, (PsiSubstitutor)PsiSubstitutor.EMPTY)}), ProblemHighlightType.LIKE_DEPRECATED, new LocalQuickFix[0]);
                return;
            }
        }

        public void visitRDotReference(@NotNull RDotReference rDotReference) {
            if (rDotReference == null) {
                MyVisitor.$$$reportNull$$$0(2);
            }
            this.processReference(RReferenceNavigator.getRightPsiReference((PsiElement)rDotReference), (PsiElement)rDotReference.getValue());
        }

        public void visitRColonReference(@NotNull RColonReference rColonReference) {
            if (rColonReference == null) {
                MyVisitor.$$$reportNull$$$0(3);
            }
            this.processReference(RReferenceNavigator.getRightPsiReference((PsiElement)rColonReference), (PsiElement)rColonReference.getValue());
        }

        public void visitRCall(@NotNull RCall rCall) {
            if (rCall == null) {
                MyVisitor.$$$reportNull$$$0(4);
            }
            PsiElement element = rCall.getFirstChild();
            this.processReference(element.getReference(), element);
        }

        public void visitRIdentifier(@NotNull RIdentifier rIdentifier) {
            if (rIdentifier == null) {
                MyVisitor.$$$reportNull$$$0(5);
            }
            this.processReference(rIdentifier.getReference(), (PsiElement)rIdentifier);
        }

        private void processReference(PsiReference reference, PsiElement problemElement) {
            PsiElement element;
            Symbol symbol = ResolveUtil.resolveToSymbolWithCaching((PsiReference)reference);
            PsiElement psiElement = element = symbol != null ? symbol.getPsiElement() : null;
            if (!(element instanceof PsiMethod)) {
                return;
            }
            if (MyVisitor.isDeprecated(element)) {
                this.registerProblem(problemElement, RBundle.message((String)"inspection.jruby.deprecated.java.method.usage", (Object[])new Object[]{HighlightMessageUtil.getSymbolName((PsiElement)element, (PsiSubstitutor)PsiSubstitutor.EMPTY)}), ProblemHighlightType.LIKE_DEPRECATED, new LocalQuickFix[0]);
            }
        }

        private static boolean isDeprecated(@NotNull PsiElement resolved) {
            if (resolved == null) {
                MyVisitor.$$$reportNull$$$0(6);
            }
            return resolved instanceof PsiDocCommentOwner && ((PsiDocCommentOwner)resolved).isDeprecated() || resolved instanceof PsiModifierListOwner && PsiImplUtil.isDeprecatedByAnnotation((PsiModifierListOwner)((PsiModifierListOwner)resolved));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "holder";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rMethod";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rDotReference";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rColonReference";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rCall";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rIdentifier";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "resolved";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/plugins/ruby/java/jruby/inspections/JRubyDeprecatedJavaMethodUsageInspection$MyVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitRMethod";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitRDotReference";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitRColonReference";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitRCall";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitRIdentifier";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isDeprecated";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

