/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.java.jruby.facet.ui;

import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.ui.ProjectJdksEditor;
import com.intellij.openapi.ui.Messages;
import com.intellij.ui.ComboboxWithBrowseButton;
import com.intellij.ui.SpeedSearchBase;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.ruby.sdk.jruby.JRubySdkUtil;
import org.jetbrains.plugins.ruby.ruby.ui.RubySdkRenderer;

public class JRubySDKsComboboxWithBrowseButton
extends ComboboxWithBrowseButton {
    public JRubySDKsComboboxWithBrowseButton() {
        JComboBox sdkCombobox = this.getComboBox();
        RubySdkRenderer.installSdkNameSpeedSearch((JComboBox)sdkCombobox);
        sdkCombobox.setRenderer(new RubySdkRenderer(false, true));
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProjectJdksEditor editor = new ProjectJdksEditor(null, ProjectManager.getInstance().getDefaultProject(), (Component)((Object)JRubySDKsComboboxWithBrowseButton.this));
                if (editor.showAndGet()) {
                    Sdk selectedJdk = editor.getSelectedJdk();
                    JRubySDKsComboboxWithBrowseButton.this.rebuildSdksListAndSelectSdk(selectedJdk);
                    if (!JRubySdkUtil.isJRubySDK((Sdk)selectedJdk)) {
                        String title = RBundle.message((String)"jruby.select.sdk");
                        String msg = RBundle.message((String)"jruby.settings.tabs.gem.manager.error.wrong.sdk");
                        Messages.showErrorDialog((Component)((Object)JRubySDKsComboboxWithBrowseButton.this), (String)msg, (String)title);
                    }
                }
            }
        });
        this.getButton().setToolTipText(UIUtil.removeMnemonic((String)RBundle.message((String)"ruby.ide.sdk.configurable.add.sdk")));
    }

    public void addComboboxActionListener(final ActionListener l) {
        final JComboBox comboBox = this.getComboBox();
        ActionListener listenerWrapper = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!SpeedSearchBase.hasActiveSpeedSearch((JComponent)comboBox)) {
                    l.actionPerformed(e);
                }
            }
        };
        comboBox.addActionListener(listenerWrapper);
    }

    public void rebuildSdksListAndSelectSdk(Sdk selectedSdk) {
        Sdk[] sdks = JRubySdkUtil.getValidSdks();
        JComboBox sdksComboBox = this.getComboBox();
        sdksComboBox.setModel(new DefaultComboBoxModel<Sdk>(sdks));
        if (selectedSdk != null) {
            for (Sdk candidateSdk : sdks) {
                if (candidateSdk == null || !candidateSdk.getName().equals(selectedSdk.getName())) continue;
                sdksComboBox.setSelectedItem(candidateSdk);
                return;
            }
        }
        sdksComboBox.setSelectedItem(null);
    }
}

