/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.java.jruby.facet;

import com.intellij.facet.Facet;
import com.intellij.facet.FacetManager;
import com.intellij.facet.FacetType;
import com.intellij.facet.ModifiableFacetModel;
import com.intellij.ide.util.frameworkSupport.FrameworkSupportConfigurable;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.ui.LabeledComponent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.java.jruby.facet.JRubyFacet;
import org.jetbrains.plugins.ruby.java.jruby.facet.JRubyFacetConfiguration;
import org.jetbrains.plugins.ruby.java.jruby.facet.JRubyFacetType;
import org.jetbrains.plugins.ruby.java.jruby.facet.ui.JRubySDKsComboboxWithBrowseButton;
import org.jetbrains.plugins.ruby.ruby.sdk.jruby.JRubySdkUtil;

public class JRubyFrameworkConfigurable
extends FrameworkSupportConfigurable {
    private final JRubySDKsComboboxWithBrowseButton mySdksComboBox = new JRubySDKsComboboxWithBrowseButton();
    protected Sdk mySelectedSdk;
    private final JComponent myMainComponent;

    public JRubyFrameworkConfigurable() {
        this.mySdksComboBox.addComboboxActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JRubyFrameworkConfigurable.this.mySelectedSdk = JRubyFrameworkConfigurable.this.getSelectedSdk();
            }
        });
        Sdk[] sdks = JRubySdkUtil.getValidSdks();
        this.mySdksComboBox.rebuildSdksListAndSelectSdk(sdks.length > 1 ? sdks[1] : null);
        this.myMainComponent = LabeledComponent.create((JComponent)((Object)this.mySdksComboBox), (String)RBundle.message((String)"jruby.framework.configurable.sdk"));
        ((LabeledComponent)this.myMainComponent).setLabelLocation("West");
    }

    @Nullable
    public JComponent getComponent() {
        return this.myMainComponent;
    }

    @Nullable
    public Sdk getSelectedSdk() {
        Object selectedObject = this.mySdksComboBox.getComboBox().getSelectedItem();
        return selectedObject instanceof Sdk ? (Sdk)selectedObject : null;
    }

    public void addSupport(@NotNull Module module, @NotNull ModifiableRootModel model, @Nullable Library library) {
        if (module == null) {
            JRubyFrameworkConfigurable.$$$reportNull$$$0(0);
        }
        if (model == null) {
            JRubyFrameworkConfigurable.$$$reportNull$$$0(1);
        }
        FacetManager facetManager = FacetManager.getInstance((Module)module);
        ModifiableFacetModel facetModel = facetManager.createModifiableModel();
        JRubyFacet facet = (JRubyFacet)facetManager.createFacet((FacetType)JRubyFacetType.getInstance(), RBundle.message((String)"jruby.facet"), null);
        ((JRubyFacetConfiguration)facet.getConfiguration()).setSdk(this.mySelectedSdk);
        facetModel.addFacet((Facet)facet);
        facetModel.commit();
        JRubyFacet.updateSdkLibrary(this.mySelectedSdk, model);
    }

    public JRubySDKsComboboxWithBrowseButton getSdksComboBox() {
        return this.mySdksComboBox;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "module";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "model";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/plugins/ruby/java/jruby/facet/JRubyFrameworkConfigurable";
        objectArray[2] = "addSupport";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

