/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.java.jruby.facet;

import com.intellij.facet.Facet;
import com.intellij.facet.FacetConfiguration;
import com.intellij.facet.FacetManager;
import com.intellij.facet.FacetManagerAdapter;
import com.intellij.facet.FacetType;
import com.intellij.facet.FacetTypeId;
import com.intellij.facet.FacetTypeRegistry;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTablesRegistrar;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.util.messages.MessageBusConnection;
import java.util.function.Predicate;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.java.jruby.JRubySdkPathsInitializedListener;
import org.jetbrains.plugins.ruby.java.jruby.facet.JRubyFacetConfiguration;

public final class JRubyFacet
extends Facet<JRubyFacetConfiguration> {
    public static final FacetTypeId<JRubyFacet> ID = new FacetTypeId("jruby");
    @NonNls
    public static final String JRUBY_FACET_LIBRARY_NAME_SUFFIX = " facet library";
    private static final Predicate<String> LIBRARY_NAME_CONDITION = it -> it != null && it.endsWith(JRUBY_FACET_LIBRARY_NAME_SUFFIX);

    public JRubyFacet(@NotNull Module module) {
        if (module == null) {
            JRubyFacet.$$$reportNull$$$0(0);
        }
        this(FacetTypeRegistry.getInstance().findFacetType(ID), module, RBundle.message((String)"jruby.facet"), new JRubyFacetConfiguration(), null);
    }

    public JRubyFacet(@NotNull FacetType facetType, @NotNull Module module, @NlsSafe String name, @NotNull JRubyFacetConfiguration configuration, Facet underlyingFacet) {
        if (facetType == null) {
            JRubyFacet.$$$reportNull$$$0(1);
        }
        if (module == null) {
            JRubyFacet.$$$reportNull$$$0(2);
        }
        if (configuration == null) {
            JRubyFacet.$$$reportNull$$$0(3);
        }
        super(facetType, module, name, (FacetConfiguration)configuration, underlyingFacet);
    }

    public static void updateSdkLibrary(Sdk sdk, ModifiableRootModel model) {
        WriteAction.runAndWait(() -> {
            if (model.getProject().isDisposed()) {
                return;
            }
            String name = sdk != null ? JRubyFacet.getFacetLibraryName(sdk.getName()) : null;
            boolean librarySeen = false;
            for (OrderEntry entry : model.getOrderEntries()) {
                if (!(entry instanceof LibraryOrderEntry)) continue;
                String libraryName = ((LibraryOrderEntry)entry).getLibraryName();
                if (name != null && name.equals(libraryName)) {
                    librarySeen = true;
                    continue;
                }
                if (libraryName == null || !libraryName.endsWith(JRUBY_FACET_LIBRARY_NAME_SUFFIX)) continue;
                model.removeOrderEntry(entry);
            }
            if (!librarySeen && name != null) {
                Library library = LibraryTablesRegistrar.getInstance().getLibraryTable().getLibraryByName(name);
                if (library == null) {
                    library = JRubySdkPathsInitializedListener.addLibrary(sdk);
                }
                LibraryOrderEntry libraryOrderEntry = model.addLibraryEntry(library);
                libraryOrderEntry.setScope(DependencyScope.PROVIDED);
            }
        });
    }

    public static void removeSdkLibrary(@NotNull Module module) {
        if (module == null) {
            JRubyFacet.$$$reportNull$$$0(4);
        }
        WriteAction.runAndWait(() -> {
            ModuleRootManager rootManager = ModuleRootManager.getInstance((Module)module);
            ModifiableRootModel model = rootManager.getModifiableModel();
            for (OrderEntry entry : model.getOrderEntries()) {
                String libraryName;
                Library library;
                if (!(entry instanceof LibraryOrderEntry) || (library = ((LibraryOrderEntry)entry).getLibrary()) == null || !LIBRARY_NAME_CONDITION.test(libraryName = library.getName())) continue;
                model.removeOrderEntry(entry);
            }
            model.commit();
        });
    }

    public static String getFacetLibraryName(String sdkName) {
        return sdkName + JRUBY_FACET_LIBRARY_NAME_SUFFIX;
    }

    public void initFacet() {
        super.initFacet();
        MessageBusConnection connection = this.getModule().getProject().getMessageBus().connect((Disposable)this);
        connection.subscribe(FacetManager.FACETS_TOPIC, (Object)new FacetManagerAdapter(){

            public void beforeFacetRemoved(@NotNull Facet facet) {
                if (facet == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (facet != JRubyFacet.this) {
                    return;
                }
                JRubyFacet.removeSdkLibrary(JRubyFacet.this.getModule());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "org/jetbrains/plugins/ruby/java/jruby/facet/JRubyFacet$1", "beforeFacetRemoved"));
            }
        });
    }

    @Nullable
    public static JRubyFacet getInstance(@NotNull Module module) {
        if (module == null) {
            JRubyFacet.$$$reportNull$$$0(5);
        }
        return (JRubyFacet)FacetManager.getInstance((Module)module).getFacetByType(ID);
    }

    public Sdk getRubySdk() {
        return ((JRubyFacetConfiguration)this.getConfiguration()).getSdk();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facetType";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/ruby/java/jruby/facet/JRubyFacet";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "removeSdkLibrary";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "getInstance";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

