/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.java.jruby.debug;

import com.intellij.debugger.NoDataException;
import com.intellij.debugger.PositionManager;
import com.intellij.debugger.PositionManagerFactory;
import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.impl.DebuggerUtilsAsync;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.requests.ClassPrepareRequestor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.CompilerModuleExtension;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.Location;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.request.ClassPrepareRequest;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RFile;

public class JRubyPositionManager
implements PositionManager {
    private static final Logger LOG = Logger.getInstance(JRubyPositionManager.class);
    private final DebugProcess myDebugProcess;

    public JRubyPositionManager(DebugProcess debugProcess) {
        this.myDebugProcess = debugProcess;
    }

    public DebugProcess getDebugProcess() {
        return this.myDebugProcess;
    }

    public SourcePosition getSourcePosition(Location location) throws NoDataException {
        if (location == null) {
            throw NoDataException.INSTANCE;
        }
        PsiFile psiFile = JRubyPositionManager.getPsiFileByLocation(this.getDebugProcess().getProject(), location);
        if (psiFile == null) {
            throw NoDataException.INSTANCE;
        }
        int lineNumber = this.calcLineIndex(location);
        if (lineNumber < 0) {
            throw NoDataException.INSTANCE;
        }
        return SourcePosition.createFromLine((PsiFile)psiFile, (int)lineNumber);
    }

    @NotNull
    public List<ReferenceType> getAllClasses(@NotNull SourcePosition classPosition) throws NoDataException {
        PsiFile file;
        RFile rFile;
        if (classPosition == null) {
            JRubyPositionManager.$$$reportNull$$$0(0);
        }
        RFile rFile2 = rFile = (file = classPosition.getFile()) instanceof RFile ? (RFile)file : null;
        if (rFile == null) {
            throw NoDataException.INSTANCE;
        }
        ArrayList<ReferenceType> result = new ArrayList<ReferenceType>();
        Project project = this.myDebugProcess.getProject();
        for (ReferenceType referenceType : this.myDebugProcess.getVirtualMachineProxy().allClasses()) {
            String shortName = JRubyPositionManager.getShortName((PsiFile)rFile);
            if (shortName == null || !referenceType.name().contains(shortName)) continue;
            try {
                String name = referenceType.sourceName();
                String path = JRubyPositionManager.getPath(referenceType);
                VirtualFile vFile = rFile.getVirtualFile();
                if (vFile == null || !name.equals(rFile.getName()) || !JRubyPositionManager.isMatchingFile(path, vFile, project)) continue;
                result.add(referenceType);
            }
            catch (AbsentInformationException | IOException | UnsupportedOperationException exception) {}
        }
        if (result.isEmpty()) {
            throw NoDataException.INSTANCE;
        }
        ArrayList<ReferenceType> arrayList = result;
        if (arrayList == null) {
            JRubyPositionManager.$$$reportNull$$$0(1);
        }
        return arrayList;
    }

    private static void checkRFile(PsiFile file) throws NoDataException {
        if (!(file instanceof RFile)) {
            throw NoDataException.INSTANCE;
        }
    }

    private static boolean isMatchingFile(String path, VirtualFile vFile, Project project) {
        if (path.equals(FileUtil.toSystemDependentName((String)vFile.getPath()))) {
            return true;
        }
        VirtualFile sourceFile = VirtualFileManager.getInstance().findFileByUrl(VfsUtilCore.pathToUrl((String)path));
        for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
            VirtualFile srcFile = JRubyPositionManager.findSrcFile(sourceFile, module);
            if (!Comparing.equal((Object)srcFile, (Object)vFile)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public List<Location> locationsOfLine(@NotNull ReferenceType type, @NotNull SourcePosition position) throws NoDataException {
        List list;
        if (type == null) {
            JRubyPositionManager.$$$reportNull$$$0(2);
        }
        if (position == null) {
            JRubyPositionManager.$$$reportNull$$$0(3);
        }
        JRubyPositionManager.checkRFile(position.getFile());
        try {
            int line = position.getLine() + 1;
            List locations = DebuggerUtilsAsync.locationsOfLineSync((ReferenceType)type, (String)"Java", null, (int)line);
            if (locations == null || locations.isEmpty()) {
                throw NoDataException.INSTANCE;
            }
            list = locations;
        }
        catch (AbsentInformationException e) {
            throw NoDataException.INSTANCE;
        }
        if (list == null) {
            JRubyPositionManager.$$$reportNull$$$0(4);
        }
        return list;
    }

    public ClassPrepareRequest createPrepareRequest(@NotNull ClassPrepareRequestor requestor, @NotNull SourcePosition position) throws NoDataException {
        String qName;
        PsiFile file;
        if (requestor == null) {
            JRubyPositionManager.$$$reportNull$$$0(5);
        }
        if (position == null) {
            JRubyPositionManager.$$$reportNull$$$0(6);
        }
        if ((file = position.getFile()) instanceof RFile && (qName = JRubyPositionManager.getShortName(file)) != null) {
            return this.myDebugProcess.getRequestsManager().createClassPrepareRequest(requestor, "*" + qName);
        }
        throw NoDataException.INSTANCE;
    }

    private int calcLineIndex(Location location) {
        LOG.assertTrue(this.myDebugProcess != null);
        if (location == null) {
            return -1;
        }
        return DebuggerUtilsEx.getLineNumber((Location)location, (boolean)true);
    }

    private static String getPath(ReferenceType referenceType) throws AbsentInformationException, IOException {
        String debugInfo = referenceType.sourceDebugExtension();
        File sourceFile = new File(debugInfo);
        return sourceFile.getCanonicalPath();
    }

    @Nullable
    private static String getShortName(PsiFile rFile) {
        VirtualFile vFile = rFile.getVirtualFile();
        return vFile != null ? vFile.getNameWithoutExtension() : null;
    }

    @Nullable
    private static PsiFile getPsiFileByLocation(Project project, Location location) {
        if (location == null) {
            return null;
        }
        try {
            String fileName = JRubyPositionManager.getPath(location.declaringType());
            VirtualFile vFile = VirtualFileManager.getInstance().findFileByUrl(VfsUtilCore.pathToUrl((String)fileName));
            if (vFile == null) {
                return null;
            }
            for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
                VirtualFile srcFile = JRubyPositionManager.findSrcFile(vFile, module);
                if (srcFile == null) continue;
                return PsiManager.getInstance((Project)project).findFile(srcFile);
            }
            return PsiManager.getInstance((Project)project).findFile(vFile);
        }
        catch (AbsentInformationException | IOException | UnsupportedOperationException e) {
            return null;
        }
    }

    @Nullable
    private static VirtualFile findSrcFile(VirtualFile originalFile, Module module) {
        CompilerModuleExtension extension = CompilerModuleExtension.getInstance((Module)module);
        if (extension != null) {
            VirtualFile[] outputRoots;
            for (VirtualFile outputRoot : outputRoots = extension.getOutputRoots(true)) {
                String relativePathToOutputRoot = VfsUtilCore.getRelativePath((VirtualFile)originalFile, (VirtualFile)outputRoot, (char)'/');
                if (relativePathToOutputRoot == null) continue;
                return JRubyPositionManager.findCorrespondingSrcFile(originalFile, module, relativePathToOutputRoot);
            }
        }
        return null;
    }

    private static VirtualFile findCorrespondingSrcFile(VirtualFile originalFile, Module module, String relativePathToOutputRoot) {
        VirtualFile[] srcRoots;
        for (VirtualFile srcRoot : srcRoots = ModuleRootManager.getInstance((Module)module).getSourceRoots()) {
            VirtualFile srcFile = srcRoot.findFileByRelativePath(relativePathToOutputRoot);
            if (srcFile == null) continue;
            return srcFile;
        }
        return originalFile;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classPosition";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/java/jruby/debug/JRubyPositionManager";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requestor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/java/jruby/debug/JRubyPositionManager";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllClasses";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "locationsOfLine";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getAllClasses";
                break;
            }
            case 1: 
            case 4: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "locationsOfLine";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createPrepareRequest";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 4 -> new IllegalStateException(string);
        };
    }

    public static final class Factory
    extends PositionManagerFactory {
        @Nullable
        public PositionManager createPositionManager(@NotNull DebugProcess process) {
            if (process == null) {
                Factory.$$$reportNull$$$0(0);
            }
            return new JRubyPositionManager(process);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "process", "org/jetbrains/plugins/ruby/java/jruby/debug/JRubyPositionManager$Factory", "createPositionManager"));
        }
    }
}

