/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.java.jruby.codeInsight.references;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.PairProcessor;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.java.jruby.psi.JRubyCallTypeProvider;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyElementFactoryCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.basicTypes.stringLiterals.RBaseString;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RExpression;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.references.RReferenceNavigator;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.references.RReference;
import org.jetbrains.plugins.ruby.utils.NamingConventions;

public final class StringImportReferenceUtil {
    @Nullable
    public static RReference createReference(PsiElement context, String str) {
        RExpression generated = RubyElementFactoryCore.createExpressionFromText((PsiElement)context, (String)str);
        return generated instanceof RReference ? (RReference)generated : null;
    }

    public static void processImportString(@NotNull String str, @NotNull PairProcessor<? super String, ? super String> processor) {
        if (str == null) {
            StringImportReferenceUtil.$$$reportNull$$$0(0);
        }
        if (processor == null) {
            StringImportReferenceUtil.$$$reportNull$$$0(1);
        }
        String[] split = str.split("\\.");
        StringBuilder sb = new StringBuilder();
        for (int i = 1; i <= split.length; ++i) {
            processor.process((Object)sb.toString(), (Object)split[i - 1]);
            if (i != 1) {
                sb.append(".");
            }
            sb.append(split[i - 1]);
        }
    }

    @NotNull
    public static List<String> getParts(@NotNull String str) {
        if (str == null) {
            StringImportReferenceUtil.$$$reportNull$$$0(2);
        }
        List<String> list = Arrays.asList(str.split("\\."));
        if (list == null) {
            StringImportReferenceUtil.$$$reportNull$$$0(3);
        }
        return list;
    }

    public static boolean checkStringContent(@NotNull String str) {
        if (str == null) {
            StringImportReferenceUtil.$$$reportNull$$$0(4);
        }
        return !str.contains(":") && !StringUtil.startsWith((CharSequence)str, (CharSequence)"Java") && !str.endsWith(".") && !str.endsWith("::");
    }

    public static boolean isIntentionAvailable(Editor editor, PsiFile file) {
        RBaseString string = (RBaseString)PsiTreeUtil.getParentOfType((PsiElement)file.findElementAt(editor.getCaretModel().getOffset()), RBaseString.class);
        return StringImportReferenceUtil.checkBaseString(string);
    }

    public static boolean checkBaseString(@Nullable RBaseString string) {
        if (string == null) {
            return false;
        }
        String content = string.getContent();
        if (content == null || !StringImportReferenceUtil.checkStringContent(content)) {
            return false;
        }
        RCall rCall = (RCall)PsiTreeUtil.getParentOfType((PsiElement)string, RCall.class);
        if (rCall == null || !JRubyCallTypeProvider.isJrubyImportCallType(rCall.getCallType())) {
            return false;
        }
        List arguments = rCall.getArguments();
        PsiReference reference = RReferenceNavigator.getRightPsiReference((PsiElement)rCall);
        PsiElement resolve = reference != null ? reference.resolve() : null;
        return (resolve instanceof PsiClass || resolve instanceof PsiPackage) && !arguments.isEmpty() && string == arguments.get(0);
    }

    @NotNull
    public static String createCamelSnakeStringReference(String content) {
        List<String> parts = StringImportReferenceUtil.getParts(content);
        int size = parts.size();
        StringBuilder sb = new StringBuilder();
        sb.append("Java");
        sb.append("::");
        for (int i = 0; i < size - 1; ++i) {
            sb.append(NamingConventions.toCamelCase((String)parts.get(i)));
        }
        sb.append("::");
        sb.append(parts.get(size - 1));
        String string = sb.toString();
        if (string == null) {
            StringImportReferenceUtil.$$$reportNull$$$0(5);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "str";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/java/jruby/codeInsight/references/StringImportReferenceUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/java/jruby/codeInsight/references/StringImportReferenceUtil";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getParts";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createCamelSnakeStringReference";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "processImportString";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getParts";
                break;
            }
            case 3: 
            case 5: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "checkStringContent";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 5 -> new IllegalStateException(string);
        };
    }
}

