/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.java.jruby.codeInsight.references;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiReference;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ProcessingContext;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.java.jruby.codeInsight.references.StringImportReferenceUtil;
import org.jetbrains.plugins.ruby.java.jruby.symbols.JavaResolveUtil;
import org.jetbrains.plugins.ruby.java.jruby.symbols.RJavaClassSymbol;
import org.jetbrains.plugins.ruby.java.jruby.symbols.RJavaPackageSymbol;
import org.jetbrains.plugins.ruby.java.jruby.types.JavaSymbolTypes;
import org.jetbrains.plugins.ruby.ruby.codeInsight.RubyRenameHelper;
import org.jetbrains.plugins.ruby.ruby.codeInsight.completion.ReferenceCompletionUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.completion.RubyCompletionProviderUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.references.RQualifiedReference;
import org.jetbrains.plugins.ruby.ruby.codeInsight.references.RQualifiedReferenceBase;
import org.jetbrains.plugins.ruby.ruby.codeInsight.references.SymbolResolveResult;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.TypeSet;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.Symbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.SymbolUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.Context;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.ContextImpl;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.RType;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.RTypeFactory;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPossibleCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyElementFactoryCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtilCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.basicTypes.stringLiterals.RBaseString;

public class JRubyStringImportReference
extends RQualifiedReferenceBase {
    @NotNull
    private final RBaseString myWholeReference;
    @NotNull
    private final RPossibleCall myCall;

    public JRubyStringImportReference(@NotNull RPossibleCall call, @NotNull RBaseString wholeReference, @NotNull String prefixString, @NotNull String value) {
        if (call == null) {
            JRubyStringImportReference.$$$reportNull$$$0(0);
        }
        if (wholeReference == null) {
            JRubyStringImportReference.$$$reportNull$$$0(1);
        }
        if (prefixString == null) {
            JRubyStringImportReference.$$$reportNull$$$0(2);
        }
        if (value == null) {
            JRubyStringImportReference.$$$reportNull$$$0(3);
        }
        super(wholeReference.getProject(), prefixString, value);
        this.myWholeReference = wholeReference;
        this.myCall = call;
    }

    @NotNull
    protected Predicate<Symbol> createCompletionFilter(boolean getVariants) {
        Predicate<Symbol> filter = Symbol.Filter.byTypes((TypeSet)SymbolUtil.getMethodTypes()).or((Predicate)Symbol.Filter.byTypes((TypeSet)JavaSymbolTypes.JAVA_CLASS_OR_PACKAGE));
        Predicate<Symbol> predicate = getVariants ? RQualifiedReference.NAME_FILTER.and(filter) : filter;
        if (predicate == null) {
            JRubyStringImportReference.$$$reportNull$$$0(4);
        }
        return predicate;
    }

    @NotNull
    public RType getRefObjectType() {
        RType rType = RTypeFactory.createNotTypedObjectSymbolType((Project)this.getProject());
        if (rType == null) {
            JRubyStringImportReference.$$$reportNull$$$0(5);
        }
        return rType;
    }

    @NotNull
    public PsiElement getElement() {
        RPossibleCall rPossibleCall = this.myCall;
        if (rPossibleCall == null) {
            JRubyStringImportReference.$$$reportNull$$$0(6);
        }
        return rPossibleCall;
    }

    @NotNull
    public TextRange getRangeInElement() {
        int prefixLen = this.myQualifier.length();
        int startFault = prefixLen != 0 ? 2 + prefixLen : 1;
        int relativeStartOffset = this.myWholeReference.getTextRange().getStartOffset() - this.myCall.getTextRange().getStartOffset() + startFault;
        TextRange textRange = TextRange.from((int)relativeStartOffset, (int)this.myName.length());
        if (textRange == null) {
            JRubyStringImportReference.$$$reportNull$$$0(7);
        }
        return textRange;
    }

    @NotNull
    public String getCanonicalText() {
        String string = this.myName;
        if (string == null) {
            JRubyStringImportReference.$$$reportNull$$$0(8);
        }
        return string;
    }

    public PsiElement handleElementRename(@NotNull String newName) throws IncorrectOperationException {
        if (newName == null) {
            JRubyStringImportReference.$$$reportNull$$$0(9);
        }
        this.checkName(newName);
        for (RubyRenameHelper helper : RubyRenameHelper.EP_NAME.getExtensionList()) {
            String nameFromHelper = helper.calculateNewName((PsiReference)this, this.myName, newName);
            if (nameFromHelper == null) continue;
            newName = nameFromHelper;
            break;
        }
        RPsiElement element = RubyElementFactoryCore.createElementFromText((PsiElement)this.myWholeReference, (String)newName);
        RubyPsiUtilCore.replaceInParent((PsiElement)this.myWholeReference, (PsiElement)element);
        return element;
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            JRubyStringImportReference.$$$reportNull$$$0(10);
        }
        for (RubyRenameHelper helper : RubyRenameHelper.EP_NAME.getExtensionList()) {
            String text = helper.calculateTextFromElement((PsiReference)this, element);
            if (text == null) continue;
            RPsiElement newElement = RubyElementFactoryCore.createElementFromText((PsiElement)this.getElement(), (String)("'" + text + "'"));
            return this.myWholeReference.replace((PsiElement)newElement);
        }
        if (element instanceof PsiNamedElement) {
            this.handleElementRename(((PsiNamedElement)element).getName());
        }
        return null;
    }

    public PsiElement resolve() {
        ArrayList<String> list = new ArrayList<String>(StringImportReferenceUtil.getParts(this.myQualifier));
        list.add(this.myName);
        Pair<Symbol, RType> result = this.getQualifierSymbol(list);
        return result != null ? ((Symbol)result.getFirst()).getPsiElement() : null;
    }

    @Nullable
    private Pair<Symbol, RType> getQualifierSymbol(List<String> list) {
        String name;
        PsiElement element = JavaResolveUtil.getPsiElement(this.getProject(), list, (PsiElement)this.myCall);
        Pair result = null;
        if (element instanceof PsiPackage) {
            String name2 = ((PsiPackage)element).getName();
            if (name2 != null) {
                RJavaPackageSymbol symbol = new RJavaPackageSymbol((PsiPackage)element, name2);
                result = new Pair((Object)symbol, (Object)symbol.getType((Context)ContextImpl.getContext((PsiElement)element)));
            }
        } else if (element instanceof PsiClass && (name = ((PsiClass)element).getName()) != null) {
            RJavaClassSymbol symbol = new RJavaClassSymbol((PsiClass)element, name);
            result = new Pair((Object)symbol, (Object)symbol.getType((Context)ContextImpl.getContext((PsiElement)element)));
        }
        return result;
    }

    public void addCompletions(@NotNull CompletionParameters parameters, ProcessingContext context, @NotNull CompletionResultSet result) {
        if (parameters == null) {
            JRubyStringImportReference.$$$reportNull$$$0(11);
        }
        if (result == null) {
            JRubyStringImportReference.$$$reportNull$$$0(12);
        }
        String prefixText = this.myName;
        prefixText = StringUtil.trimEnd((String)prefixText, (String)"IntellijIdeaRulezzz");
        Pair<Symbol, RType> pair = this.getQualifierSymbol(StringImportReferenceUtil.getParts(this.myQualifier));
        RType type = pair != null ? (RType)pair.getSecond() : this.getRefObjectType();
        Ref gotSomething = Ref.create((Object)false);
        ReferenceCompletionUtil.addLookupItemsByType((RType)type, this.createCompletionFilter(true).and(RubyCompletionProviderUtil.symbolNamePrefixFilter((CompletionResultSet)result)), (String)prefixText, (boolean)true, (PsiElement)this.getElement(), variant -> {
            gotSomething.set((Object)true);
            result.addElement(variant);
        });
        if (!((Boolean)gotSomething.get()).booleanValue()) {
            super.addCompletions(parameters, context, result);
        }
    }

    @NotNull
    public SymbolResolveResult resolveToSymbol() {
        RType type;
        ProgressManager.checkCanceled();
        Pair<Symbol, RType> pair = this.getQualifierSymbol(StringImportReferenceUtil.getParts(this.myQualifier));
        RType rType = type = pair != null ? (RType)pair.getSecond() : this.getRefObjectType();
        if (pair != null && type != null) {
            SymbolResolveResult symbolResolveResult = SymbolResolveResult.create((Symbol)((Symbol)pair.getFirst()), (boolean)type.isTyped());
            if (symbolResolveResult == null) {
                JRubyStringImportReference.$$$reportNull$$$0(13);
            }
            return symbolResolveResult;
        }
        SymbolResolveResult symbolResolveResult = super.resolveToSymbol();
        if (symbolResolveResult == null) {
            JRubyStringImportReference.$$$reportNull$$$0(14);
        }
        return symbolResolveResult;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        JRubyStringImportReference reference = (JRubyStringImportReference)((Object)o);
        return Objects.equals(this.myWholeReference, reference.myWholeReference) && Objects.equals(this.myCall, reference.myCall);
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.myWholeReference.hashCode();
        result = 31 * result + this.myCall.hashCode();
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 6, 7, 8, 13, 14 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "wholeReference";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefixString";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/java/jruby/codeInsight/references/JRubyStringImportReference";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/java/jruby/codeInsight/references/JRubyStringImportReference";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createCompletionFilter";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getRefObjectType";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getElement";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getRangeInElement";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getCanonicalText";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveToSymbol";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 13: 
            case 14: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "handleElementRename";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "bindToElement";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "addCompletions";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5, 6, 7, 8, 13, 14 -> new IllegalStateException(string);
        };
    }
}

