/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.java.jruby.codeInsight.implement;

import com.intellij.codeInsight.generation.ClassMember;
import com.intellij.codeInsight.generation.PsiMethodMember;
import com.intellij.ide.util.MemberChooser;
import com.intellij.lang.LanguageCodeInsightActionHandler;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.java.jruby.types.JavaSymbolTypes;
import org.jetbrains.plugins.ruby.ruby.actions.RubyGotoSuperHandler;
import org.jetbrains.plugins.ruby.ruby.actions.override.RubyOverrideHandler;
import org.jetbrains.plugins.ruby.ruby.codeInsight.OverriddenMethodGenerator;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.Type;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.TypeSet;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.Symbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.SymbolUtil;

public final class JRubyImplementHandler
implements LanguageCodeInsightActionHandler {
    public boolean isValidFor(Editor editor, PsiFile file) {
        return RubyGotoSuperHandler.findElementAndSymbol((Editor)editor, (PsiFile)file, (boolean)true) != null;
    }

    public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile psiFile) {
        Pair elementAndSymbol;
        if (project == null) {
            JRubyImplementHandler.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            JRubyImplementHandler.$$$reportNull$$$0(1);
        }
        if (psiFile == null) {
            JRubyImplementHandler.$$$reportNull$$$0(2);
        }
        if ((elementAndSymbol = RubyGotoSuperHandler.findElementAndSymbol((Editor)editor, (PsiFile)psiFile, (boolean)true)) != null) {
            JRubyImplementHandler.execute(editor, project, (PsiElement)elementAndSymbol.first, (Symbol)elementAndSymbol.second);
        }
    }

    public boolean startInWriteAction() {
        return false;
    }

    @NotNull
    public static List<ClassMember> createImplementMembers(@NotNull Symbol classSymbol) {
        if (classSymbol == null) {
            JRubyImplementHandler.$$$reportNull$$$0(3);
        }
        ArrayList<ClassMember> result = new ArrayList<ClassMember>();
        HashSet seenNames = new HashSet();
        TypeSet overridableTypes = OverriddenMethodGenerator.getOverridableTypes();
        PsiElement element = classSymbol.getPsiElement();
        SymbolUtil.processMembers((Symbol)classSymbol, (Predicate)Symbol.Filter.byTypes((TypeSet)overridableTypes), (PsiElement)element, method -> {
            String name = method.getName();
            if (method.getType() == JavaSymbolTypes.JAVA_METHOD) {
                PsiElement psiMethod = method.getPsiElement();
                if (psiMethod != null && !JRubyImplementHandler.isAbstract((PsiMethod)psiMethod)) {
                    seenNames.add(name);
                    seenNames.add(((NavigationItem)psiMethod).getName());
                }
            } else {
                seenNames.add(name);
            }
            return true;
        });
        MultiMap memberToClass = new MultiMap();
        LinkedHashSet containingClasses = new LinkedHashSet();
        SymbolUtil.processMembers((Symbol)classSymbol, (Predicate)Symbol.Filter.byType((Type)JavaSymbolTypes.JAVA_METHOD), (PsiElement)element, methodSymbol -> {
            PsiClass aClass;
            PsiMethod psiMethod = (PsiMethod)methodSymbol.getPsiElement();
            assert (psiMethod != null);
            String name = psiMethod.getName();
            if (!seenNames.contains(name) && JRubyImplementHandler.isAbstract(psiMethod) && (aClass = psiMethod.getContainingClass()) != null) {
                String fqn = aClass.getQualifiedName();
                containingClasses.add(fqn);
                memberToClass.putValue((Object)fqn, (Object)psiMethod);
                seenNames.add(name);
            }
            return true;
        });
        for (String fqn : containingClasses) {
            List members = (List)memberToClass.get((Object)fqn);
            members.sort(Comparator.comparingInt(PsiElement::getTextOffset));
            for (PsiMethod member : members) {
                result.add((ClassMember)new PsiMethodMember(member));
            }
        }
        ArrayList<ClassMember> arrayList = result;
        if (arrayList == null) {
            JRubyImplementHandler.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    private static boolean isAbstract(PsiMethod method) {
        return method.isValid() && method.hasModifierProperty("abstract");
    }

    public static void execute(@NotNull Editor editor, @NotNull Project project, @Nullable PsiElement element, @NotNull Symbol symbol) {
        List selectedMembers;
        if (editor == null) {
            JRubyImplementHandler.$$$reportNull$$$0(5);
        }
        if (project == null) {
            JRubyImplementHandler.$$$reportNull$$$0(6);
        }
        if (symbol == null) {
            JRubyImplementHandler.$$$reportNull$$$0(7);
        }
        List implementMembers = JRubyImplementHandler.createImplementMembers(symbol);
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            selectedMembers = implementMembers;
        } else {
            ClassMember[] primaryElements = new ClassMember[implementMembers.size()];
            MemberChooser chooser = new MemberChooser(implementMembers.toArray(primaryElements), false, true, project);
            chooser.setTitle(RBundle.message((String)"refactoring.implement.java.methods.title"));
            chooser.setCopyJavadocVisible(false);
            chooser.selectElements(primaryElements);
            if (!chooser.showAndGet()) {
                return;
            }
            selectedMembers = chooser.getSelectedElements();
        }
        assert (element != null);
        if (selectedMembers != null) {
            RubyOverrideHandler.generateAndInsert((Project)project, (Editor)editor, (PsiFile)element.getContainingFile(), (int)element.getTextOffset(), selectedMembers);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classSymbol";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/java/jruby/codeInsight/implement/JRubyImplementHandler";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbol";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/java/jruby/codeInsight/implement/JRubyImplementHandler";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createImplementMembers";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createImplementMembers";
                break;
            }
            case 4: {
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "execute";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4 -> new IllegalStateException(string);
        };
    }
}

