/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.java.jruby.codeInsight.completion;

import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPackage;
import com.intellij.ui.IconManager;
import com.intellij.ui.icons.RowIcon;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.java.jruby.symbols.JavaLookupElement;
import org.jetbrains.plugins.ruby.java.jruby.symbols.JavaMethodLookupElement;
import org.jetbrains.plugins.ruby.java.jruby.symbols.JavaResolveUtil;
import org.jetbrains.plugins.ruby.java.jruby.symbols.RJavaClassSymbol;
import org.jetbrains.plugins.ruby.java.jruby.symbols.RJavaFieldSymbol;
import org.jetbrains.plugins.ruby.java.jruby.symbols.RJavaMethodSymbol;
import org.jetbrains.plugins.ruby.java.jruby.symbols.RJavaPackageSymbol;
import org.jetbrains.plugins.ruby.java.jruby.types.JavaSymbolTypes;
import org.jetbrains.plugins.ruby.ruby.codeInsight.completion.CompletionResolveContext;
import org.jetbrains.plugins.ruby.ruby.codeInsight.completion.MethodInsertHandlerCreator;
import org.jetbrains.plugins.ruby.ruby.codeInsight.completion.ReferenceCompletionUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.completion.RubyCompletionGrouping;
import org.jetbrains.plugins.ruby.ruby.codeInsight.completion.RubyCompletionProvider;
import org.jetbrains.plugins.ruby.ruby.codeInsight.completion.RubyLookupElement;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.Type;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.TypeSet;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.fqn.FQN;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.MultiSymbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.PsiElementSymbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.Symbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.RType;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.references.RReference;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RConstant;

public final class JRubyCompletionProvider
extends RubyCompletionProvider {
    public LookupElement createLookupItem(@NotNull Symbol symbol, String name, boolean bold, @Nullable Symbol typeSourceSymbol, RType originalType, boolean isInsertHandlerCanBeApplied, MethodInsertHandlerCreator insertHandler, FQN symbolFQN) {
        if (symbol == null) {
            JRubyCompletionProvider.$$$reportNull$$$0(0);
        }
        Type type = symbol.getType();
        if (name == null || StringUtil.isEmpty((String)name)) {
            return null;
        }
        LookupElement element = JRubyCompletionProvider.createLookupItemImpl(symbol, name, type);
        return element == null ? null : PrioritizedLookupElement.withPriority((LookupElement)element, (double)RubyCompletionGrouping.BOLDED.getValue());
    }

    @Nullable
    private static LookupElement createLookupItemImpl(Symbol symbol, String name, Type type) {
        if ("java".equals(name)) {
            PsiElement element = JavaResolveUtil.getPsiElement(symbol.getProject(), Collections.singletonList("java"), null);
            return element != null ? new JavaLookupElement(name, element) : null;
        }
        if (symbol instanceof MultiSymbol) {
            Symbol s = (Symbol)ContainerUtil.getFirstItem((List)((MultiSymbol)symbol).getSymbols());
            if (s instanceof PsiElementSymbol) {
                RowIcon icon = IconManager.getInstance().createRowIcon(2);
                icon.setIcon(AllIcons.General.AddJdk, 0);
                icon.setIcon(((PsiElementSymbol)s).getPsiElement().getIcon(0), 1);
                return new RubyLookupElement(name, null, "...", true, (Icon)icon, null);
            }
            return null;
        }
        if (type == JavaSymbolTypes.JAVA_CLASS) {
            RJavaClassSymbol classSymbol = (RJavaClassSymbol)symbol;
            PsiClass psiClass = (PsiClass)classSymbol.getPsiElement();
            return new JavaLookupElement(name, (PsiElement)psiClass);
        }
        if (type == JavaSymbolTypes.JAVA_PACKAGE) {
            RJavaPackageSymbol packageSymbol = (RJavaPackageSymbol)symbol;
            PsiPackage psiPackage = (PsiPackage)packageSymbol.getPsiElement();
            return new JavaLookupElement(name, (PsiElement)psiPackage);
        }
        if (type == JavaSymbolTypes.JAVA_METHOD) {
            RJavaMethodSymbol methodSymbol = (RJavaMethodSymbol)symbol;
            PsiMethod psiMethod = (PsiMethod)methodSymbol.getPsiElement();
            return new JavaMethodLookupElement(name, psiMethod);
        }
        if (type == JavaSymbolTypes.JAVA_FIELD) {
            RJavaFieldSymbol fieldSymbol = (RJavaFieldSymbol)symbol;
            PsiField element = (PsiField)fieldSymbol.getPsiElement();
            return new JavaLookupElement(name, (PsiElement)element);
        }
        return null;
    }

    protected Predicate<Symbol> getCompletionFilter(RPsiElement element) {
        CompletionResolveContext completionResolveContext = ReferenceCompletionUtil.getContextType((PsiElement)element);
        if (completionResolveContext != null || JRubyCompletionProvider.isJavaImportReference(element)) {
            return Symbol.Filter.byTypes((TypeSet)JavaSymbolTypes.JAVA_CLASS_OR_PACKAGE).or((Predicate)Symbol.Filter.byType((Type)JavaSymbolTypes.JAVA_PRIMITIVE));
        }
        return Symbol.Filter.byTypes((TypeSet)JavaSymbolTypes.ALL_JAVA_TYPES);
    }

    private static boolean isJavaImportReference(RPsiElement element) {
        if (!(element instanceof RReference)) {
            return false;
        }
        RReference reference = (RReference)element;
        RPsiElement receiver = reference.getReceiver();
        return receiver instanceof RConstant && "Java".equals(receiver.getName());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "symbol", "org/jetbrains/plugins/ruby/java/jruby/codeInsight/completion/JRubyCompletionProvider", "createLookupItem"));
    }
}

