/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.java.jruby;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReference;
import org.jetbrains.plugins.ruby.ruby.codeInsight.RubyRenameHelper;
import org.jetbrains.plugins.ruby.utils.NamingConventions;

public final class JRubyRenameHelper
implements RubyRenameHelper {
    public String calculateNewName(PsiReference reference, String oldReferenceName, String newElementName) {
        PsiElement element = reference.resolve();
        if (element instanceof PsiMethod) {
            String prefix;
            String oldElementName = ((PsiMethod)element).getName();
            if (oldReferenceName.equals(NamingConventions.toUnderscoreCase((String)oldElementName))) {
                return NamingConventions.toUnderscoreCase((String)newElementName);
            }
            if ((oldElementName.startsWith("get") || oldElementName.startsWith("set")) && newElementName.startsWith(prefix = oldElementName.substring(0, 3))) {
                String shortName = StringUtil.decapitalize((String)oldElementName.substring(3));
                if (shortName.equals(oldReferenceName)) {
                    return StringUtil.decapitalize((String)newElementName.substring(3));
                }
                if (NamingConventions.toUnderscoreCase((String)shortName).equals(oldReferenceName)) {
                    return NamingConventions.toUnderscoreCase((String)StringUtil.decapitalize((String)newElementName.substring(3)));
                }
            }
        }
        return null;
    }

    public String calculateTextFromElement(PsiReference reference, PsiElement newTarget) {
        if (newTarget instanceof PsiClass) {
            return ((PsiClass)newTarget).getQualifiedName();
        }
        return null;
    }
}

