/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.java.jruby;

import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.utils.NamingConventions;

public final class JRubyNameConventions {
    private JRubyNameConventions() {
    }

    @NotNull
    public static Collection<String> getRubyNames(@NotNull String name) {
        if (name == null) {
            JRubyNameConventions.$$$reportNull$$$0(0);
        }
        ArrayList<String> result = new ArrayList<String>();
        String s = NamingConventions.toUnderscoreCase((String)name, (boolean)false);
        if (!s.equals(name)) {
            result.add(s);
        }
        Object propName = null;
        if (name.startsWith("get")) {
            propName = StringUtil.decapitalize((String)name.substring(3));
        } else if (name.startsWith("set")) {
            propName = StringUtil.decapitalize((String)name.substring(3)) + "=";
        }
        if (propName != null) {
            result.add((String)propName);
            String propNameUnderscore = NamingConventions.toUnderscoreCase((String)propName, (boolean)false);
            if (!propNameUnderscore.equals(propName)) {
                result.add(propNameUnderscore);
            }
        }
        ArrayList<String> arrayList = result;
        if (arrayList == null) {
            JRubyNameConventions.$$$reportNull$$$0(1);
        }
        return arrayList;
    }

    @NotNull
    public static Collection<String> getJavaNames(@Nullable String name) {
        String newName;
        if (name == null) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                JRubyNameConventions.$$$reportNull$$$0(2);
            }
            return list;
        }
        if (NamingConventions.isInUnderscoredCase((String)name) && !name.equals(newName = StringUtil.decapitalize((String)NamingConventions.toCamelCase((String)name)))) {
            List<String> list = Arrays.asList(name, newName);
            if (list == null) {
                JRubyNameConventions.$$$reportNull$$$0(3);
            }
            return list;
        }
        Set<String> set = Collections.singleton(name);
        if (set == null) {
            JRubyNameConventions.$$$reportNull$$$0(4);
        }
        return set;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/java/jruby/JRubyNameConventions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/java/jruby/JRubyNameConventions";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getRubyNames";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getJavaNames";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getRubyNames";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 4 -> new IllegalStateException(string);
        };
    }
}

