/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.java.jruby;

import com.intellij.codeInsight.daemon.impl.ShowAutoImportPass;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.codeInsight.hint.QuestionAction;
import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.codeInspection.HintAction;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.IncorrectOperationException;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.java.jruby.psi.JRubyCallTypeProvider;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RFile;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyElementFactoryCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.blocks.RCompoundStatement;

public class JRubyAutoImportAction
implements HintAction,
QuestionAction {
    private final RPsiElement myUnresolvedReferenceElement;
    private final PsiClass[] myClasses;

    public JRubyAutoImportAction(RPsiElement unresolvedReferenceElement, PsiClass[] classes) {
        this.myUnresolvedReferenceElement = unresolvedReferenceElement;
        this.myClasses = classes;
    }

    public boolean showHint(@NotNull Editor editor) {
        if (editor == null) {
            JRubyAutoImportAction.$$$reportNull$$$0(0);
        }
        String hintText = ShowAutoImportPass.getMessage((boolean)false, (String)RBundle.message((String)"class"), (String)this.myClasses[0].getQualifiedName());
        HintManager.getInstance().showQuestionHint(editor, hintText, this.myUnresolvedReferenceElement.getTextRange().getStartOffset(), this.myUnresolvedReferenceElement.getTextRange().getEndOffset(), (QuestionAction)this);
        return true;
    }

    @NotNull
    public String getText() {
        String string = RBundle.message((String)"jruby.action.import.java.class.text");
        if (string == null) {
            JRubyAutoImportAction.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = RBundle.message((String)"jruby.action.import.java.class.familyName");
        if (string == null) {
            JRubyAutoImportAction.$$$reportNull$$$0(2);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile psiFile) {
        if (project == null) {
            JRubyAutoImportAction.$$$reportNull$$$0(3);
        }
        return true;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile psiFile) throws IncorrectOperationException {
        if (project == null) {
            JRubyAutoImportAction.$$$reportNull$$$0(4);
        }
    }

    @NotNull
    public IntentionPreviewInfo generatePreview(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile psiFile) {
        if (project == null) {
            JRubyAutoImportAction.$$$reportNull$$$0(5);
        }
        if (editor == null) {
            JRubyAutoImportAction.$$$reportNull$$$0(6);
        }
        if (psiFile == null) {
            JRubyAutoImportAction.$$$reportNull$$$0(7);
        }
        IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.EMPTY;
        if (intentionPreviewInfo == null) {
            JRubyAutoImportAction.$$$reportNull$$$0(8);
        }
        return intentionPreviewInfo;
    }

    public boolean startInWriteAction() {
        return false;
    }

    public boolean execute() {
        Project project = this.myUnresolvedReferenceElement.getProject();
        WriteCommandAction.writeCommandAction((Project)project, (PsiFile[])new PsiFile[]{this.myUnresolvedReferenceElement.getContainingFile()}).run(() -> {
            PsiElement anchorStatement = JRubyAutoImportAction.findAnchorStatement(this.myUnresolvedReferenceElement);
            RFile rFile = RubyElementFactoryCore.createRubyFile((Project)project, (String)(JRubyCallTypeProvider.JAVA_IMPORT_CALL.getCommandName() + this.myClasses[0].getQualifiedName() + "\n"));
            List elementList = rFile.getStatements();
            ASTNode[] astNodes = rFile.getNode().getChildren(null);
            RubyPsiUtil.addBeforeInParent((PsiElement)anchorStatement, (PsiElement[])new PsiElement[]{(PsiElement)elementList.get(0), astNodes[1].getPsi()});
        });
        return true;
    }

    private static PsiElement findAnchorStatement(RPsiElement unresolvedReferenceElement) {
        RPsiElement result = unresolvedReferenceElement;
        while (!(result.getParent() instanceof RCompoundStatement)) {
            result = result.getParent();
        }
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: 
            case 2: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/java/jruby/JRubyAutoImportAction";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/java/jruby/JRubyAutoImportAction";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "generatePreview";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "showHint";
                break;
            }
            case 1: 
            case 2: 
            case 8: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "generatePreview";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 8 -> new IllegalStateException(string);
        };
    }
}

