/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.refactoring.move;

import com.intellij.codeInsight.editorActions.moveUpDown.LineMover;
import com.intellij.codeInsight.editorActions.moveUpDown.LineRange;
import com.intellij.codeInsight.editorActions.moveUpDown.StatementUpDownMover;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.lang.documentation.RubyCommentsUtilCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RFile;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyCommonPsiUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtilCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.RCaseStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.RCondition;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.RIfStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.RUnlessStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.RUntilStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.RWhenCase;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.RWhileStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.blocks.RBodyStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.blocks.RCompoundStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.blocks.RElseBlock;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.blocks.RElsifBlock;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.blocks.RRescueBlock;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RArgument;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.names.RName;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.names.RSuperClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RContainer;
import org.jetbrains.plugins.ruby.ruby.lang.psi.iterators.RBlockCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.iterators.RCodeBlock;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RIdentifier;

public final class RubyStatementUpDownMover
extends LineMover {
    private static boolean checkBoundaries(@NotNull Editor editor, LineRange range, boolean down) {
        if (editor == null) {
            RubyStatementUpDownMover.$$$reportNull$$$0(0);
        }
        int maxLine = editor.offsetToLogicalPosition((int)editor.getDocument().getTextLength()).line;
        if (range.startLine == 0 && !down) {
            return false;
        }
        return range.endLine <= maxLine || !down;
    }

    public boolean checkAvailable(@NotNull Editor editor, @NotNull PsiFile file, @NotNull StatementUpDownMover.MoveInfo info, boolean down) {
        List comments;
        if (editor == null) {
            RubyStatementUpDownMover.$$$reportNull$$$0(1);
        }
        if (file == null) {
            RubyStatementUpDownMover.$$$reportNull$$$0(2);
        }
        if (info == null) {
            RubyStatementUpDownMover.$$$reportNull$$$0(3);
        }
        if (!(file instanceof RFile)) {
            return false;
        }
        if (editor.getSelectionModel().hasSelection()) {
            return super.checkAvailable(editor, file, info, down);
        }
        LineRange range = RubyStatementUpDownMover.getLineRangeFromSelection((Editor)editor);
        if (!RubyStatementUpDownMover.checkBoundaries(editor, range, down)) {
            return false;
        }
        int nearLine = down ? range.endLine : range.startLine - 1;
        info.toMove = range;
        info.toMove2 = new LineRange(nearLine, nearLine + 1);
        Document document = editor.getDocument();
        RPsiElement statement = RubyStatementUpDownMover.expandToStatement(file, document, info.toMove);
        if (statement == null) {
            info.toMove2 = null;
            return true;
        }
        range = statement instanceof RContainer ? new LineRange((PsiElement)(!(comments = RubyCommentsUtilCore.getPsiComments((PsiElement)statement)).isEmpty() ? (PsiElement)comments.get(0) : statement), (PsiElement)statement, document) : new LineRange((PsiElement)statement, (PsiElement)statement, document);
        info.toMove = range;
        int maxLine = editor.offsetToLogicalPosition((int)editor.getDocument().getTextLength()).line;
        if (range.startLine == 0 && !down || range.endLine > maxLine && down) {
            info.toMove2 = null;
            return true;
        }
        nearLine = down ? range.endLine : range.startLine - 1;
        info.toMove2 = new LineRange(nearLine, nearLine + 1);
        String lineText = document.getCharsSequence().subSequence(document.getLineStartOffset(info.toMove2.startLine), document.getLineEndOffset(info.toMove2.startLine)).toString();
        if (StringUtil.isEmptyOrSpaces((String)lineText) || lineText.trim().startsWith("#") && !(statement instanceof RContainer)) {
            return true;
        }
        if (statement instanceof RContainer) {
            PsiElement element;
            PsiElement psiElement = element = down ? RubyPsiUtilCore.getSignificantLeafToTheRight((PsiElement)file.findElementAt(document.getLineStartOffset(info.toMove2.startLine))) : RubyCommonPsiUtil.getSignificantLeafToTheLeft((PsiElement)file.findElementAt(document.getLineEndOffset(info.toMove2.startLine)));
            if (element == null) {
                return true;
            }
            PsiElement child = RubyPsiUtilCore.getCompoundStatementChild((RCompoundStatement)((RCompoundStatement)statement.getParent()), (PsiElement)element);
            if (child == null) {
                return true;
            }
            if (child instanceof RContainer && !(!down ? PsiTreeUtil.getPrevSiblingOfType((PsiElement)statement, RContainer.class) == child : PsiTreeUtil.getNextSiblingOfType((PsiElement)statement, RContainer.class) == child)) {
                return true;
            }
            List comments2 = RubyCommentsUtilCore.getPsiComments((PsiElement)child);
            info.toMove2 = new LineRange(!comments2.isEmpty() ? (PsiElement)comments2.get(0) : child, child, document);
        } else {
            PsiElement element;
            PsiElement psiElement = element = down ? RubyCommonPsiUtil.getSignificantLeafToTheLeft((PsiElement)file.findElementAt(document.getLineEndOffset(info.toMove2.startLine))) : RubyPsiUtilCore.getSignificantLeafToTheRight((PsiElement)file.findElementAt(document.getLineStartOffset(info.toMove2.startLine)));
            if (element == null) {
                return true;
            }
            if ((element = RubyPsiUtilCore.getCoveringRPsiElement((PsiElement)element)) == null) {
                return true;
            }
            PsiElement parent = element.getParent();
            if (parent instanceof RContainer || parent instanceof RSuperClass || parent instanceof RName || RubyPsiUtilCore.isRClassName((PsiElement)parent) || PsiTreeUtil.getParentOfType((PsiElement)parent, RCondition.class, (boolean)false) != null || element instanceof RIdentifier && parent instanceof RArgument || parent instanceof RCompoundStatement || parent instanceof RBodyStatement || parent instanceof RCodeBlock || parent instanceof RCaseStatement || parent instanceof RIfStatement || parent instanceof RUnlessStatement || parent instanceof RWhileStatement || parent instanceof RUntilStatement || parent instanceof RElseBlock || parent instanceof RElsifBlock || parent instanceof RRescueBlock || parent instanceof RWhenCase || parent instanceof RBlockCall) {
                return true;
            }
            PsiElement child = RubyPsiUtilCore.getCompoundStatementChild((RCompoundStatement)RubyPsiUtilCore.getCompoundStatement((PsiElement)element), (PsiElement)element);
            if (child == null) {
                return true;
            }
            PsiElement firstLeaf = PsiTreeUtil.getDeepestFirst((PsiElement)child);
            PsiElement lastLeaf = PsiTreeUtil.getDeepestLast((PsiElement)child);
            info.toMove2 = PsiTreeUtil.isAncestor((PsiElement)child, (PsiElement)statement, (boolean)false) ? (down ? new LineRange(lastLeaf, lastLeaf, document) : new LineRange(firstLeaf, firstLeaf, document)) : new LineRange(firstLeaf, lastLeaf, document);
        }
        return true;
    }

    @Nullable
    private static RPsiElement expandToStatement(PsiFile file, Document document, LineRange lineRange) {
        PsiElement firstElement = file.findElementAt(RubyStatementUpDownMover.getLineStartSafeOffset((Document)document, (int)lineRange.startLine));
        PsiElement lastElement = file.findElementAt(RubyStatementUpDownMover.getLineStartSafeOffset((Document)document, (int)lineRange.endLine) - 1);
        if (firstElement == null || lastElement == null) {
            return null;
        }
        firstElement = RubyPsiUtilCore.getSignificantLeafToTheRight((PsiElement)firstElement);
        lastElement = RubyCommonPsiUtil.getSignificantLeafToTheLeft((PsiElement)lastElement);
        if (firstElement == null || lastElement == null || !RubyPsiUtilCore.isBefore((PsiElement)firstElement, (PsiElement)lastElement)) {
            return null;
        }
        PsiElement parent = PsiTreeUtil.findCommonParent((PsiElement)firstElement, (PsiElement)lastElement);
        if (parent == null) {
            return null;
        }
        RPsiElement statement = RubyPsiUtilCore.getStatement((PsiElement)parent);
        if (statement == null) {
            return null;
        }
        return PsiTreeUtil.getDeepestFirst((PsiElement)statement) == firstElement ? statement : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/refactoring/move/RubyStatementUpDownMover";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "checkBoundaries";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "checkAvailable";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

