/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.actions.intention.blocks;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPossibleCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyElementFactoryCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtilCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.RBlockStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.blocks.RBodyStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.blocks.RCompoundStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RBlockArgumentList;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.iterators.RBlockCallNavigator;
import org.jetbrains.plugins.ruby.ruby.lang.psi.iterators.RBlockCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.iterators.RCodeBlock;
import org.jetbrains.plugins.ruby.ruby.lang.psi.iterators.RDoCodeBlock;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.ruby19.controlStructures.RLambda;
import org.jetbrains.plugins.ruby.ruby.sdk.LanguageLevel;

public final class BraceConverter {
    private static final Logger LOG = Logger.getInstance(BraceConverter.class);

    private BraceConverter() {
    }

    public static void replaceBlock(@NotNull Project project, @NotNull PsiElement element, @NotNull Class<? extends RCodeBlock> type) {
        RCodeBlock block;
        if (project == null) {
            BraceConverter.$$$reportNull$$$0(0);
        }
        if (element == null) {
            BraceConverter.$$$reportNull$$$0(1);
        }
        if (type == null) {
            BraceConverter.$$$reportNull$$$0(2);
        }
        if ((block = (RCodeBlock)PsiTreeUtil.getParentOfType((PsiElement)element, type, (boolean)false)) == null) {
            LOG.debug("No block found for ", new Object[]{element, "; blockType: ", type});
            return;
        }
        String newBlockText = type == RDoCodeBlock.class ? BraceConverter.buildBraceBlockText(block) : BraceConverter.buildDoBlockText(block);
        PsiElement blockParent = block.getParent();
        LanguageLevel languageLevel = Objects.requireNonNullElse(block.getLanguageLevel(), LanguageLevel.latest());
        if (blockParent instanceof RLambda) {
            block.replace((PsiElement)RubyElementFactoryCore.createCodeBlockFromText((Project)project, (String)newBlockText, (LanguageLevel)languageLevel));
            return;
        }
        RBlockCall blockCall = RBlockCallNavigator.getByBlock((RCodeBlock)block);
        if (blockCall == null) {
            LOG.debug("No block call found for ", new Object[]{element, "; block type: ", type});
            return;
        }
        int blockCallStartOffset = blockCall.getTextRange().getStartOffset();
        TextRange blockRangeInBlockCall = block.getTextRange().shiftLeft(blockCallStartOffset);
        String newBlockCallText = blockRangeInBlockCall.replace(blockCall.getText(), newBlockText);
        RPossibleCall call = ((RBlockCall)blockParent).getCall();
        if (type == RDoCodeBlock.class && call instanceof RCall) {
            TextRange rcallTextRange = call.getTextRange().shiftLeft(blockCallStartOffset);
            newBlockCallText = rcallTextRange.replace(newBlockCallText, ((RCall)call).getPsiCommand().getText() + "(" + ((RCall)call).getCallArguments().getText() + ")");
        }
        blockCall.replace((PsiElement)RubyElementFactoryCore.createExpressionFromText((Project)project, (String)newBlockCallText, (LanguageLevel)languageLevel));
    }

    public static boolean available(Editor editor, PsiElement element, Class<? extends RCodeBlock> type) {
        List statements;
        if (element.getContainingFile().getViewProvider().getLanguages().size() != 1) {
            return false;
        }
        RCodeBlock block = (RCodeBlock)PsiTreeUtil.getParentOfType((PsiElement)element, RCodeBlock.class, (boolean)false);
        if (!type.isInstance(block) || PsiTreeUtil.hasErrorElements((PsiElement)block)) {
            return false;
        }
        Document document = editor.getDocument();
        if (RubyPsiUtilCore.hasNonEditableFragment((Project)element.getProject(), (Document)document, (PsiElement)block.getParent())) {
            return false;
        }
        boolean sameLine = document.getLineNumber(block.getTextOffset()) == document.getLineNumber(element.getTextOffset());
        RCompoundStatement compoundStatement = block.getCompoundStatement();
        if (!sameLine && ((statements = compoundStatement.getStatements()).size() > 1 || ContainerUtil.getOnlyItem((Collection)statements) instanceof RBlockStatement)) {
            return false;
        }
        if (type == RDoCodeBlock.class && PsiTreeUtil.getChildOfType((PsiElement)compoundStatement, PsiComment.class) != null) {
            return false;
        }
        RBodyStatement bodyStatement = block.getBodyStatement();
        return bodyStatement == null || bodyStatement.getElseBlock() == null && bodyStatement.getEnsureBlock() == null && bodyStatement.getRescueBlocks().isEmpty();
    }

    @NotNull
    private static String buildBraceBlockText(@NotNull RCodeBlock block) {
        String blockText;
        StringBuilder blockBuilder;
        String regex;
        Pattern blockStartPattern;
        Matcher matcher;
        if (block == null) {
            BraceConverter.$$$reportNull$$$0(3);
        }
        if ((matcher = (blockStartPattern = Pattern.compile(regex = "^do" + BraceConverter.processBlockVars(blockBuilder = new StringBuilder("{"), block.getBlockArguments()) + "(.*)end$", 32)).matcher(blockText = block.getText())).matches()) {
            if (matcher.group(1) != null) {
                blockBuilder.append(BraceConverter.trimIfRequired(matcher.group(1)));
            }
        } else {
            LOG.error("unable to match do-end block text regexp=(" + regex + ") block = (" + blockText + ")");
        }
        blockBuilder.append("}");
        String string = blockBuilder.toString();
        if (string == null) {
            BraceConverter.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    private static String processBlockVars(@NotNull StringBuilder blockBuilder, @Nullable RBlockArgumentList blockVariables) {
        if (blockBuilder == null) {
            BraceConverter.$$$reportNull$$$0(5);
        }
        if (blockVariables == null) {
            return "";
        }
        String blockVariablesText = blockVariables.getText();
        blockBuilder.append("|").append(blockVariablesText).append("|");
        String string = "\\s*\\|\\s*" + Pattern.quote(blockVariablesText) + "\\s*\\|";
        if (string == null) {
            BraceConverter.$$$reportNull$$$0(6);
        }
        return string;
    }

    @NotNull
    private static String trimIfRequired(@NotNull String sample) {
        String trimmed;
        if (sample == null) {
            BraceConverter.$$$reportNull$$$0(7);
        }
        if ((trimmed = sample.trim()).contains("\n")) {
            String string = sample;
            if (string == null) {
                BraceConverter.$$$reportNull$$$0(8);
            }
            return string;
        }
        String string = trimmed;
        if (string == null) {
            BraceConverter.$$$reportNull$$$0(9);
        }
        return string;
    }

    @NotNull
    private static String buildDoBlockText(@NotNull RCodeBlock block) {
        if (block == null) {
            BraceConverter.$$$reportNull$$$0(10);
        }
        String blockVarsText = block.getBlockArguments() != null ? "|" + block.getBlockArguments().getText() + "|" : "";
        String blockText = block.getText();
        int firstIndex = blockText.indexOf("|") + 1;
        String bodyText = !blockVarsText.isEmpty() ? blockText.substring(blockText.indexOf("|", firstIndex) + 1, blockText.lastIndexOf("}")) : blockText.substring(blockText.indexOf("{") + 1, blockText.lastIndexOf("}"));
        String string = " do " + blockVarsText + bodyText + " end";
        if (string == null) {
            BraceConverter.$$$reportNull$$$0(11);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 6, 8, 9, 11 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 3: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "block";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/actions/intention/blocks/BraceConverter";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "blockBuilder";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sample";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/actions/intention/blocks/BraceConverter";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "buildBraceBlockText";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "processBlockVars";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "trimIfRequired";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "buildDoBlockText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "replaceBlock";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "buildBraceBlockText";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 11: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "processBlockVars";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "trimIfRequired";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "buildDoBlockText";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 6, 8, 9, 11 -> new IllegalStateException(string);
        };
    }
}

