/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.wizard;

import com.intellij.ide.projectView.actions.MarkRootsManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.util.NlsActions;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.DirectoryProjectGeneratorBase;
import com.intellij.platform.ProjectGeneratorPeer;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.utils.VirtualFileUtil;
import org.jetbrains.plugins.ruby.wizard.RubyWizardSharedSettings;

public abstract class RubyFrameworkProjectGenerator<T>
extends DirectoryProjectGeneratorBase<T> {
    private static final Logger LOG = Logger.getInstance(RubyFrameworkProjectGenerator.class);
    private static final List<String> STANDARD_TEST_SOURCE_PATHS = Arrays.asList("features", "spec", "test");

    @NotNull
    @NlsActions.ActionText
    public abstract String getParentGroupName();

    public NotNullLazyValue<ProjectGeneratorPeer<T>> createLazyPeer(@NotNull RubyWizardSharedSettings sharedSettings) {
        if (sharedSettings == null) {
            RubyFrameworkProjectGenerator.$$$reportNull$$$0(0);
        }
        return NotNullLazyValue.lazy(() -> this.createPeer(sharedSettings));
    }

    @NotNull
    public ProjectGeneratorPeer<T> createPeer() {
        throw new UnsupportedOperationException("Cannot create ruby project generator without shared settings.");
    }

    @NotNull
    protected abstract ProjectGeneratorPeer<T> createPeer(@NotNull RubyWizardSharedSettings var1);

    public static void setupStandardTestSourceRoots(@NotNull VirtualFile baseDir, @NotNull ModifiableRootModel model) {
        ContentEntry entry;
        if (baseDir == null) {
            RubyFrameworkProjectGenerator.$$$reportNull$$$0(1);
        }
        if (model == null) {
            RubyFrameworkProjectGenerator.$$$reportNull$$$0(2);
        }
        if ((entry = MarkRootsManager.findContentEntry((ModuleRootModel)model, (VirtualFile)baseDir)) != null) {
            String baseDirUrl = baseDir.getUrl();
            STANDARD_TEST_SOURCE_PATHS.forEach(path -> entry.addSourceFolder(VirtualFileUtil.buildUrl(baseDirUrl, path), true));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sharedSettings";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseDir";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/ruby/wizard/RubyFrameworkProjectGenerator";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createLazyPeer";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "setupStandardTestSourceRoots";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

