/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.version.management.system;

import com.intellij.codeWithMe.ClientId;
import com.intellij.idea.AppMode;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ApplicationKt;
import java.io.File;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.remote.RubyRemoteInterpreterManager;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkType;
import org.jetbrains.plugins.ruby.version.management.AbstractSdkRefresher;
import org.jetbrains.plugins.ruby.version.management.RubySdkInfo;
import org.jetbrains.plugins.ruby.version.management.RubyVersionManagerHandler;
import org.jetbrains.plugins.ruby.version.management.RubyVersionManagerSdkData;
import org.jetbrains.plugins.ruby.version.management.SdkRefresherUtilKt;
import org.jetbrains.plugins.ruby.version.management.system.RubySystemData;
import org.jetbrains.plugins.ruby.version.management.system.RubySystemSdkRefresher;
import org.jetbrains.plugins.ruby.version.management.system.RubySystemSdkRefresherKt;
import org.jetbrains.plugins.ruby.version.management.system.RubySystemVersionManagerHandler;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u001dB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0014J\b\u0010\u0006\u001a\u00020\u0005H\u0014J\b\u0010\u0007\u001a\u00020\bH\u0014J\u000e\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0002J\n\u0010\f\u001a\u0004\u0018\u00010\rH\u0002J\u001e\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\r2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0002J\u0016\u0010\u0011\u001a\u00020\u00052\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0002J\u001c\u0010\u0012\u001a\u00020\u00052\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0082@\u00a2\u0006\u0002\u0010\u0014J\u0012\u0010\u0015\u001a\u00020\b2\b\u0010\u0016\u001a\u0004\u0018\u00010\u000bH\u0016J&\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u00182\n\u0010\u001b\u001a\u0006\u0012\u0002\b\u00030\u001cH\u0016\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/plugins/ruby/version/management/system/RubySystemSdkRefresher;", "Lorg/jetbrains/plugins/ruby/version/management/AbstractSdkRefresher;", "<init>", "()V", "doInitialize", "", "doRefreshSDKs", "isPermitted", "", "getRegisteredUncustomizedSystemSdks", "", "Lcom/intellij/openapi/projectRoots/Sdk;", "findSystemRubySdkInfo", "Lorg/jetbrains/plugins/ruby/version/management/RubySdkInfo;", "createSystemSdkIfNecessary", "sysSdkInfo", "regSysSdks", "cleanUpSystemSdks", "removeSdks", "sdkToRemove", "(Ljava/util/List;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "isManagedSdk", "sdk", "suggestSdkName", "", "executablePath", "distributionId", "sdkData", "Lorg/jetbrains/plugins/ruby/version/management/RubyVersionManagerSdkData;", "RubySdkRefresherService", "intellij.ruby.backend"})
@SourceDebugExtension(value={"SMAP\nRubySystemSdkRefresher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RubySystemSdkRefresher.kt\norg/jetbrains/plugins/ruby/version/management/system/RubySystemSdkRefresher\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,123:1\n774#2:124\n865#2,2:125\n2746#2,3:127\n774#2:130\n865#2,2:131\n40#3,3:133\n*S KotlinDebug\n*F\n+ 1 RubySystemSdkRefresher.kt\norg/jetbrains/plugins/ruby/version/management/system/RubySystemSdkRefresher\n*L\n53#1:124\n53#1:125,2\n74#1:127,3\n89#1:130\n89#1:131,2\n93#1:133,3\n*E\n"})
public final class RubySystemSdkRefresher
extends AbstractSdkRefresher {
    @Override
    protected void doInitialize() {
    }

    @Override
    protected void doRefreshSDKs() {
        RubySdkInfo sysSdkInfo = this.findSystemRubySdkInfo();
        Object[] objectArray = new Object[]{sysSdkInfo};
        RubySystemSdkRefresherKt.access$getLOG$p().debug("System ruby sdk found: ", objectArray);
        List<Sdk> regSysSdks = this.getRegisteredUncustomizedSystemSdks();
        Object[] objectArray2 = new Object[]{regSysSdks};
        RubySystemSdkRefresherKt.access$getLOG$p().debug("Registered uncustomized system ruby sdks: ", objectArray2);
        if (sysSdkInfo != null) {
            this.createSystemSdkIfNecessary(sysSdkInfo, regSysSdks);
        }
        this.cleanUpSystemSdks(regSysSdks);
    }

    @Override
    protected boolean isPermitted() {
        return super.isPermitted() && !ApplicationKt.getApplication().isUnitTestMode() && !SystemInfo.isWindows && AppMode.isRemoteDevHost();
    }

    /*
     * Unable to fully structure code
     */
    private final List<Sdk> getRegisteredUncustomizedSystemSdks() {
        $this$filter$iv = SdkRefresherUtilKt.getRegisteredRubySdks();
        $i$f$filter = false;
        var3_3 = $this$filter$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterTo = false;
        for (T element$iv$iv : $this$filterTo$iv$iv) {
            sdk = (Sdk)element$iv$iv;
            $i$a$-filter-RubySystemSdkRefresher$getRegisteredUncustomizedSystemSdks$1 = false;
            if (!this.isManagedSdk(sdk)) ** GOTO lbl-1000
            v0 = RubySystemData.from(sdk);
            v1 = v0 != null && (v0 = v0.getConfiguratorAndArguments()) != null ? v0.isEmpty() : false;
            if (v1) {
                v2 = true;
            } else lbl-1000:
            // 2 sources

            {
                v2 = false;
            }
            if (!v2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final RubySdkInfo findSystemRubySdkInfo() {
        for (String path : RubySystemSdkRefresherKt.access$getSYSTEM_RUBY_PATHS$p()) {
            VirtualFile vfile;
            File file = new File(path);
            if (!file.exists() || (vfile = (VirtualFile)ReadAction.compute(() -> RubySystemSdkRefresher.findSystemRubySdkInfo$lambda$1(file))) == null) continue;
            return new RubySdkInfo(path, vfile, null);
        }
        return null;
    }

    private final void createSystemSdkIfNecessary(RubySdkInfo sysSdkInfo, List<? extends Sdk> regSysSdks) {
        boolean isCreationNecessary;
        Object[] $this$none$iv;
        VirtualFile interpreterHome;
        RubySdkType sdkType;
        block7: {
            RubySdkType rubySdkType = sysSdkInfo.getSdkType();
            if (rubySdkType == null) {
                return;
            }
            sdkType = rubySdkType;
            VirtualFile virtualFile = sysSdkInfo.getInterpreterHome();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getInterpreterHome(...)");
            interpreterHome = virtualFile;
            $this$none$iv = (Object[])regSysSdks;
            boolean $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                v2 = true;
            } else {
                for (Object t : $this$none$iv) {
                    boolean bl;
                    Sdk sdk = (Sdk)t;
                    boolean bl2 = false;
                    if (Intrinsics.areEqual((Object)sdk.getSdkType(), (Object)((Object)sdkType)) && Intrinsics.areEqual((Object)sdk.getHomeDirectory(), (Object)interpreterHome)) {
                        Object[] objectArray = new Object[]{interpreterHome, ": ", sdk};
                        RubySystemSdkRefresherKt.access$getLOG$p().debug("Found an existing SDK for interpreter at ", objectArray);
                        bl = true;
                    } else {
                        bl = false;
                    }
                    if (!bl) continue;
                    v2 = false;
                    break block7;
                }
                v2 = isCreationNecessary = true;
            }
        }
        if (isCreationNecessary) {
            $this$none$iv = new Object[]{sysSdkInfo};
            RubySystemSdkRefresherKt.access$getLOG$p().debug("Creating sdk from system sdk info: ", $this$none$iv);
            RubySystemData rubySystemData = RubySystemVersionManagerHandler.getInstance().createAdditionalData();
            Intrinsics.checkNotNullExpressionValue((Object)rubySystemData, (String)"createAdditionalData(...)");
            RubySystemData sdkData = rubySystemData;
            sdkType.createAndAddLocalSdk(interpreterHome, sdkData);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void cleanUpSystemSdks(List<? extends Sdk> regSysSdks) {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = regSysSdks;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Sdk sdk = (Sdk)element$iv$iv;
            boolean bl = false;
            if (!(!FileUtil.exists((String)sdk.getHomePath()))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List sysSdksToRemove = (List)destination$iv$iv;
        if (!((Collection)sysSdksToRemove).isEmpty()) {
            boolean $i$f$service = false;
            Class<RubySdkRefresherService> serviceClass$iv = RubySdkRefresherService.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            BuildersKt.launch$default((CoroutineScope)((RubySdkRefresherService)object).getCs(), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, (List<? extends Sdk>)sysSdksToRemove, null){
                int label;
                final /* synthetic */ RubySystemSdkRefresher this$0;
                final /* synthetic */ List<Sdk> $sysSdksToRemove;
                {
                    this.this$0 = $receiver;
                    this.$sysSdksToRemove = $sysSdksToRemove;
                    super(2, $completion);
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final Object invokeSuspend(Object $result) {
                    Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            this.label = 1;
                            Object object2 = RubySystemSdkRefresher.access$removeSdks(this.this$0, this.$sysSdksToRemove, (Continuation)this);
                            if (object2 != object) return Unit.INSTANCE;
                            return object;
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            Object object2 = $result;
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
        }
    }

    /*
     * Unable to fully structure code
     */
    private final Object removeSdks(List<? extends Sdk> sdkToRemove, Continuation<? super Unit> $completion) {
        if (!($completion instanceof removeSdks.1)) ** GOTO lbl-1000
        var7_3 = $completion;
        if ((var7_3.label & -2147483648) != 0) {
            var7_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                /* synthetic */ Object result;
                final /* synthetic */ RubySystemSdkRefresher this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return RubySystemSdkRefresher.access$removeSdks(this.this$0, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var8_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                jdkTable = ProjectJdkTable.getInstance();
                var4_7 = sdkToRemove.iterator();
lbl14:
                // 3 sources

                while (var4_7.hasNext()) {
                    sdk = (Sdk)var4_7.next();
                    $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)sdkToRemove);
                    $continuation.L$1 = jdkTable;
                    $continuation.L$2 = var4_7;
                    $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)sdk);
                    $continuation.label = 1;
                    v0 = CoroutinesKt.edtWriteAction((Function0)(Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, removeSdks$lambda$4(com.intellij.openapi.projectRoots.Sdk com.intellij.openapi.projectRoots.ProjectJdkTable ), ()Lkotlin/Unit;)((Sdk)sdk, (ProjectJdkTable)jdkTable), (Continuation)$continuation);
                    if (v0 != var8_5) continue;
                    return var8_5;
                }
                break;
            }
            case 1: {
                sdk = (Sdk)$continuation.L$3;
                var4_7 = (Iterator)$continuation.L$2;
                jdkTable = (ProjectJdkTable)$continuation.L$1;
                sdkToRemove = (List)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
                ** GOTO lbl14
            }
        }
        return Unit.INSTANCE;
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isManagedSdk(@Nullable Sdk sdk) {
        if (!(RubyVersionManagerHandler.from(sdk) instanceof RubySystemVersionManagerHandler)) return false;
        if (RubyRemoteInterpreterManager.isRemoteSdk(sdk)) return false;
        Sdk sdk2 = sdk;
        if (!CollectionsKt.contains((Iterable)RubySystemSdkRefresherKt.access$getSYSTEM_RUBY_PATHS$p(), (Object)(sdk2 != null ? sdk2.getHomePath() : null))) return false;
        return true;
    }

    @Nullable
    public String suggestSdkName(@NotNull String executablePath, @NotNull String distributionId, @NotNull RubyVersionManagerSdkData<?> sdkData) {
        Intrinsics.checkNotNullParameter((Object)executablePath, (String)"executablePath");
        Intrinsics.checkNotNullParameter((Object)distributionId, (String)"distributionId");
        Intrinsics.checkNotNullParameter(sdkData, (String)"sdkData");
        if (this.isPermitted() && sdkData instanceof RubySystemData) {
            return ((RubySystemData)sdkData).getHandler().getId() + ": " + executablePath;
        }
        return null;
    }

    private static final VirtualFile findSystemRubySdkInfo$lambda$1(File $file) {
        return VfsUtil.findFileByIoFile((File)$file, (boolean)false);
    }

    private static final Unit removeSdks$lambda$4(Sdk $sdk, ProjectJdkTable $jdkTable) {
        Object[] objectArray = new Object[]{$sdk};
        RubySystemSdkRefresherKt.access$getLOG$p().debug("Removing system sdk: ", objectArray);
        $jdkTable.removeJdk($sdk);
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ Object access$removeSdks(RubySystemSdkRefresher $this, List sdkToRemove, Continuation $completion) {
        return $this.removeSdks(sdkToRemove, (Continuation<? super Unit>)$completion);
    }

    @Service(value={Service.Level.APP})
    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/plugins/ruby/version/management/system/RubySystemSdkRefresher$RubySdkRefresherService;", "", "cs", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lkotlinx/coroutines/CoroutineScope;)V", "getCs", "()Lkotlinx/coroutines/CoroutineScope;", "intellij.ruby.backend"})
    private static final class RubySdkRefresherService {
        @NotNull
        private final CoroutineScope cs;

        public RubySdkRefresherService(@NotNull CoroutineScope cs) {
            Intrinsics.checkNotNullParameter((Object)cs, (String)"cs");
            this.cs = cs;
        }

        @NotNull
        public final CoroutineScope getCs() {
            return this.cs;
        }
    }
}

