/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.version.management.rvm;

import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.sdk.RubyVersionUtil;
import org.jetbrains.plugins.ruby.version.management.RubySdkConfig;
import org.jetbrains.plugins.ruby.version.management.RubyVersionManagerHandler;

final class RvmrcFile {
    @NonNls
    public static final String RVMRC_FILE_NAME = ".rvmrc";
    private static final Pattern FULL_RVM_USE_CMD_FORM_PATTERN = Pattern.compile("(?:^|.*\\n)\\s*rvm\\s(?:.+[\\t ])?use\\s+(?:--?\\w+\\s+)*(system|\\S*)?(\\s|;|$)");
    private static final Pattern SHORT_RVM_USE_CMD_FORM_PATTERN = Pattern.compile("(?:^|.*\\n)\\s*rvm\\s+(?:--?\\w+\\s+)*(system|\\S*)?(\\s|;|$)");
    @Nullable
    private String myRubyVersion;
    @Nullable
    private String myGemset;

    private RvmrcFile(@NotNull String content) {
        String rubySdkAndGemset;
        if (content == null) {
            RvmrcFile.$$$reportNull$$$0(0);
        }
        Matcher matcher = RvmrcFile.getVersionMatcher(content);
        if (matcher != null) {
            rubySdkAndGemset = StringUtil.unquoteString((String)matcher.group(1).replace('\'', '\"').replace(";", ""));
            if (rubySdkAndGemset.startsWith("$")) {
                rubySdkAndGemset = RvmrcFile.findVariable(content, rubySdkAndGemset);
            }
        } else {
            rubySdkAndGemset = RvmrcFile.findVariable(content, "$environment_id");
        }
        if (rubySdkAndGemset != null) {
            String[] versionAndGemset = rubySdkAndGemset.split("@");
            this.myRubyVersion = versionAndGemset[0];
            if (versionAndGemset.length > 1) {
                this.myGemset = versionAndGemset[1];
            }
        }
    }

    @Nullable
    public String getRubyVersion() {
        return this.myRubyVersion;
    }

    @Nullable
    public String getGemset() {
        return this.myGemset;
    }

    @Nullable
    private static Matcher getVersionMatcher(@NotNull String content) {
        Matcher shortMatcher;
        Matcher fullMatcher;
        if (content == null) {
            RvmrcFile.$$$reportNull$$$0(1);
        }
        Matcher matcher = (fullMatcher = FULL_RVM_USE_CMD_FORM_PATTERN.matcher(content)).find() ? fullMatcher : ((shortMatcher = SHORT_RVM_USE_CMD_FORM_PATTERN.matcher(content)).find() ? shortMatcher : null);
        return matcher;
    }

    @Nullable
    private static String findVariable(@NotNull String configContent, @NotNull String variable) {
        if (configContent == null) {
            RvmrcFile.$$$reportNull$$$0(2);
        }
        if (variable == null) {
            RvmrcFile.$$$reportNull$$$0(3);
        }
        String[] lines = StringUtil.splitByLines((String)configContent);
        String assignmentPrefix = variable.substring(1) + "=";
        for (String line : lines) {
            if (!line.startsWith(assignmentPrefix)) continue;
            return StringUtil.unquoteString((String)StringUtil.trimEnd((String)StringUtil.trimStart((String)line, (String)assignmentPrefix), (char)';'));
        }
        return null;
    }

    @Contract(value="null -> null")
    @Nullable
    public static RvmrcFile create(@Nullable VirtualFile file) {
        if (file == null) {
            return null;
        }
        String configContent = LoadTextUtil.loadText((VirtualFile)file).toString().strip();
        if (configContent.isEmpty()) {
            return null;
        }
        return new RvmrcFile(configContent);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configContent";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/ruby/version/management/rvm/RvmrcFile";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getVersionMatcher";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "findVariable";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    static final class SdkConfigFactory
    implements RubySdkConfig.Factory {
        private static final List<String> SOURCE_FILENAMES = Collections.singletonList(".rvmrc");

        SdkConfigFactory() {
        }

        @Override
        @NotNull
        public Collection<String> getSourceFilenames() {
            List<String> list = SOURCE_FILENAMES;
            if (list == null) {
                SdkConfigFactory.$$$reportNull$$$0(0);
            }
            return list;
        }

        @Nullable
        public RubySdkConfig createFromRoot(@NotNull VirtualFile root, @NotNull RubyVersionManagerHandler vmHandler) {
            RvmrcFile file;
            if (root == null) {
                SdkConfigFactory.$$$reportNull$$$0(1);
            }
            if (vmHandler == null) {
                SdkConfigFactory.$$$reportNull$$$0(2);
            }
            if ((file = RvmrcFile.create(root.findChild(RvmrcFile.RVMRC_FILE_NAME))) == null || file.getRubyVersion() == null) {
                return null;
            }
            String version = RubyVersionUtil.normalizeVersionForVms(file.getRubyVersion());
            return new RubySdkConfig(version, file.getGemset(), RvmrcFile.RVMRC_FILE_NAME, vmHandler);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/ruby/version/management/rvm/RvmrcFile$SdkConfigFactory";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "root";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "vmHandler";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSourceFilenames";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/ruby/version/management/rvm/RvmrcFile$SdkConfigFactory";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "createFromRoot";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2 -> new IllegalArgumentException(string);
            };
        }
    }
}

