/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.version.management.rvm;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionMode;
import com.intellij.execution.ExecutionModes;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.NullableLazyValue;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.EnvironmentUtil;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jdom.Element;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.ruby.run.RubyRunner;
import org.jetbrains.plugins.ruby.ruby.run.context.RubyRunnerExecutionContext;
import org.jetbrains.plugins.ruby.version.management.RubySdkConfig;
import org.jetbrains.plugins.ruby.version.management.RubySdkInfo;
import org.jetbrains.plugins.ruby.version.management.RubyVersionAndGemsetSdkConfigFactory;
import org.jetbrains.plugins.ruby.version.management.RubyVersionManagerHandler;
import org.jetbrains.plugins.ruby.version.management.RubyVersionManagerHandlerBase;
import org.jetbrains.plugins.ruby.version.management.RubyVersionManagerSdkData;
import org.jetbrains.plugins.ruby.version.management.SdkInstaller;
import org.jetbrains.plugins.ruby.version.management.rvm.RvmSdkData;
import org.jetbrains.plugins.ruby.version.management.rvm.RvmSdkInstaller;
import org.jetbrains.plugins.ruby.version.management.rvm.RvmrcFile;
import org.jetbrains.plugins.ruby.version.management.rvm.VersionsConfFile;

public final class RvmVersionManagerHandler
extends RubyVersionManagerHandlerBase<RvmSdkData> {
    public static final String USE_RVM_DEFAULT_RUBY_ONELINER_KEY = "ruby.version.management.rvm.default.ruby";
    private static final Logger LOG = Logger.getInstance(RvmVersionManagerHandler.class);
    @NonNls
    private static final String IS_RVM_SDK = "IS_RVM_SDK";
    @NonNls
    private static final String RVM_GEMSET_NAME = "RVM_GEMSET_NAME";
    @NonNls
    private static final String RVM_IGNORE_GLOBAL = "RVM_IGNORE_GLOBAL";
    private static final String RVM_PATH = "rvm_path";
    private static final String RVM_RUBIES_PATH = "rvm_rubies_path";
    private static final String RVM_GEMS_PATH = "rvm_gems_path";
    private static final String RVM_GEMS_DIRECTORY = "gems";
    private static final String RVM_RUBIES_DIRECTORY = "rubies";
    static final String RVM_DEFAULT_RUBY = "default";
    private static final String RVM_SYSTEM_RUBY = "system";
    private static final String RUBYMINE_RVM_GEMS_PATH_PROPERTY = "rubymine.rvm.gems.path";
    private static final String RVM_HOME_PATH = FileUtil.expandUserHome((String)"~/.rvm");
    private static final String RVM_HOME_GEMS_PATH = FileUtil.join((String[])new String[]{RVM_HOME_PATH, "gems"});
    static final List<String> RVM_SEARCH_PATHS_LIST = Arrays.asList(FileUtil.join((String[])new String[]{RVM_HOME_PATH, "bin"}), "/usr/local/rvm/bin", "/usr/share/rvm/bin", "/opt/rvm/bin");
    private static final String SILENCE_PATH_MISMATCH_CHECK_FLAG = "rvm_silence_path_mismatch_check_flag";
    private static final List<RvmSdkInstaller> SDK_INSTALLERS = Collections.singletonList(new RvmSdkInstaller());

    @Override
    @NotNull
    protected List<String> getAdditionalPathsToSearch() {
        List<String> list = RVM_SEARCH_PATHS_LIST;
        if (list == null) {
            RvmVersionManagerHandler.$$$reportNull$$$0(0);
        }
        return list;
    }

    @Override
    @NotNull
    public String getVersionManagerExecutableName() {
        return "rvm";
    }

    @Override
    @NotNull
    public RvmSdkData createAdditionalData() {
        return new RvmSdkData(this);
    }

    @Override
    @NotNull
    protected List<String> processAvailableDistributionsOutput(@NotNull List<String> rawOutput) {
        if (rawOutput == null) {
            RvmVersionManagerHandler.$$$reportNull$$$0(1);
        }
        List list = ContainerUtil.filter(rawOutput, s -> s != null && !StringUtil.endsWith((CharSequence)s, (CharSequence)"@global"));
        if (list == null) {
            RvmVersionManagerHandler.$$$reportNull$$$0(2);
        }
        return list;
    }

    @Override
    @NotNull
    protected List<String> getAvailableDistributionsCommands(@NotNull RubyRunner runner, @NotNull String versionManagerPath) {
        if (runner == null) {
            RvmVersionManagerHandler.$$$reportNull$$$0(3);
        }
        if (versionManagerPath == null) {
            RvmVersionManagerHandler.$$$reportNull$$$0(4);
        }
        List<String> list = Arrays.asList(versionManagerPath, "list", "gemsets", "strings");
        if (list == null) {
            RvmVersionManagerHandler.$$$reportNull$$$0(5);
        }
        return list;
    }

    @Override
    @Nullable
    protected RubyVersionManagerSdkData doLoadLegacy(@NotNull Element rootElement, @NotNull String interpreterPath) {
        if (rootElement == null) {
            RvmVersionManagerHandler.$$$reportNull$$$0(6);
        }
        if (interpreterPath == null) {
            RvmVersionManagerHandler.$$$reportNull$$$0(7);
        }
        String isRvmElement = rootElement.getAttributeValue(IS_RVM_SDK);
        String rvmGemset = rootElement.getAttributeValue(RVM_GEMSET_NAME);
        if (isRvmElement != null && Boolean.parseBoolean(isRvmElement) || rvmGemset != null) {
            RvmSdkData rvmSdkAdditionalData = this.createAdditionalData().withDistributionId(RvmVersionManagerHandler.getVersionFromInterpreterPath(interpreterPath), rvmGemset);
            rvmSdkAdditionalData.withRVMIgnoreGlobalGemset(Boolean.parseBoolean(rootElement.getAttributeValue(RVM_IGNORE_GLOBAL, "false")));
            return rvmSdkAdditionalData;
        }
        return null;
    }

    @Override
    @NotNull
    public RvmSdkData createAdditionalData(@NotNull RubySdkInfo sdkInfo) {
        if (sdkInfo == null) {
            RvmVersionManagerHandler.$$$reportNull$$$0(8);
        }
        RvmSdkData rvmSdkData = ((RvmSdkData)super.createAdditionalData(sdkInfo)).withDistributionId(sdkInfo.getInterpreterHome().getName(), sdkInfo.getGemSet());
        if (rvmSdkData == null) {
            RvmVersionManagerHandler.$$$reportNull$$$0(9);
        }
        return rvmSdkData;
    }

    @Override
    @NotNull
    protected List<String> patchCommands(@NotNull RubyRunner rubyRunner, @NotNull String versionManagerPath, @NotNull String distributionId, @NotNull List<String> commandsToPatch, @NotNull Map<String, String> env) {
        if (rubyRunner == null) {
            RvmVersionManagerHandler.$$$reportNull$$$0(10);
        }
        if (versionManagerPath == null) {
            RvmVersionManagerHandler.$$$reportNull$$$0(11);
        }
        if (distributionId == null) {
            RvmVersionManagerHandler.$$$reportNull$$$0(12);
        }
        if (commandsToPatch == null) {
            RvmVersionManagerHandler.$$$reportNull$$$0(13);
        }
        if (env == null) {
            RvmVersionManagerHandler.$$$reportNull$$$0(14);
        }
        env.put(SILENCE_PATH_MISMATCH_CHECK_FLAG, "1");
        List<String> list = rubyRunner.getCommandsSequence(ContainerUtil.concat(Arrays.asList(versionManagerPath, distributionId, "do"), commandsToPatch));
        if (list == null) {
            RvmVersionManagerHandler.$$$reportNull$$$0(15);
        }
        return list;
    }

    @NotNull
    public static RvmVersionManagerHandler getInstance() {
        RvmVersionManagerHandler rvmVersionManagerHandler = Objects.requireNonNull((RvmVersionManagerHandler)RubyVersionManagerHandler.findHandler(o -> o instanceof RvmVersionManagerHandler));
        if (rvmVersionManagerHandler == null) {
            RvmVersionManagerHandler.$$$reportNull$$$0(16);
        }
        return rvmVersionManagerHandler;
    }

    @Override
    @NotNull
    protected String getStarterScriptName() {
        return "rvm_starter.sh";
    }

    private static Map<@NotNull String, @NotNull String> getEnvironmentVarsFromRubyOneliner(@NotNull Path pathToRvm, @NotNull String rubyVersion, @NotNull RubyRunner runner) throws ExecutionException {
        if (pathToRvm == null) {
            RvmVersionManagerHandler.$$$reportNull$$$0(17);
        }
        if (rubyVersion == null) {
            RvmVersionManagerHandler.$$$reportNull$$$0(18);
        }
        if (runner == null) {
            RvmVersionManagerHandler.$$$reportNull$$$0(19);
        }
        LOG.debug("Getting rvm environment from " + String.valueOf(pathToRvm) + " using ruby (" + rubyVersion + ") oneliner");
        GeneralCommandLine baseCommandLine = new GeneralCommandLine(new String[]{pathToRvm.toString(), rubyVersion, "do", "ruby", "-e", "ENV.each{|k,v| print %Q<#{k}=#{v}\\0>}"});
        ProcessOutput processOutput = RvmVersionManagerHandler.getProcessOutput(runner, baseCommandLine, "Error getting rvm environment from script, error code ");
        if (processOutput == null) {
            return null;
        }
        return EnvironmentUtil.parseEnv((String[])processOutput.getStdout().split("\u0000"));
    }

    @Nullable
    private static ProcessOutput getProcessOutput(@NotNull RubyRunner runner, GeneralCommandLine baseCommandLine, String errorMessage) throws ExecutionException {
        if (runner == null) {
            RvmVersionManagerHandler.$$$reportNull$$$0(20);
        }
        ExecutionModes.SameThreadMode executionMode = new ExecutionModes.SameThreadMode(false, RBundle.message((String)"version.manager.rvm.fetching.environment"), RubyRunner.DEFAULT_EXECUTION_TIMEOUT);
        executionMode.addProcessListener(RubyRunner.CLOSE_INPUT_ADAPTER);
        ProcessOutput processOutput = runner.execute((RubyRunnerExecutionContext)RubyRunnerExecutionContext.create(runner.wrapWithShell(true, false, baseCommandLine.getCommandLineString())).withExecutionMode((ExecutionMode)executionMode));
        assert (processOutput != null);
        LOG.debug(processOutput.getStdout());
        if (processOutput.getExitCode() != 0) {
            LOG.warn(errorMessage + String.valueOf(processOutput));
            return null;
        }
        return processOutput;
    }

    @Override
    protected Collection<Class<? extends RubySdkConfig.Factory>> getSdkConfigFactories() {
        return List.of(RvmrcFile.SdkConfigFactory.class, VersionsConfFile.SdkConfigFactory.class, RubyVersionAndGemsetSdkConfigFactory.class);
    }

    @Override
    @NotNull
    public Collection<? extends SdkInstaller> getInstallers() {
        List<RvmSdkInstaller> list = SDK_INSTALLERS;
        if (list == null) {
            RvmVersionManagerHandler.$$$reportNull$$$0(21);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 3, 4, 6, 7, 8, 10, 11, 12, 13, 14, 17, 18, 19, 20 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/version/management/rvm/RvmVersionManagerHandler";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rawOutput";
                break;
            }
            case 3: 
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runner";
                break;
            }
            case 4: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "versionManagerPath";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootElement";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreterPath";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkInfo";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rubyRunner";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "distributionId";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandsToPatch";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathToRvm";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rubyVersion";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getAdditionalPathsToSearch";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/version/management/rvm/RvmVersionManagerHandler";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "processAvailableDistributionsOutput";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getAvailableDistributionsCommands";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createAdditionalData";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "patchCommands";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstallers";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "processAvailableDistributionsOutput";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getAvailableDistributionsCommands";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "doLoadLegacy";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createAdditionalData";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "patchCommands";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getEnvironmentVarsFromRubyOneliner";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getProcessOutput";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 3, 4, 6, 7, 8, 10, 11, 12, 13, 14, 17, 18, 19, 20 -> new IllegalArgumentException(string);
        };
    }

    static final class RvmEnvironment {
        @NotNull
        private final String myRubiesPath;
        @NotNull
        private final String myGemsPath;
        private final NullableLazyValue<VirtualFile> myRubiesVirtualFileProvider;

        RvmEnvironment(@NotNull Map<String, String> rvmEnvironment) {
            if (rvmEnvironment == null) {
                RvmEnvironment.$$$reportNull$$$0(0);
            }
            this.myRubiesVirtualFileProvider = NullableLazyValue.atomicLazyNullable(() -> VfsUtil.findFileByIoFile((File)new File(this.getRubiesPath()), (boolean)false));
            this.myRubiesPath = rvmEnvironment.get(RvmVersionManagerHandler.RVM_RUBIES_PATH);
            this.myGemsPath = rvmEnvironment.get(RvmVersionManagerHandler.RVM_GEMS_PATH);
        }

        @NotNull
        String getRubiesPath() {
            String string = this.myRubiesPath;
            if (string == null) {
                RvmEnvironment.$$$reportNull$$$0(1);
            }
            return string;
        }

        @NotNull
        String getGemsPath() {
            String string = this.myGemsPath;
            if (string == null) {
                RvmEnvironment.$$$reportNull$$$0(2);
            }
            return string;
        }

        @Nullable
        VirtualFile getRubiesVirtualFile() {
            return (VirtualFile)this.myRubiesVirtualFileProvider.getValue();
        }

        @Contract(value="null, _ -> null")
        @Nullable
        static RvmEnvironment compute(@Nullable Path pathToRvm, @NotNull RubyRunner runner) {
            if (runner == null) {
                RvmEnvironment.$$$reportNull$$$0(3);
            }
            if (pathToRvm == null) {
                return null;
            }
            try {
                Map<String, String> rvmEnvironment;
                if (Registry.is((String)RvmVersionManagerHandler.USE_RVM_DEFAULT_RUBY_ONELINER_KEY, (boolean)false)) {
                    rvmEnvironment = RvmVersionManagerHandler.getEnvironmentVarsFromRubyOneliner(pathToRvm, RvmVersionManagerHandler.RVM_DEFAULT_RUBY, runner);
                } else {
                    String firstRubyFromRvmList = (String)ContainerUtil.getFirstItem(RvmVersionManagerHandler.getInstance().getAvailableDistributions(runner, pathToRvm.toString()));
                    rvmEnvironment = RvmVersionManagerHandler.getEnvironmentVarsFromRubyOneliner(pathToRvm, Objects.requireNonNullElse(firstRubyFromRvmList, RvmVersionManagerHandler.RVM_SYSTEM_RUBY), runner);
                }
                if (rvmEnvironment == null) {
                    rvmEnvironment = new HashMap<String, String>();
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("IDE environment:");
                    EnvironmentUtil.getEnvironmentMap().forEach((k, v) -> LOG.debug(k + ": " + v));
                    LOG.debug("RVM environment read:");
                    rvmEnvironment.forEach((k, v) -> LOG.debug(k + ": " + v));
                }
                String rvmGemsPath = rvmEnvironment.get(RvmVersionManagerHandler.RVM_GEMS_PATH);
                String rvmRubiesPath = rvmEnvironment.get(RvmVersionManagerHandler.RVM_RUBIES_PATH);
                String rvmPath = rvmEnvironment.get(RvmVersionManagerHandler.RVM_PATH);
                if (StringUtil.isEmpty((String)rvmRubiesPath) && StringUtil.isNotEmpty((String)rvmPath)) {
                    rvmRubiesPath = FileUtil.toSystemIndependentName((String)Paths.get(rvmPath, new String[0]).resolve(RvmVersionManagerHandler.RVM_RUBIES_DIRECTORY).toString());
                    LOG.warn("rvm_rubies_path(" + rvmRubiesPath + ") inferred from rvm_path(" + rvmPath + ")");
                    rvmEnvironment.put(RvmVersionManagerHandler.RVM_RUBIES_PATH, rvmRubiesPath);
                }
                if (StringUtil.isEmpty((String)rvmGemsPath) && StringUtil.isNotEmpty((String)rvmRubiesPath)) {
                    String manualPath = System.getProperty(RvmVersionManagerHandler.RUBYMINE_RVM_GEMS_PATH_PROPERTY);
                    if (StringUtil.isNotEmpty((String)manualPath)) {
                        rvmGemsPath = FileUtil.toSystemIndependentName((String)Paths.get(manualPath, new String[0]).toString());
                        LOG.warn("rvm_gems_path(" + rvmGemsPath + ") set manually with rubymine.rvm.gems.path property");
                    } else if (Files.exists(Paths.get(RVM_HOME_GEMS_PATH, new String[0]), new LinkOption[0])) {
                        rvmGemsPath = FileUtil.toSystemIndependentName((String)Paths.get(RVM_HOME_GEMS_PATH, new String[0]).toString());
                        LOG.warn("rvm_gems_path(" + rvmGemsPath + ") inferred from existing " + RVM_HOME_GEMS_PATH);
                    } else {
                        rvmGemsPath = FileUtil.toSystemIndependentName((String)Paths.get(rvmRubiesPath, new String[0]).getParent().resolve(RvmVersionManagerHandler.RVM_GEMS_DIRECTORY).toString());
                        LOG.warn("rvm_gems_path(" + rvmGemsPath + ") inferred from rvm_rubies_path(" + rvmRubiesPath + ")");
                    }
                    rvmEnvironment.put(RvmVersionManagerHandler.RVM_GEMS_PATH, rvmGemsPath);
                }
                boolean rubiesPathEmpty = StringUtil.isEmpty((String)rvmRubiesPath);
                boolean gemsPathEmpty = StringUtil.isEmpty((String)rvmGemsPath);
                if (rubiesPathEmpty || gemsPathEmpty) {
                    LOG.warn("RVM environment is not good:\nrubies path: " + rvmRubiesPath + "\ngems path: " + rvmGemsPath + "\n; rvm environment: " + String.valueOf(rvmEnvironment));
                    LOG.warn("Inferring paths from the path to RVM " + String.valueOf(pathToRvm));
                    Path binPath = pathToRvm.getParent();
                    if (binPath == null) {
                        LOG.warn("No bin path in " + String.valueOf(pathToRvm));
                        return null;
                    }
                    Path rvmRootPath = binPath.getParent();
                    if (rvmRootPath == null) {
                        LOG.warn("No rvm root path in " + String.valueOf(pathToRvm));
                        return null;
                    }
                    if (rubiesPathEmpty) {
                        rvmRubiesPath = FileUtil.toSystemIndependentName((String)rvmRootPath.resolve(RvmVersionManagerHandler.RVM_RUBIES_DIRECTORY).toString());
                        LOG.warn("rvm_rubies_path(" + rvmRubiesPath + ") inferred from path to rvm executable (" + String.valueOf(pathToRvm) + ")");
                        rvmEnvironment.put(RvmVersionManagerHandler.RVM_RUBIES_PATH, rvmRubiesPath);
                    }
                    if (gemsPathEmpty) {
                        rvmGemsPath = FileUtil.toSystemIndependentName((String)rvmRootPath.resolve(RvmVersionManagerHandler.RVM_GEMS_DIRECTORY).toString());
                        LOG.warn("rvm_gems_path(" + rvmGemsPath + ") inferred from path to rvm executable (" + String.valueOf(pathToRvm) + ")");
                        rvmEnvironment.put(RvmVersionManagerHandler.RVM_GEMS_PATH, rvmGemsPath);
                    }
                }
                return new RvmEnvironment(rvmEnvironment);
            }
            catch (ProcessCanceledException e) {
                throw e;
            }
            catch (Exception e) {
                LOG.warn("Error getting rvm environment", (Throwable)e);
                return null;
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rvmEnvironment";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/ruby/version/management/rvm/RvmVersionManagerHandler$RvmEnvironment";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "runner";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/ruby/version/management/rvm/RvmVersionManagerHandler$RvmEnvironment";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRubiesPath";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getGemsPath";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "compute";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 2 -> new IllegalStateException(string);
            };
        }
    }
}

