/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.version.management.rvm;

import com.google.common.collect.Collections2;
import com.google.common.collect.Sets;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.openapi.projectRoots.SdkModificator;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.ui.DialogBuilder;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.EnvironmentUtil;
import com.intellij.util.NullableConsumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.Topic;
import com.intellij.util.text.VersionComparatorUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import javax.swing.JComponent;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.gem.ui.SdkComparator;
import org.jetbrains.plugins.ruby.gem.workspace.sync.RubySdkGemLibraryManager;
import org.jetbrains.plugins.ruby.remote.RubyRemoteInterpreterManager;
import org.jetbrains.plugins.ruby.ruby.sdk.RVMGemsetDialog;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkAdditionalData;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkAdditionalDataBase;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkConfigurableUtil;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkType;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkUtil;
import org.jetbrains.plugins.ruby.ruby.sdk.jruby.JRubySdkType;
import org.jetbrains.plugins.ruby.version.management.RubyVersionManagerSdkData;
import org.jetbrains.plugins.ruby.version.management.rbenv.gemsets.RbenvGemsetManager;
import org.jetbrains.plugins.ruby.version.management.rvm.LocalRvmPathsSettings;
import org.jetbrains.plugins.ruby.version.management.rvm.RvmSdkData;
import org.jetbrains.plugins.ruby.version.management.rvm.RvmSdkInfo;
import org.jetbrains.plugins.ruby.version.management.rvm.RvmSdkRefresher;
import org.jetbrains.plugins.ruby.version.management.rvm.RvmSettings;

@Deprecated
@ApiStatus.Internal
public final class RVMSupportUtil {
    public static final Topic<RVMGemsetListener> RVM_GEMSET_ADDED_TOPIC = Topic.create((String)"RVM gemset added", RVMGemsetListener.class, (Topic.BroadcastDirection)Topic.BroadcastDirection.NONE);
    @NonNls
    public static final String FAKE_NA_GEMSET = "[n/a]";
    @NonNls
    public static final String RUBY = "ruby";
    public static final Key<Object> NEW_RVM_GEMSET_SDK = Key.create((String)"NEW_RVM_GEMSET_SDK");
    private static final Logger LOG = Logger.getInstance(RubySdkConfigurableUtil.class);
    @NonNls
    private static final String DEFAULT_GEMSET = "default";
    @NonNls
    public static final String DEFAULT_GEMSET_NAME = "[default]";
    @NonNls
    private static final String RVM_ENV_KEY_MY_RUBY_HOME = "MY_RUBY_HOME";
    @NonNls
    private static final String RVM_SYSTEM_SDK = "system";
    @NonNls
    private static final String MACRUBY = "macruby";
    @NonNls
    private static final String RBX = "rbx";
    @NonNls
    private static final String MAGLEV = "maglev";
    @NonNls
    private static final String REE = "ree";
    @NonNls
    private static final String JRUBY = "jruby";
    @NonNls
    private static final String IRONRUBY = "ironruby";
    private static final Object NEW_RVM_GEMSET_SDK_VALUE = new Object();
    private static final Pattern RVM_GEMSET_NAME_REGEXP = Pattern.compile("[-_.A-Za-z0-9]+");

    private RVMSupportUtil() {
    }

    @NotNull
    public static String getGemsetSuffix(@NotNull String gemset) {
        if (gemset == null) {
            RVMSupportUtil.$$$reportNull$$$0(0);
        }
        String string = " [" + gemset + "]";
        if (string == null) {
            RVMSupportUtil.$$$reportNull$$$0(1);
        }
        return string;
    }

    public static boolean isRVMInterpreter(@NotNull String executablePath, @NotNull RvmSettings rvmSettings) {
        if (executablePath == null) {
            RVMSupportUtil.$$$reportNull$$$0(2);
        }
        if (rvmSettings == null) {
            RVMSupportUtil.$$$reportNull$$$0(3);
        }
        if (!rvmSettings.isRvmSupportEnabled()) {
            return false;
        }
        String rvmHomePath = rvmSettings.getRvmHomePath();
        if (rvmHomePath == null) {
            return false;
        }
        return executablePath.startsWith(rvmHomePath + "/rubies");
    }

    public static boolean isRVMInterpreter(@Nullable RubyVersionManagerSdkData versionManagerSdkAdditionalData) {
        return versionManagerSdkAdditionalData instanceof RvmSdkData;
    }

    public static boolean isRVMInterpreter(@Nullable Sdk sdk) {
        return RvmSdkData.from(sdk) != null;
    }

    @Nullable
    public static String getGemsetName(@Nullable Sdk sdk) {
        RvmSdkData rvmSdkAdditionalData = RvmSdkData.from(sdk);
        return rvmSdkAdditionalData == null ? null : rvmSdkAdditionalData.getGemsetName();
    }

    @Nullable
    public static String getGemsetName(@Nullable SdkAdditionalData additionalData) {
        return (String)ObjectUtils.doIfNotNull((Object)RvmSdkData.from(additionalData), d -> d.getGemsetName());
    }

    public static boolean isRvmIgnoreGlobalGemSet(@Nullable Sdk sdk) {
        RvmSdkData rvmSdkAdditionalData = RvmSdkData.from(sdk);
        return rvmSdkAdditionalData != null && rvmSdkAdditionalData.isRVMIgnoreGlobalGemset();
    }

    @NotNull
    public static String getGemsetPresentableName(@Nullable Sdk sdk) {
        if (!RVMSupportUtil.isRVMInterpreter(sdk)) {
            return FAKE_NA_GEMSET;
        }
        String gemset = RVMSupportUtil.getGemsetName(sdk);
        String string = gemset == null ? DEFAULT_GEMSET_NAME : gemset;
        if (string == null) {
            RVMSupportUtil.$$$reportNull$$$0(4);
        }
        return string;
    }

    public static RubyDistToGemsetTable getInterpreterDistName2GemSetsTable(@Nullable VirtualFile rvmSdksRoot, @Nullable VirtualFile rvmGemsFolder) {
        if (rvmGemsFolder == null || rvmSdksRoot == null) {
            return RubyDistToGemsetTable.emptyTable();
        }
        RubyDistToGemsetTable rubyDist2Gemset = new RubyDistToGemsetTable();
        RVMSupportUtil.getGemsetsForSdk(rvmGemsFolder, rvmSdksRoot).forEach(info -> rubyDist2Gemset.putGemset(StringUtil.nullize((String)info.gemset()), info.sdkDistName()));
        return rubyDist2Gemset;
    }

    @NotNull
    private static Stream<RvmSdkInfo> getGemsetsForSdk(@NotNull VirtualFile gemsFolder, @NotNull VirtualFile distFolder) {
        if (gemsFolder == null) {
            RVMSupportUtil.$$$reportNull$$$0(5);
        }
        if (distFolder == null) {
            RVMSupportUtil.$$$reportNull$$$0(6);
        }
        Stream<RvmSdkInfo> stream = Arrays.stream(gemsFolder.getChildren()).filter(folder -> folder.isDirectory()).map(folder -> {
            String folderName = folder.getName();
            String distName = RVMSupportUtil.getDistName(folderName);
            if (distFolder.findChild(distName) != null) {
                return new RvmSdkInfo(distName, RVMSupportUtil.getGemsetName(folderName));
            }
            return null;
        }).filter(Objects::nonNull);
        if (stream == null) {
            RVMSupportUtil.$$$reportNull$$$0(7);
        }
        return stream;
    }

    public static String getGemsetSeparator() {
        String separator;
        if (SystemInfo.isUnix && (separator = EnvironmentUtil.getValue((String)"rvm_gemset_separator")) != null) {
            return separator;
        }
        return "@";
    }

    public static boolean isGlobalGempathIgnored(@Nullable Sdk sdk) {
        RvmSdkData rvmSdkAdditionalData = RvmSdkData.from(sdk);
        return rvmSdkAdditionalData != null && rvmSdkAdditionalData.isRVMIgnoreGlobalGemset();
    }

    public static void updateSdk(@Nullable Sdk sdk, boolean ignoreGlobalGemset) {
        if (sdk == null) {
            return;
        }
        if (ignoreGlobalGemset == RVMSupportUtil.isGlobalGempathIgnored(sdk)) {
            return;
        }
        RubySdkAdditionalDataBase.modify((Sdk)sdk, modifiableSdkData -> {
            RvmSdkData rvmSdkAdditionalData = RvmSdkData.from((SdkAdditionalData)modifiableSdkData);
            if (rvmSdkAdditionalData != null) {
                rvmSdkAdditionalData.withRVMIgnoreGlobalGemset(ignoreGlobalGemset);
            }
        });
        RubySdkGemLibraryManager.getInstance().refreshRoots(sdk);
    }

    public static Set<String> determineGemRootsPaths(Sdk sdk) {
        return Sets.newLinkedHashSet((Iterable)Collections2.transform(RVMSupportUtil.determineSdkRootsPaths(sdk), input -> input + "/gems"));
    }

    public static Set<String> determineSdkRootsPaths(Sdk sdk) {
        try {
            RubySdkAdditionalData data = RubySdkUtil.getRubySdkAdditionalData(sdk);
            String gemSetName = RVMSupportUtil.getGemsetName(sdk);
            Pair<String, String> paths = RVMSupportUtil.getMainAndGlobalGemPaths(data.getInterpreterPath(sdk), gemSetName, data.getRvmSettings());
            if (paths == null) {
                LOG.warn("unable to get main and global paths for " + String.valueOf(sdk) + "\n\tinterpreter path = " + data.getInterpreterPath(sdk) + "\n\t rvm home = " + data.getRvmSettings().getRvmHomePath());
                return new LinkedHashSet<String>();
            }
            LinkedHashSet<String> result = new LinkedHashSet<String>();
            result.add((String)paths.first);
            if (!RVMSupportUtil.isRvmIgnoreGlobalGemSet(sdk)) {
                result.add((String)paths.second);
            }
            return result;
        }
        catch (IllegalArgumentException e) {
            LOG.error((Throwable)e);
            return new LinkedHashSet<String>(0);
        }
    }

    @Nullable
    public static String determineMainGemRootPath(@NotNull Sdk sdk) {
        if (sdk == null) {
            RVMSupportUtil.$$$reportNull$$$0(8);
        }
        try {
            RubySdkAdditionalData data = RubySdkUtil.getRubySdkAdditionalData(sdk);
            String interpreterPath = data.getInterpreterPath(sdk);
            String gemset = RVMSupportUtil.getGemsetName(sdk);
            Pair<String, String> paths = RVMSupportUtil.getMainAndGlobalGemPaths(interpreterPath, gemset, data.getRvmSettings());
            return (String)Pair.getFirst(paths);
        }
        catch (IllegalArgumentException e) {
            LOG.error((Throwable)e);
            return null;
        }
    }

    @Nullable
    public static Pair<String, String> determineMainAndGlobalGemPaths(@NotNull Sdk sdk) {
        if (sdk == null) {
            RVMSupportUtil.$$$reportNull$$$0(9);
        }
        try {
            RubySdkAdditionalData data = RubySdkUtil.getRubySdkAdditionalData(sdk);
            String interpreterPath = data.getInterpreterPath(sdk);
            String gemset = RVMSupportUtil.getGemsetName(sdk);
            Pair<String, String> paths = RVMSupportUtil.getMainAndGlobalGemPaths(interpreterPath, gemset, data.getRvmSettings());
            if (paths == null) {
                return null;
            }
            return Pair.create((Object)((String)paths.first), !RVMSupportUtil.isRvmIgnoreGlobalGemSet(sdk) ? (String)paths.second : null);
        }
        catch (IllegalArgumentException e) {
            LOG.error((Throwable)e);
            return null;
        }
    }

    @Nullable
    public static String getCurrentRvmSdkName() {
        if (!SystemInfo.isUnix) {
            return null;
        }
        String rubyHome = EnvironmentUtil.getValue((String)RVM_ENV_KEY_MY_RUBY_HOME);
        if (StringUtil.isEmpty((String)rubyHome)) {
            return null;
        }
        if (rubyHome.charAt(rubyHome.length() - 1) == File.separatorChar) {
            rubyHome = rubyHome.substring(0, rubyHome.length() - 1);
        }
        String rvmDistName = rubyHome.substring(rubyHome.lastIndexOf(File.separatorChar) + 1);
        String gemHome = EnvironmentUtil.getValue((String)"GEM_HOME");
        int gsIndex = gemHome == null ? -1 : gemHome.lastIndexOf(RVMSupportUtil.getGemsetSeparator());
        String gemset = gsIndex == -1 ? null : gemHome.substring(gsIndex + 1);
        return StringUtil.isEmpty(gemset) ? rvmDistName : rvmDistName + RVMSupportUtil.getGemsetSeparator() + gemset;
    }

    @Nullable
    public static Sdk findSdkBy(@NotNull String rvmSdkDistName, @Nullable String gemset) {
        if (rvmSdkDistName == null) {
            RVMSupportUtil.$$$reportNull$$$0(10);
        }
        if (RVM_SYSTEM_SDK.equals(rvmSdkDistName)) {
            return null;
        }
        String sdkSignature = "/rubies/" + rvmSdkDistName + "/bin";
        ArrayList<Sdk> rubySdks = RubySdkType.getAllValidRubySdks();
        for (Sdk sdk : rubySdks) {
            String interpreterExecutablePath = sdk.getHomePath();
            assert (interpreterExecutablePath != null);
            if (!interpreterExecutablePath.contains(sdkSignature) || !RVMSupportUtil.areGemsetsEqual(gemset, RVMSupportUtil.getGemsetName(sdk))) continue;
            return sdk;
        }
        return null;
    }

    private static boolean canOverride(@NotNull String envVariable, @NotNull Map<String, String> userDefinedEnvVars, @Nullable Map<String, String> defaultEnv) {
        if (envVariable == null) {
            RVMSupportUtil.$$$reportNull$$$0(11);
        }
        if (userDefinedEnvVars == null) {
            RVMSupportUtil.$$$reportNull$$$0(12);
        }
        if (!userDefinedEnvVars.containsKey(envVariable)) {
            return true;
        }
        if (defaultEnv != null) {
            String userValue = userDefinedEnvVars.get(envVariable);
            String defaultValue = defaultEnv.get(envVariable);
            if (userValue == null) {
                return defaultValue == null;
            }
            return userValue.equals(defaultValue);
        }
        return false;
    }

    @Nullable
    private static String getParentDir(@Nullable String urlOrPath) {
        if (urlOrPath == null) {
            return null;
        }
        int index = Math.max(urlOrPath.lastIndexOf("/"), urlOrPath.lastIndexOf("\\"));
        return index < 0 ? null : urlOrPath.substring(0, index);
    }

    @Nullable
    public static Pair<String, String> getMainAndGlobalGemPaths(@NotNull String executablePath, @Nullable String gemSetName, @NotNull RvmSettings rvmSettings) throws IllegalArgumentException {
        String baseGemsPath;
        if (executablePath == null) {
            RVMSupportUtil.$$$reportNull$$$0(13);
        }
        if (rvmSettings == null) {
            RVMSupportUtil.$$$reportNull$$$0(14);
        }
        if ((baseGemsPath = RVMSupportUtil.getBaseGemsPath(executablePath, rvmSettings)) == null) {
            return null;
        }
        String gs = RVMSupportUtil.getGemsetSeparator();
        boolean useDefaultGemset = gemSetName == null;
        String mainGemPath = useDefaultGemset ? baseGemsPath : baseGemsPath + gs + gemSetName;
        String globalGSGemPath = baseGemsPath + gs + "global";
        return Pair.create((Object)mainGemPath, (Object)globalGSGemPath);
    }

    @Nullable
    public static String getGemsetName(@NotNull String rvmGemsSubFolder) {
        int separatorIndex;
        if (rvmGemsSubFolder == null) {
            RVMSupportUtil.$$$reportNull$$$0(15);
        }
        return (separatorIndex = rvmGemsSubFolder.indexOf(RVMSupportUtil.getGemsetSeparator())) == -1 ? null : rvmGemsSubFolder.substring(separatorIndex + 1);
    }

    @NotNull
    public static String getDistName(@NotNull String rvmGemsSubFolder) {
        int separatorIndex;
        if (rvmGemsSubFolder == null) {
            RVMSupportUtil.$$$reportNull$$$0(16);
        }
        String string = (separatorIndex = rvmGemsSubFolder.indexOf(RVMSupportUtil.getGemsetSeparator())) == -1 ? rvmGemsSubFolder : rvmGemsSubFolder.substring(0, separatorIndex);
        if (string == null) {
            RVMSupportUtil.$$$reportNull$$$0(17);
        }
        return string;
    }

    @Nullable
    public static String getRVMSdkVersion(@NotNull Sdk sdk) {
        VirtualFile homeDirectory;
        if (sdk == null) {
            RVMSupportUtil.$$$reportNull$$$0(18);
        }
        if ((homeDirectory = sdk.getHomeDirectory()) == null) {
            return null;
        }
        return RvmSdkRefresher.getRvmRubyDistName(homeDirectory);
    }

    @Nullable
    public static String determineSuitableRVMSdkDist(@NotNull String rvmrcSdkRef, @Nullable String rvmrcGemset, @NotNull RubyDistToGemsetTable distName2GemsetsTable) {
        if (rvmrcSdkRef == null) {
            RVMSupportUtil.$$$reportNull$$$0(19);
        }
        if (distName2GemsetsTable == null) {
            RVMSupportUtil.$$$reportNull$$$0(20);
        }
        String maxDistName = null;
        for (Map.Entry<String, List<String>> distAndGemsets : distName2GemsetsTable.myRubyDist2Gemset.entrySet()) {
            String distName = distAndGemsets.getKey();
            if (!RVMSupportUtil.sdkRefMatches(rvmrcSdkRef, distName)) continue;
            List<String> gemsets = distAndGemsets.getValue();
            for (String gemset : gemsets) {
                if (!RVMSupportUtil.areGemsetsEqual(rvmrcGemset, gemset)) continue;
                if (rvmrcSdkRef.equalsIgnoreCase(distName)) {
                    return distName;
                }
                if (VersionComparatorUtil.compare((String)distName, maxDistName) <= 0) continue;
                maxDistName = distName;
            }
        }
        return maxDistName;
    }

    public static boolean sdkRefMatches(@NotNull String sdkRef, @NotNull String distName) {
        if (sdkRef == null) {
            RVMSupportUtil.$$$reportNull$$$0(21);
        }
        if (distName == null) {
            RVMSupportUtil.$$$reportNull$$$0(22);
        }
        if (distName.startsWith(sdkRef)) {
            return true;
        }
        if (StringUtil.isEmptyOrSpaces((String)sdkRef)) {
            return false;
        }
        if (sdkRef.endsWith("-p0")) {
            return RVMSupportUtil.sdkRefMatches(sdkRef.substring(0, sdkRef.length() - 3), distName);
        }
        if (sdkRef.startsWith("1.3") || sdkRef.startsWith("1.4") || sdkRef.startsWith("1.5") || sdkRef.startsWith("1.6") || sdkRef.startsWith("1.7") || sdkRef.matches("^9\\.\\d\\.\\d\\.\\d.*$")) {
            return distName.startsWith("jruby-" + sdkRef);
        }
        if (Character.isDigit(sdkRef.charAt(0))) {
            return distName.startsWith("ruby-" + sdkRef);
        }
        return false;
    }

    private static boolean areGemsetsEqual(@Nullable String gemset1, @Nullable String gemset2) {
        if (DEFAULT_GEMSET.equals(gemset1)) {
            gemset1 = null;
        }
        if (DEFAULT_GEMSET.equals(gemset2)) {
            gemset2 = null;
        }
        return gemset1 == null && gemset2 == null || gemset1 != null && gemset1.equals(gemset2);
    }

    @Nullable
    public static String getBaseGemsPath(@NotNull String executablePath, @NotNull RvmSettings rvmSettings) throws IllegalArgumentException {
        Pair<String, String> rootAndDist;
        if (executablePath == null) {
            RVMSupportUtil.$$$reportNull$$$0(23);
        }
        if (rvmSettings == null) {
            RVMSupportUtil.$$$reportNull$$$0(24);
        }
        if ((rootAndDist = RVMSupportUtil.getRVMGemsRootAndDistName(executablePath, rvmSettings)) == null) {
            return null;
        }
        return (String)rootAndDist.first + "/" + (String)rootAndDist.second;
    }

    @NotNull
    private static Pair<String, String> mixedModeGemPathUpdate(@NotNull RvmSettings rvmSettings, @NotNull String root, @NotNull String dist) {
        VirtualFile gemsFolder;
        if (rvmSettings == null) {
            RVMSupportUtil.$$$reportNull$$$0(25);
        }
        if (root == null) {
            RVMSupportUtil.$$$reportNull$$$0(26);
        }
        if (dist == null) {
            RVMSupportUtil.$$$reportNull$$$0(27);
        }
        if (rvmSettings instanceof LocalRvmPathsSettings && ((LocalRvmPathsSettings)rvmSettings).isMixedMode() && (gemsFolder = ((LocalRvmPathsSettings)rvmSettings).getGemsFolder()) != null) {
            Pair pair = Pair.create((Object)gemsFolder.getPath(), (Object)dist);
            if (pair == null) {
                RVMSupportUtil.$$$reportNull$$$0(28);
            }
            return pair;
        }
        Pair pair = Pair.create((Object)root, (Object)dist);
        if (pair == null) {
            RVMSupportUtil.$$$reportNull$$$0(29);
        }
        return pair;
    }

    @Nullable
    private static Pair<String, String> getRVMGemsRootAndDistName(@NotNull String executablePath, @NotNull RvmSettings rvmSettings) throws IllegalArgumentException {
        String interpreterRelativePath;
        String rvmHomePath;
        if (executablePath == null) {
            RVMSupportUtil.$$$reportNull$$$0(30);
        }
        if (rvmSettings == null) {
            RVMSupportUtil.$$$reportNull$$$0(31);
        }
        if ((rvmHomePath = rvmSettings.getRvmHomePath()) == null) {
            return null;
        }
        String rvmHome = rvmHomePath + "/";
        String rvmInterpretersFolderPath = rvmHome + "rubies/";
        if (!executablePath.startsWith(rvmInterpretersFolderPath)) {
            return null;
        }
        String string = interpreterRelativePath = executablePath.startsWith(rvmInterpretersFolderPath) ? executablePath.substring(rvmInterpretersFolderPath.length()) : null;
        if (interpreterRelativePath == null) {
            return null;
        }
        String rubyDistName = interpreterRelativePath.substring(0, interpreterRelativePath.indexOf("/"));
        if (StringUtil.isEmptyOrSpaces((String)rubyDistName)) {
            throw new IllegalArgumentException("Unable to fetch ruby distributive name for: " + executablePath);
        }
        return RVMSupportUtil.mixedModeGemPathUpdate(rvmSettings, rvmHome + "gems", rubyDistName);
    }

    @Nullable
    public static RubySdkType getRubySdkType(@NotNull String distName) {
        if (distName == null) {
            RVMSupportUtil.$$$reportNull$$$0(32);
        }
        if (distName.startsWith(RUBY) || distName.startsWith(REE) || distName.startsWith(MACRUBY) || distName.startsWith(RBX) || distName.startsWith(IRONRUBY) || distName.startsWith(MAGLEV)) {
            return RubySdkType.getInstance();
        }
        if (distName.startsWith(JRUBY)) {
            return JRubySdkType.getInstance();
        }
        return null;
    }

    @Nullable
    public static String getRVMSdkDistName(@NotNull Sdk rvmSdk) {
        if (rvmSdk == null) {
            RVMSupportUtil.$$$reportNull$$$0(33);
        }
        return RbenvGemsetManager.getSdkVersion(rvmSdk);
    }

    @Nullable
    public static Sdk findRVMGemsetSdk(@NotNull Sdk rvmSdk, @NotNull String rvmGemset) {
        String rvmSdkDistName;
        if (rvmSdk == null) {
            RVMSupportUtil.$$$reportNull$$$0(34);
        }
        if (rvmGemset == null) {
            RVMSupportUtil.$$$reportNull$$$0(35);
        }
        if ((rvmSdkDistName = RVMSupportUtil.getRVMSdkDistName(rvmSdk)) == null) {
            return null;
        }
        return RVMSupportUtil.findSdkBy(rvmSdkDistName, rvmGemset);
    }

    @NotNull
    public static Collection<Sdk> getRVMSdks(Sdk @NotNull [] existingSdks) {
        if (existingSdks == null) {
            RVMSupportUtil.$$$reportNull$$$0(36);
        }
        List list = ContainerUtil.filter((Object[])existingSdks, sdk -> RVMSupportUtil.isRVMInterpreter(sdk) && RVMSupportUtil.getGemsetName(sdk) == null && !RubyRemoteInterpreterManager.isRemoteSdk(sdk));
        if (list == null) {
            RVMSupportUtil.$$$reportNull$$$0(37);
        }
        return list;
    }

    public static boolean isNewRVMGemsetSdk(@NotNull Sdk sdk) {
        if (sdk == null) {
            RVMSupportUtil.$$$reportNull$$$0(38);
        }
        return sdk.getUserData(NEW_RVM_GEMSET_SDK) != null;
    }

    public static void unmarkNewRVMGemsetSdk(@NotNull Sdk sdk) {
        if (sdk == null) {
            RVMSupportUtil.$$$reportNull$$$0(39);
        }
        sdk.putUserData(NEW_RVM_GEMSET_SDK, null);
    }

    @Nullable
    public static Sdk getPreferableRVMSdk(@Nullable Project project, Sdk @NotNull [] sdksOfType, @Nullable Sdk selectedSdk) {
        Sdk projectSdk;
        Sdk rootRVMSdk;
        if (sdksOfType == null) {
            RVMSupportUtil.$$$reportNull$$$0(40);
        }
        if (RVMSupportUtil.isLocalRootRVMSdk(selectedSdk)) {
            return selectedSdk;
        }
        Collection<Sdk> rvmSdks = RVMSupportUtil.getRVMSdks(sdksOfType);
        if (RVMSupportUtil.getGemsetName(selectedSdk) != null && RVMSupportUtil.isLocalRootRVMSdk(rootRVMSdk = RVMSupportUtil.findRootRVMSdk(selectedSdk, rvmSdks))) {
            return rootRVMSdk;
        }
        if (project != null && RVMSupportUtil.isLocalRootRVMSdk(projectSdk = ProjectRootManager.getInstance((Project)project).getProjectSdk())) {
            return projectSdk;
        }
        Sdk defaultSdk = ProjectRootManager.getInstance((Project)ProjectManager.getInstance().getDefaultProject()).getProjectSdk();
        if (RVMSupportUtil.isLocalRootRVMSdk(defaultSdk)) {
            return defaultSdk;
        }
        return rvmSdks.stream().min(SdkComparator.SDK_COMPARATOR).orElse(null);
    }

    public static List<Sdk> getSortedRVMSdks(Sdk @NotNull [] existingSdks) {
        if (existingSdks == null) {
            RVMSupportUtil.$$$reportNull$$$0(41);
        }
        return ContainerUtil.sorted(RVMSupportUtil.getRVMSdks(existingSdks), (Comparator)SdkComparator.SDK_COMPARATOR);
    }

    public static void showNewRVMGemsetDialog(@Nullable Project project, @Nullable Sdk initSelectedSdk, Sdk @NotNull [] allSdks, @NotNull NullableConsumer<? super Sdk> consumer) {
        if (consumer == null) {
            RVMSupportUtil.$$$reportNull$$$0(42);
        }
        if (allSdks == null) {
            RVMSupportUtil.$$$reportNull$$$0(43);
        }
        if (initSelectedSdk == null) {
            LOG.warn("No RVM sdks were found.");
            return;
        }
        DialogBuilder dialogBuilder = new DialogBuilder(project);
        RVMGemsetDialog dialog = new RVMGemsetDialog(project, allSdks, initSelectedSdk);
        dialogBuilder.setCenterPanel((JComponent)dialog.getMainPanel());
        dialogBuilder.setOkOperation(() -> {
            Sdk rootRVMSdk;
            String rvmGemsetName = dialog.getRVMGemsetName();
            if (!RVMSupportUtil.checkValid(dialogBuilder, rvmGemsetName, rootRVMSdk = dialog.getSelectedSdk())) {
                return;
            }
            if (rootRVMSdk == null) {
                LOG.warn("For some reason sdk isn't selected.");
                return;
            }
            dialogBuilder.getDialogWrapper().close(0);
            Sdk newRVMGemsetSdk = RVMSupportUtil.createRVMGemsetMockSdk(rvmGemsetName, rootRVMSdk);
            if (project != null) {
                ((RVMGemsetListener)project.getMessageBus().syncPublisher(RVM_GEMSET_ADDED_TOPIC)).onNewRVMGemsetAdded(newRVMGemsetSdk);
            }
            consumer.consume((Object)newRVMGemsetSdk);
        });
        dialogBuilder.setPreferredFocusComponent(dialog.getRVMGemsetTextField());
        dialogBuilder.addOkAction();
        dialogBuilder.addCancelAction();
        dialogBuilder.setTitle(RBundle.message((String)"ruby.ide.sdk.configurable.create.rvm.gemset.dialog.title"));
        dialogBuilder.setHelpId("rvm.new.gemset.dialog");
        dialogBuilder.show();
    }

    private static Sdk createRVMGemsetMockSdk(@NotNull String rvmGemsetName, @NotNull Sdk rootRVMSdk) {
        String sdkName;
        if (rvmGemsetName == null) {
            RVMSupportUtil.$$$reportNull$$$0(44);
        }
        if (rootRVMSdk == null) {
            RVMSupportUtil.$$$reportNull$$$0(45);
        }
        RubySdkAdditionalData newSdkAdditionalData = new RubySdkAdditionalData(RubySdkAdditionalData.notNullFrom(rootRVMSdk));
        RvmSdkData newRvmSdkAdditionalData = RvmSdkData.notNullFrom((SdkAdditionalData)newSdkAdditionalData).withGemsetName(rvmGemsetName);
        VirtualFile homeDirectory = rootRVMSdk.getHomeDirectory();
        VirtualFile sdkBinFolder = homeDirectory != null ? homeDirectory.getParent() : null;
        VirtualFile sdkHomeFolder = sdkBinFolder != null ? sdkBinFolder.getParent() : null;
        String homePath = rootRVMSdk.getHomePath();
        if (homePath == null) {
            sdkName = null;
        } else {
            String distributionId = sdkHomeFolder != null ? sdkHomeFolder.getName() : (homeDirectory != null ? homeDirectory.getName() : RUBY);
            sdkName = RubySdkType.getInstance().createSdkName(homePath, distributionId, newRvmSdkAdditionalData);
        }
        Sdk newRVMGemsetSdk = ProjectJdkTable.getInstance().createSdk(sdkName, (SdkTypeId)RubySdkType.getInstance());
        SdkModificator sdkModificator = newRVMGemsetSdk.getSdkModificator();
        sdkModificator.setHomePath(rootRVMSdk.getHomePath());
        sdkModificator.setVersionString(rootRVMSdk.getVersionString());
        sdkModificator.setSdkAdditionalData((SdkAdditionalData)newSdkAdditionalData);
        WriteAction.run(() -> ((SdkModificator)sdkModificator).commitChanges());
        newRVMGemsetSdk.putUserData(NEW_RVM_GEMSET_SDK, NEW_RVM_GEMSET_SDK_VALUE);
        return newRVMGemsetSdk;
    }

    private static boolean checkValid(@NotNull DialogBuilder dialogBuilder, @NotNull String rvmGemsetName, @Nullable Sdk sdk) {
        if (dialogBuilder == null) {
            RVMSupportUtil.$$$reportNull$$$0(46);
        }
        if (rvmGemsetName == null) {
            RVMSupportUtil.$$$reportNull$$$0(47);
        }
        if (!RVM_GEMSET_NAME_REGEXP.matcher(rvmGemsetName).matches()) {
            dialogBuilder.setErrorText(RBundle.message((String)"ruby.ide.sdk.configurable.create.rvm.gemset.validation.failed"));
            return false;
        }
        if (sdk == null) {
            dialogBuilder.setErrorText(RBundle.message((String)"ruby.ide.sdk.configurable.create.rvm.gemset.no.sdk"));
            return false;
        }
        if (RVMSupportUtil.findRVMGemsetSdk(sdk, rvmGemsetName) != null) {
            dialogBuilder.setErrorText(RBundle.message((String)"ruby.ide.sdk.configurable.create.rvm.gemset.already.exists", (Object[])new Object[]{rvmGemsetName, sdk.getName()}));
            return false;
        }
        return true;
    }

    public static boolean isLocalRootRVMSdk(@Nullable Sdk initSelectedSdk) {
        return RVMSupportUtil.isRVMInterpreter(initSelectedSdk) && RVMSupportUtil.getGemsetName(initSelectedSdk) == null && !RubyRemoteInterpreterManager.isRemoteSdk(initSelectedSdk);
    }

    @Nullable
    public static Sdk findRootRVMSdk(@NotNull Sdk rvmSdk, @NotNull Collection<? extends Sdk> sdks) {
        if (rvmSdk == null) {
            RVMSupportUtil.$$$reportNull$$$0(48);
        }
        if (sdks == null) {
            RVMSupportUtil.$$$reportNull$$$0(49);
        }
        return (Sdk)ContainerUtil.find(sdks, sdk -> StringUtil.equals((CharSequence)rvmSdk.getHomePath(), (CharSequence)sdk.getHomePath()) && RVMSupportUtil.getGemsetName(sdk) == null);
    }

    public static boolean isRvmSdk(@NotNull File interpreterFile) {
        File parentFile;
        if (interpreterFile == null) {
            RVMSupportUtil.$$$reportNull$$$0(50);
        }
        if ((parentFile = interpreterFile.getParentFile()) == null) {
            return false;
        }
        return "gems".equals(parentFile.getName());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 4, 7, 17, 28, 29, 37 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gemset";
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 17: 
            case 28: 
            case 29: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/version/management/rvm/RVMSupportUtil";
                break;
            }
            case 2: 
            case 13: 
            case 23: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executablePath";
                break;
            }
            case 3: 
            case 14: 
            case 24: 
            case 25: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rvmSettings";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gemsFolder";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "distFolder";
                break;
            }
            case 8: 
            case 9: 
            case 18: 
            case 38: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rvmSdkDistName";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "envVariable";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "userDefinedEnvVars";
                break;
            }
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rvmGemsSubFolder";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rvmrcSdkRef";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "distName2GemsetsTable";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkRef";
                break;
            }
            case 22: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "distName";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dist";
                break;
            }
            case 33: 
            case 34: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rvmSdk";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rvmGemset";
                break;
            }
            case 36: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "existingSdks";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdksOfType";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allSdks";
                break;
            }
            case 44: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rvmGemsetName";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootRVMSdk";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialogBuilder";
                break;
            }
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdks";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreterFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/version/management/rvm/RVMSupportUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getGemsetSuffix";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getGemsetPresentableName";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getGemsetsForSdk";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getDistName";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "mixedModeGemPathUpdate";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "getRVMSdks";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getGemsetSuffix";
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 17: 
            case 28: 
            case 29: 
            case 37: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isRVMInterpreter";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getGemsetsForSdk";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "determineMainGemRootPath";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "determineMainAndGlobalGemPaths";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "findSdkBy";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "canOverride";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getMainAndGlobalGemPaths";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getGemsetName";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getDistName";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getRVMSdkVersion";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "determineSuitableRVMSdkDist";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "sdkRefMatches";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getBaseGemsPath";
                break;
            }
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "mixedModeGemPathUpdate";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getRVMGemsRootAndDistName";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getRubySdkType";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getRVMSdkDistName";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "findRVMGemsetSdk";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "getRVMSdks";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "isNewRVMGemsetSdk";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "unmarkNewRVMGemsetSdk";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "getPreferableRVMSdk";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "getSortedRVMSdks";
                break;
            }
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "showNewRVMGemsetDialog";
                break;
            }
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "createRVMGemsetMockSdk";
                break;
            }
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "checkValid";
                break;
            }
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "findRootRVMSdk";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "isRvmSdk";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 4, 7, 17, 28, 29, 37 -> new IllegalStateException(string);
        };
    }

    public static interface Constants {
        public static final String LOCAL_RVM_HOME_FOLDER_NAME = ".rvm";
        public static final String RVM_GEMS_FOLDER_NAME = "gems";
        public static final String RVM_RUBIES_FOLDER_NAME = "rubies";
        public static final String RVM_BIN_FOLDER_RELATIVE_PATH = "/bin";
        public static final String RVM_EXECUTABLE = "rvm";
        public static final String DEFAULT_GEMSET_SEPARATOR = "@";
        public static final String RVM_GEMSET_SEPARATOR_ENVVAR = "rvm_gemset_separator";
        public static final String GLOBAL_GEMSET_NAME = "global";
        public static final String GEM_PATH = "GEM_PATH";
        public static final String GEM_HOME = "GEM_HOME";
        public static final String MY_RUBY_HOME = "MY_RUBY_HOME";
        public static final String GEMS_ROOT_RELATIVE_PATH = "/gems";
        public static final String RVM_RUBY_STRING = "rvm_ruby_string";
        public static final String RVM_GEMSET = "gemset";
        public static final String IRBRC = "IRBRC";
    }

    public static class RubyDistToGemsetTable {
        private final Map<String, List<String>> myRubyDist2Gemset;

        public RubyDistToGemsetTable() {
            this(new HashMap<String, List<String>>());
        }

        private RubyDistToGemsetTable(Map<String, List<String>> tableImpl) {
            this.myRubyDist2Gemset = tableImpl;
        }

        public void putGemset(String gemsetName, String distName) {
            List<String> gemsets = this.myRubyDist2Gemset.get(distName);
            if (gemsets == null) {
                gemsets = new ArrayList<String>(1);
                this.myRubyDist2Gemset.put(distName, gemsets);
            }
            gemsets.add(gemsetName);
        }

        public boolean isEmpty() {
            return this.myRubyDist2Gemset.isEmpty();
        }

        public List<String> getGemsets(String distName) {
            return this.myRubyDist2Gemset.get(distName);
        }

        public static RubyDistToGemsetTable emptyTable() {
            return new RubyDistToGemsetTable(Collections.emptyMap());
        }
    }

    public static interface RVMGemsetListener {
        public void onNewRVMGemsetAdded(@NotNull Sdk var1);
    }
}

